@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.inputs

import com.pulumi.alicloud.cdn.inputs.DomainNewCertificateConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certId The ID of the certificate. It takes effect only when CertType = cas.
 * @property certName Certificate name, only flyer names are supported.
 * @property certRegion The certificate region, which takes effect only when CertType = cas, supports cn-hangzhou (domestic) and ap-southeast-1 (International), and is cn-hangzhou by default.
 * @property certType Certificate type. Value:
 * - **upload**: upload certificate.
 * - **cas**: Cloud Shield certificate.
 * - **free**: free certificate.
 * > If the certificate type is **cas**, **PrivateKey** does not need to pass parameters.
 * @property forceSet The force set of the security certificate.
 * @property privateKey The content of the private key. If the certificate is not enabled, you do not need to enter the content of the private key. To configure the certificate, enter the content of the private key.
 * @property serverCertificate The content of the security certificate. If the certificate is not enabled, you do not need to enter the content of the security certificate. Please enter the content of the certificate to configure the certificate.
 * @property serverCertificateStatus Whether the HTTPS certificate is enabled. Value:
 * - **on**(default): enabled.
 * - **off** : not enabled.
 */
public data class DomainNewCertificateConfigArgs(
    public val certId: Output<String>? = null,
    public val certName: Output<String>? = null,
    public val certRegion: Output<String>? = null,
    public val certType: Output<String>? = null,
    public val forceSet: Output<String>? = null,
    public val privateKey: Output<String>? = null,
    public val serverCertificate: Output<String>? = null,
    public val serverCertificateStatus: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.inputs.DomainNewCertificateConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.inputs.DomainNewCertificateConfigArgs =
        com.pulumi.alicloud.cdn.inputs.DomainNewCertificateConfigArgs.builder()
            .certId(certId?.applyValue({ args0 -> args0 }))
            .certName(certName?.applyValue({ args0 -> args0 }))
            .certRegion(certRegion?.applyValue({ args0 -> args0 }))
            .certType(certType?.applyValue({ args0 -> args0 }))
            .forceSet(forceSet?.applyValue({ args0 -> args0 }))
            .privateKey(privateKey?.applyValue({ args0 -> args0 }))
            .serverCertificate(serverCertificate?.applyValue({ args0 -> args0 }))
            .serverCertificateStatus(serverCertificateStatus?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainNewCertificateConfigArgs].
 */
@PulumiTagMarker
public class DomainNewCertificateConfigArgsBuilder internal constructor() {
    private var certId: Output<String>? = null

    private var certName: Output<String>? = null

    private var certRegion: Output<String>? = null

    private var certType: Output<String>? = null

    private var forceSet: Output<String>? = null

    private var privateKey: Output<String>? = null

    private var serverCertificate: Output<String>? = null

    private var serverCertificateStatus: Output<String>? = null

    /**
     * @param value The ID of the certificate. It takes effect only when CertType = cas.
     */
    @JvmName("svhfjjcmhnjtmldb")
    public suspend fun certId(`value`: Output<String>) {
        this.certId = value
    }

    /**
     * @param value Certificate name, only flyer names are supported.
     */
    @JvmName("ftvjrkskpcvyndaf")
    public suspend fun certName(`value`: Output<String>) {
        this.certName = value
    }

    /**
     * @param value The certificate region, which takes effect only when CertType = cas, supports cn-hangzhou (domestic) and ap-southeast-1 (International), and is cn-hangzhou by default.
     */
    @JvmName("lrqbmdxxvspdhghr")
    public suspend fun certRegion(`value`: Output<String>) {
        this.certRegion = value
    }

    /**
     * @param value Certificate type. Value:
     * - **upload**: upload certificate.
     * - **cas**: Cloud Shield certificate.
     * - **free**: free certificate.
     * > If the certificate type is **cas**, **PrivateKey** does not need to pass parameters.
     */
    @JvmName("axshsynyenhxirms")
    public suspend fun certType(`value`: Output<String>) {
        this.certType = value
    }

    /**
     * @param value The force set of the security certificate.
     */
    @JvmName("qqtsjlyusquvfyli")
    public suspend fun forceSet(`value`: Output<String>) {
        this.forceSet = value
    }

    /**
     * @param value The content of the private key. If the certificate is not enabled, you do not need to enter the content of the private key. To configure the certificate, enter the content of the private key.
     */
    @JvmName("scsbqewmwhrqqktr")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value The content of the security certificate. If the certificate is not enabled, you do not need to enter the content of the security certificate. Please enter the content of the certificate to configure the certificate.
     */
    @JvmName("eyyjaeggblpdbwbx")
    public suspend fun serverCertificate(`value`: Output<String>) {
        this.serverCertificate = value
    }

    /**
     * @param value Whether the HTTPS certificate is enabled. Value:
     * - **on**(default): enabled.
     * - **off** : not enabled.
     */
    @JvmName("vedwukoybhyyxhdx")
    public suspend fun serverCertificateStatus(`value`: Output<String>) {
        this.serverCertificateStatus = value
    }

    /**
     * @param value The ID of the certificate. It takes effect only when CertType = cas.
     */
    @JvmName("spcoxlsenaftejlo")
    public suspend fun certId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certId = mapped
    }

    /**
     * @param value Certificate name, only flyer names are supported.
     */
    @JvmName("lvukolnyirhhvkwx")
    public suspend fun certName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certName = mapped
    }

    /**
     * @param value The certificate region, which takes effect only when CertType = cas, supports cn-hangzhou (domestic) and ap-southeast-1 (International), and is cn-hangzhou by default.
     */
    @JvmName("lwtnsgsreemmrgom")
    public suspend fun certRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certRegion = mapped
    }

    /**
     * @param value Certificate type. Value:
     * - **upload**: upload certificate.
     * - **cas**: Cloud Shield certificate.
     * - **free**: free certificate.
     * > If the certificate type is **cas**, **PrivateKey** does not need to pass parameters.
     */
    @JvmName("hjjsngrkmseivkbm")
    public suspend fun certType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certType = mapped
    }

    /**
     * @param value The force set of the security certificate.
     */
    @JvmName("bjtjmomsrkbhvjer")
    public suspend fun forceSet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceSet = mapped
    }

    /**
     * @param value The content of the private key. If the certificate is not enabled, you do not need to enter the content of the private key. To configure the certificate, enter the content of the private key.
     */
    @JvmName("fjmbpvmiyrvhsufa")
    public suspend fun privateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value The content of the security certificate. If the certificate is not enabled, you do not need to enter the content of the security certificate. Please enter the content of the certificate to configure the certificate.
     */
    @JvmName("lbaracchdqllhghm")
    public suspend fun serverCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCertificate = mapped
    }

    /**
     * @param value Whether the HTTPS certificate is enabled. Value:
     * - **on**(default): enabled.
     * - **off** : not enabled.
     */
    @JvmName("joiwjulbukbdojeu")
    public suspend fun serverCertificateStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCertificateStatus = mapped
    }

    internal fun build(): DomainNewCertificateConfigArgs = DomainNewCertificateConfigArgs(
        certId = certId,
        certName = certName,
        certRegion = certRegion,
        certType = certType,
        forceSet = forceSet,
        privateKey = privateKey,
        serverCertificate = serverCertificate,
        serverCertificateStatus = serverCertificateStatus,
    )
}
