@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.inputs

import com.pulumi.alicloud.cdn.inputs.DomainNewSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property content The address of source. Valid values can be ip or doaminName. Each item's `content` can not be repeated.
 * @property port The port of source. Valid values are `443` and `80`. Default value is `80`.
 * @property priority Priority of the source. Valid values are `0` and `100`. Default value is `20`.
 * @property type The type of the source. Valid values are `ipaddr`, `domain` and `oss`.
 * @property weight Weight of the source. Valid values are from `0` to `100`. Default value is `10`, but if type is `ipaddr`, the value can only be `10`. .
 */
public data class DomainNewSourceArgs(
    public val content: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val priority: Output<Int>? = null,
    public val type: Output<String>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.inputs.DomainNewSourceArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.inputs.DomainNewSourceArgs =
        com.pulumi.alicloud.cdn.inputs.DomainNewSourceArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainNewSourceArgs].
 */
@PulumiTagMarker
public class DomainNewSourceArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var port: Output<Int>? = null

    private var priority: Output<Int>? = null

    private var type: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The address of source. Valid values can be ip or doaminName. Each item's `content` can not be repeated.
     */
    @JvmName("ggtnyhxrofixlylw")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The port of source. Valid values are `443` and `80`. Default value is `80`.
     */
    @JvmName("aedkpaeyodgdoupd")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Priority of the source. Valid values are `0` and `100`. Default value is `20`.
     */
    @JvmName("yrppslteuehflrxq")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The type of the source. Valid values are `ipaddr`, `domain` and `oss`.
     */
    @JvmName("ojaemtlcrmptsuet")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Weight of the source. Valid values are from `0` to `100`. Default value is `10`, but if type is `ipaddr`, the value can only be `10`. .
     */
    @JvmName("ynkurqhsyjwnugdu")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The address of source. Valid values can be ip or doaminName. Each item's `content` can not be repeated.
     */
    @JvmName("hpyonfjtfmcgowuc")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The port of source. Valid values are `443` and `80`. Default value is `80`.
     */
    @JvmName("mpkriaeffpsnwdsg")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Priority of the source. Valid values are `0` and `100`. Default value is `20`.
     */
    @JvmName("okistbcvkxgrmqli")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The type of the source. Valid values are `ipaddr`, `domain` and `oss`.
     */
    @JvmName("ajuwqugcguxbfyke")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Weight of the source. Valid values are from `0` to `100`. Default value is `10`, but if type is `ipaddr`, the value can only be `10`. .
     */
    @JvmName("vbuskkhqdnvdawro")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): DomainNewSourceArgs = DomainNewSourceArgs(
        content = content,
        port = port,
        priority = priority,
        type = type,
        weight = weight,
    )
}
