@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.inputs

import com.pulumi.alicloud.cdn.inputs.DomainPage404ConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customPageUrl
 * @property errorCode
 * @property pageType
 */
public data class DomainPage404ConfigArgs(
    public val customPageUrl: Output<String>? = null,
    public val errorCode: Output<String>? = null,
    public val pageType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.inputs.DomainPage404ConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.inputs.DomainPage404ConfigArgs =
        com.pulumi.alicloud.cdn.inputs.DomainPage404ConfigArgs.builder()
            .customPageUrl(customPageUrl?.applyValue({ args0 -> args0 }))
            .errorCode(errorCode?.applyValue({ args0 -> args0 }))
            .pageType(pageType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainPage404ConfigArgs].
 */
@PulumiTagMarker
public class DomainPage404ConfigArgsBuilder internal constructor() {
    private var customPageUrl: Output<String>? = null

    private var errorCode: Output<String>? = null

    private var pageType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("rqjyokwoequxwtup")
    public suspend fun customPageUrl(`value`: Output<String>) {
        this.customPageUrl = value
    }

    /**
     * @param value
     */
    @JvmName("nsllsknkmuwtorql")
    public suspend fun errorCode(`value`: Output<String>) {
        this.errorCode = value
    }

    /**
     * @param value
     */
    @JvmName("julhonworaiojywf")
    public suspend fun pageType(`value`: Output<String>) {
        this.pageType = value
    }

    /**
     * @param value
     */
    @JvmName("ecpecuwxynbgbsrn")
    public suspend fun customPageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPageUrl = mapped
    }

    /**
     * @param value
     */
    @JvmName("hhxfoqadvqklfxjt")
    public suspend fun errorCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorCode = mapped
    }

    /**
     * @param value
     */
    @JvmName("mkpsocqelmyiagps")
    public suspend fun pageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pageType = mapped
    }

    internal fun build(): DomainPage404ConfigArgs = DomainPage404ConfigArgs(
        customPageUrl = customPageUrl,
        errorCode = errorCode,
        pageType = pageType,
    )
}
