@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.inputs

import com.pulumi.alicloud.cdn.inputs.DomainParameterFilterConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enable
 * @property hashKeyArgs
 */
public data class DomainParameterFilterConfigArgs(
    public val enable: Output<String>? = null,
    public val hashKeyArgs: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.inputs.DomainParameterFilterConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.inputs.DomainParameterFilterConfigArgs =
        com.pulumi.alicloud.cdn.inputs.DomainParameterFilterConfigArgs.builder()
            .enable(enable?.applyValue({ args0 -> args0 }))
            .hashKeyArgs(hashKeyArgs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DomainParameterFilterConfigArgs].
 */
@PulumiTagMarker
public class DomainParameterFilterConfigArgsBuilder internal constructor() {
    private var enable: Output<String>? = null

    private var hashKeyArgs: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("nntildelbktbansd")
    public suspend fun enable(`value`: Output<String>) {
        this.enable = value
    }

    /**
     * @param value
     */
    @JvmName("grvnlydfdhepsgwu")
    public suspend fun hashKeyArgs(`value`: Output<List<String>>) {
        this.hashKeyArgs = value
    }

    @JvmName("rhqcyobqhnkrrpad")
    public suspend fun hashKeyArgs(vararg values: Output<String>) {
        this.hashKeyArgs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vqxylrkswwmwjgnc")
    public suspend fun hashKeyArgs(values: List<Output<String>>) {
        this.hashKeyArgs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("lvxjnrdoifjtpxcd")
    public suspend fun enable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value
     */
    @JvmName("dogkltahcxtxghea")
    public suspend fun hashKeyArgs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hashKeyArgs = mapped
    }

    /**
     * @param values
     */
    @JvmName("cabvwvhmpqpvbvbs")
    public suspend fun hashKeyArgs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hashKeyArgs = mapped
    }

    internal fun build(): DomainParameterFilterConfigArgs = DomainParameterFilterConfigArgs(
        enable = enable,
        hashKeyArgs = hashKeyArgs,
    )
}
