@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.inputs

import com.pulumi.alicloud.cdn.inputs.DomainReferConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowEmpty
 * @property referLists
 * @property referType
 */
public data class DomainReferConfigArgs(
    public val allowEmpty: Output<String>? = null,
    public val referLists: Output<List<String>>,
    public val referType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.inputs.DomainReferConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.inputs.DomainReferConfigArgs =
        com.pulumi.alicloud.cdn.inputs.DomainReferConfigArgs.builder()
            .allowEmpty(allowEmpty?.applyValue({ args0 -> args0 }))
            .referLists(referLists.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .referType(referType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainReferConfigArgs].
 */
@PulumiTagMarker
public class DomainReferConfigArgsBuilder internal constructor() {
    private var allowEmpty: Output<String>? = null

    private var referLists: Output<List<String>>? = null

    private var referType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("rxrnveuqeamugolo")
    public suspend fun allowEmpty(`value`: Output<String>) {
        this.allowEmpty = value
    }

    /**
     * @param value
     */
    @JvmName("ltxcpephbbxrmucr")
    public suspend fun referLists(`value`: Output<List<String>>) {
        this.referLists = value
    }

    @JvmName("cywlxoxdixtsebkb")
    public suspend fun referLists(vararg values: Output<String>) {
        this.referLists = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("tpigyhvomlwhpmkc")
    public suspend fun referLists(values: List<Output<String>>) {
        this.referLists = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("lsuemvhxbqscimog")
    public suspend fun referType(`value`: Output<String>) {
        this.referType = value
    }

    /**
     * @param value
     */
    @JvmName("mohnmxwbospwxops")
    public suspend fun allowEmpty(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowEmpty = mapped
    }

    /**
     * @param value
     */
    @JvmName("luoeqvyshsjxfjhq")
    public suspend fun referLists(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referLists = mapped
    }

    /**
     * @param values
     */
    @JvmName("ohwpjxnqwvltbrpv")
    public suspend fun referLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referLists = mapped
    }

    /**
     * @param value
     */
    @JvmName("ihwvkjayrprtvtsf")
    public suspend fun referType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referType = mapped
    }

    internal fun build(): DomainReferConfigArgs = DomainReferConfigArgs(
        allowEmpty = allowEmpty,
        referLists = referLists ?: throw PulumiNullFieldException("referLists"),
        referType = referType,
    )
}
