@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.inputs

import com.pulumi.alicloud.cdn.inputs.GetBlockedRegionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBlockedRegions.
 * @property language The language. Valid values: `zh`, `en`, `jp`.
 */
public data class GetBlockedRegionsPlainArgs(
    public val language: String,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.inputs.GetBlockedRegionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.inputs.GetBlockedRegionsPlainArgs =
        com.pulumi.alicloud.cdn.inputs.GetBlockedRegionsPlainArgs.builder()
            .language(language.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBlockedRegionsPlainArgs].
 */
@PulumiTagMarker
public class GetBlockedRegionsPlainArgsBuilder internal constructor() {
    private var language: String? = null

    /**
     * @param value The language. Valid values: `zh`, `en`, `jp`.
     */
    @JvmName("qokgrlecnwvkpgbu")
    public suspend fun language(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.language = mapped
    }

    internal fun build(): GetBlockedRegionsPlainArgs = GetBlockedRegionsPlainArgs(
        language = language ?: throw PulumiNullFieldException("language"),
    )
}
