@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.inputs

import com.pulumi.alicloud.cdn.inputs.GetIpInfoPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIpInfo.
 * @property ip Specify IP address.
 */
public data class GetIpInfoPlainArgs(
    public val ip: String,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.inputs.GetIpInfoPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.inputs.GetIpInfoPlainArgs =
        com.pulumi.alicloud.cdn.inputs.GetIpInfoPlainArgs.builder()
            .ip(ip.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpInfoPlainArgs].
 */
@PulumiTagMarker
public class GetIpInfoPlainArgsBuilder internal constructor() {
    private var ip: String? = null

    /**
     * @param value Specify IP address.
     */
    @JvmName("tccvnpaivymxbjxc")
    public suspend fun ip(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ip = mapped
    }

    internal fun build(): GetIpInfoPlainArgs = GetIpInfoPlainArgs(
        ip = ip ?: throw PulumiNullFieldException("ip"),
    )
}
