@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.inputs

import com.pulumi.alicloud.cdn.inputs.GetRealTimeLogDeliveriesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRealTimeLogDeliveries.
 * @property domain
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the real-time log delivery feature. Valid Values: `online` and `offline`.
 */
public data class GetRealTimeLogDeliveriesPlainArgs(
    public val domain: String,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.inputs.GetRealTimeLogDeliveriesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.inputs.GetRealTimeLogDeliveriesPlainArgs =
        com.pulumi.alicloud.cdn.inputs.GetRealTimeLogDeliveriesPlainArgs.builder()
            .domain(domain.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRealTimeLogDeliveriesPlainArgs].
 */
@PulumiTagMarker
public class GetRealTimeLogDeliveriesPlainArgsBuilder internal constructor() {
    private var domain: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value
     */
    @JvmName("ayvhchakahnxodnc")
    public suspend fun domain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domain = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("yksgcdlubuedayor")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the real-time log delivery feature. Valid Values: `online` and `offline`.
     */
    @JvmName("uuuhvvdkgebjwphi")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetRealTimeLogDeliveriesPlainArgs = GetRealTimeLogDeliveriesPlainArgs(
        domain = domain ?: throw PulumiNullFieldException("domain"),
        outputFile = outputFile,
        status = status,
    )
}
