@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.inputs

import com.pulumi.alicloud.cdn.inputs.GetServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getService.
 * @property enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
 * @property internetChargeType The new billing method. Valid values: `PayByTraffic` and `PayByBandwidth`. Default value: `PayByTraffic`.
 * It is required when `enable = on`. If the CDN service has been opened and you can update its internet charge type by modifying the filed `internet_charge_type`.
 * As a note, the updated internet charge type will be effective in the next day zero time.
 * > **NOTE:** Setting `enable = "On"` to open the CDN service that means you have read and agreed the [CDN Terms of Service](https://help.aliyun.com/document_detail/27110.html). The service can not closed once it is opened.
 */
public data class GetServicePlainArgs(
    public val enable: String? = null,
    public val internetChargeType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.inputs.GetServicePlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.inputs.GetServicePlainArgs =
        com.pulumi.alicloud.cdn.inputs.GetServicePlainArgs.builder()
            .enable(enable?.let({ args0 -> args0 }))
            .internetChargeType(internetChargeType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServicePlainArgs].
 */
@PulumiTagMarker
public class GetServicePlainArgsBuilder internal constructor() {
    private var enable: String? = null

    private var internetChargeType: String? = null

    /**
     * @param value Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     */
    @JvmName("ekmagpmwceojoaic")
    public suspend fun enable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enable = mapped
    }

    /**
     * @param value The new billing method. Valid values: `PayByTraffic` and `PayByBandwidth`. Default value: `PayByTraffic`.
     * It is required when `enable = on`. If the CDN service has been opened and you can update its internet charge type by modifying the filed `internet_charge_type`.
     * As a note, the updated internet charge type will be effective in the next day zero time.
     * > **NOTE:** Setting `enable = "On"` to open the CDN service that means you have read and agreed the [CDN Terms of Service](https://help.aliyun.com/document_detail/27110.html). The service can not closed once it is opened.
     */
    @JvmName("ewqkjpiyjqdminav")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.internetChargeType = mapped
    }

    internal fun build(): GetServicePlainArgs = GetServicePlainArgs(
        enable = enable,
        internetChargeType = internetChargeType,
    )
}
