@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authType
 * @property masterKey
 * @property slaveKey
 * @property timeout
 */
public data class DomainAuthConfig(
    public val authType: String? = null,
    public val masterKey: String? = null,
    public val slaveKey: String? = null,
    public val timeout: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cdn.outputs.DomainAuthConfig): DomainAuthConfig = DomainAuthConfig(
            authType = javaType.authType().map({ args0 -> args0 }).orElse(null),
            masterKey = javaType.masterKey().map({ args0 -> args0 }).orElse(null),
            slaveKey = javaType.slaveKey().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
