@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cacheContent
 * @property cacheId
 * @property cacheType
 * @property ttl
 * @property weight
 */
public data class DomainCacheConfig(
    public val cacheContent: String,
    public val cacheId: String? = null,
    public val cacheType: String,
    public val ttl: Int,
    public val weight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cdn.outputs.DomainCacheConfig): DomainCacheConfig = DomainCacheConfig(
            cacheContent = javaType.cacheContent(),
            cacheId = javaType.cacheId().map({ args0 -> args0 }).orElse(null),
            cacheType = javaType.cacheType(),
            ttl = javaType.ttl(),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
