@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property privateKey
 * @property serverCertificate
 * @property serverCertificateStatus
 */
public data class DomainCertificateConfig(
    public val privateKey: String? = null,
    public val serverCertificate: String? = null,
    public val serverCertificateStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cdn.outputs.DomainCertificateConfig): DomainCertificateConfig = DomainCertificateConfig(
            privateKey = javaType.privateKey().map({ args0 -> args0 }).orElse(null),
            serverCertificate = javaType.serverCertificate().map({ args0 -> args0 }).orElse(null),
            serverCertificateStatus = javaType.serverCertificateStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
