@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certId The ID of the certificate. It takes effect only when CertType = cas.
 * @property certName Certificate name, only flyer names are supported.
 * @property certRegion The certificate region, which takes effect only when CertType = cas, supports cn-hangzhou (domestic) and ap-southeast-1 (International), and is cn-hangzhou by default.
 * @property certType Certificate type. Value:
 * - **upload**: upload certificate.
 * - **cas**: Cloud Shield certificate.
 * - **free**: free certificate.
 * > If the certificate type is **cas**, **PrivateKey** does not need to pass parameters.
 * @property forceSet The force set of the security certificate.
 * @property privateKey The content of the private key. If the certificate is not enabled, you do not need to enter the content of the private key. To configure the certificate, enter the content of the private key.
 * @property serverCertificate The content of the security certificate. If the certificate is not enabled, you do not need to enter the content of the security certificate. Please enter the content of the certificate to configure the certificate.
 * @property serverCertificateStatus Whether the HTTPS certificate is enabled. Value:
 * - **on**(default): enabled.
 * - **off** : not enabled.
 */
public data class DomainNewCertificateConfig(
    public val certId: String? = null,
    public val certName: String? = null,
    public val certRegion: String? = null,
    public val certType: String? = null,
    public val forceSet: String? = null,
    public val privateKey: String? = null,
    public val serverCertificate: String? = null,
    public val serverCertificateStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cdn.outputs.DomainNewCertificateConfig): DomainNewCertificateConfig = DomainNewCertificateConfig(
            certId = javaType.certId().map({ args0 -> args0 }).orElse(null),
            certName = javaType.certName().map({ args0 -> args0 }).orElse(null),
            certRegion = javaType.certRegion().map({ args0 -> args0 }).orElse(null),
            certType = javaType.certType().map({ args0 -> args0 }).orElse(null),
            forceSet = javaType.forceSet().map({ args0 -> args0 }).orElse(null),
            privateKey = javaType.privateKey().map({ args0 -> args0 }).orElse(null),
            serverCertificate = javaType.serverCertificate().map({ args0 -> args0 }).orElse(null),
            serverCertificateStatus = javaType.serverCertificateStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
