@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content The address of source. Valid values can be ip or doaminName. Each item's `content` can not be repeated.
 * @property port The port of source. Valid values are `443` and `80`. Default value is `80`.
 * @property priority Priority of the source. Valid values are `0` and `100`. Default value is `20`.
 * @property type The type of the source. Valid values are `ipaddr`, `domain` and `oss`.
 * @property weight Weight of the source. Valid values are from `0` to `100`. Default value is `10`, but if type is `ipaddr`, the value can only be `10`. .
 */
public data class DomainNewSource(
    public val content: String? = null,
    public val port: Int? = null,
    public val priority: Int? = null,
    public val type: String? = null,
    public val weight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cdn.outputs.DomainNewSource): DomainNewSource = DomainNewSource(
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
