@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowEmpty
 * @property referLists
 * @property referType
 */
public data class DomainReferConfig(
    public val allowEmpty: String? = null,
    public val referLists: List<String>,
    public val referType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cdn.outputs.DomainReferConfig): DomainReferConfig = DomainReferConfig(
            allowEmpty = javaType.allowEmpty().map({ args0 -> args0 }).orElse(null),
            referLists = javaType.referLists().map({ args0 -> args0 }),
            referType = javaType.referType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
