@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property continent The region to which the country belongs.
 * @property countriesAndRegions National region abbreviation.
 * @property countriesAndRegionsName The name of the country and region.
 */
public data class GetBlockedRegionsRegion(
    public val continent: String,
    public val countriesAndRegions: String,
    public val countriesAndRegionsName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cdn.outputs.GetBlockedRegionsRegion): GetBlockedRegionsRegion = GetBlockedRegionsRegion(
            continent = javaType.continent(),
            countriesAndRegions = javaType.countriesAndRegions(),
            countriesAndRegionsName = javaType.countriesAndRegionsName(),
        )
    }
}
