@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBlockedRegions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property language
 * @property regions
 */
public data class GetBlockedRegionsResult(
    public val id: String,
    public val language: String,
    public val regions: List<GetBlockedRegionsRegion>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cdn.outputs.GetBlockedRegionsResult): GetBlockedRegionsResult = GetBlockedRegionsResult(
            id = javaType.id(),
            language = javaType.language(),
            regions = javaType.regions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cdn.kotlin.outputs.GetBlockedRegionsRegion.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
