@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getIpInfo.
 * @property cdnIp
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ip
 * @property isp
 * @property ispEname
 * @property region
 * @property regionEname
 */
public data class GetIpInfoResult(
    public val cdnIp: String,
    public val id: String,
    public val ip: String,
    public val isp: String,
    public val ispEname: String,
    public val region: String,
    public val regionEname: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cdn.outputs.GetIpInfoResult): GetIpInfoResult = GetIpInfoResult(
            cdnIp = javaType.cdnIp(),
            id = javaType.id(),
            ip = javaType.ip(),
            isp = javaType.isp(),
            ispEname = javaType.ispEname(),
            region = javaType.region(),
            regionEname = javaType.regionEname(),
        )
    }
}
