@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domain Real-Time Log Service Domain.
 * @property id The ID of the Real Time Log Delivery.
 * @property logstore The name of the Logstore that collects log data from Alibaba Cloud Content Delivery Network (CDN) in real time.
 * @property project The name of the Log Service project that is used for real-time log delivery.
 * @property slsRegion The region where the Log Service project is deployed.
 * @property status The status of the real-time log delivery feature. Valid Values: `online` and `offline`.
 */
public data class GetRealTimeLogDeliveriesDelivery(
    public val domain: String,
    public val id: String,
    public val logstore: String,
    public val project: String,
    public val slsRegion: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cdn.outputs.GetRealTimeLogDeliveriesDelivery): GetRealTimeLogDeliveriesDelivery = GetRealTimeLogDeliveriesDelivery(
            domain = javaType.domain(),
            id = javaType.id(),
            logstore = javaType.logstore(),
            project = javaType.project(),
            slsRegion = javaType.slsRegion(),
            status = javaType.status(),
        )
    }
}
