@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRealTimeLogDeliveries.
 * @property deliveries
 * @property domain
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property status
 */
public data class GetRealTimeLogDeliveriesResult(
    public val deliveries: List<GetRealTimeLogDeliveriesDelivery>,
    public val domain: String,
    public val id: String,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cdn.outputs.GetRealTimeLogDeliveriesResult): GetRealTimeLogDeliveriesResult = GetRealTimeLogDeliveriesResult(
            deliveries = javaType.deliveries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cdn.kotlin.outputs.GetRealTimeLogDeliveriesDelivery.Companion.toKotlin(args0)
                })
            }),
            domain = javaType.domain(),
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
