@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getService.
 * @property changingAffectTime The time when the change of the billing method starts to take effect. The time is displayed in GMT.
 * @property changingChargeType The billing method to be effective.
 * @property enable
 * @property id The provider-assigned unique ID for this managed resource.
 * @property internetChargeType
 * @property openingTime The time when the CDN service was activated. The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mmZ format.
 * @property status The current service enable status.
 */
public data class GetServiceResult(
    public val changingAffectTime: String,
    public val changingChargeType: String,
    public val enable: String? = null,
    public val id: String,
    public val internetChargeType: String? = null,
    public val openingTime: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cdn.outputs.GetServiceResult): GetServiceResult = GetServiceResult(
            changingAffectTime = javaType.changingAffectTime(),
            changingChargeType = javaType.changingChargeType(),
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            internetChargeType = javaType.internetChargeType().map({ args0 -> args0 }).orElse(null),
            openingTime = javaType.openingTime(),
            status = javaType.status(),
        )
    }
}
