@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BandwidthPackage].
 */
@PulumiTagMarker
public class BandwidthPackageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BandwidthPackageArgs = BandwidthPackageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BandwidthPackageArgsBuilder.() -> Unit) {
        val builder = BandwidthPackageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BandwidthPackage {
        val builtJavaResource = com.pulumi.alicloud.cen.BandwidthPackage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BandwidthPackage(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * CEN bandwidth package can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/bandwidthPackage:BandwidthPackage example cenbwp-abc123456
 * ```
 */
public class BandwidthPackage internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.BandwidthPackage,
) : KotlinCustomResource(javaResource, BandwidthPackageMapper) {
    /**
     * The bandwidth in Mbps of the bandwidth package. Cannot be less than 2Mbps.
     */
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The name of the bandwidth package. Defaults to null.
     * ->**NOTE:** PrePaid mode will deduct fees from the account directly and the bandwidth package can't be deleted before expired time.
     * ->**NOTE:** The PostPaid mode is only for test. Please open a ticket if you need.
     */
    public val cenBandwidthPackageName: Output<String>
        get() = javaResource.cenBandwidthPackageName().applyValue({ args0 -> args0 })

    /**
     * Field `charge_type` has been deprecated from version 1.97.0. Use `payment_type` and instead.
     */
    @Deprecated(
        message = """
  Field 'charge_type' has been deprecated from version 1.98.0. Use 'payment_type' and instead.
  """,
    )
    public val chargeType: Output<String>
        get() = javaResource.chargeType().applyValue({ args0 -> args0 })

    /**
     * The description of the bandwidth package. Default to null.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time of the bandwidth package to expire.
     */
    public val expiredTime: Output<String>
        get() = javaResource.expiredTime().applyValue({ args0 -> args0 })

    /**
     * The area A to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
     */
    public val geographicRegionAId: Output<String>
        get() = javaResource.geographicRegionAId().applyValue({ args0 -> args0 })

    /**
     * The area B to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
     */
    public val geographicRegionBId: Output<String>
        get() = javaResource.geographicRegionBId().applyValue({ args0 -> args0 })

    /**
     * Field `geographic_region_ids` has been deprecated from version 1.97.0. Use `geographic_region_a_id` and `geographic_region_b_id` instead.
     */
    @Deprecated(
        message = """
  Field 'geographic_region_ids' has been deprecated from version 1.98.0. Use
      'geographic_region_a_id' and 'geographic_region_b_id' instead.
  """,
    )
    public val geographicRegionIds: Output<List<String>>
        get() = javaResource.geographicRegionIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Field `name` has been deprecated from version 1.97.0. Use `cen_bandwidth_package_name` and instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.98.0. Use 'cen_bandwidth_package_name' and
      instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The billing method. Valid value: `PostPaid` | `PrePaid`. Default to `PrePaid`. If set to PrePaid, the bandwidth package can't be deleted before expired time.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The purchase period in month. Valid value: `1`, `2`, `3`, `6`, `12`.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The association status of the bandwidth package.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object BandwidthPackageMapper : ResourceMapper<BandwidthPackage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.BandwidthPackage::class == javaResource::class

    override fun map(javaResource: Resource): BandwidthPackage = BandwidthPackage(
        javaResource as
            com.pulumi.alicloud.cen.BandwidthPackage,
    )
}

/**
 * @see [BandwidthPackage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BandwidthPackage].
 */
public suspend fun bandwidthPackage(
    name: String,
    block: suspend BandwidthPackageResourceBuilder.() -> Unit,
): BandwidthPackage {
    val builder = BandwidthPackageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BandwidthPackage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bandwidthPackage(name: String): BandwidthPackage {
    val builder = BandwidthPackageResourceBuilder()
    builder.name(name)
    return builder.build()
}
