@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.BandwidthPackageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * CEN bandwidth package can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/bandwidthPackage:BandwidthPackage example cenbwp-abc123456
 * ```
 * @property bandwidth The bandwidth in Mbps of the bandwidth package. Cannot be less than 2Mbps.
 * @property cenBandwidthPackageName The name of the bandwidth package. Defaults to null.
 * ->**NOTE:** PrePaid mode will deduct fees from the account directly and the bandwidth package can't be deleted before expired time.
 * ->**NOTE:** The PostPaid mode is only for test. Please open a ticket if you need.
 * @property chargeType Field `charge_type` has been deprecated from version 1.97.0. Use `payment_type` and instead.
 * @property description The description of the bandwidth package. Default to null.
 * @property geographicRegionAId The area A to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
 * @property geographicRegionBId The area B to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
 * @property geographicRegionIds Field `geographic_region_ids` has been deprecated from version 1.97.0. Use `geographic_region_a_id` and `geographic_region_b_id` instead.
 * @property name Field `name` has been deprecated from version 1.97.0. Use `cen_bandwidth_package_name` and instead.
 * @property paymentType The billing method. Valid value: `PostPaid` | `PrePaid`. Default to `PrePaid`. If set to PrePaid, the bandwidth package can't be deleted before expired time.
 * @property period The purchase period in month. Valid value: `1`, `2`, `3`, `6`, `12`.
 * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
 */
public data class BandwidthPackageArgs(
    public val bandwidth: Output<Int>? = null,
    public val cenBandwidthPackageName: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'charge_type' has been deprecated from version 1.98.0. Use 'payment_type' and instead.
  """,
    )
    public val chargeType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val geographicRegionAId: Output<String>? = null,
    public val geographicRegionBId: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'geographic_region_ids' has been deprecated from version 1.98.0. Use
      'geographic_region_a_id' and 'geographic_region_b_id' instead.
  """,
    )
    public val geographicRegionIds: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.98.0. Use 'cen_bandwidth_package_name' and
      instead.
  """,
    )
    public val name: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.BandwidthPackageArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.BandwidthPackageArgs =
        com.pulumi.alicloud.cen.BandwidthPackageArgs.builder()
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .cenBandwidthPackageName(cenBandwidthPackageName?.applyValue({ args0 -> args0 }))
            .chargeType(chargeType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .geographicRegionAId(geographicRegionAId?.applyValue({ args0 -> args0 }))
            .geographicRegionBId(geographicRegionBId?.applyValue({ args0 -> args0 }))
            .geographicRegionIds(geographicRegionIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BandwidthPackageArgs].
 */
@PulumiTagMarker
public class BandwidthPackageArgsBuilder internal constructor() {
    private var bandwidth: Output<Int>? = null

    private var cenBandwidthPackageName: Output<String>? = null

    private var chargeType: Output<String>? = null

    private var description: Output<String>? = null

    private var geographicRegionAId: Output<String>? = null

    private var geographicRegionBId: Output<String>? = null

    private var geographicRegionIds: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    /**
     * @param value The bandwidth in Mbps of the bandwidth package. Cannot be less than 2Mbps.
     */
    @JvmName("dfloovnlphncipjx")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value The name of the bandwidth package. Defaults to null.
     * ->**NOTE:** PrePaid mode will deduct fees from the account directly and the bandwidth package can't be deleted before expired time.
     * ->**NOTE:** The PostPaid mode is only for test. Please open a ticket if you need.
     */
    @JvmName("kenisdwhkjxbupld")
    public suspend fun cenBandwidthPackageName(`value`: Output<String>) {
        this.cenBandwidthPackageName = value
    }

    /**
     * @param value Field `charge_type` has been deprecated from version 1.97.0. Use `payment_type` and instead.
     */
    @Deprecated(
        message = """
  Field 'charge_type' has been deprecated from version 1.98.0. Use 'payment_type' and instead.
  """,
    )
    @JvmName("ltbjlatacualmjvr")
    public suspend fun chargeType(`value`: Output<String>) {
        this.chargeType = value
    }

    /**
     * @param value The description of the bandwidth package. Default to null.
     */
    @JvmName("nlwoltswhkcqckjj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The area A to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
     */
    @JvmName("crjtelydrrttqsyb")
    public suspend fun geographicRegionAId(`value`: Output<String>) {
        this.geographicRegionAId = value
    }

    /**
     * @param value The area B to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
     */
    @JvmName("uhckcfiyubblnwth")
    public suspend fun geographicRegionBId(`value`: Output<String>) {
        this.geographicRegionBId = value
    }

    /**
     * @param value Field `geographic_region_ids` has been deprecated from version 1.97.0. Use `geographic_region_a_id` and `geographic_region_b_id` instead.
     */
    @Deprecated(
        message = """
  Field 'geographic_region_ids' has been deprecated from version 1.98.0. Use
      'geographic_region_a_id' and 'geographic_region_b_id' instead.
  """,
    )
    @JvmName("ibqnvyygfbeaixud")
    public suspend fun geographicRegionIds(`value`: Output<List<String>>) {
        this.geographicRegionIds = value
    }

    @JvmName("kepwvgbibwighflv")
    public suspend fun geographicRegionIds(vararg values: Output<String>) {
        this.geographicRegionIds = Output.all(values.asList())
    }

    /**
     * @param values Field `geographic_region_ids` has been deprecated from version 1.97.0. Use `geographic_region_a_id` and `geographic_region_b_id` instead.
     */
    @Deprecated(
        message = """
  Field 'geographic_region_ids' has been deprecated from version 1.98.0. Use
      'geographic_region_a_id' and 'geographic_region_b_id' instead.
  """,
    )
    @JvmName("odwjprtwcvfriikn")
    public suspend fun geographicRegionIds(values: List<Output<String>>) {
        this.geographicRegionIds = Output.all(values)
    }

    /**
     * @param value Field `name` has been deprecated from version 1.97.0. Use `cen_bandwidth_package_name` and instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.98.0. Use 'cen_bandwidth_package_name' and
      instead.
  """,
    )
    @JvmName("fcnvyoruhcdtgsht")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The billing method. Valid value: `PostPaid` | `PrePaid`. Default to `PrePaid`. If set to PrePaid, the bandwidth package can't be deleted before expired time.
     */
    @JvmName("mwvvvrhajggnwahp")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The purchase period in month. Valid value: `1`, `2`, `3`, `6`, `12`.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("ggtlgthjmuohpvey")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The bandwidth in Mbps of the bandwidth package. Cannot be less than 2Mbps.
     */
    @JvmName("ckxalkslkufwihbu")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The name of the bandwidth package. Defaults to null.
     * ->**NOTE:** PrePaid mode will deduct fees from the account directly and the bandwidth package can't be deleted before expired time.
     * ->**NOTE:** The PostPaid mode is only for test. Please open a ticket if you need.
     */
    @JvmName("phinuwsjyeoskpkm")
    public suspend fun cenBandwidthPackageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenBandwidthPackageName = mapped
    }

    /**
     * @param value Field `charge_type` has been deprecated from version 1.97.0. Use `payment_type` and instead.
     */
    @Deprecated(
        message = """
  Field 'charge_type' has been deprecated from version 1.98.0. Use 'payment_type' and instead.
  """,
    )
    @JvmName("gvrirhxrlctkyyho")
    public suspend fun chargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chargeType = mapped
    }

    /**
     * @param value The description of the bandwidth package. Default to null.
     */
    @JvmName("gufqukjxbtpdqnbo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The area A to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
     */
    @JvmName("moeqowkatnlgwvjb")
    public suspend fun geographicRegionAId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geographicRegionAId = mapped
    }

    /**
     * @param value The area B to which the network instance belongs. Valid values: `China` | `North-America` | `Asia-Pacific` | `Europe` | `Australia`.
     */
    @JvmName("xbbhpooubcnrgpvd")
    public suspend fun geographicRegionBId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geographicRegionBId = mapped
    }

    /**
     * @param value Field `geographic_region_ids` has been deprecated from version 1.97.0. Use `geographic_region_a_id` and `geographic_region_b_id` instead.
     */
    @Deprecated(
        message = """
  Field 'geographic_region_ids' has been deprecated from version 1.98.0. Use
      'geographic_region_a_id' and 'geographic_region_b_id' instead.
  """,
    )
    @JvmName("bkukvcfavkwcrtdx")
    public suspend fun geographicRegionIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geographicRegionIds = mapped
    }

    /**
     * @param values Field `geographic_region_ids` has been deprecated from version 1.97.0. Use `geographic_region_a_id` and `geographic_region_b_id` instead.
     */
    @Deprecated(
        message = """
  Field 'geographic_region_ids' has been deprecated from version 1.98.0. Use
      'geographic_region_a_id' and 'geographic_region_b_id' instead.
  """,
    )
    @JvmName("fuclrftalsjceeld")
    public suspend fun geographicRegionIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geographicRegionIds = mapped
    }

    /**
     * @param value Field `name` has been deprecated from version 1.97.0. Use `cen_bandwidth_package_name` and instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.98.0. Use 'cen_bandwidth_package_name' and
      instead.
  """,
    )
    @JvmName("yxbyvwkihqipofwa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The billing method. Valid value: `PostPaid` | `PrePaid`. Default to `PrePaid`. If set to PrePaid, the bandwidth package can't be deleted before expired time.
     */
    @JvmName("adyowyrbuooprmst")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The purchase period in month. Valid value: `1`, `2`, `3`, `6`, `12`.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("ngtnpqkjgdqqtflk")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    internal fun build(): BandwidthPackageArgs = BandwidthPackageArgs(
        bandwidth = bandwidth,
        cenBandwidthPackageName = cenBandwidthPackageName,
        chargeType = chargeType,
        description = description,
        geographicRegionAId = geographicRegionAId,
        geographicRegionBId = geographicRegionBId,
        geographicRegionIds = geographicRegionIds,
        name = name,
        paymentType = paymentType,
        period = period,
    )
}
