@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.CenFunctions.getBandwidthLimitsPlain
import com.pulumi.alicloud.cen.CenFunctions.getBandwidthPackagesPlain
import com.pulumi.alicloud.cen.CenFunctions.getChildInstanceRouteEntryToAttachmentsPlain
import com.pulumi.alicloud.cen.CenFunctions.getFlowlogsPlain
import com.pulumi.alicloud.cen.CenFunctions.getInstanceAttachmentsPlain
import com.pulumi.alicloud.cen.CenFunctions.getInstancesPlain
import com.pulumi.alicloud.cen.CenFunctions.getInterRegionTrafficQosPoliciesPlain
import com.pulumi.alicloud.cen.CenFunctions.getInterRegionTrafficQosQueuesPlain
import com.pulumi.alicloud.cen.CenFunctions.getPrivateZonesPlain
import com.pulumi.alicloud.cen.CenFunctions.getRegionRouteEntriesPlain
import com.pulumi.alicloud.cen.CenFunctions.getRouteEntriesPlain
import com.pulumi.alicloud.cen.CenFunctions.getRouteMapsPlain
import com.pulumi.alicloud.cen.CenFunctions.getRouteServicesPlain
import com.pulumi.alicloud.cen.CenFunctions.getTrafficMarkingPoliciesPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouteTableAggregationsPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterAvailableResourcesPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterCidrsPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterMulticastDomainAssociationsPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterMulticastDomainMembersPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterMulticastDomainPeerMembersPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterMulticastDomainSourcesPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterMulticastDomainsPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterPeerAttachmentsPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterPrefixListAssociationsPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterRouteEntriesPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterRouteTableAssociationsPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterRouteTablePropagationsPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterRouteTablesPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterServicePlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterVbrAttachmentsPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterVpcAttachmentsPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRouterVpnAttachmentsPlain
import com.pulumi.alicloud.cen.CenFunctions.getTransitRoutersPlain
import com.pulumi.alicloud.cen.CenFunctions.getVbrHealthChecksPlain
import com.pulumi.alicloud.cen.kotlin.inputs.GetBandwidthLimitsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetBandwidthLimitsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetBandwidthPackagesPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetBandwidthPackagesPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetChildInstanceRouteEntryToAttachmentsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetChildInstanceRouteEntryToAttachmentsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetFlowlogsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetFlowlogsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetInstanceAttachmentsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetInstanceAttachmentsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetInterRegionTrafficQosPoliciesPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetInterRegionTrafficQosPoliciesPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetInterRegionTrafficQosQueuesPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetInterRegionTrafficQosQueuesPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetPrivateZonesPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetPrivateZonesPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetRegionRouteEntriesPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetRegionRouteEntriesPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetRouteEntriesPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetRouteEntriesPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetRouteMapsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetRouteMapsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetRouteServicesPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetRouteServicesPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTrafficMarkingPoliciesPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTrafficMarkingPoliciesPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouteTableAggregationsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouteTableAggregationsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterAvailableResourcesPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterAvailableResourcesPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterCidrsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterCidrsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterMulticastDomainAssociationsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterMulticastDomainAssociationsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterMulticastDomainMembersPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterMulticastDomainMembersPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterMulticastDomainPeerMembersPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterMulticastDomainPeerMembersPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterMulticastDomainSourcesPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterMulticastDomainSourcesPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterMulticastDomainsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterMulticastDomainsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterPeerAttachmentsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterPeerAttachmentsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterPrefixListAssociationsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterPrefixListAssociationsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterRouteEntriesPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterRouteEntriesPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterRouteTableAssociationsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterRouteTableAssociationsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterRouteTablePropagationsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterRouteTablePropagationsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterRouteTablesPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterRouteTablesPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterServicePlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterServicePlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterVbrAttachmentsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterVbrAttachmentsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterVpcAttachmentsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterVpcAttachmentsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterVpnAttachmentsPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRouterVpnAttachmentsPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRoutersPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetTransitRoutersPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.inputs.GetVbrHealthChecksPlainArgs
import com.pulumi.alicloud.cen.kotlin.inputs.GetVbrHealthChecksPlainArgsBuilder
import com.pulumi.alicloud.cen.kotlin.outputs.GetBandwidthLimitsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetBandwidthPackagesResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetChildInstanceRouteEntryToAttachmentsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetFlowlogsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetInstanceAttachmentsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetInterRegionTrafficQosPoliciesResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetInterRegionTrafficQosQueuesResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetPrivateZonesResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetRegionRouteEntriesResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetRouteEntriesResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetRouteMapsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetRouteServicesResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTrafficMarkingPoliciesResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouteTableAggregationsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterAvailableResourcesResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterCidrsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainAssociationsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainMembersResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainPeerMembersResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainSourcesResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterPeerAttachmentsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterPrefixListAssociationsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterRouteEntriesResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterRouteTableAssociationsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterRouteTablePropagationsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterRouteTablesResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterServiceResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterVbrAttachmentsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterVpcAttachmentsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterVpnAttachmentsResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRoutersResult
import com.pulumi.alicloud.cen.kotlin.outputs.GetVbrHealthChecksResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.cen.kotlin.outputs.GetBandwidthLimitsResult.Companion.toKotlin as getBandwidthLimitsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetBandwidthPackagesResult.Companion.toKotlin as getBandwidthPackagesResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetChildInstanceRouteEntryToAttachmentsResult.Companion.toKotlin as getChildInstanceRouteEntryToAttachmentsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetFlowlogsResult.Companion.toKotlin as getFlowlogsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetInstanceAttachmentsResult.Companion.toKotlin as getInstanceAttachmentsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetInterRegionTrafficQosPoliciesResult.Companion.toKotlin as getInterRegionTrafficQosPoliciesResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetInterRegionTrafficQosQueuesResult.Companion.toKotlin as getInterRegionTrafficQosQueuesResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetPrivateZonesResult.Companion.toKotlin as getPrivateZonesResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetRegionRouteEntriesResult.Companion.toKotlin as getRegionRouteEntriesResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetRouteEntriesResult.Companion.toKotlin as getRouteEntriesResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetRouteMapsResult.Companion.toKotlin as getRouteMapsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetRouteServicesResult.Companion.toKotlin as getRouteServicesResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTrafficMarkingPoliciesResult.Companion.toKotlin as getTrafficMarkingPoliciesResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouteTableAggregationsResult.Companion.toKotlin as getTransitRouteTableAggregationsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterAvailableResourcesResult.Companion.toKotlin as getTransitRouterAvailableResourcesResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterCidrsResult.Companion.toKotlin as getTransitRouterCidrsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainAssociationsResult.Companion.toKotlin as getTransitRouterMulticastDomainAssociationsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainMembersResult.Companion.toKotlin as getTransitRouterMulticastDomainMembersResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainPeerMembersResult.Companion.toKotlin as getTransitRouterMulticastDomainPeerMembersResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainSourcesResult.Companion.toKotlin as getTransitRouterMulticastDomainSourcesResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainsResult.Companion.toKotlin as getTransitRouterMulticastDomainsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterPeerAttachmentsResult.Companion.toKotlin as getTransitRouterPeerAttachmentsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterPrefixListAssociationsResult.Companion.toKotlin as getTransitRouterPrefixListAssociationsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterRouteEntriesResult.Companion.toKotlin as getTransitRouterRouteEntriesResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterRouteTableAssociationsResult.Companion.toKotlin as getTransitRouterRouteTableAssociationsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterRouteTablePropagationsResult.Companion.toKotlin as getTransitRouterRouteTablePropagationsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterRouteTablesResult.Companion.toKotlin as getTransitRouterRouteTablesResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterServiceResult.Companion.toKotlin as getTransitRouterServiceResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterVbrAttachmentsResult.Companion.toKotlin as getTransitRouterVbrAttachmentsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterVpcAttachmentsResult.Companion.toKotlin as getTransitRouterVpcAttachmentsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterVpnAttachmentsResult.Companion.toKotlin as getTransitRouterVpnAttachmentsResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRoutersResult.Companion.toKotlin as getTransitRoutersResultToKotlin
import com.pulumi.alicloud.cen.kotlin.outputs.GetVbrHealthChecksResult.Companion.toKotlin as getVbrHealthChecksResultToKotlin

public object CenFunctions {
    /**
     * This data source provides CEN Bandwidth Limits available to the user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const bwl = alicloud.cen.getBandwidthLimits({
     *     instanceIds: ["cen-id1"],
     * });
     * export const firstCenBandwidthLimitsLocalRegionId = bwl.then(bwl => bwl.limits?.[0]?.localRegionId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * bwl = alicloud.cen.get_bandwidth_limits(instance_ids=["cen-id1"])
     * pulumi.export("firstCenBandwidthLimitsLocalRegionId", bwl.limits[0].local_region_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var bwl = AliCloud.Cen.GetBandwidthLimits.Invoke(new()
     *     {
     *         InstanceIds = new[]
     *         {
     *             "cen-id1",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstCenBandwidthLimitsLocalRegionId"] = bwl&#46;Apply(getBandwidthLimitsResult => getBandwidthLimitsResult&#46;Limits[0]?.LocalRegionId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		bwl, err := cen.GetBandwidthLimits(ctx, &cen.GetBandwidthLimitsArgs{
     * 			InstanceIds: []string{
     * 				"cen-id1",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstCenBandwidthLimitsLocalRegionId", bwl.Limits[0].LocalRegionId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetBandwidthLimitsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var bwl = CenFunctions.getBandwidthLimits(GetBandwidthLimitsArgs.builder()
     *             .instanceIds("cen-id1")
     *             .build());
     *         ctx.export("firstCenBandwidthLimitsLocalRegionId", bwl.applyValue(getBandwidthLimitsResult -> getBandwidthLimitsResult.limits()[0].localRegionId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   bwl:
     *     fn::invoke:
     *       Function: alicloud:cen:getBandwidthLimits
     *       Arguments:
     *         instanceIds:
     *           - cen-id1
     * outputs:
     *   firstCenBandwidthLimitsLocalRegionId: ${bwl.limits[0].localRegionId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBandwidthLimits.
     * @return A collection of values returned by getBandwidthLimits.
     */
    public suspend fun getBandwidthLimits(argument: GetBandwidthLimitsPlainArgs): GetBandwidthLimitsResult =
        getBandwidthLimitsResultToKotlin(getBandwidthLimitsPlain(argument.toJava()).await())

    /**
     * @see [getBandwidthLimits].
     * @param instanceIds A list of CEN instances IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getBandwidthLimits.
     */
    public suspend fun getBandwidthLimits(
        instanceIds: List<String>? = null,
        outputFile: String? =
            null,
    ): GetBandwidthLimitsResult {
        val argument = GetBandwidthLimitsPlainArgs(
            instanceIds = instanceIds,
            outputFile = outputFile,
        )
        return getBandwidthLimitsResultToKotlin(getBandwidthLimitsPlain(argument.toJava()).await())
    }

    /**
     * @see [getBandwidthLimits].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetBandwidthLimitsPlainArgs].
     * @return A collection of values returned by getBandwidthLimits.
     */
    public suspend fun getBandwidthLimits(argument: suspend GetBandwidthLimitsPlainArgsBuilder.() -> Unit): GetBandwidthLimitsResult {
        val builder = GetBandwidthLimitsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBandwidthLimitsResultToKotlin(getBandwidthLimitsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN Bandwidth Packages available to the user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cen.getBandwidthPackages({
     *     instanceId: "cen-id1",
     *     nameRegex: "^foo",
     * });
     * export const firstCenBandwidthPackageId = example.then(example => example.packages?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cen.get_bandwidth_packages(instance_id="cen-id1",
     *     name_regex="^foo")
     * pulumi.export("firstCenBandwidthPackageId", example.packages[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cen.GetBandwidthPackages.Invoke(new()
     *     {
     *         InstanceId = "cen-id1",
     *         NameRegex = "^foo",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstCenBandwidthPackageId"] = example&#46;Apply(getBandwidthPackagesResult => getBandwidthPackagesResult&#46;Packages[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cen.GetBandwidthPackages(ctx, &cen.GetBandwidthPackagesArgs{
     * 			InstanceId: pulumi.StringRef("cen-id1"),
     * 			NameRegex:  pulumi.StringRef("^foo"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstCenBandwidthPackageId", example.Packages[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetBandwidthPackagesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CenFunctions.getBandwidthPackages(GetBandwidthPackagesArgs.builder()
     *             .instanceId("cen-id1")
     *             .nameRegex("^foo")
     *             .build());
     *         ctx.export("firstCenBandwidthPackageId", example.applyValue(getBandwidthPackagesResult -> getBandwidthPackagesResult.packages()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cen:getBandwidthPackages
     *       Arguments:
     *         instanceId: cen-id1
     *         nameRegex: ^foo
     * outputs:
     *   firstCenBandwidthPackageId: ${example.packages[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBandwidthPackages.
     * @return A collection of values returned by getBandwidthPackages.
     */
    public suspend fun getBandwidthPackages(argument: GetBandwidthPackagesPlainArgs): GetBandwidthPackagesResult =
        getBandwidthPackagesResultToKotlin(getBandwidthPackagesPlain(argument.toJava()).await())

    /**
     * @see [getBandwidthPackages].
     * @param ids Limit search to a list of specific CEN Bandwidth Package IDs.
     * @param includeReservationData Indicates whether to include renewal data. Valid values: `true`: Return renewal data in the response. `false`: Do not return renewal data in the response.
     * @param instanceId ID of a CEN instance.
     * @param nameRegex A regex string to filter CEN Bandwidth Package by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status Status of the CEN Bandwidth Package in CEN instance, Valid value: `Idle` and `InUse`.
     * @return A collection of values returned by getBandwidthPackages.
     */
    public suspend fun getBandwidthPackages(
        ids: List<String>? = null,
        includeReservationData: Boolean? = null,
        instanceId: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetBandwidthPackagesResult {
        val argument = GetBandwidthPackagesPlainArgs(
            ids = ids,
            includeReservationData = includeReservationData,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getBandwidthPackagesResultToKotlin(getBandwidthPackagesPlain(argument.toJava()).await())
    }

    /**
     * @see [getBandwidthPackages].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetBandwidthPackagesPlainArgs].
     * @return A collection of values returned by getBandwidthPackages.
     */
    public suspend fun getBandwidthPackages(argument: suspend GetBandwidthPackagesPlainArgsBuilder.() -> Unit): GetBandwidthPackagesResult {
        val builder = GetBandwidthPackagesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBandwidthPackagesResultToKotlin(getBandwidthPackagesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Cen Child Instance Route Entry To Attachment available to the user.[What is Child Instance Route Entry To Attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createcenchildinstancerouteentrytoattachment)
     * > **NOTE:** Available in 1.195.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cen.getChildInstanceRouteEntryToAttachments({
     *     childInstanceRouteTableId: "vtb-t4nt0z5xxbti85c78nkzy",
     *     transitRouterAttachmentId: "tr-attach-f1fd1y50rql00emvej",
     * });
     * export const alicloudCenChildInstanceRouteEntryToAttachmentExampleId = _default.then(_default => _default.attachments?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cen.get_child_instance_route_entry_to_attachments(child_instance_route_table_id="vtb-t4nt0z5xxbti85c78nkzy",
     *     transit_router_attachment_id="tr-attach-f1fd1y50rql00emvej")
     * pulumi.export("alicloudCenChildInstanceRouteEntryToAttachmentExampleId", default.attachments[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Cen.GetChildInstanceRouteEntryToAttachments.Invoke(new()
     *     {
     *         ChildInstanceRouteTableId = "vtb-t4nt0z5xxbti85c78nkzy",
     *         TransitRouterAttachmentId = "tr-attach-f1fd1y50rql00emvej",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudCenChildInstanceRouteEntryToAttachmentExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getChildInstanceRouteEntryToAttachmentsResult => getChildInstanceRouteEntryToAttachmentsResult&#46;Attachments[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := cen.GetChildInstanceRouteEntryToAttachments(ctx, &cen.GetChildInstanceRouteEntryToAttachmentsArgs{
     * 			ChildInstanceRouteTableId: "vtb-t4nt0z5xxbti85c78nkzy",
     * 			TransitRouterAttachmentId: "tr-attach-f1fd1y50rql00emvej",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudCenChildInstanceRouteEntryToAttachmentExampleId", _default.Attachments[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetChildInstanceRouteEntryToAttachmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CenFunctions.getChildInstanceRouteEntryToAttachments(GetChildInstanceRouteEntryToAttachmentsArgs.builder()
     *             .childInstanceRouteTableId("vtb-t4nt0z5xxbti85c78nkzy")
     *             .transitRouterAttachmentId("tr-attach-f1fd1y50rql00emvej")
     *             .build());
     *         ctx.export("alicloudCenChildInstanceRouteEntryToAttachmentExampleId", default_.attachments()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cen:getChildInstanceRouteEntryToAttachments
     *       Arguments:
     *         childInstanceRouteTableId: vtb-t4nt0z5xxbti85c78nkzy
     *         transitRouterAttachmentId: tr-attach-f1fd1y50rql00emvej
     * outputs:
     *   alicloudCenChildInstanceRouteEntryToAttachmentExampleId: ${default.attachments[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getChildInstanceRouteEntryToAttachments.
     * @return A collection of values returned by getChildInstanceRouteEntryToAttachments.
     */
    public suspend fun getChildInstanceRouteEntryToAttachments(argument: GetChildInstanceRouteEntryToAttachmentsPlainArgs): GetChildInstanceRouteEntryToAttachmentsResult =
        getChildInstanceRouteEntryToAttachmentsResultToKotlin(getChildInstanceRouteEntryToAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getChildInstanceRouteEntryToAttachments].
     * @param cenId The ID of the CEN instance.
     * @param childInstanceRouteTableId The first ID of the resource
     * @param ids Limit search to a list of specific IDs.The value is formulated as `<cen_id>:<child_instance_route_table_id>:<transit_router_attachment_id>:<destination_cidr_block>`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param serviceType ServiceType
     * @param transitRouterAttachmentId TransitRouterAttachmentId
     * @return A collection of values returned by getChildInstanceRouteEntryToAttachments.
     */
    public suspend fun getChildInstanceRouteEntryToAttachments(
        cenId: String? = null,
        childInstanceRouteTableId: String,
        ids: List<String>? = null,
        outputFile: String? = null,
        serviceType: String? = null,
        transitRouterAttachmentId: String,
    ): GetChildInstanceRouteEntryToAttachmentsResult {
        val argument = GetChildInstanceRouteEntryToAttachmentsPlainArgs(
            cenId = cenId,
            childInstanceRouteTableId = childInstanceRouteTableId,
            ids = ids,
            outputFile = outputFile,
            serviceType = serviceType,
            transitRouterAttachmentId = transitRouterAttachmentId,
        )
        return getChildInstanceRouteEntryToAttachmentsResultToKotlin(getChildInstanceRouteEntryToAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getChildInstanceRouteEntryToAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetChildInstanceRouteEntryToAttachmentsPlainArgs].
     * @return A collection of values returned by getChildInstanceRouteEntryToAttachments.
     */
    public suspend fun getChildInstanceRouteEntryToAttachments(argument: suspend GetChildInstanceRouteEntryToAttachmentsPlainArgsBuilder.() -> Unit): GetChildInstanceRouteEntryToAttachmentsResult {
        val builder = GetChildInstanceRouteEntryToAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getChildInstanceRouteEntryToAttachmentsResultToKotlin(getChildInstanceRouteEntryToAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN flow logs available to the user.
     * > **NOTE:** Available in 1.78.0+
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cen.getFlowlogs({
     *     ids: ["flowlog-tig1xxxxx"],
     *     nameRegex: "^foo",
     * });
     * export const firstCenFlowlogId = defaultAlicloudCenInstances.flowlogs[0].id;
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cen.get_flowlogs(ids=["flowlog-tig1xxxxx"],
     *     name_regex="^foo")
     * pulumi.export("firstCenFlowlogId", default_alicloud_cen_instances["flowlogs"][0]["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Cen.GetFlowlogs.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "flowlog-tig1xxxxx",
     *         },
     *         NameRegex = "^foo",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstCenFlowlogId"] = defaultAlicloudCenInstances&#46;Flowlogs[0].Id,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cen.GetFlowlogs(ctx, &cen.GetFlowlogsArgs{
     * 			Ids: []string{
     * 				"flowlog-tig1xxxxx",
     * 			},
     * 			NameRegex: pulumi.StringRef("^foo"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstCenFlowlogId", defaultAlicloudCenInstances.Flowlogs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetFlowlogsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CenFunctions.getFlowlogs(GetFlowlogsArgs.builder()
     *             .ids("flowlog-tig1xxxxx")
     *             .nameRegex("^foo")
     *             .build());
     *         ctx.export("firstCenFlowlogId", defaultAlicloudCenInstances.flowlogs()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cen:getFlowlogs
     *       Arguments:
     *         ids:
     *           - flowlog-tig1xxxxx
     *         nameRegex: ^foo
     * outputs:
     *   firstCenFlowlogId: ${defaultAlicloudCenInstances.flowlogs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFlowlogs.
     * @return A collection of values returned by getFlowlogs.
     */
    public suspend fun getFlowlogs(argument: GetFlowlogsPlainArgs): GetFlowlogsResult =
        getFlowlogsResultToKotlin(getFlowlogsPlain(argument.toJava()).await())

    /**
     * @see [getFlowlogs].
     * @param cenId The ID of the CEN Instance.
     * @param description The description of flowlog.
     * @param ids A list of CEN flow log IDs.
     * @param logStoreName The name of the log store which is in the  `project_name` SLS project.
     * @param nameRegex A regex string to filter CEN flow logs by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param projectName The name of the SLS project.
     * @param status The status of flowlog. Valid values: ["Active", "Inactive"]. Default to "Active".
     * @return A collection of values returned by getFlowlogs.
     */
    public suspend fun getFlowlogs(
        cenId: String? = null,
        description: String? = null,
        ids: List<String>? = null,
        logStoreName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        projectName: String? = null,
        status: String? = null,
    ): GetFlowlogsResult {
        val argument = GetFlowlogsPlainArgs(
            cenId = cenId,
            description = description,
            ids = ids,
            logStoreName = logStoreName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            projectName = projectName,
            status = status,
        )
        return getFlowlogsResultToKotlin(getFlowlogsPlain(argument.toJava()).await())
    }

    /**
     * @see [getFlowlogs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetFlowlogsPlainArgs].
     * @return A collection of values returned by getFlowlogs.
     */
    public suspend fun getFlowlogs(argument: suspend GetFlowlogsPlainArgsBuilder.() -> Unit): GetFlowlogsResult {
        val builder = GetFlowlogsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFlowlogsResultToKotlin(getFlowlogsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Cen Instance Attachments of the current Alibaba Cloud User.
     * > **NOTE:** Available in v1.97.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cen.getInstanceAttachments({
     *     instanceId: "cen-o40h17ll9w********",
     * });
     * export const theFirstAttachmentedInstanceId = example.then(example => example.attachments?.[0]?.childInstanceId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cen.get_instance_attachments(instance_id="cen-o40h17ll9w********")
     * pulumi.export("theFirstAttachmentedInstanceId", example.attachments[0].child_instance_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cen.GetInstanceAttachments.Invoke(new()
     *     {
     *         InstanceId = "cen-o40h17ll9w********",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["theFirstAttachmentedInstanceId"] = example&#46;Apply(getInstanceAttachmentsResult => getInstanceAttachmentsResult&#46;Attachments[0]?.ChildInstanceId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cen.GetInstanceAttachments(ctx, &cen.GetInstanceAttachmentsArgs{
     * 			InstanceId: "cen-o40h17ll9w********",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("theFirstAttachmentedInstanceId", example.Attachments[0].ChildInstanceId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetInstanceAttachmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CenFunctions.getInstanceAttachments(GetInstanceAttachmentsArgs.builder()
     *             .instanceId("cen-o40h17ll9w********")
     *             .build());
     *         ctx.export("theFirstAttachmentedInstanceId", example.applyValue(getInstanceAttachmentsResult -> getInstanceAttachmentsResult.attachments()[0].childInstanceId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cen:getInstanceAttachments
     *       Arguments:
     *         instanceId: cen-o40h17ll9w********
     * outputs:
     *   theFirstAttachmentedInstanceId: ${example.attachments[0].childInstanceId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceAttachments.
     * @return A collection of values returned by getInstanceAttachments.
     */
    public suspend fun getInstanceAttachments(argument: GetInstanceAttachmentsPlainArgs): GetInstanceAttachmentsResult =
        getInstanceAttachmentsResultToKotlin(getInstanceAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getInstanceAttachments].
     * @param childInstanceRegionId The region to which the network to be queried belongs.
     * @param childInstanceType The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
     * @param instanceId The ID of the CEN instance.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the Cen Child Instance Attachment. Valid value: `Attaching`, `Attached` and `Aetaching`.
     * @return A collection of values returned by getInstanceAttachments.
     */
    public suspend fun getInstanceAttachments(
        childInstanceRegionId: String? = null,
        childInstanceType: String? = null,
        instanceId: String,
        outputFile: String? = null,
        status: String? = null,
    ): GetInstanceAttachmentsResult {
        val argument = GetInstanceAttachmentsPlainArgs(
            childInstanceRegionId = childInstanceRegionId,
            childInstanceType = childInstanceType,
            instanceId = instanceId,
            outputFile = outputFile,
            status = status,
        )
        return getInstanceAttachmentsResultToKotlin(getInstanceAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetInstanceAttachmentsPlainArgs].
     * @return A collection of values returned by getInstanceAttachments.
     */
    public suspend fun getInstanceAttachments(argument: suspend GetInstanceAttachmentsPlainArgsBuilder.() -> Unit): GetInstanceAttachmentsResult {
        val builder = GetInstanceAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceAttachmentsResultToKotlin(getInstanceAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN instances available to the user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const cenInstancesDs = alicloud.cen.getInstances({
     *     ids: ["cen-id1"],
     *     nameRegex: "^foo",
     * });
     * export const firstCenInstanceId = cenInstancesDs.then(cenInstancesDs => cenInstancesDs.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * cen_instances_ds = alicloud.cen.get_instances(ids=["cen-id1"],
     *     name_regex="^foo")
     * pulumi.export("firstCenInstanceId", cen_instances_ds.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var cenInstancesDs = AliCloud.Cen.GetInstances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "cen-id1",
     *         },
     *         NameRegex = "^foo",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstCenInstanceId"] = cenInstancesDs&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cenInstancesDs, err := cen.GetInstances(ctx, &cen.GetInstancesArgs{
     * 			Ids: []string{
     * 				"cen-id1",
     * 			},
     * 			NameRegex: pulumi.StringRef("^foo"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstCenInstanceId", cenInstancesDs.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var cenInstancesDs = CenFunctions.getInstances(GetInstancesArgs.builder()
     *             .ids("cen-id1")
     *             .nameRegex("^foo")
     *             .build());
     *         ctx.export("firstCenInstanceId", cenInstancesDs.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   cenInstancesDs:
     *     fn::invoke:
     *       Function: alicloud:cen:getInstances
     *       Arguments:
     *         ids:
     *           - cen-id1
     *         nameRegex: ^foo
     * outputs:
     *   firstCenInstanceId: ${cenInstancesDs.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param ids A list of CEN instances IDs.
     * @param nameRegex A regex string to filter CEN instances by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of CEN instance. Valid value: `Active`, `Creating` and `Deleting`.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            tags = tags,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cen Inter Region Traffic Qos Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.195.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cen.getInterRegionTrafficQosPolicies({
     *     ids: ["example_id"],
     *     transitRouterId: "your_transit_router_id",
     *     transitRouterAttachmentId: "your_transit_router_attachment_id",
     * });
     * export const cenInterRegionTrafficQosPolicyId0 = ids.then(ids => ids.policies?.[0]?.id);
     * const nameRegex = alicloud.cen.getInterRegionTrafficQosPolicies({
     *     nameRegex: "^my-name",
     *     transitRouterId: "your_transit_router_id",
     *     transitRouterAttachmentId: "your_transit_router_attachment_id",
     * });
     * export const cenInterRegionTrafficQosPolicyId1 = nameRegex.then(nameRegex => nameRegex.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cen.get_inter_region_traffic_qos_policies(ids=["example_id"],
     *     transit_router_id="your_transit_router_id",
     *     transit_router_attachment_id="your_transit_router_attachment_id")
     * pulumi.export("cenInterRegionTrafficQosPolicyId0", ids.policies[0].id)
     * name_regex = alicloud.cen.get_inter_region_traffic_qos_policies(name_regex="^my-name",
     *     transit_router_id="your_transit_router_id",
     *     transit_router_attachment_id="your_transit_router_attachment_id")
     * pulumi.export("cenInterRegionTrafficQosPolicyId1", name_regex.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cen.GetInterRegionTrafficQosPolicies.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         TransitRouterId = "your_transit_router_id",
     *         TransitRouterAttachmentId = "your_transit_router_attachment_id",
     *     });
     *     var nameRegex = AliCloud.Cen.GetInterRegionTrafficQosPolicies.Invoke(new()
     *     {
     *         NameRegex = "^my-name",
     *         TransitRouterId = "your_transit_router_id",
     *         TransitRouterAttachmentId = "your_transit_router_attachment_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cenInterRegionTrafficQosPolicyId0"] = ids&#46;Apply(getInterRegionTrafficQosPoliciesResult => getInterRegionTrafficQosPoliciesResult&#46;Policies[0]?.Id),
     *         ["cenInterRegionTrafficQosPolicyId1"] = nameRegex&#46;Apply(getInterRegionTrafficQosPoliciesResult => getInterRegionTrafficQosPoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cen.GetInterRegionTrafficQosPolicies(ctx, &cen.GetInterRegionTrafficQosPoliciesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			TransitRouterId:           "your_transit_router_id",
     * 			TransitRouterAttachmentId: "your_transit_router_attachment_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cenInterRegionTrafficQosPolicyId0", ids.Policies[0].Id)
     * 		nameRegex, err := cen.GetInterRegionTrafficQosPolicies(ctx, &cen.GetInterRegionTrafficQosPoliciesArgs{
     * 			NameRegex:                 pulumi.StringRef("^my-name"),
     * 			TransitRouterId:           "your_transit_router_id",
     * 			TransitRouterAttachmentId: "your_transit_router_attachment_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cenInterRegionTrafficQosPolicyId1", nameRegex.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetInterRegionTrafficQosPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CenFunctions.getInterRegionTrafficQosPolicies(GetInterRegionTrafficQosPoliciesArgs.builder()
     *             .ids("example_id")
     *             .transitRouterId("your_transit_router_id")
     *             .transitRouterAttachmentId("your_transit_router_attachment_id")
     *             .build());
     *         ctx.export("cenInterRegionTrafficQosPolicyId0", ids.applyValue(getInterRegionTrafficQosPoliciesResult -> getInterRegionTrafficQosPoliciesResult.policies()[0].id()));
     *         final var nameRegex = CenFunctions.getInterRegionTrafficQosPolicies(GetInterRegionTrafficQosPoliciesArgs.builder()
     *             .nameRegex("^my-name")
     *             .transitRouterId("your_transit_router_id")
     *             .transitRouterAttachmentId("your_transit_router_attachment_id")
     *             .build());
     *         ctx.export("cenInterRegionTrafficQosPolicyId1", nameRegex.applyValue(getInterRegionTrafficQosPoliciesResult -> getInterRegionTrafficQosPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cen:getInterRegionTrafficQosPolicies
     *       Arguments:
     *         ids:
     *           - example_id
     *         transitRouterId: your_transit_router_id
     *         transitRouterAttachmentId: your_transit_router_attachment_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cen:getInterRegionTrafficQosPolicies
     *       Arguments:
     *         nameRegex: ^my-name
     *         transitRouterId: your_transit_router_id
     *         transitRouterAttachmentId: your_transit_router_attachment_id
     * outputs:
     *   cenInterRegionTrafficQosPolicyId0: ${ids.policies[0].id}
     *   cenInterRegionTrafficQosPolicyId1: ${nameRegex.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInterRegionTrafficQosPolicies.
     * @return A collection of values returned by getInterRegionTrafficQosPolicies.
     */
    public suspend fun getInterRegionTrafficQosPolicies(argument: GetInterRegionTrafficQosPoliciesPlainArgs): GetInterRegionTrafficQosPoliciesResult =
        getInterRegionTrafficQosPoliciesResultToKotlin(getInterRegionTrafficQosPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getInterRegionTrafficQosPolicies].
     * @param ids A list of Inter Region Traffic Qos Policy IDs.
     * @param nameRegex A regex string to filter results by Inter Region Traffic Qos Policy name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the traffic scheduling policy. Valid Value: `Creating`, `Active`, `Modifying`, `Deleting`, `Deleted`.
     * @param trafficQosPolicyDescription The description of the QoS policy.
     * @param trafficQosPolicyId The ID of the QoS policy.
     * @param trafficQosPolicyName The name of the QoS policy.
     * @param transitRouterAttachmentId The ID of the inter-region connection.
     * @param transitRouterId The ID of the transit router.
     * @return A collection of values returned by getInterRegionTrafficQosPolicies.
     */
    public suspend fun getInterRegionTrafficQosPolicies(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        trafficQosPolicyDescription: String? = null,
        trafficQosPolicyId: String? = null,
        trafficQosPolicyName: String? = null,
        transitRouterAttachmentId: String,
        transitRouterId: String,
    ): GetInterRegionTrafficQosPoliciesResult {
        val argument = GetInterRegionTrafficQosPoliciesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            trafficQosPolicyDescription = trafficQosPolicyDescription,
            trafficQosPolicyId = trafficQosPolicyId,
            trafficQosPolicyName = trafficQosPolicyName,
            transitRouterAttachmentId = transitRouterAttachmentId,
            transitRouterId = transitRouterId,
        )
        return getInterRegionTrafficQosPoliciesResultToKotlin(getInterRegionTrafficQosPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInterRegionTrafficQosPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetInterRegionTrafficQosPoliciesPlainArgs].
     * @return A collection of values returned by getInterRegionTrafficQosPolicies.
     */
    public suspend fun getInterRegionTrafficQosPolicies(argument: suspend GetInterRegionTrafficQosPoliciesPlainArgsBuilder.() -> Unit): GetInterRegionTrafficQosPoliciesResult {
        val builder = GetInterRegionTrafficQosPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInterRegionTrafficQosPoliciesResultToKotlin(getInterRegionTrafficQosPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Cen Inter Region Traffic Qos Queue available to the user.
     * > **NOTE:** Available in 1.195.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cen.getInterRegionTrafficQosQueues({
     *     ids: [defaultAlicloudCenInterRegionTrafficQosQueue&#46;id],
     *     nameRegex: defaultAlicloudCenInterRegionTrafficQosQueue.name,
     *     trafficQosPolicyId: "qos-xxxxxxx",
     * });
     * export const alicloudCenInterRegionTrafficQosQueueExampleId = _default.then(_default => _default.queues?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cen.get_inter_region_traffic_qos_queues(ids=[default_alicloud_cen_inter_region_traffic_qos_queue["id"]],
     *     name_regex=default_alicloud_cen_inter_region_traffic_qos_queue["name"],
     *     traffic_qos_policy_id="qos-xxxxxxx")
     * pulumi.export("alicloudCenInterRegionTrafficQosQueueExampleId", default.queues[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Cen.GetInterRegionTrafficQosQueues.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudCenInterRegionTrafficQosQueue.Id,
     *         },
     *         NameRegex = defaultAlicloudCenInterRegionTrafficQosQueue.Name,
     *         TrafficQosPolicyId = "qos-xxxxxxx",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudCenInterRegionTrafficQosQueueExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getInterRegionTrafficQosQueuesResult => getInterRegionTrafficQosQueuesResult&#46;Queues[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := cen.GetInterRegionTrafficQosQueues(ctx, &cen.GetInterRegionTrafficQosQueuesArgs{
     * Ids: interface{}{
     * defaultAlicloudCenInterRegionTrafficQosQueue.Id,
     * },
     * NameRegex: pulumi.StringRef(defaultAlicloudCenInterRegionTrafficQosQueue.Name),
     * TrafficQosPolicyId: "qos-xxxxxxx",
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudCenInterRegionTrafficQosQueueExampleId", _default.Queues[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetInterRegionTrafficQosQueuesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CenFunctions.getInterRegionTrafficQosQueues(GetInterRegionTrafficQosQueuesArgs.builder()
     *             .ids(defaultAlicloudCenInterRegionTrafficQosQueue.id())
     *             .nameRegex(defaultAlicloudCenInterRegionTrafficQosQueue.name())
     *             .trafficQosPolicyId("qos-xxxxxxx")
     *             .build());
     *         ctx.export("alicloudCenInterRegionTrafficQosQueueExampleId", default_.queues()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cen:getInterRegionTrafficQosQueues
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudCenInterRegionTrafficQosQueue.id}
     *         nameRegex: ${defaultAlicloudCenInterRegionTrafficQosQueue.name}
     *         trafficQosPolicyId: qos-xxxxxxx
     * outputs:
     *   alicloudCenInterRegionTrafficQosQueueExampleId: ${default.queues[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInterRegionTrafficQosQueues.
     * @return A collection of values returned by getInterRegionTrafficQosQueues.
     */
    public suspend fun getInterRegionTrafficQosQueues(argument: GetInterRegionTrafficQosQueuesPlainArgs): GetInterRegionTrafficQosQueuesResult =
        getInterRegionTrafficQosQueuesResultToKotlin(getInterRegionTrafficQosQueuesPlain(argument.toJava()).await())

    /**
     * @see [getInterRegionTrafficQosQueues].
     * @param ids A list of Inter Region Traffic Qos Queue IDs.
     * @param nameRegex A regex string to filter results by Group Metric Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param trafficQosPolicyId The ID of the traffic scheduling policy.
     * @return A collection of values returned by getInterRegionTrafficQosQueues.
     */
    public suspend fun getInterRegionTrafficQosQueues(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        trafficQosPolicyId: String,
    ): GetInterRegionTrafficQosQueuesResult {
        val argument = GetInterRegionTrafficQosQueuesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            trafficQosPolicyId = trafficQosPolicyId,
        )
        return getInterRegionTrafficQosQueuesResultToKotlin(getInterRegionTrafficQosQueuesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInterRegionTrafficQosQueues].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetInterRegionTrafficQosQueuesPlainArgs].
     * @return A collection of values returned by getInterRegionTrafficQosQueues.
     */
    public suspend fun getInterRegionTrafficQosQueues(argument: suspend GetInterRegionTrafficQosQueuesPlainArgsBuilder.() -> Unit): GetInterRegionTrafficQosQueuesResult {
        val builder = GetInterRegionTrafficQosQueuesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInterRegionTrafficQosQueuesResultToKotlin(getInterRegionTrafficQosQueuesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN Private Zones available to the user.
     * > **NOTE:** Available in v1.88.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const this = alicloud.cen.getPrivateZones({
     *     cenId: "cen-o40h17ll9w********",
     *     ids: ["cn-hangzhou"],
     *     status: "Active",
     * });
     * export const firstCenPrivateZonesId = _this.then(_this => _this.zones?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * this = alicloud.cen.get_private_zones(cen_id="cen-o40h17ll9w********",
     *     ids=["cn-hangzhou"],
     *     status="Active")
     * pulumi.export("firstCenPrivateZonesId", this.zones[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @this = AliCloud.Cen.GetPrivateZones.Invoke(new()
     *     {
     *         CenId = "cen-o40h17ll9w********",
     *         Ids = new[]
     *         {
     *             "cn-hangzhou",
     *         },
     *         Status = "Active",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstCenPrivateZonesId"] = @this&#46;Apply(@this => @this&#46;Apply(getPrivateZonesResult => getPrivateZonesResult&#46;Zones[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		this, err := cen.GetPrivateZones(ctx, &cen.GetPrivateZonesArgs{
     * 			CenId: "cen-o40h17ll9w********",
     * 			Ids: []string{
     * 				"cn-hangzhou",
     * 			},
     * 			Status: pulumi.StringRef("Active"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstCenPrivateZonesId", this.Zones[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetPrivateZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var this = CenFunctions.getPrivateZones(GetPrivateZonesArgs.builder()
     *             .cenId("cen-o40h17ll9w********")
     *             .ids("cn-hangzhou")
     *             .status("Active")
     *             .build());
     *         ctx.export("firstCenPrivateZonesId", this_.zones()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   this:
     *     fn::invoke:
     *       Function: alicloud:cen:getPrivateZones
     *       Arguments:
     *         cenId: cen-o40h17ll9w********
     *         ids:
     *           - cn-hangzhou
     *         status: Active
     * outputs:
     *   firstCenPrivateZonesId: ${this.zones[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPrivateZones.
     * @return A collection of values returned by getPrivateZones.
     */
    public suspend fun getPrivateZones(argument: GetPrivateZonesPlainArgs): GetPrivateZonesResult =
        getPrivateZonesResultToKotlin(getPrivateZonesPlain(argument.toJava()).await())

    /**
     * @see [getPrivateZones].
     * @param cenId The ID of the CEN instance.
     * @param hostRegionId The service region. The service region is the target region of the PrivateZone service accessed through CEN.
     * @param ids A list of CEN private zone IDs. Each element format as `<cen_id>:<access_region_id>`.
     * **NOTE:** Before 1.162.0, each element same as `access_region_id`.
     * * `host_region_id ` - (Optional) The service region is the target region of the PrivateZone service accessed through CEN.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the PrivateZone service, including `Creating`, `Active` and `Deleting`.
     * @return A collection of values returned by getPrivateZones.
     */
    public suspend fun getPrivateZones(
        cenId: String,
        hostRegionId: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetPrivateZonesResult {
        val argument = GetPrivateZonesPlainArgs(
            cenId = cenId,
            hostRegionId = hostRegionId,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getPrivateZonesResultToKotlin(getPrivateZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetPrivateZonesPlainArgs].
     * @return A collection of values returned by getPrivateZones.
     */
    public suspend fun getPrivateZones(argument: suspend GetPrivateZonesPlainArgsBuilder.() -> Unit): GetPrivateZonesResult {
        val builder = GetPrivateZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateZonesResultToKotlin(getPrivateZonesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN Regional Route Entries available to the user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const entry = alicloud.cen.getRegionRouteEntries({
     *     instanceId: "cen-id1",
     *     regionId: "cn-beijing",
     * });
     * export const firstRegionRouteEntriesRouteEntryCidrBlock = entry.then(entry => entry.entries?.[0]?.cidrBlock);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * entry = alicloud.cen.get_region_route_entries(instance_id="cen-id1",
     *     region_id="cn-beijing")
     * pulumi.export("firstRegionRouteEntriesRouteEntryCidrBlock", entry.entries[0].cidr_block)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var entry = AliCloud.Cen.GetRegionRouteEntries.Invoke(new()
     *     {
     *         InstanceId = "cen-id1",
     *         RegionId = "cn-beijing",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRegionRouteEntriesRouteEntryCidrBlock"] = entry&#46;Apply(getRegionRouteEntriesResult => getRegionRouteEntriesResult&#46;Entries[0]?.CidrBlock),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		entry, err := cen.GetRegionRouteEntries(ctx, &cen.GetRegionRouteEntriesArgs{
     * 			InstanceId: "cen-id1",
     * 			RegionId:   "cn-beijing",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRegionRouteEntriesRouteEntryCidrBlock", entry.Entries[0].CidrBlock)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetRegionRouteEntriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var entry = CenFunctions.getRegionRouteEntries(GetRegionRouteEntriesArgs.builder()
     *             .instanceId("cen-id1")
     *             .regionId("cn-beijing")
     *             .build());
     *         ctx.export("firstRegionRouteEntriesRouteEntryCidrBlock", entry.applyValue(getRegionRouteEntriesResult -> getRegionRouteEntriesResult.entries()[0].cidrBlock()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   entry:
     *     fn::invoke:
     *       Function: alicloud:cen:getRegionRouteEntries
     *       Arguments:
     *         instanceId: cen-id1
     *         regionId: cn-beijing
     * outputs:
     *   firstRegionRouteEntriesRouteEntryCidrBlock: ${entry.entries[0].cidrBlock}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRegionRouteEntries.
     * @return A collection of values returned by getRegionRouteEntries.
     */
    public suspend fun getRegionRouteEntries(argument: GetRegionRouteEntriesPlainArgs): GetRegionRouteEntriesResult =
        getRegionRouteEntriesResultToKotlin(getRegionRouteEntriesPlain(argument.toJava()).await())

    /**
     * @see [getRegionRouteEntries].
     * @param instanceId ID of the CEN instance.
     * @param outputFile
     * @param regionId ID of the region.
     * @return A collection of values returned by getRegionRouteEntries.
     */
    public suspend fun getRegionRouteEntries(
        instanceId: String,
        outputFile: String? = null,
        regionId: String,
    ): GetRegionRouteEntriesResult {
        val argument = GetRegionRouteEntriesPlainArgs(
            instanceId = instanceId,
            outputFile = outputFile,
            regionId = regionId,
        )
        return getRegionRouteEntriesResultToKotlin(getRegionRouteEntriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegionRouteEntries].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetRegionRouteEntriesPlainArgs].
     * @return A collection of values returned by getRegionRouteEntries.
     */
    public suspend fun getRegionRouteEntries(argument: suspend GetRegionRouteEntriesPlainArgsBuilder.() -> Unit): GetRegionRouteEntriesResult {
        val builder = GetRegionRouteEntriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegionRouteEntriesResultToKotlin(getRegionRouteEntriesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN Route Entries available to the user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const entry = alicloud.cen.getRouteEntries({
     *     instanceId: "cen-id1",
     *     routeTableId: "vtb-id1",
     * });
     * export const firstRouteEntriesRouteEntryCidrBlock = entry.then(entry => entry.entries?.[0]?.cidrBlock);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * entry = alicloud.cen.get_route_entries(instance_id="cen-id1",
     *     route_table_id="vtb-id1")
     * pulumi.export("firstRouteEntriesRouteEntryCidrBlock", entry.entries[0].cidr_block)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var entry = AliCloud.Cen.GetRouteEntries.Invoke(new()
     *     {
     *         InstanceId = "cen-id1",
     *         RouteTableId = "vtb-id1",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRouteEntriesRouteEntryCidrBlock"] = entry&#46;Apply(getRouteEntriesResult => getRouteEntriesResult&#46;Entries[0]?.CidrBlock),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		entry, err := cen.GetRouteEntries(ctx, &cen.GetRouteEntriesArgs{
     * 			InstanceId:   "cen-id1",
     * 			RouteTableId: "vtb-id1",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRouteEntriesRouteEntryCidrBlock", entry.Entries[0].CidrBlock)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetRouteEntriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var entry = CenFunctions.getRouteEntries(GetRouteEntriesArgs.builder()
     *             .instanceId("cen-id1")
     *             .routeTableId("vtb-id1")
     *             .build());
     *         ctx.export("firstRouteEntriesRouteEntryCidrBlock", entry.applyValue(getRouteEntriesResult -> getRouteEntriesResult.entries()[0].cidrBlock()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   entry:
     *     fn::invoke:
     *       Function: alicloud:cen:getRouteEntries
     *       Arguments:
     *         instanceId: cen-id1
     *         routeTableId: vtb-id1
     * outputs:
     *   firstRouteEntriesRouteEntryCidrBlock: ${entry.entries[0].cidrBlock}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRouteEntries.
     * @return A collection of values returned by getRouteEntries.
     */
    public suspend fun getRouteEntries(argument: GetRouteEntriesPlainArgs): GetRouteEntriesResult =
        getRouteEntriesResultToKotlin(getRouteEntriesPlain(argument.toJava()).await())

    /**
     * @see [getRouteEntries].
     * @param cidrBlock The destination CIDR block of the route entry to query.
     * @param instanceId ID of the CEN instance.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param routeTableId ID of the route table of the VPC or VBR.
     * @return A collection of values returned by getRouteEntries.
     */
    public suspend fun getRouteEntries(
        cidrBlock: String? = null,
        instanceId: String,
        outputFile: String? = null,
        routeTableId: String,
    ): GetRouteEntriesResult {
        val argument = GetRouteEntriesPlainArgs(
            cidrBlock = cidrBlock,
            instanceId = instanceId,
            outputFile = outputFile,
            routeTableId = routeTableId,
        )
        return getRouteEntriesResultToKotlin(getRouteEntriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteEntries].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetRouteEntriesPlainArgs].
     * @return A collection of values returned by getRouteEntries.
     */
    public suspend fun getRouteEntries(argument: suspend GetRouteEntriesPlainArgsBuilder.() -> Unit): GetRouteEntriesResult {
        val builder = GetRouteEntriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteEntriesResultToKotlin(getRouteEntriesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN Route Maps available to the user.
     * > **NOTE:** Available in v1.87.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const this = alicloud.cen.getRouteMaps({
     *     cenId: "cen-ihdlgo87ai********",
     *     ids: ["cen-ihdlgo87ai:cenrmap-bnh97kb3mn********"],
     *     descriptionRegex: "datasource_test",
     *     cenRegionId: "cn-hangzhou",
     *     transmitDirection: "RegionIn",
     *     status: "Active",
     * });
     * export const firstCenRouteMapId = _this.then(_this => _this.maps?.[0]?.routeMapId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * this = alicloud.cen.get_route_maps(cen_id="cen-ihdlgo87ai********",
     *     ids=["cen-ihdlgo87ai:cenrmap-bnh97kb3mn********"],
     *     description_regex="datasource_test",
     *     cen_region_id="cn-hangzhou",
     *     transmit_direction="RegionIn",
     *     status="Active")
     * pulumi.export("firstCenRouteMapId", this.maps[0].route_map_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @this = AliCloud.Cen.GetRouteMaps.Invoke(new()
     *     {
     *         CenId = "cen-ihdlgo87ai********",
     *         Ids = new[]
     *         {
     *             "cen-ihdlgo87ai:cenrmap-bnh97kb3mn********",
     *         },
     *         DescriptionRegex = "datasource_test",
     *         CenRegionId = "cn-hangzhou",
     *         TransmitDirection = "RegionIn",
     *         Status = "Active",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstCenRouteMapId"] = @this&#46;Apply(@this => @this&#46;Apply(getRouteMapsResult => getRouteMapsResult&#46;Maps[0]?.RouteMapId)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		this, err := cen.GetRouteMaps(ctx, &cen.GetRouteMapsArgs{
     * 			CenId: "cen-ihdlgo87ai********",
     * 			Ids: []string{
     * 				"cen-ihdlgo87ai:cenrmap-bnh97kb3mn********",
     * 			},
     * 			DescriptionRegex:  pulumi.StringRef("datasource_test"),
     * 			CenRegionId:       pulumi.StringRef("cn-hangzhou"),
     * 			TransmitDirection: pulumi.StringRef("RegionIn"),
     * 			Status:            pulumi.StringRef("Active"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstCenRouteMapId", this.Maps[0].RouteMapId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetRouteMapsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var this = CenFunctions.getRouteMaps(GetRouteMapsArgs.builder()
     *             .cenId("cen-ihdlgo87ai********")
     *             .ids("cen-ihdlgo87ai:cenrmap-bnh97kb3mn********")
     *             .descriptionRegex("datasource_test")
     *             .cenRegionId("cn-hangzhou")
     *             .transmitDirection("RegionIn")
     *             .status("Active")
     *             .build());
     *         ctx.export("firstCenRouteMapId", this_.maps()[0].routeMapId());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   this:
     *     fn::invoke:
     *       Function: alicloud:cen:getRouteMaps
     *       Arguments:
     *         cenId: cen-ihdlgo87ai********
     *         ids:
     *           - cen-ihdlgo87ai:cenrmap-bnh97kb3mn********
     *         descriptionRegex: datasource_test
     *         cenRegionId: cn-hangzhou
     *         transmitDirection: RegionIn
     *         status: Active
     * outputs:
     *   firstCenRouteMapId: ${this.maps[0].routeMapId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRouteMaps.
     * @return A collection of values returned by getRouteMaps.
     */
    public suspend fun getRouteMaps(argument: GetRouteMapsPlainArgs): GetRouteMapsResult =
        getRouteMapsResultToKotlin(getRouteMapsPlain(argument.toJava()).await())

    /**
     * @see [getRouteMaps].
     * @param cenId The ID of the CEN instance.
     * @param cenRegionId The ID of the region to which the CEN instance belongs.
     * @param descriptionRegex A regex string to filter CEN route map by description.
     * @param ids A list of CEN route map IDs. Each item formats as `<cen_id>:<route_map_id>`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the route map, including `Creating`, `Active` and `Deleting`.
     * @param transmitDirection The direction in which the route map is applied, including `RegionIn` and `RegionOut`.
     * @return A collection of values returned by getRouteMaps.
     */
    public suspend fun getRouteMaps(
        cenId: String,
        cenRegionId: String? = null,
        descriptionRegex: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
        transmitDirection: String? = null,
    ): GetRouteMapsResult {
        val argument = GetRouteMapsPlainArgs(
            cenId = cenId,
            cenRegionId = cenRegionId,
            descriptionRegex = descriptionRegex,
            ids = ids,
            outputFile = outputFile,
            status = status,
            transmitDirection = transmitDirection,
        )
        return getRouteMapsResultToKotlin(getRouteMapsPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteMaps].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetRouteMapsPlainArgs].
     * @return A collection of values returned by getRouteMaps.
     */
    public suspend fun getRouteMaps(argument: suspend GetRouteMapsPlainArgsBuilder.() -> Unit): GetRouteMapsResult {
        val builder = GetRouteMapsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteMapsResultToKotlin(getRouteMapsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN Route Service available to the user.
     * > **NOTE:** Available in v1.102.0+
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cen.getRouteServices({
     *     cenId: "cen-7qthudw0ll6jmc****",
     * });
     * export const firstCenRouteServiceId = example.then(example => example.services?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cen.get_route_services(cen_id="cen-7qthudw0ll6jmc****")
     * pulumi.export("firstCenRouteServiceId", example.services[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cen.GetRouteServices.Invoke(new()
     *     {
     *         CenId = "cen-7qthudw0ll6jmc****",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstCenRouteServiceId"] = example&#46;Apply(getRouteServicesResult => getRouteServicesResult&#46;Services[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cen.GetRouteServices(ctx, &cen.GetRouteServicesArgs{
     * 			CenId: "cen-7qthudw0ll6jmc****",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstCenRouteServiceId", example.Services[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetRouteServicesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CenFunctions.getRouteServices(GetRouteServicesArgs.builder()
     *             .cenId("cen-7qthudw0ll6jmc****")
     *             .build());
     *         ctx.export("firstCenRouteServiceId", example.applyValue(getRouteServicesResult -> getRouteServicesResult.services()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cen:getRouteServices
     *       Arguments:
     *         cenId: cen-7qthudw0ll6jmc****
     * outputs:
     *   firstCenRouteServiceId: ${example.services[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRouteServices.
     * @return A collection of values returned by getRouteServices.
     */
    public suspend fun getRouteServices(argument: GetRouteServicesPlainArgs): GetRouteServicesResult =
        getRouteServicesResultToKotlin(getRouteServicesPlain(argument.toJava()).await())

    /**
     * @see [getRouteServices].
     * @param accessRegionId The region of the network instances that access the cloud services.
     * @param cenId The ID of the CEN instance.
     * @param host The domain name or IP address of the cloud service.
     * @param hostRegionId The region of the cloud service.
     * @param hostVpcId The VPC associated with the cloud service.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the cloud service. Valid values: `Active`, `Creating` and `Deleting`.
     * @return A collection of values returned by getRouteServices.
     */
    public suspend fun getRouteServices(
        accessRegionId: String? = null,
        cenId: String,
        host: String? = null,
        hostRegionId: String? = null,
        hostVpcId: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetRouteServicesResult {
        val argument = GetRouteServicesPlainArgs(
            accessRegionId = accessRegionId,
            cenId = cenId,
            host = host,
            hostRegionId = hostRegionId,
            hostVpcId = hostVpcId,
            outputFile = outputFile,
            status = status,
        )
        return getRouteServicesResultToKotlin(getRouteServicesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteServices].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetRouteServicesPlainArgs].
     * @return A collection of values returned by getRouteServices.
     */
    public suspend fun getRouteServices(argument: suspend GetRouteServicesPlainArgsBuilder.() -> Unit): GetRouteServicesResult {
        val builder = GetRouteServicesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteServicesResultToKotlin(getRouteServicesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cen Traffic Marking Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.173.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cen.getTrafficMarkingPolicies({
     *     transitRouterId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const cenTrafficMarkingPolicyId1 = ids.then(ids => ids.policies?.[0]?.id);
     * const nameRegex = alicloud.cen.getTrafficMarkingPolicies({
     *     transitRouterId: "example_value",
     *     nameRegex: "^my-TrafficMarkingPolicy",
     * });
     * export const cenTrafficMarkingPolicyId2 = nameRegex.then(nameRegex => nameRegex.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cen.get_traffic_marking_policies(transit_router_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("cenTrafficMarkingPolicyId1", ids.policies[0].id)
     * name_regex = alicloud.cen.get_traffic_marking_policies(transit_router_id="example_value",
     *     name_regex="^my-TrafficMarkingPolicy")
     * pulumi.export("cenTrafficMarkingPolicyId2", name_regex.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cen.GetTrafficMarkingPolicies.Invoke(new()
     *     {
     *         TransitRouterId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Cen.GetTrafficMarkingPolicies.Invoke(new()
     *     {
     *         TransitRouterId = "example_value",
     *         NameRegex = "^my-TrafficMarkingPolicy",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cenTrafficMarkingPolicyId1"] = ids&#46;Apply(getTrafficMarkingPoliciesResult => getTrafficMarkingPoliciesResult&#46;Policies[0]?.Id),
     *         ["cenTrafficMarkingPolicyId2"] = nameRegex&#46;Apply(getTrafficMarkingPoliciesResult => getTrafficMarkingPoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cen.GetTrafficMarkingPolicies(ctx, &cen.GetTrafficMarkingPoliciesArgs{
     * 			TransitRouterId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cenTrafficMarkingPolicyId1", ids.Policies[0].Id)
     * 		nameRegex, err := cen.GetTrafficMarkingPolicies(ctx, &cen.GetTrafficMarkingPoliciesArgs{
     * 			TransitRouterId: "example_value",
     * 			NameRegex:       pulumi.StringRef("^my-TrafficMarkingPolicy"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cenTrafficMarkingPolicyId2", nameRegex.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTrafficMarkingPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CenFunctions.getTrafficMarkingPolicies(GetTrafficMarkingPoliciesArgs.builder()
     *             .transitRouterId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("cenTrafficMarkingPolicyId1", ids.applyValue(getTrafficMarkingPoliciesResult -> getTrafficMarkingPoliciesResult.policies()[0].id()));
     *         final var nameRegex = CenFunctions.getTrafficMarkingPolicies(GetTrafficMarkingPoliciesArgs.builder()
     *             .transitRouterId("example_value")
     *             .nameRegex("^my-TrafficMarkingPolicy")
     *             .build());
     *         ctx.export("cenTrafficMarkingPolicyId2", nameRegex.applyValue(getTrafficMarkingPoliciesResult -> getTrafficMarkingPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cen:getTrafficMarkingPolicies
     *       Arguments:
     *         transitRouterId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cen:getTrafficMarkingPolicies
     *       Arguments:
     *         transitRouterId: example_value
     *         nameRegex: ^my-TrafficMarkingPolicy
     * outputs:
     *   cenTrafficMarkingPolicyId1: ${ids.policies[0].id}
     *   cenTrafficMarkingPolicyId2: ${nameRegex.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTrafficMarkingPolicies.
     * @return A collection of values returned by getTrafficMarkingPolicies.
     */
    public suspend fun getTrafficMarkingPolicies(argument: GetTrafficMarkingPoliciesPlainArgs): GetTrafficMarkingPoliciesResult =
        getTrafficMarkingPoliciesResultToKotlin(getTrafficMarkingPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getTrafficMarkingPolicies].
     * @param description
     * @param ids A list of Traffic Marking Policy IDs.
     * @param nameRegex A regex string to filter results by Traffic Marking Policy name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource.  Valid values: `Active`, `Creating`, `Deleting`, `Updating`.
     * @param transitRouterId The ID of the transit router.
     * @return A collection of values returned by getTrafficMarkingPolicies.
     */
    public suspend fun getTrafficMarkingPolicies(
        description: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        transitRouterId: String,
    ): GetTrafficMarkingPoliciesResult {
        val argument = GetTrafficMarkingPoliciesPlainArgs(
            description = description,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouterId = transitRouterId,
        )
        return getTrafficMarkingPoliciesResultToKotlin(getTrafficMarkingPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrafficMarkingPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTrafficMarkingPoliciesPlainArgs].
     * @return A collection of values returned by getTrafficMarkingPolicies.
     */
    public suspend fun getTrafficMarkingPolicies(argument: suspend GetTrafficMarkingPoliciesPlainArgsBuilder.() -> Unit): GetTrafficMarkingPoliciesResult {
        val builder = GetTrafficMarkingPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrafficMarkingPoliciesResultToKotlin(getTrafficMarkingPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cen Transit Route Table Aggregations of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.202.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cen.getTransitRouteTableAggregations({
     *     ids: ["example_id"],
     *     transitRouteTableId: "your_transit_route_table_id",
     * });
     * export const cenTransitRouterMulticastDomainId0 = ids.then(ids => ids.transitRouteTableAggregations?.[0]?.id);
     * const nameRegex = alicloud.cen.getTransitRouteTableAggregations({
     *     nameRegex: "^my-name",
     *     transitRouteTableId: "your_transit_route_table_id",
     * });
     * export const cenTransitRouterMulticastDomainId1 = nameRegex.then(nameRegex => nameRegex.transitRouteTableAggregations?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cen.get_transit_route_table_aggregations(ids=["example_id"],
     *     transit_route_table_id="your_transit_route_table_id")
     * pulumi.export("cenTransitRouterMulticastDomainId0", ids.transit_route_table_aggregations[0].id)
     * name_regex = alicloud.cen.get_transit_route_table_aggregations(name_regex="^my-name",
     *     transit_route_table_id="your_transit_route_table_id")
     * pulumi.export("cenTransitRouterMulticastDomainId1", name_regex.transit_route_table_aggregations[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cen.GetTransitRouteTableAggregations.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         TransitRouteTableId = "your_transit_route_table_id",
     *     });
     *     var nameRegex = AliCloud.Cen.GetTransitRouteTableAggregations.Invoke(new()
     *     {
     *         NameRegex = "^my-name",
     *         TransitRouteTableId = "your_transit_route_table_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cenTransitRouterMulticastDomainId0"] = ids&#46;Apply(getTransitRouteTableAggregationsResult => getTransitRouteTableAggregationsResult&#46;TransitRouteTableAggregations[0]?.Id),
     *         ["cenTransitRouterMulticastDomainId1"] = nameRegex&#46;Apply(getTransitRouteTableAggregationsResult => getTransitRouteTableAggregationsResult&#46;TransitRouteTableAggregations[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cen.GetTransitRouteTableAggregations(ctx, &cen.GetTransitRouteTableAggregationsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			TransitRouteTableId: "your_transit_route_table_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cenTransitRouterMulticastDomainId0", ids.TransitRouteTableAggregations[0].Id)
     * 		nameRegex, err := cen.GetTransitRouteTableAggregations(ctx, &cen.GetTransitRouteTableAggregationsArgs{
     * 			NameRegex:           pulumi.StringRef("^my-name"),
     * 			TransitRouteTableId: "your_transit_route_table_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cenTransitRouterMulticastDomainId1", nameRegex.TransitRouteTableAggregations[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouteTableAggregationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CenFunctions.getTransitRouteTableAggregations(GetTransitRouteTableAggregationsArgs.builder()
     *             .ids("example_id")
     *             .transitRouteTableId("your_transit_route_table_id")
     *             .build());
     *         ctx.export("cenTransitRouterMulticastDomainId0", ids.applyValue(getTransitRouteTableAggregationsResult -> getTransitRouteTableAggregationsResult.transitRouteTableAggregations()[0].id()));
     *         final var nameRegex = CenFunctions.getTransitRouteTableAggregations(GetTransitRouteTableAggregationsArgs.builder()
     *             .nameRegex("^my-name")
     *             .transitRouteTableId("your_transit_route_table_id")
     *             .build());
     *         ctx.export("cenTransitRouterMulticastDomainId1", nameRegex.applyValue(getTransitRouteTableAggregationsResult -> getTransitRouteTableAggregationsResult.transitRouteTableAggregations()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouteTableAggregations
     *       Arguments:
     *         ids:
     *           - example_id
     *         transitRouteTableId: your_transit_route_table_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouteTableAggregations
     *       Arguments:
     *         nameRegex: ^my-name
     *         transitRouteTableId: your_transit_route_table_id
     * outputs:
     *   cenTransitRouterMulticastDomainId0: ${ids.transitRouteTableAggregations[0].id}
     *   cenTransitRouterMulticastDomainId1: ${nameRegex.transitRouteTableAggregations[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouteTableAggregations.
     * @return A collection of values returned by getTransitRouteTableAggregations.
     */
    public suspend fun getTransitRouteTableAggregations(argument: GetTransitRouteTableAggregationsPlainArgs): GetTransitRouteTableAggregationsResult =
        getTransitRouteTableAggregationsResultToKotlin(getTransitRouteTableAggregationsPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouteTableAggregations].
     * @param ids A list of Transit Route Table Aggregation IDs.
     * @param nameRegex A regex string to filter results by Transit Route Table Aggregation name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of Transit Route Table Aggregation. Valid Values: `AllConfigured`, `Configuring`, `ConfigFailed`, `PartialConfigured`, `Deleting`.
     * @param transitRouteTableAggregationCidr The destination CIDR block of the aggregate route.
     * @param transitRouteTableId The ID of the route table of the Enterprise Edition transit router.
     * @return A collection of values returned by getTransitRouteTableAggregations.
     */
    public suspend fun getTransitRouteTableAggregations(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        transitRouteTableAggregationCidr: String? = null,
        transitRouteTableId: String,
    ): GetTransitRouteTableAggregationsResult {
        val argument = GetTransitRouteTableAggregationsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouteTableAggregationCidr = transitRouteTableAggregationCidr,
            transitRouteTableId = transitRouteTableId,
        )
        return getTransitRouteTableAggregationsResultToKotlin(getTransitRouteTableAggregationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouteTableAggregations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouteTableAggregationsPlainArgs].
     * @return A collection of values returned by getTransitRouteTableAggregations.
     */
    public suspend fun getTransitRouteTableAggregations(argument: suspend GetTransitRouteTableAggregationsPlainArgsBuilder.() -> Unit): GetTransitRouteTableAggregationsResult {
        val builder = GetTransitRouteTableAggregationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouteTableAggregationsResultToKotlin(getTransitRouteTableAggregationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the CEN Transit Router Available Resources of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.163.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cen.getTransitRouterAvailableResources({});
     * export const masterId = ids.then(ids => ids.resources?.[0]?&#46;masterZones?&#46;[0]);
     * export const slaveId = ids.then(ids => ids.resources?.[0]?&#46;slaveZones?&#46;[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cen.get_transit_router_available_resources()
     * pulumi.export("masterId", ids.resources[0]&#46;master_zones[0])
     * pulumi.export("slaveId", ids.resources[0]&#46;slave_zones[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cen.GetTransitRouterAvailableResources.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["masterId"] = ids&#46;Apply(getTransitRouterAvailableResourcesResult => getTransitRouterAvailableResourcesResult&#46;Resources[0]?&#46;MasterZones[0]),
     *         ["slaveId"] = ids&#46;Apply(getTransitRouterAvailableResourcesResult => getTransitRouterAvailableResourcesResult&#46;Resources[0]?&#46;SlaveZones[0]),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cen.GetTransitRouterAvailableResources(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("masterId", ids.Resources[0]&#46;MasterZones[0])
     * 		ctx.Export("slaveId", ids.Resources[0]&#46;SlaveZones[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouterAvailableResourcesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CenFunctions.getTransitRouterAvailableResources();
     *         ctx.export("masterId", ids.applyValue(getTransitRouterAvailableResourcesResult -> getTransitRouterAvailableResourcesResult.resources()[0]&#46;masterZones()[0]));
     *         ctx.export("slaveId", ids.applyValue(getTransitRouterAvailableResourcesResult -> getTransitRouterAvailableResourcesResult.resources()[0]&#46;slaveZones()[0]));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterAvailableResources
     *       Arguments: {}
     * outputs:
     *   masterId: ${ids.resources[0]&#46;masterZones[0]}
     *   slaveId: ${ids.resources[0]&#46;slaveZones[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouterAvailableResources.
     * @return A collection of values returned by getTransitRouterAvailableResources.
     */
    public suspend fun getTransitRouterAvailableResources(argument: GetTransitRouterAvailableResourcesPlainArgs): GetTransitRouterAvailableResourcesResult =
        getTransitRouterAvailableResourcesResultToKotlin(getTransitRouterAvailableResourcesPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterAvailableResources].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param supportMulticast Specifies whether to query only the zones in which the multicast feature is supported.
     * @return A collection of values returned by getTransitRouterAvailableResources.
     */
    public suspend fun getTransitRouterAvailableResources(
        outputFile: String? = null,
        supportMulticast: Boolean? = null,
    ): GetTransitRouterAvailableResourcesResult {
        val argument = GetTransitRouterAvailableResourcesPlainArgs(
            outputFile = outputFile,
            supportMulticast = supportMulticast,
        )
        return getTransitRouterAvailableResourcesResultToKotlin(getTransitRouterAvailableResourcesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterAvailableResources].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterAvailableResourcesPlainArgs].
     * @return A collection of values returned by getTransitRouterAvailableResources.
     */
    public suspend fun getTransitRouterAvailableResources(argument: suspend GetTransitRouterAvailableResourcesPlainArgsBuilder.() -> Unit): GetTransitRouterAvailableResourcesResult {
        val builder = GetTransitRouterAvailableResourcesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterAvailableResourcesResultToKotlin(getTransitRouterAvailableResourcesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cen Transit Router Cidrs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.193.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cen.getTransitRouterCidrs({
     *     ids: ["example_id"],
     *     transitRouterId: "tr-6ehx7q2jze8ch5ji0****",
     * });
     * export const cenTransitRouterCidrId0 = ids.then(ids => ids.cidrs?.[0]?.id);
     * const nameRegex = alicloud.cen.getTransitRouterCidrs({
     *     nameRegex: "^my-name",
     *     transitRouterId: "tr-6ehx7q2jze8ch5ji0****",
     * });
     * export const cenTransitRouterCidrId1 = nameRegex.then(nameRegex => nameRegex.cidrs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cen.get_transit_router_cidrs(ids=["example_id"],
     *     transit_router_id="tr-6ehx7q2jze8ch5ji0****")
     * pulumi.export("cenTransitRouterCidrId0", ids.cidrs[0].id)
     * name_regex = alicloud.cen.get_transit_router_cidrs(name_regex="^my-name",
     *     transit_router_id="tr-6ehx7q2jze8ch5ji0****")
     * pulumi.export("cenTransitRouterCidrId1", name_regex.cidrs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cen.GetTransitRouterCidrs.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         TransitRouterId = "tr-6ehx7q2jze8ch5ji0****",
     *     });
     *     var nameRegex = AliCloud.Cen.GetTransitRouterCidrs.Invoke(new()
     *     {
     *         NameRegex = "^my-name",
     *         TransitRouterId = "tr-6ehx7q2jze8ch5ji0****",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cenTransitRouterCidrId0"] = ids&#46;Apply(getTransitRouterCidrsResult => getTransitRouterCidrsResult&#46;Cidrs[0]?.Id),
     *         ["cenTransitRouterCidrId1"] = nameRegex&#46;Apply(getTransitRouterCidrsResult => getTransitRouterCidrsResult&#46;Cidrs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cen.GetTransitRouterCidrs(ctx, &cen.GetTransitRouterCidrsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			TransitRouterId: "tr-6ehx7q2jze8ch5ji0****",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cenTransitRouterCidrId0", ids.Cidrs[0].Id)
     * 		nameRegex, err := cen.GetTransitRouterCidrs(ctx, &cen.GetTransitRouterCidrsArgs{
     * 			NameRegex:       pulumi.StringRef("^my-name"),
     * 			TransitRouterId: "tr-6ehx7q2jze8ch5ji0****",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cenTransitRouterCidrId1", nameRegex.Cidrs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouterCidrsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CenFunctions.getTransitRouterCidrs(GetTransitRouterCidrsArgs.builder()
     *             .ids("example_id")
     *             .transitRouterId("tr-6ehx7q2jze8ch5ji0****")
     *             .build());
     *         ctx.export("cenTransitRouterCidrId0", ids.applyValue(getTransitRouterCidrsResult -> getTransitRouterCidrsResult.cidrs()[0].id()));
     *         final var nameRegex = CenFunctions.getTransitRouterCidrs(GetTransitRouterCidrsArgs.builder()
     *             .nameRegex("^my-name")
     *             .transitRouterId("tr-6ehx7q2jze8ch5ji0****")
     *             .build());
     *         ctx.export("cenTransitRouterCidrId1", nameRegex.applyValue(getTransitRouterCidrsResult -> getTransitRouterCidrsResult.cidrs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterCidrs
     *       Arguments:
     *         ids:
     *           - example_id
     *         transitRouterId: tr-6ehx7q2jze8ch5ji0****
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterCidrs
     *       Arguments:
     *         nameRegex: ^my-name
     *         transitRouterId: tr-6ehx7q2jze8ch5ji0****
     * outputs:
     *   cenTransitRouterCidrId0: ${ids.cidrs[0].id}
     *   cenTransitRouterCidrId1: ${nameRegex.cidrs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouterCidrs.
     * @return A collection of values returned by getTransitRouterCidrs.
     */
    public suspend fun getTransitRouterCidrs(argument: GetTransitRouterCidrsPlainArgs): GetTransitRouterCidrsResult =
        getTransitRouterCidrsResultToKotlin(getTransitRouterCidrsPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterCidrs].
     * @param ids A list of Cen Transit Router Cidr IDs.
     * @param nameRegex A regex string to filter results by Transit Router Cidr name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param transitRouterCidrId The ID of the transit router cidr.
     * @param transitRouterId The ID of the transit router.
     * @return A collection of values returned by getTransitRouterCidrs.
     */
    public suspend fun getTransitRouterCidrs(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        transitRouterCidrId: String? = null,
        transitRouterId: String,
    ): GetTransitRouterCidrsResult {
        val argument = GetTransitRouterCidrsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            transitRouterCidrId = transitRouterCidrId,
            transitRouterId = transitRouterId,
        )
        return getTransitRouterCidrsResultToKotlin(getTransitRouterCidrsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterCidrs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterCidrsPlainArgs].
     * @return A collection of values returned by getTransitRouterCidrs.
     */
    public suspend fun getTransitRouterCidrs(argument: suspend GetTransitRouterCidrsPlainArgsBuilder.() -> Unit): GetTransitRouterCidrsResult {
        val builder = GetTransitRouterCidrsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterCidrsResultToKotlin(getTransitRouterCidrsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cen Transit Router Multicast Domain Associations of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.195.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cen.getTransitRouterMulticastDomainAssociations({
     *     ids: ["example_id"],
     *     transitRouterMulticastDomainId: "your_transit_router_multicast_domain_id",
     * });
     * export const cenTransitRouterMulticastDomainId0 = ids.then(ids => ids.associations?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cen.get_transit_router_multicast_domain_associations(ids=["example_id"],
     *     transit_router_multicast_domain_id="your_transit_router_multicast_domain_id")
     * pulumi.export("cenTransitRouterMulticastDomainId0", ids.associations[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cen.GetTransitRouterMulticastDomainAssociations.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         TransitRouterMulticastDomainId = "your_transit_router_multicast_domain_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cenTransitRouterMulticastDomainId0"] = ids&#46;Apply(getTransitRouterMulticastDomainAssociationsResult => getTransitRouterMulticastDomainAssociationsResult&#46;Associations[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cen.GetTransitRouterMulticastDomainAssociations(ctx, &cen.GetTransitRouterMulticastDomainAssociationsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			TransitRouterMulticastDomainId: "your_transit_router_multicast_domain_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cenTransitRouterMulticastDomainId0", ids.Associations[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainAssociationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CenFunctions.getTransitRouterMulticastDomainAssociations(GetTransitRouterMulticastDomainAssociationsArgs.builder()
     *             .ids("example_id")
     *             .transitRouterMulticastDomainId("your_transit_router_multicast_domain_id")
     *             .build());
     *         ctx.export("cenTransitRouterMulticastDomainId0", ids.applyValue(getTransitRouterMulticastDomainAssociationsResult -> getTransitRouterMulticastDomainAssociationsResult.associations()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterMulticastDomainAssociations
     *       Arguments:
     *         ids:
     *           - example_id
     *         transitRouterMulticastDomainId: your_transit_router_multicast_domain_id
     * outputs:
     *   cenTransitRouterMulticastDomainId0: ${ids.associations[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouterMulticastDomainAssociations.
     * @return A collection of values returned by getTransitRouterMulticastDomainAssociations.
     */
    public suspend fun getTransitRouterMulticastDomainAssociations(argument: GetTransitRouterMulticastDomainAssociationsPlainArgs): GetTransitRouterMulticastDomainAssociationsResult =
        getTransitRouterMulticastDomainAssociationsResultToKotlin(getTransitRouterMulticastDomainAssociationsPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterMulticastDomainAssociations].
     * @param ids A list of Transit Router Multicast Domain Association IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceId The ID of the resource associated with the multicast domain.
     * @param resourceType The type of resource associated with the multicast domain. Valid Value: `VPC`.
     * @param status The status of the associated resource. Valid Value: `Associated`, `Associating`, `Dissociating`.
     * @param transitRouterAttachmentId The ID of the network instance connection.
     * @param transitRouterMulticastDomainId The ID of the multicast domain.
     * @param vswitchId The ID of the vSwitch.
     * @return A collection of values returned by getTransitRouterMulticastDomainAssociations.
     */
    public suspend fun getTransitRouterMulticastDomainAssociations(
        ids: List<String>? = null,
        outputFile: String? = null,
        resourceId: String? = null,
        resourceType: String? = null,
        status: String? = null,
        transitRouterAttachmentId: String? = null,
        transitRouterMulticastDomainId: String,
        vswitchId: String? = null,
    ): GetTransitRouterMulticastDomainAssociationsResult {
        val argument = GetTransitRouterMulticastDomainAssociationsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            resourceId = resourceId,
            resourceType = resourceType,
            status = status,
            transitRouterAttachmentId = transitRouterAttachmentId,
            transitRouterMulticastDomainId = transitRouterMulticastDomainId,
            vswitchId = vswitchId,
        )
        return getTransitRouterMulticastDomainAssociationsResultToKotlin(getTransitRouterMulticastDomainAssociationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterMulticastDomainAssociations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterMulticastDomainAssociationsPlainArgs].
     * @return A collection of values returned by getTransitRouterMulticastDomainAssociations.
     */
    public suspend fun getTransitRouterMulticastDomainAssociations(argument: suspend GetTransitRouterMulticastDomainAssociationsPlainArgsBuilder.() -> Unit): GetTransitRouterMulticastDomainAssociationsResult {
        val builder = GetTransitRouterMulticastDomainAssociationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterMulticastDomainAssociationsResultToKotlin(getTransitRouterMulticastDomainAssociationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Cen Transit Router Multicast Domain Member available to the user. [What is Transit Router Multicast Domain Member](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-registertransitroutermulticastgroupmembers)
     * > **NOTE:** Available since v1.195.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cen.getTransitRouterMulticastDomainMembers({
     *     transitRouterMulticastDomainId: "tr-mcast-domain-2d9oq455uk533zfr29",
     * });
     * export const alicloudCenTransitRouterMulticastDomainMemberExampleId = _default.then(_default => _default.members?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cen.get_transit_router_multicast_domain_members(transit_router_multicast_domain_id="tr-mcast-domain-2d9oq455uk533zfr29")
     * pulumi.export("alicloudCenTransitRouterMulticastDomainMemberExampleId", default.members[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Cen.GetTransitRouterMulticastDomainMembers.Invoke(new()
     *     {
     *         TransitRouterMulticastDomainId = "tr-mcast-domain-2d9oq455uk533zfr29",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudCenTransitRouterMulticastDomainMemberExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getTransitRouterMulticastDomainMembersResult => getTransitRouterMulticastDomainMembersResult&#46;Members[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := cen.GetTransitRouterMulticastDomainMembers(ctx, &cen.GetTransitRouterMulticastDomainMembersArgs{
     * 			TransitRouterMulticastDomainId: "tr-mcast-domain-2d9oq455uk533zfr29",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudCenTransitRouterMulticastDomainMemberExampleId", _default.Members[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainMembersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CenFunctions.getTransitRouterMulticastDomainMembers(GetTransitRouterMulticastDomainMembersArgs.builder()
     *             .transitRouterMulticastDomainId("tr-mcast-domain-2d9oq455uk533zfr29")
     *             .build());
     *         ctx.export("alicloudCenTransitRouterMulticastDomainMemberExampleId", default_.members()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterMulticastDomainMembers
     *       Arguments:
     *         transitRouterMulticastDomainId: tr-mcast-domain-2d9oq455uk533zfr29
     * outputs:
     *   alicloudCenTransitRouterMulticastDomainMemberExampleId: ${default.members[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouterMulticastDomainMembers.
     * @return A collection of values returned by getTransitRouterMulticastDomainMembers.
     */
    public suspend fun getTransitRouterMulticastDomainMembers(argument: GetTransitRouterMulticastDomainMembersPlainArgs): GetTransitRouterMulticastDomainMembersResult =
        getTransitRouterMulticastDomainMembersResultToKotlin(getTransitRouterMulticastDomainMembersPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterMulticastDomainMembers].
     * @param ids A list of Transit Router Multicast Domain Member IDs.
     * @param networkInterfaceId The ID of the ENI.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param transitRouterMulticastDomainId The ID of the multicast domain to which the multicast member belongs.
     * @return A collection of values returned by getTransitRouterMulticastDomainMembers.
     */
    public suspend fun getTransitRouterMulticastDomainMembers(
        ids: List<String>? = null,
        networkInterfaceId: String? = null,
        outputFile: String? = null,
        transitRouterMulticastDomainId: String,
    ): GetTransitRouterMulticastDomainMembersResult {
        val argument = GetTransitRouterMulticastDomainMembersPlainArgs(
            ids = ids,
            networkInterfaceId = networkInterfaceId,
            outputFile = outputFile,
            transitRouterMulticastDomainId = transitRouterMulticastDomainId,
        )
        return getTransitRouterMulticastDomainMembersResultToKotlin(getTransitRouterMulticastDomainMembersPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterMulticastDomainMembers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterMulticastDomainMembersPlainArgs].
     * @return A collection of values returned by getTransitRouterMulticastDomainMembers.
     */
    public suspend fun getTransitRouterMulticastDomainMembers(argument: suspend GetTransitRouterMulticastDomainMembersPlainArgsBuilder.() -> Unit): GetTransitRouterMulticastDomainMembersResult {
        val builder = GetTransitRouterMulticastDomainMembersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterMulticastDomainMembersResultToKotlin(getTransitRouterMulticastDomainMembersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Cen Transit Router Multicast Domain Peer Member available to the user. [What is Transit Router Multicast Domain Peer Member](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-registertransitroutermulticastgroupmembers)
     * > **NOTE:** Available since v1.195.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cen.getTransitRouterMulticastDomainPeerMembers({
     *     transitRouterMulticastDomainId: "tr-mcast-domain-2d9oq455uk533zfrxx",
     * });
     * export const alicloudCenTransitRouterMulticastDomainPeerMemberExampleId = _default.then(_default => _default.members?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cen.get_transit_router_multicast_domain_peer_members(transit_router_multicast_domain_id="tr-mcast-domain-2d9oq455uk533zfrxx")
     * pulumi.export("alicloudCenTransitRouterMulticastDomainPeerMemberExampleId", default.members[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Cen.GetTransitRouterMulticastDomainPeerMembers.Invoke(new()
     *     {
     *         TransitRouterMulticastDomainId = "tr-mcast-domain-2d9oq455uk533zfrxx",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudCenTransitRouterMulticastDomainPeerMemberExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getTransitRouterMulticastDomainPeerMembersResult => getTransitRouterMulticastDomainPeerMembersResult&#46;Members[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := cen.GetTransitRouterMulticastDomainPeerMembers(ctx, &cen.GetTransitRouterMulticastDomainPeerMembersArgs{
     * 			TransitRouterMulticastDomainId: "tr-mcast-domain-2d9oq455uk533zfrxx",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudCenTransitRouterMulticastDomainPeerMemberExampleId", _default.Members[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainPeerMembersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CenFunctions.getTransitRouterMulticastDomainPeerMembers(GetTransitRouterMulticastDomainPeerMembersArgs.builder()
     *             .transitRouterMulticastDomainId("tr-mcast-domain-2d9oq455uk533zfrxx")
     *             .build());
     *         ctx.export("alicloudCenTransitRouterMulticastDomainPeerMemberExampleId", default_.members()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterMulticastDomainPeerMembers
     *       Arguments:
     *         transitRouterMulticastDomainId: tr-mcast-domain-2d9oq455uk533zfrxx
     * outputs:
     *   alicloudCenTransitRouterMulticastDomainPeerMemberExampleId: ${default.members[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouterMulticastDomainPeerMembers.
     * @return A collection of values returned by getTransitRouterMulticastDomainPeerMembers.
     */
    public suspend fun getTransitRouterMulticastDomainPeerMembers(argument: GetTransitRouterMulticastDomainPeerMembersPlainArgs): GetTransitRouterMulticastDomainPeerMembersResult =
        getTransitRouterMulticastDomainPeerMembersResultToKotlin(getTransitRouterMulticastDomainPeerMembersPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterMulticastDomainPeerMembers].
     * @param ids A list of Cen Transit Router Multicast Domain Peer Member IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param peerTransitRouterMulticastDomains The IDs of the inter-region multicast domains.
     * @param resourceId The ID of the resource associated with the multicast resource.
     * @param resourceType The type of the multicast resource. Valid values:
     * * VPC: queries multicast resources by VPC.
     * * TR: queries multicast resources that are also deployed in a different region.
     * @param transitRouterAttachmentId The ID of the network instance connection.
     * @param transitRouterMulticastDomainId The ID of the multicast domain to which the multicast member belongs.
     * @return A collection of values returned by getTransitRouterMulticastDomainPeerMembers.
     */
    public suspend fun getTransitRouterMulticastDomainPeerMembers(
        ids: List<String>? = null,
        outputFile: String? = null,
        peerTransitRouterMulticastDomains: List<String>? = null,
        resourceId: String? = null,
        resourceType: String? = null,
        transitRouterAttachmentId: String? = null,
        transitRouterMulticastDomainId: String,
    ): GetTransitRouterMulticastDomainPeerMembersResult {
        val argument = GetTransitRouterMulticastDomainPeerMembersPlainArgs(
            ids = ids,
            outputFile = outputFile,
            peerTransitRouterMulticastDomains = peerTransitRouterMulticastDomains,
            resourceId = resourceId,
            resourceType = resourceType,
            transitRouterAttachmentId = transitRouterAttachmentId,
            transitRouterMulticastDomainId = transitRouterMulticastDomainId,
        )
        return getTransitRouterMulticastDomainPeerMembersResultToKotlin(getTransitRouterMulticastDomainPeerMembersPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterMulticastDomainPeerMembers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterMulticastDomainPeerMembersPlainArgs].
     * @return A collection of values returned by getTransitRouterMulticastDomainPeerMembers.
     */
    public suspend fun getTransitRouterMulticastDomainPeerMembers(argument: suspend GetTransitRouterMulticastDomainPeerMembersPlainArgsBuilder.() -> Unit): GetTransitRouterMulticastDomainPeerMembersResult {
        val builder = GetTransitRouterMulticastDomainPeerMembersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterMulticastDomainPeerMembersResultToKotlin(getTransitRouterMulticastDomainPeerMembersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Cen Transit Router Multicast Domain Source available to the user.[What is Transit Router Multicast Domain Source](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-registertransitroutermulticastgroupsources)
     * > **NOTE:** Available since v1.195.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cen.getTransitRouterMulticastDomainSources({
     *     transitRouterMulticastDomainId: "tr-mcast-domain-xxxxxx",
     * });
     * export const alicloudCenTransitRouterMulticastDomainSourceExampleId = _default.then(_default => _default.sources?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cen.get_transit_router_multicast_domain_sources(transit_router_multicast_domain_id="tr-mcast-domain-xxxxxx")
     * pulumi.export("alicloudCenTransitRouterMulticastDomainSourceExampleId", default.sources[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Cen.GetTransitRouterMulticastDomainSources.Invoke(new()
     *     {
     *         TransitRouterMulticastDomainId = "tr-mcast-domain-xxxxxx",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudCenTransitRouterMulticastDomainSourceExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getTransitRouterMulticastDomainSourcesResult => getTransitRouterMulticastDomainSourcesResult&#46;Sources[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := cen.GetTransitRouterMulticastDomainSources(ctx, &cen.GetTransitRouterMulticastDomainSourcesArgs{
     * 			TransitRouterMulticastDomainId: "tr-mcast-domain-xxxxxx",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudCenTransitRouterMulticastDomainSourceExampleId", _default.Sources[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainSourcesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CenFunctions.getTransitRouterMulticastDomainSources(GetTransitRouterMulticastDomainSourcesArgs.builder()
     *             .transitRouterMulticastDomainId("tr-mcast-domain-xxxxxx")
     *             .build());
     *         ctx.export("alicloudCenTransitRouterMulticastDomainSourceExampleId", default_.sources()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterMulticastDomainSources
     *       Arguments:
     *         transitRouterMulticastDomainId: tr-mcast-domain-xxxxxx
     * outputs:
     *   alicloudCenTransitRouterMulticastDomainSourceExampleId: ${default.sources[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouterMulticastDomainSources.
     * @return A collection of values returned by getTransitRouterMulticastDomainSources.
     */
    public suspend fun getTransitRouterMulticastDomainSources(argument: GetTransitRouterMulticastDomainSourcesPlainArgs): GetTransitRouterMulticastDomainSourcesResult =
        getTransitRouterMulticastDomainSourcesResultToKotlin(getTransitRouterMulticastDomainSourcesPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterMulticastDomainSources].
     * @param ids A list of the multicast domain IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param transitRouterMulticastDomainId The ID of the multicast domain to which the multicast source belongs.
     * @return A collection of values returned by getTransitRouterMulticastDomainSources.
     */
    public suspend fun getTransitRouterMulticastDomainSources(
        ids: List<String>? = null,
        outputFile: String? = null,
        transitRouterMulticastDomainId: String,
    ): GetTransitRouterMulticastDomainSourcesResult {
        val argument = GetTransitRouterMulticastDomainSourcesPlainArgs(
            ids = ids,
            outputFile = outputFile,
            transitRouterMulticastDomainId = transitRouterMulticastDomainId,
        )
        return getTransitRouterMulticastDomainSourcesResultToKotlin(getTransitRouterMulticastDomainSourcesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterMulticastDomainSources].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterMulticastDomainSourcesPlainArgs].
     * @return A collection of values returned by getTransitRouterMulticastDomainSources.
     */
    public suspend fun getTransitRouterMulticastDomainSources(argument: suspend GetTransitRouterMulticastDomainSourcesPlainArgsBuilder.() -> Unit): GetTransitRouterMulticastDomainSourcesResult {
        val builder = GetTransitRouterMulticastDomainSourcesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterMulticastDomainSourcesResultToKotlin(getTransitRouterMulticastDomainSourcesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cen Transit Router Multicast Domains of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.195.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cen.getTransitRouterMulticastDomains({
     *     ids: ["example_id"],
     *     transitRouterId: "your_transit_router_id",
     * });
     * export const cenTransitRouterMulticastDomainId0 = ids.then(ids => ids.domains?.[0]?.id);
     * const nameRegex = alicloud.cen.getTransitRouterMulticastDomains({
     *     nameRegex: "^my-name",
     *     transitRouterId: "your_transit_router_id",
     * });
     * export const cenTransitRouterMulticastDomainId1 = nameRegex.then(nameRegex => nameRegex.domains?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cen.get_transit_router_multicast_domains(ids=["example_id"],
     *     transit_router_id="your_transit_router_id")
     * pulumi.export("cenTransitRouterMulticastDomainId0", ids.domains[0].id)
     * name_regex = alicloud.cen.get_transit_router_multicast_domains(name_regex="^my-name",
     *     transit_router_id="your_transit_router_id")
     * pulumi.export("cenTransitRouterMulticastDomainId1", name_regex.domains[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cen.GetTransitRouterMulticastDomains.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         TransitRouterId = "your_transit_router_id",
     *     });
     *     var nameRegex = AliCloud.Cen.GetTransitRouterMulticastDomains.Invoke(new()
     *     {
     *         NameRegex = "^my-name",
     *         TransitRouterId = "your_transit_router_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cenTransitRouterMulticastDomainId0"] = ids&#46;Apply(getTransitRouterMulticastDomainsResult => getTransitRouterMulticastDomainsResult&#46;Domains[0]?.Id),
     *         ["cenTransitRouterMulticastDomainId1"] = nameRegex&#46;Apply(getTransitRouterMulticastDomainsResult => getTransitRouterMulticastDomainsResult&#46;Domains[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cen.GetTransitRouterMulticastDomains(ctx, &cen.GetTransitRouterMulticastDomainsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			TransitRouterId: "your_transit_router_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cenTransitRouterMulticastDomainId0", ids.Domains[0].Id)
     * 		nameRegex, err := cen.GetTransitRouterMulticastDomains(ctx, &cen.GetTransitRouterMulticastDomainsArgs{
     * 			NameRegex:       pulumi.StringRef("^my-name"),
     * 			TransitRouterId: "your_transit_router_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cenTransitRouterMulticastDomainId1", nameRegex.Domains[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CenFunctions.getTransitRouterMulticastDomains(GetTransitRouterMulticastDomainsArgs.builder()
     *             .ids("example_id")
     *             .transitRouterId("your_transit_router_id")
     *             .build());
     *         ctx.export("cenTransitRouterMulticastDomainId0", ids.applyValue(getTransitRouterMulticastDomainsResult -> getTransitRouterMulticastDomainsResult.domains()[0].id()));
     *         final var nameRegex = CenFunctions.getTransitRouterMulticastDomains(GetTransitRouterMulticastDomainsArgs.builder()
     *             .nameRegex("^my-name")
     *             .transitRouterId("your_transit_router_id")
     *             .build());
     *         ctx.export("cenTransitRouterMulticastDomainId1", nameRegex.applyValue(getTransitRouterMulticastDomainsResult -> getTransitRouterMulticastDomainsResult.domains()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterMulticastDomains
     *       Arguments:
     *         ids:
     *           - example_id
     *         transitRouterId: your_transit_router_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterMulticastDomains
     *       Arguments:
     *         nameRegex: ^my-name
     *         transitRouterId: your_transit_router_id
     * outputs:
     *   cenTransitRouterMulticastDomainId0: ${ids.domains[0].id}
     *   cenTransitRouterMulticastDomainId1: ${nameRegex.domains[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouterMulticastDomains.
     * @return A collection of values returned by getTransitRouterMulticastDomains.
     */
    public suspend fun getTransitRouterMulticastDomains(argument: GetTransitRouterMulticastDomainsPlainArgs): GetTransitRouterMulticastDomainsResult =
        getTransitRouterMulticastDomainsResultToKotlin(getTransitRouterMulticastDomainsPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterMulticastDomains].
     * @param ids A list of Transit Router Multicast Domain IDs.
     * @param nameRegex A regex string to filter results by Transit Router Multicast Domain name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the multicast domain. Valid Value: `Active`.
     * @param transitRouterId The ID of the transit router.
     * @param transitRouterMulticastDomainId The ID of the multicast domain.
     * @return A collection of values returned by getTransitRouterMulticastDomains.
     */
    public suspend fun getTransitRouterMulticastDomains(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        transitRouterId: String,
        transitRouterMulticastDomainId: String? = null,
    ): GetTransitRouterMulticastDomainsResult {
        val argument = GetTransitRouterMulticastDomainsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouterId = transitRouterId,
            transitRouterMulticastDomainId = transitRouterMulticastDomainId,
        )
        return getTransitRouterMulticastDomainsResultToKotlin(getTransitRouterMulticastDomainsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterMulticastDomains].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterMulticastDomainsPlainArgs].
     * @return A collection of values returned by getTransitRouterMulticastDomains.
     */
    public suspend fun getTransitRouterMulticastDomains(argument: suspend GetTransitRouterMulticastDomainsPlainArgsBuilder.() -> Unit): GetTransitRouterMulticastDomainsResult {
        val builder = GetTransitRouterMulticastDomainsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterMulticastDomainsResultToKotlin(getTransitRouterMulticastDomainsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN Transit Router peer attachments available to the user.
     * > **NOTE:** Available in 1.128.0+
     * @param argument A collection of arguments for invoking getTransitRouterPeerAttachments.
     * @return A collection of values returned by getTransitRouterPeerAttachments.
     */
    public suspend fun getTransitRouterPeerAttachments(argument: GetTransitRouterPeerAttachmentsPlainArgs): GetTransitRouterPeerAttachmentsResult =
        getTransitRouterPeerAttachmentsResultToKotlin(getTransitRouterPeerAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterPeerAttachments].
     * @param cenId ID of the CEN instance.
     * @param ids A list of CEN Transit Router peer attachments IDs.
     * @param nameRegex A regex string to filter CEN Transit Router peer attachments by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of CEN Transit Router peer attachment. Valid values `Attached`, `Attaching` and `Detaching`.
     * @param transitRouterAttachmentId The ID of CEN Transit Router peer attachments.
     * @param transitRouterId The ID of transit router.
     * @return A collection of values returned by getTransitRouterPeerAttachments.
     */
    public suspend fun getTransitRouterPeerAttachments(
        cenId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        transitRouterAttachmentId: String? = null,
        transitRouterId: String? = null,
    ): GetTransitRouterPeerAttachmentsResult {
        val argument = GetTransitRouterPeerAttachmentsPlainArgs(
            cenId = cenId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouterAttachmentId = transitRouterAttachmentId,
            transitRouterId = transitRouterId,
        )
        return getTransitRouterPeerAttachmentsResultToKotlin(getTransitRouterPeerAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterPeerAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterPeerAttachmentsPlainArgs].
     * @return A collection of values returned by getTransitRouterPeerAttachments.
     */
    public suspend fun getTransitRouterPeerAttachments(argument: suspend GetTransitRouterPeerAttachmentsPlainArgsBuilder.() -> Unit): GetTransitRouterPeerAttachmentsResult {
        val builder = GetTransitRouterPeerAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterPeerAttachmentsResultToKotlin(getTransitRouterPeerAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cen Transit Router Prefix List Associations of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.188.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cen.getTransitRouterPrefixListAssociations({
     *     transitRouterId: "tr-6ehx7q2jze8ch5ji0****",
     *     transitRouterTableId: "vtb-6ehgc262hr170qgyc****",
     * });
     * export const cenTransitRouterPrefixListAssociationId = _default.then(_default => _default.associations?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cen.get_transit_router_prefix_list_associations(transit_router_id="tr-6ehx7q2jze8ch5ji0****",
     *     transit_router_table_id="vtb-6ehgc262hr170qgyc****")
     * pulumi.export("cenTransitRouterPrefixListAssociationId", default.associations[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Cen.GetTransitRouterPrefixListAssociations.Invoke(new()
     *     {
     *         TransitRouterId = "tr-6ehx7q2jze8ch5ji0****",
     *         TransitRouterTableId = "vtb-6ehgc262hr170qgyc****",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cenTransitRouterPrefixListAssociationId"] = @default&#46;Apply(@default => @default&#46;Apply(getTransitRouterPrefixListAssociationsResult => getTransitRouterPrefixListAssociationsResult&#46;Associations[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := cen.GetTransitRouterPrefixListAssociations(ctx, &cen.GetTransitRouterPrefixListAssociationsArgs{
     * 			TransitRouterId:      "tr-6ehx7q2jze8ch5ji0****",
     * 			TransitRouterTableId: "vtb-6ehgc262hr170qgyc****",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cenTransitRouterPrefixListAssociationId", _default.Associations[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouterPrefixListAssociationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CenFunctions.getTransitRouterPrefixListAssociations(GetTransitRouterPrefixListAssociationsArgs.builder()
     *             .transitRouterId("tr-6ehx7q2jze8ch5ji0****")
     *             .transitRouterTableId("vtb-6ehgc262hr170qgyc****")
     *             .build());
     *         ctx.export("cenTransitRouterPrefixListAssociationId", default_.associations()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterPrefixListAssociations
     *       Arguments:
     *         transitRouterId: tr-6ehx7q2jze8ch5ji0****
     *         transitRouterTableId: vtb-6ehgc262hr170qgyc****
     * outputs:
     *   cenTransitRouterPrefixListAssociationId: ${default.associations[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouterPrefixListAssociations.
     * @return A collection of values returned by getTransitRouterPrefixListAssociations.
     */
    public suspend fun getTransitRouterPrefixListAssociations(argument: GetTransitRouterPrefixListAssociationsPlainArgs): GetTransitRouterPrefixListAssociationsResult =
        getTransitRouterPrefixListAssociationsResultToKotlin(getTransitRouterPrefixListAssociationsPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterPrefixListAssociations].
     * @param ids A list of Cen Transit Router Prefix List Association IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param ownerUid The ID of the Alibaba Cloud account to which the prefix list belongs.
     * @param pageNumber
     * @param pageSize
     * @param prefixListId The ID of the prefix list.
     * @param status The status of the prefix list. Valid Value: `Active`, `Updating`.
     * @param transitRouterId The ID of the transit router.
     * @param transitRouterTableId The ID of the route table of the transit router.
     * @return A collection of values returned by getTransitRouterPrefixListAssociations.
     */
    public suspend fun getTransitRouterPrefixListAssociations(
        ids: List<String>? = null,
        outputFile: String? = null,
        ownerUid: Int? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        prefixListId: String? = null,
        status: String? = null,
        transitRouterId: String,
        transitRouterTableId: String,
    ): GetTransitRouterPrefixListAssociationsResult {
        val argument = GetTransitRouterPrefixListAssociationsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            ownerUid = ownerUid,
            pageNumber = pageNumber,
            pageSize = pageSize,
            prefixListId = prefixListId,
            status = status,
            transitRouterId = transitRouterId,
            transitRouterTableId = transitRouterTableId,
        )
        return getTransitRouterPrefixListAssociationsResultToKotlin(getTransitRouterPrefixListAssociationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterPrefixListAssociations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterPrefixListAssociationsPlainArgs].
     * @return A collection of values returned by getTransitRouterPrefixListAssociations.
     */
    public suspend fun getTransitRouterPrefixListAssociations(argument: suspend GetTransitRouterPrefixListAssociationsPlainArgsBuilder.() -> Unit): GetTransitRouterPrefixListAssociationsResult {
        val builder = GetTransitRouterPrefixListAssociationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterPrefixListAssociationsResultToKotlin(getTransitRouterPrefixListAssociationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN Transit Router Route Entries available to the user.[What is Cen Transit Router Route Entries](https://help.aliyun.com/document_detail/260941.html)
     * > **NOTE:** Available in 1.126.0+
     * @param argument A collection of arguments for invoking getTransitRouterRouteEntries.
     * @return A collection of values returned by getTransitRouterRouteEntries.
     */
    public suspend fun getTransitRouterRouteEntries(argument: GetTransitRouterRouteEntriesPlainArgs): GetTransitRouterRouteEntriesResult =
        getTransitRouterRouteEntriesResultToKotlin(getTransitRouterRouteEntriesPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterRouteEntries].
     * @param ids A list of CEN Transit Router Route Entry IDs.
     * @param nameRegex
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status
     * @param transitRouterRouteEntryIds A list of ID of the cen transit router route entry.
     * @param transitRouterRouteEntryNames A list of name of the cen transit router route entry.
     * @param transitRouterRouteEntryStatus The status of the resource.Valid values `Creating`, `Active` and `Deleting`.
     * @param transitRouterRouteTableId ID of the CEN Transit Router Route Table.
     * @return A collection of values returned by getTransitRouterRouteEntries.
     */
    public suspend fun getTransitRouterRouteEntries(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        transitRouterRouteEntryIds: List<String>? = null,
        transitRouterRouteEntryNames: List<String>? = null,
        transitRouterRouteEntryStatus: String? = null,
        transitRouterRouteTableId: String,
    ): GetTransitRouterRouteEntriesResult {
        val argument = GetTransitRouterRouteEntriesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouterRouteEntryIds = transitRouterRouteEntryIds,
            transitRouterRouteEntryNames = transitRouterRouteEntryNames,
            transitRouterRouteEntryStatus = transitRouterRouteEntryStatus,
            transitRouterRouteTableId = transitRouterRouteTableId,
        )
        return getTransitRouterRouteEntriesResultToKotlin(getTransitRouterRouteEntriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterRouteEntries].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterRouteEntriesPlainArgs].
     * @return A collection of values returned by getTransitRouterRouteEntries.
     */
    public suspend fun getTransitRouterRouteEntries(argument: suspend GetTransitRouterRouteEntriesPlainArgsBuilder.() -> Unit): GetTransitRouterRouteEntriesResult {
        val builder = GetTransitRouterRouteEntriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterRouteEntriesResultToKotlin(getTransitRouterRouteEntriesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN Transit Router Route Table Associations available to the user.[What is Cen Transit Router Route Table Associations](https://help.aliyun.com/document_detail/261243.html)
     * > **NOTE:** Available in 1.126.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cen.getTransitRouterRouteTableAssociations({
     *     transitRouterRouteTableId: "rtb-id1",
     * });
     * export const firstTransitRouterPeerAttachmentsTransitRouterAttachmentResourceType = _default.then(_default => _default.associations?.[0]?.resourceType);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cen.get_transit_router_route_table_associations(transit_router_route_table_id="rtb-id1")
     * pulumi.export("firstTransitRouterPeerAttachmentsTransitRouterAttachmentResourceType", default.associations[0].resource_type)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Cen.GetTransitRouterRouteTableAssociations.Invoke(new()
     *     {
     *         TransitRouterRouteTableId = "rtb-id1",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstTransitRouterPeerAttachmentsTransitRouterAttachmentResourceType"] = @default&#46;Apply(@default => @default&#46;Apply(getTransitRouterRouteTableAssociationsResult => getTransitRouterRouteTableAssociationsResult&#46;Associations[0]?.ResourceType)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := cen.GetTransitRouterRouteTableAssociations(ctx, &cen.GetTransitRouterRouteTableAssociationsArgs{
     * 			TransitRouterRouteTableId: pulumi.StringRef("rtb-id1"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstTransitRouterPeerAttachmentsTransitRouterAttachmentResourceType", _default.Associations[0].ResourceType)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteTableAssociationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CenFunctions.getTransitRouterRouteTableAssociations(GetTransitRouterRouteTableAssociationsArgs.builder()
     *             .transitRouterRouteTableId("rtb-id1")
     *             .build());
     *         ctx.export("firstTransitRouterPeerAttachmentsTransitRouterAttachmentResourceType", default_.associations()[0].resourceType());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterRouteTableAssociations
     *       Arguments:
     *         transitRouterRouteTableId: rtb-id1
     * outputs:
     *   firstTransitRouterPeerAttachmentsTransitRouterAttachmentResourceType: ${default.associations[0].resourceType}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouterRouteTableAssociations.
     * @return A collection of values returned by getTransitRouterRouteTableAssociations.
     */
    public suspend fun getTransitRouterRouteTableAssociations(argument: GetTransitRouterRouteTableAssociationsPlainArgs): GetTransitRouterRouteTableAssociationsResult =
        getTransitRouterRouteTableAssociationsResultToKotlin(getTransitRouterRouteTableAssociationsPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterRouteTableAssociations].
     * @param ids A list of CEN Transit Router Route Table Association IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the route table, including `Active`, `Associating`, `Dissociating`.
     * @param transitRouterAttachmentId The ID of the network instance connection.
     * @param transitRouterAttachmentResourceId The ID of the next hop.
     * @param transitRouterAttachmentResourceType The type of next hop. Valid values:
     * * `VPC`: virtual private cloud (VPC)
     * * `VBR`: virtual border router (VBR)
     * * `TR`: transit router
     * * `VPN`: VPN attachment
     * @param transitRouterRouteTableId The ID of the route table of the Enterprise Edition transit router.
     * @return A collection of values returned by getTransitRouterRouteTableAssociations.
     */
    public suspend fun getTransitRouterRouteTableAssociations(
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
        transitRouterAttachmentId: String? = null,
        transitRouterAttachmentResourceId: String? = null,
        transitRouterAttachmentResourceType: String? = null,
        transitRouterRouteTableId: String? = null,
    ): GetTransitRouterRouteTableAssociationsResult {
        val argument = GetTransitRouterRouteTableAssociationsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            status = status,
            transitRouterAttachmentId = transitRouterAttachmentId,
            transitRouterAttachmentResourceId = transitRouterAttachmentResourceId,
            transitRouterAttachmentResourceType = transitRouterAttachmentResourceType,
            transitRouterRouteTableId = transitRouterRouteTableId,
        )
        return getTransitRouterRouteTableAssociationsResultToKotlin(getTransitRouterRouteTableAssociationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterRouteTableAssociations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterRouteTableAssociationsPlainArgs].
     * @return A collection of values returned by getTransitRouterRouteTableAssociations.
     */
    public suspend fun getTransitRouterRouteTableAssociations(argument: suspend GetTransitRouterRouteTableAssociationsPlainArgsBuilder.() -> Unit): GetTransitRouterRouteTableAssociationsResult {
        val builder = GetTransitRouterRouteTableAssociationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterRouteTableAssociationsResultToKotlin(getTransitRouterRouteTableAssociationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN Transit Router Route Table Propagations available to the user.[What is Cen Transit Router Route Table Propagations](https://help.aliyun.com/document_detail/261245.html)
     * > **NOTE:** Available in 1.126.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cen.getTransitRouterRouteTablePropagations({
     *     transitRouterRouteTableId: "rtb-id1",
     * });
     * export const firstTransitRouterPeerAttachmentsTransitRouterAttachmentResourceType = _default.then(_default => _default.propagations?.[0]?.resourceType);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cen.get_transit_router_route_table_propagations(transit_router_route_table_id="rtb-id1")
     * pulumi.export("firstTransitRouterPeerAttachmentsTransitRouterAttachmentResourceType", default.propagations[0].resource_type)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Cen.GetTransitRouterRouteTablePropagations.Invoke(new()
     *     {
     *         TransitRouterRouteTableId = "rtb-id1",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstTransitRouterPeerAttachmentsTransitRouterAttachmentResourceType"] = @default&#46;Apply(@default => @default&#46;Apply(getTransitRouterRouteTablePropagationsResult => getTransitRouterRouteTablePropagationsResult&#46;Propagations[0]?.ResourceType)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := cen.GetTransitRouterRouteTablePropagations(ctx, &cen.GetTransitRouterRouteTablePropagationsArgs{
     * 			TransitRouterRouteTableId: "rtb-id1",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstTransitRouterPeerAttachmentsTransitRouterAttachmentResourceType", _default.Propagations[0].ResourceType)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteTablePropagationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CenFunctions.getTransitRouterRouteTablePropagations(GetTransitRouterRouteTablePropagationsArgs.builder()
     *             .transitRouterRouteTableId("rtb-id1")
     *             .build());
     *         ctx.export("firstTransitRouterPeerAttachmentsTransitRouterAttachmentResourceType", default_.propagations()[0].resourceType());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterRouteTablePropagations
     *       Arguments:
     *         transitRouterRouteTableId: rtb-id1
     * outputs:
     *   firstTransitRouterPeerAttachmentsTransitRouterAttachmentResourceType: ${default.propagations[0].resourceType}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouterRouteTablePropagations.
     * @return A collection of values returned by getTransitRouterRouteTablePropagations.
     */
    public suspend fun getTransitRouterRouteTablePropagations(argument: GetTransitRouterRouteTablePropagationsPlainArgs): GetTransitRouterRouteTablePropagationsResult =
        getTransitRouterRouteTablePropagationsResultToKotlin(getTransitRouterRouteTablePropagationsPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterRouteTablePropagations].
     * @param ids A list of CEN Transit Router Route Table Association IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the route table, including `Active`, `Enabling`, `Disabling`, `Deleted`.
     * @param transitRouterRouteTableId ID of the route table of the VPC or VBR.
     * @return A collection of values returned by getTransitRouterRouteTablePropagations.
     */
    public suspend fun getTransitRouterRouteTablePropagations(
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
        transitRouterRouteTableId: String,
    ): GetTransitRouterRouteTablePropagationsResult {
        val argument = GetTransitRouterRouteTablePropagationsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            status = status,
            transitRouterRouteTableId = transitRouterRouteTableId,
        )
        return getTransitRouterRouteTablePropagationsResultToKotlin(getTransitRouterRouteTablePropagationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterRouteTablePropagations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterRouteTablePropagationsPlainArgs].
     * @return A collection of values returned by getTransitRouterRouteTablePropagations.
     */
    public suspend fun getTransitRouterRouteTablePropagations(argument: suspend GetTransitRouterRouteTablePropagationsPlainArgsBuilder.() -> Unit): GetTransitRouterRouteTablePropagationsResult {
        val builder = GetTransitRouterRouteTablePropagationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterRouteTablePropagationsResultToKotlin(getTransitRouterRouteTablePropagationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN Transit Router Route Tables available to the user.[What is Cen Transit Router Route Tables](https://help.aliyun.com/document_detail/261237.html)
     * > **NOTE:** Available in 1.126.0+
     * @param argument A collection of arguments for invoking getTransitRouterRouteTables.
     * @return A collection of values returned by getTransitRouterRouteTables.
     */
    public suspend fun getTransitRouterRouteTables(argument: GetTransitRouterRouteTablesPlainArgs): GetTransitRouterRouteTablesResult =
        getTransitRouterRouteTablesResultToKotlin(getTransitRouterRouteTablesPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterRouteTables].
     * @param ids A list of CEN Transit Router Route Table IDs.
     * @param nameRegex
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status
     * @param transitRouterId ID of the CEN Transit Router Route Table.
     * @param transitRouterRouteTableIds A list of ID of the CEN Transit Router Route Table.
     * @param transitRouterRouteTableNames A list of name of the CEN Transit Router Route Table.
     * @param transitRouterRouteTableStatus The status of the transit router route table to query.
     * @return A collection of values returned by getTransitRouterRouteTables.
     */
    public suspend fun getTransitRouterRouteTables(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        transitRouterId: String,
        transitRouterRouteTableIds: List<String>? = null,
        transitRouterRouteTableNames: List<String>? = null,
        transitRouterRouteTableStatus: String? = null,
    ): GetTransitRouterRouteTablesResult {
        val argument = GetTransitRouterRouteTablesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouterId = transitRouterId,
            transitRouterRouteTableIds = transitRouterRouteTableIds,
            transitRouterRouteTableNames = transitRouterRouteTableNames,
            transitRouterRouteTableStatus = transitRouterRouteTableStatus,
        )
        return getTransitRouterRouteTablesResultToKotlin(getTransitRouterRouteTablesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterRouteTables].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterRouteTablesPlainArgs].
     * @return A collection of values returned by getTransitRouterRouteTables.
     */
    public suspend fun getTransitRouterRouteTables(argument: suspend GetTransitRouterRouteTablesPlainArgsBuilder.() -> Unit): GetTransitRouterRouteTablesResult {
        val builder = GetTransitRouterRouteTablesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterRouteTablesResultToKotlin(getTransitRouterRouteTablesPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open CEN Transit Router Service automatically. If the service has been opened, it will return opened.
     * For information about CEN and how to use it, see [What is CEN](https://www.alibabacloud.com/help/en/doc-detail/59870.htm).
     * > **NOTE:** Available since v1.139.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.cen.getTransitRouterService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.cen.get_transit_router_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Cen.GetTransitRouterService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cen.GetTransitRouterService(ctx, &cen.GetTransitRouterServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouterServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = CenFunctions.getTransitRouterService(GetTransitRouterServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouterService.
     * @return A collection of values returned by getTransitRouterService.
     */
    public suspend fun getTransitRouterService(argument: GetTransitRouterServicePlainArgs): GetTransitRouterServiceResult =
        getTransitRouterServiceResultToKotlin(getTransitRouterServicePlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the CEN Transit Router Service that means you have read and agreed the [CEN Terms of Service](https://help.aliyun.com/document_detail/66667.html). The service can not closed once it is opened.
     * @return A collection of values returned by getTransitRouterService.
     */
    public suspend fun getTransitRouterService(enable: String? = null): GetTransitRouterServiceResult {
        val argument = GetTransitRouterServicePlainArgs(
            enable = enable,
        )
        return getTransitRouterServiceResultToKotlin(getTransitRouterServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterServicePlainArgs].
     * @return A collection of values returned by getTransitRouterService.
     */
    public suspend fun getTransitRouterService(argument: suspend GetTransitRouterServicePlainArgsBuilder.() -> Unit): GetTransitRouterServiceResult {
        val builder = GetTransitRouterServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterServiceResultToKotlin(getTransitRouterServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN Transit Router VBR Attachments available to the user.[What is Cen Transit Router VBR Attachments](https://help.aliyun.com/document_detail/261226.html)
     * > **NOTE:** Available in 1.126.0+
     * @param argument A collection of arguments for invoking getTransitRouterVbrAttachments.
     * @return A collection of values returned by getTransitRouterVbrAttachments.
     */
    public suspend fun getTransitRouterVbrAttachments(argument: GetTransitRouterVbrAttachmentsPlainArgs): GetTransitRouterVbrAttachmentsResult =
        getTransitRouterVbrAttachmentsResultToKotlin(getTransitRouterVbrAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterVbrAttachments].
     * @param cenId ID of the CEN instance.
     * @param ids A list of resource id. The element value is same as `transit_router_id`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values `Attached`, `Attaching` and `Detaching`.
     * @param transitRouterId ID of the transit router.
     * @return A collection of values returned by getTransitRouterVbrAttachments.
     */
    public suspend fun getTransitRouterVbrAttachments(
        cenId: String,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
        transitRouterId: String? = null,
    ): GetTransitRouterVbrAttachmentsResult {
        val argument = GetTransitRouterVbrAttachmentsPlainArgs(
            cenId = cenId,
            ids = ids,
            outputFile = outputFile,
            status = status,
            transitRouterId = transitRouterId,
        )
        return getTransitRouterVbrAttachmentsResultToKotlin(getTransitRouterVbrAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterVbrAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterVbrAttachmentsPlainArgs].
     * @return A collection of values returned by getTransitRouterVbrAttachments.
     */
    public suspend fun getTransitRouterVbrAttachments(argument: suspend GetTransitRouterVbrAttachmentsPlainArgsBuilder.() -> Unit): GetTransitRouterVbrAttachmentsResult {
        val builder = GetTransitRouterVbrAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterVbrAttachmentsResultToKotlin(getTransitRouterVbrAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the CEN Transit Router VPC Attachments of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.126.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "terraform-example";
     * const default = alicloud.getZones({});
     * const defaultGetNetworks = alicloud.vpc.getNetworks({
     *     nameRegex: "^default-NODELETING$",
     * });
     * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
     *     vpcId: defaultGetNetworks.ids?.[0],
     *     zoneId: _default.ids?.[0],
     * }));
     * const defaultMaster = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
     *     vpcId: defaultGetNetworks.ids?.[0],
     *     zoneId: _default.ids?.[1],
     * }));
     * const defaultInstance = new alicloud.cen.Instance("default", {
     *     cenInstanceName: name,
     *     protectionLevel: "REDUCED",
     * });
     * const defaultTransitRouter = new alicloud.cen.TransitRouter("default", {cenId: defaultInstance.id});
     * const defaultTransitRouterVpcAttachment = new alicloud.cen.TransitRouterVpcAttachment("default", {
     *     cenId: defaultInstance.id,
     *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
     *     transitRouterId: defaultTransitRouter.transitRouterId,
     *     transitRouterAttachmentName: name,
     *     transitRouterAttachmentDescription: name,
     *     zoneMappings: [
     *         {
     *             vswitchId: defaultMaster.then(defaultMaster => defaultMaster.vswitches?.[0]?.id),
     *             zoneId: defaultMaster.then(defaultMaster => defaultMaster.vswitches?.[0]?.zoneId),
     *         },
     *         {
     *             vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.id),
     *             zoneId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.vswitches?.[0]?.zoneId),
     *         },
     *     ],
     * });
     * const ids = alicloud.cen.getTransitRouterVpcAttachmentsOutput({
     *     ids: [defaultTransitRouterVpcAttachment&#46;id],
     *     cenId: defaultInstance.id,
     * });
     * export const cenTransitRouterVpcAttachmentsId0 = ids.apply(ids => ids.attachments?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "terraform-example"
     * default = alicloud.get_zones()
     * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
     * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
     *     zone_id=default.ids[0])
     * default_master = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
     *     zone_id=default.ids[1])
     * default_instance = alicloud.cen.Instance("default",
     *     cen_instance_name=name,
     *     protection_level="REDUCED")
     * default_transit_router = alicloud.cen.TransitRouter("default", cen_id=default_instance.id)
     * default_transit_router_vpc_attachment = alicloud.cen.TransitRouterVpcAttachment("default",
     *     cen_id=default_instance.id,
     *     vpc_id=default_get_networks.ids[0],
     *     transit_router_id=default_transit_router.transit_router_id,
     *     transit_router_attachment_name=name,
     *     transit_router_attachment_description=name,
     *     zone_mappings=[
     *         {
     *             "vswitch_id": default_master.vswitches[0].id,
     *             "zone_id": default_master.vswitches[0].zone_id,
     *         },
     *         {
     *             "vswitch_id": default_get_switches.vswitches[0].id,
     *             "zone_id": default_get_switches.vswitches[0].zone_id,
     *         },
     *     ])
     * ids = alicloud.cen.get_transit_router_vpc_attachments_output(ids=[default_transit_router_vpc_attachment&#46;id],
     *     cen_id=default_instance.id)
     * pulumi.export("cenTransitRouterVpcAttachmentsId0", ids.attachments[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "terraform-example";
     *     var @default = AliCloud.GetZones.Invoke();
     *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
     *     {
     *         NameRegex = "^default-NODELETING$",
     *     });
     *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
     *     {
     *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
     *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Ids[0]),
     *     });
     *     var defaultMaster = AliCloud.Vpc.GetSwitches.Invoke(new()
     *     {
     *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
     *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Ids[1]),
     *     });
     *     var defaultInstance = new AliCloud.Cen.Instance("default", new()
     *     {
     *         CenInstanceName = name,
     *         ProtectionLevel = "REDUCED",
     *     });
     *     var defaultTransitRouter = new AliCloud.Cen.TransitRouter("default", new()
     *     {
     *         CenId = defaultInstance.Id,
     *     });
     *     var defaultTransitRouterVpcAttachment = new AliCloud.Cen.TransitRouterVpcAttachment("default", new()
     *     {
     *         CenId = defaultInstance.Id,
     *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
     *         TransitRouterId = defaultTransitRouter.TransitRouterId,
     *         TransitRouterAttachmentName = name,
     *         TransitRouterAttachmentDescription = name,
     *         ZoneMappings = new[]
     *         {
     *             new AliCloud.Cen.Inputs.TransitRouterVpcAttachmentZoneMappingArgs
     *             {
     *                 VswitchId = defaultMaster.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.Id),
     *                 ZoneId = defaultMaster.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.ZoneId),
     *             },
     *             new AliCloud.Cen.Inputs.TransitRouterVpcAttachmentZoneMappingArgs
     *             {
     *                 VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.Id),
     *                 ZoneId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Vswitches[0]?.ZoneId),
     *             },
     *         },
     *     });
     *     var ids = AliCloud.Cen.GetTransitRouterVpcAttachments.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultTransitRouterVpcAttachment.Id,
     *         },
     *         CenId = defaultInstance.Id,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cenTransitRouterVpcAttachmentsId0"] = ids&#46;Apply(getTransitRouterVpcAttachmentsResult => getTransitRouterVpcAttachmentsResult&#46;Attachments[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "terraform-example"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_default, err := alicloud.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
     * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
     * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
     * 			ZoneId: pulumi.StringRef(_default.Ids[0]),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultMaster, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
     * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
     * 			ZoneId: pulumi.StringRef(_default.Ids[1]),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultInstance, err := cen.NewInstance(ctx, "default", &cen.InstanceArgs{
     * 			CenInstanceName: pulumi.String(name),
     * 			ProtectionLevel: pulumi.String("REDUCED"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultTransitRouter, err := cen.NewTransitRouter(ctx, "default", &cen.TransitRouterArgs{
     * 			CenId: defaultInstance.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultTransitRouterVpcAttachment, err := cen.NewTransitRouterVpcAttachment(ctx, "default", &cen.TransitRouterVpcAttachmentArgs{
     * 			CenId:                              defaultInstance.ID(),
     * 			VpcId:                              pulumi.String(defaultGetNetworks.Ids[0]),
     * 			TransitRouterId:                    defaultTransitRouter.TransitRouterId,
     * 			TransitRouterAttachmentName:        pulumi.String(name),
     * 			TransitRouterAttachmentDescription: pulumi.String(name),
     * 			ZoneMappings: cen.TransitRouterVpcAttachmentZoneMappingArray{
     * 				&cen.TransitRouterVpcAttachmentZoneMappingArgs{
     * 					VswitchId: pulumi.String(defaultMaster.Vswitches[0].Id),
     * 					ZoneId:    pulumi.String(defaultMaster.Vswitches[0].ZoneId),
     * 				},
     * 				&cen.TransitRouterVpcAttachmentZoneMappingArgs{
     * 					VswitchId: pulumi.String(defaultGetSwitches.Vswitches[0].Id),
     * 					ZoneId:    pulumi.String(defaultGetSwitches.Vswitches[0].ZoneId),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids := cen.GetTransitRouterVpcAttachmentsOutput(ctx, cen.GetTransitRouterVpcAttachmentsOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				defaultTransitRouterVpcAttachment.ID(),
     * 			},
     * 			CenId: defaultInstance.ID(),
     * 		}, nil)
     * 		ctx.Export("cenTransitRouterVpcAttachmentsId0", ids.ApplyT(func(ids cen.GetTransitRouterVpcAttachmentsResult) (*string, error) {
     * 			return &ids.Attachments[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.vpc.VpcFunctions;
     * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
     * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
     * import com.pulumi.alicloud.cen.Instance;
     * import com.pulumi.alicloud.cen.InstanceArgs;
     * import com.pulumi.alicloud.cen.TransitRouter;
     * import com.pulumi.alicloud.cen.TransitRouterArgs;
     * import com.pulumi.alicloud.cen.TransitRouterVpcAttachment;
     * import com.pulumi.alicloud.cen.TransitRouterVpcAttachmentArgs;
     * import com.pulumi.alicloud.cen.inputs.TransitRouterVpcAttachmentZoneMappingArgs;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouterVpcAttachmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("terraform-example");
     *         final var default = AlicloudFunctions.getZones();
     *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
     *             .nameRegex("^default-NODELETING$")
     *             .build());
     *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
     *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
     *             .zoneId(default_.ids()[0])
     *             .build());
     *         final var defaultMaster = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
     *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
     *             .zoneId(default_.ids()[1])
     *             .build());
     *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
     *             .cenInstanceName(name)
     *             .protectionLevel("REDUCED")
     *             .build());
     *         var defaultTransitRouter = new TransitRouter("defaultTransitRouter", TransitRouterArgs.builder()
     *             .cenId(defaultInstance.id())
     *             .build());
     *         var defaultTransitRouterVpcAttachment = new TransitRouterVpcAttachment("defaultTransitRouterVpcAttachment", TransitRouterVpcAttachmentArgs.builder()
     *             .cenId(defaultInstance.id())
     *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
     *             .transitRouterId(defaultTransitRouter.transitRouterId())
     *             .transitRouterAttachmentName(name)
     *             .transitRouterAttachmentDescription(name)
     *             .zoneMappings(
     *                 TransitRouterVpcAttachmentZoneMappingArgs.builder()
     *                     .vswitchId(defaultMaster.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].id()))
     *                     .zoneId(defaultMaster.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].zoneId()))
     *                     .build(),
     *                 TransitRouterVpcAttachmentZoneMappingArgs.builder()
     *                     .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].id()))
     *                     .zoneId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.vswitches()[0].zoneId()))
     *                     .build())
     *             .build());
     *         final var ids = CenFunctions.getTransitRouterVpcAttachments(GetTransitRouterVpcAttachmentsArgs.builder()
     *             .ids(defaultTransitRouterVpcAttachment.id())
     *             .cenId(defaultInstance.id())
     *             .build());
     *         ctx.export("cenTransitRouterVpcAttachmentsId0", ids.applyValue(getTransitRouterVpcAttachmentsResult -> getTransitRouterVpcAttachmentsResult).applyValue(ids -> ids.applyValue(getTransitRouterVpcAttachmentsResult -> getTransitRouterVpcAttachmentsResult.attachments()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: terraform-example
     * resources:
     *   defaultInstance:
     *     type: alicloud:cen:Instance
     *     name: default
     *     properties:
     *       cenInstanceName: ${name}
     *       protectionLevel: REDUCED
     *   defaultTransitRouter:
     *     type: alicloud:cen:TransitRouter
     *     name: default
     *     properties:
     *       cenId: ${defaultInstance.id}
     *   defaultTransitRouterVpcAttachment:
     *     type: alicloud:cen:TransitRouterVpcAttachment
     *     name: default
     *     properties:
     *       cenId: ${defaultInstance.id}
     *       vpcId: ${defaultGetNetworks.ids[0]}
     *       transitRouterId: ${defaultTransitRouter.transitRouterId}
     *       transitRouterAttachmentName: ${name}
     *       transitRouterAttachmentDescription: ${name}
     *       zoneMappings:
     *         - vswitchId: ${defaultMaster.vswitches[0].id}
     *           zoneId: ${defaultMaster.vswitches[0].zoneId}
     *         - vswitchId: ${defaultGetSwitches.vswitches[0].id}
     *           zoneId: ${defaultGetSwitches.vswitches[0].zoneId}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getZones
     *       Arguments: {}
     *   defaultGetNetworks:
     *     fn::invoke:
     *       Function: alicloud:vpc:getNetworks
     *       Arguments:
     *         nameRegex: ^default-NODELETING$
     *   defaultGetSwitches:
     *     fn::invoke:
     *       Function: alicloud:vpc:getSwitches
     *       Arguments:
     *         vpcId: ${defaultGetNetworks.ids[0]}
     *         zoneId: ${default.ids[0]}
     *   defaultMaster:
     *     fn::invoke:
     *       Function: alicloud:vpc:getSwitches
     *       Arguments:
     *         vpcId: ${defaultGetNetworks.ids[0]}
     *         zoneId: ${default.ids[1]}
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterVpcAttachments
     *       Arguments:
     *         ids:
     *           - ${defaultTransitRouterVpcAttachment.id}
     *         cenId: ${defaultInstance.id}
     * outputs:
     *   cenTransitRouterVpcAttachmentsId0: ${ids.attachments[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouterVpcAttachments.
     * @return A collection of values returned by getTransitRouterVpcAttachments.
     */
    public suspend fun getTransitRouterVpcAttachments(argument: GetTransitRouterVpcAttachmentsPlainArgs): GetTransitRouterVpcAttachmentsResult =
        getTransitRouterVpcAttachmentsResultToKotlin(getTransitRouterVpcAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterVpcAttachments].
     * @param cenId The ID of the CEN instance.
     * @param ids A list of Transit Router VPC Attachment IDs.
     * @param nameRegex A regex string to filter results by Transit Router VPC Attachment name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the Transit Router VPC Attachment. Valid Values: `Attached`, `Attaching`, `Detaching`.
     * @param transitRouterAttachmentId The ID of the Transit Router VPC Attachment.
     * @param transitRouterId The ID of the transit router.
     * @param vpcId The ID of the VPC.
     * @return A collection of values returned by getTransitRouterVpcAttachments.
     */
    public suspend fun getTransitRouterVpcAttachments(
        cenId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        transitRouterAttachmentId: String? = null,
        transitRouterId: String? = null,
        vpcId: String? = null,
    ): GetTransitRouterVpcAttachmentsResult {
        val argument = GetTransitRouterVpcAttachmentsPlainArgs(
            cenId = cenId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouterAttachmentId = transitRouterAttachmentId,
            transitRouterId = transitRouterId,
            vpcId = vpcId,
        )
        return getTransitRouterVpcAttachmentsResultToKotlin(getTransitRouterVpcAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterVpcAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterVpcAttachmentsPlainArgs].
     * @return A collection of values returned by getTransitRouterVpcAttachments.
     */
    public suspend fun getTransitRouterVpcAttachments(argument: suspend GetTransitRouterVpcAttachmentsPlainArgsBuilder.() -> Unit): GetTransitRouterVpcAttachmentsResult {
        val builder = GetTransitRouterVpcAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterVpcAttachmentsResultToKotlin(getTransitRouterVpcAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cen Transit Router Vpn Attachments of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.183.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cen.getTransitRouterVpnAttachments({
     *     cenId: "example_value",
     * });
     * export const cenTransitRouterVpnAttachmentId1 = ids.then(ids => ids.attachments?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cen.get_transit_router_vpn_attachments(cen_id="example_value")
     * pulumi.export("cenTransitRouterVpnAttachmentId1", ids.attachments[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cen.GetTransitRouterVpnAttachments.Invoke(new()
     *     {
     *         CenId = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cenTransitRouterVpnAttachmentId1"] = ids&#46;Apply(getTransitRouterVpnAttachmentsResult => getTransitRouterVpnAttachmentsResult&#46;Attachments[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cen.GetTransitRouterVpnAttachments(ctx, &cen.GetTransitRouterVpnAttachmentsArgs{
     * 			CenId: "example_value",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cenTransitRouterVpnAttachmentId1", ids.Attachments[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRouterVpnAttachmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CenFunctions.getTransitRouterVpnAttachments(GetTransitRouterVpnAttachmentsArgs.builder()
     *             .cenId("example_value")
     *             .build());
     *         ctx.export("cenTransitRouterVpnAttachmentId1", ids.applyValue(getTransitRouterVpnAttachmentsResult -> getTransitRouterVpnAttachmentsResult.attachments()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouterVpnAttachments
     *       Arguments:
     *         cenId: example_value
     * outputs:
     *   cenTransitRouterVpnAttachmentId1: ${ids.attachments[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouterVpnAttachments.
     * @return A collection of values returned by getTransitRouterVpnAttachments.
     */
    public suspend fun getTransitRouterVpnAttachments(argument: GetTransitRouterVpnAttachmentsPlainArgs): GetTransitRouterVpnAttachmentsResult =
        getTransitRouterVpnAttachmentsResultToKotlin(getTransitRouterVpnAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouterVpnAttachments].
     * @param cenId The id of the cen.
     * @param ids A list of Transit Router Vpn Attachment IDs.
     * @param nameRegex
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The Status of Transit Router Vpn Attachment. Valid Value: `Attached`, `Attaching`, `Detaching`.
     * @param transitRouterId The ID of the forwarding router instance.
     * @return A collection of values returned by getTransitRouterVpnAttachments.
     */
    public suspend fun getTransitRouterVpnAttachments(
        cenId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        transitRouterId: String? = null,
    ): GetTransitRouterVpnAttachmentsResult {
        val argument = GetTransitRouterVpnAttachmentsPlainArgs(
            cenId = cenId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouterId = transitRouterId,
        )
        return getTransitRouterVpnAttachmentsResultToKotlin(getTransitRouterVpnAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouterVpnAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRouterVpnAttachmentsPlainArgs].
     * @return A collection of values returned by getTransitRouterVpnAttachments.
     */
    public suspend fun getTransitRouterVpnAttachments(argument: suspend GetTransitRouterVpnAttachmentsPlainArgsBuilder.() -> Unit): GetTransitRouterVpnAttachmentsResult {
        val builder = GetTransitRouterVpnAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRouterVpnAttachmentsResultToKotlin(getTransitRouterVpnAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN Transit Routers available to the user.[What is Cen Transit Routers](https://help.aliyun.com/document_detail/261219.html)
     * > **NOTE:** Available in 1.126.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cen.getTransitRouters({
     *     cenId: "cen-id1",
     * });
     * export const firstTransitRoutersType = _default.then(_default => _default.transitRouters?.[0]?.type);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cen.get_transit_routers(cen_id="cen-id1")
     * pulumi.export("firstTransitRoutersType", default.transit_routers[0].type)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Cen.GetTransitRouters.Invoke(new()
     *     {
     *         CenId = "cen-id1",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstTransitRoutersType"] = @default&#46;Apply(@default => @default&#46;Apply(getTransitRoutersResult => getTransitRoutersResult&#46;TransitRouters[0]?.Type)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := cen.GetTransitRouters(ctx, &cen.GetTransitRoutersArgs{
     * 			CenId: "cen-id1",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstTransitRoutersType", _default.TransitRouters[0].Type)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cen.CenFunctions;
     * import com.pulumi.alicloud.cen.inputs.GetTransitRoutersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CenFunctions.getTransitRouters(GetTransitRoutersArgs.builder()
     *             .cenId("cen-id1")
     *             .build());
     *         ctx.export("firstTransitRoutersType", default_.transitRouters()[0].type());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cen:getTransitRouters
     *       Arguments:
     *         cenId: cen-id1
     * outputs:
     *   firstTransitRoutersType: ${default.transitRouters[0].type}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitRouters.
     * @return A collection of values returned by getTransitRouters.
     */
    public suspend fun getTransitRouters(argument: GetTransitRoutersPlainArgs): GetTransitRoutersResult =
        getTransitRoutersResultToKotlin(getTransitRoutersPlain(argument.toJava()).await())

    /**
     * @see [getTransitRouters].
     * @param cenId The ID of the CEN instance.
     * @param ids A list of resource id. The element value is same as <cen_id>:<transit_router_id>`.
     * @param nameRegex A regex string to filter CEN Transit Routers by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values `Active`, `Creating`, `Deleting` and `Updating`.
     * @param transitRouterId The ID of the transit router.
     * @param transitRouterIds A list of ID of the transit router.
     * @return A collection of values returned by getTransitRouters.
     */
    public suspend fun getTransitRouters(
        cenId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        transitRouterId: String? = null,
        transitRouterIds: List<String>? = null,
    ): GetTransitRoutersResult {
        val argument = GetTransitRoutersPlainArgs(
            cenId = cenId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouterId = transitRouterId,
            transitRouterIds = transitRouterIds,
        )
        return getTransitRoutersResultToKotlin(getTransitRoutersPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitRouters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetTransitRoutersPlainArgs].
     * @return A collection of values returned by getTransitRouters.
     */
    public suspend fun getTransitRouters(argument: suspend GetTransitRoutersPlainArgsBuilder.() -> Unit): GetTransitRoutersResult {
        val builder = GetTransitRoutersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitRoutersResultToKotlin(getTransitRoutersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides CEN VBR Health Checks available to the user.
     * > **NOTE:** Available in 1.98.0+
     * @param argument A collection of arguments for invoking getVbrHealthChecks.
     * @return A collection of values returned by getVbrHealthChecks.
     */
    public suspend fun getVbrHealthChecks(argument: GetVbrHealthChecksPlainArgs): GetVbrHealthChecksResult =
        getVbrHealthChecksResultToKotlin(getVbrHealthChecksPlain(argument.toJava()).await())

    /**
     * @see [getVbrHealthChecks].
     * @param cenId The ID of the Cloud Enterprise Network (CEN) instance.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param vbrInstanceId The ID of the VBR instance.
     * @param vbrInstanceOwnerId The User ID (UID) of the account to which the VBR instance belongs.
     * @param vbrInstanceRegionId The ID of the region where the VBR instance is deployed.
     * @return A collection of values returned by getVbrHealthChecks.
     */
    public suspend fun getVbrHealthChecks(
        cenId: String? = null,
        outputFile: String? = null,
        vbrInstanceId: String? = null,
        vbrInstanceOwnerId: Int? = null,
        vbrInstanceRegionId: String,
    ): GetVbrHealthChecksResult {
        val argument = GetVbrHealthChecksPlainArgs(
            cenId = cenId,
            outputFile = outputFile,
            vbrInstanceId = vbrInstanceId,
            vbrInstanceOwnerId = vbrInstanceOwnerId,
            vbrInstanceRegionId = vbrInstanceRegionId,
        )
        return getVbrHealthChecksResultToKotlin(getVbrHealthChecksPlain(argument.toJava()).await())
    }

    /**
     * @see [getVbrHealthChecks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cen&#46;kotlin&#46;inputs&#46;GetVbrHealthChecksPlainArgs].
     * @return A collection of values returned by getVbrHealthChecks.
     */
    public suspend fun getVbrHealthChecks(argument: suspend GetVbrHealthChecksPlainArgsBuilder.() -> Unit): GetVbrHealthChecksResult {
        val builder = GetVbrHealthChecksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVbrHealthChecksResultToKotlin(getVbrHealthChecksPlain(builtArgument.toJava()).await())
    }
}
