@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FlowLog].
 */
@PulumiTagMarker
public class FlowLogResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FlowLogArgs = FlowLogArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FlowLogArgsBuilder.() -> Unit) {
        val builder = FlowLogArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FlowLog {
        val builtJavaResource = com.pulumi.alicloud.cen.FlowLog(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FlowLog(builtJavaResource)
    }
}

/**
 * This resource used to create a flow log function in Cloud Enterprise Network (CEN).
 * By using the flow log function, you can capture the traffic data of the network instances in different regions of a CEN.
 * You can also use the data aggregated in flow logs to analyze cross-region traffic flows, minimize traffic costs, and troubleshoot network faults.
 * For information about CEN flow log and how to use it, see [Manage CEN flowlog](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createflowlog).
 * > **NOTE:** Available since v1.73.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Create a cen flowlog resource and use it to publish a route entry pointing to an ECS.
 * const _default = new alicloud.cen.Instance("default", {name: "my-cen"});
 * const defaultProject = new alicloud.log.Project("default", {
 *     name: "sls-for-flowlog",
 *     description: "create by terraform",
 * });
 * const defaultStore = new alicloud.log.Store("default", {
 *     project: defaultProject.name,
 *     name: "sls-for-flowlog",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const defaultFlowLog = new alicloud.cen.FlowLog("default", {
 *     flowLogName: "my-flowlog",
 *     cenId: _default.id,
 *     projectName: defaultProject.name,
 *     logStoreName: defaultStore.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Create a cen flowlog resource and use it to publish a route entry pointing to an ECS.
 * default = alicloud.cen.Instance("default", name="my-cen")
 * default_project = alicloud.log.Project("default",
 *     name="sls-for-flowlog",
 *     description="create by terraform")
 * default_store = alicloud.log.Store("default",
 *     project=default_project.name,
 *     name="sls-for-flowlog",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * default_flow_log = alicloud.cen.FlowLog("default",
 *     flow_log_name="my-flowlog",
 *     cen_id=default.id,
 *     project_name=default_project.name,
 *     log_store_name=default_store.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a cen flowlog resource and use it to publish a route entry pointing to an ECS.
 *     var @default = new AliCloud.Cen.Instance("default", new()
 *     {
 *         Name = "my-cen",
 *     });
 *     var defaultProject = new AliCloud.Log.Project("default", new()
 *     {
 *         Name = "sls-for-flowlog",
 *         Description = "create by terraform",
 *     });
 *     var defaultStore = new AliCloud.Log.Store("default", new()
 *     {
 *         Project = defaultProject.Name,
 *         Name = "sls-for-flowlog",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var defaultFlowLog = new AliCloud.Cen.FlowLog("default", new()
 *     {
 *         FlowLogName = "my-flowlog",
 *         CenId = @default.Id,
 *         ProjectName = defaultProject.Name,
 *         LogStoreName = defaultStore.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a cen flowlog resource and use it to publish a route entry pointing to an ECS.
 * 		_, err := cen.NewInstance(ctx, "default", &cen.InstanceArgs{
 * 			Name: pulumi.String("my-cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultProject, err := log.NewProject(ctx, "default", &log.ProjectArgs{
 * 			Name:        pulumi.String("sls-for-flowlog"),
 * 			Description: pulumi.String("create by terraform"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultStore, err := log.NewStore(ctx, "default", &log.StoreArgs{
 * 			Project:            defaultProject.Name,
 * 			Name:               pulumi.String("sls-for-flowlog"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewFlowLog(ctx, "default", &cen.FlowLogArgs{
 * 			FlowLogName:  pulumi.String("my-flowlog"),
 * 			CenId:        _default.ID(),
 * 			ProjectName:  defaultProject.Name,
 * 			LogStoreName: defaultStore.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.cen.FlowLog;
 * import com.pulumi.alicloud.cen.FlowLogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a cen flowlog resource and use it to publish a route entry pointing to an ECS.
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .name("my-cen")
 *             .build());
 *         var defaultProject = new Project("defaultProject", ProjectArgs.builder()
 *             .name("sls-for-flowlog")
 *             .description("create by terraform")
 *             .build());
 *         var defaultStore = new Store("defaultStore", StoreArgs.builder()
 *             .project(defaultProject.name())
 *             .name("sls-for-flowlog")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var defaultFlowLog = new FlowLog("defaultFlowLog", FlowLogArgs.builder()
 *             .flowLogName("my-flowlog")
 *             .cenId(default_.id())
 *             .projectName(defaultProject.name())
 *             .logStoreName(defaultStore.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a cen flowlog resource and use it to publish a route entry pointing to an ECS.
 *   default:
 *     type: alicloud:cen:Instance
 *     properties:
 *       name: my-cen
 *   defaultProject:
 *     type: alicloud:log:Project
 *     name: default
 *     properties:
 *       name: sls-for-flowlog
 *       description: create by terraform
 *   defaultStore:
 *     type: alicloud:log:Store
 *     name: default
 *     properties:
 *       project: ${defaultProject.name}
 *       name: sls-for-flowlog
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   defaultFlowLog:
 *     type: alicloud:cen:FlowLog
 *     name: default
 *     properties:
 *       flowLogName: my-flowlog
 *       cenId: ${default.id}
 *       projectName: ${defaultProject.name}
 *       logStoreName: ${defaultStore.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN flowlog can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/flowLog:FlowLog default flowlog-tig1xxxxxx
 * ```
 */
public class FlowLog internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.FlowLog,
) : KotlinCustomResource(javaResource, FlowLogMapper) {
    /**
     * The ID of the CEN Instance.
     */
    public val cenId: Output<String>
        get() = javaResource.cenId().applyValue({ args0 -> args0 })

    /**
     * The description of flowlog.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of flowlog.
     */
    public val flowLogName: Output<String>?
        get() = javaResource.flowLogName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the log store which is in the  `project_name` SLS project.
     */
    public val logStoreName: Output<String>
        get() = javaResource.logStoreName().applyValue({ args0 -> args0 })

    /**
     * The name of the SLS project.
     */
    public val projectName: Output<String>
        get() = javaResource.projectName().applyValue({ args0 -> args0 })

    /**
     * The status of flowlog. Valid values: ["Active", "Inactive"]. Default to "Active".
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object FlowLogMapper : ResourceMapper<FlowLog> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.FlowLog::class == javaResource::class

    override fun map(javaResource: Resource): FlowLog = FlowLog(
        javaResource as
            com.pulumi.alicloud.cen.FlowLog,
    )
}

/**
 * @see [FlowLog].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FlowLog].
 */
public suspend fun flowLog(name: String, block: suspend FlowLogResourceBuilder.() -> Unit): FlowLog {
    val builder = FlowLogResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FlowLog].
 * @param name The _unique_ name of the resulting resource.
 */
public fun flowLog(name: String): FlowLog {
    val builder = FlowLogResourceBuilder()
    builder.name(name)
    return builder.build()
}
