@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.FlowLogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This resource used to create a flow log function in Cloud Enterprise Network (CEN).
 * By using the flow log function, you can capture the traffic data of the network instances in different regions of a CEN.
 * You can also use the data aggregated in flow logs to analyze cross-region traffic flows, minimize traffic costs, and troubleshoot network faults.
 * For information about CEN flow log and how to use it, see [Manage CEN flowlog](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createflowlog).
 * > **NOTE:** Available since v1.73.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Create a cen flowlog resource and use it to publish a route entry pointing to an ECS.
 * const _default = new alicloud.cen.Instance("default", {name: "my-cen"});
 * const defaultProject = new alicloud.log.Project("default", {
 *     name: "sls-for-flowlog",
 *     description: "create by terraform",
 * });
 * const defaultStore = new alicloud.log.Store("default", {
 *     project: defaultProject.name,
 *     name: "sls-for-flowlog",
 *     retentionPeriod: 3650,
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const defaultFlowLog = new alicloud.cen.FlowLog("default", {
 *     flowLogName: "my-flowlog",
 *     cenId: _default.id,
 *     projectName: defaultProject.name,
 *     logStoreName: defaultStore.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Create a cen flowlog resource and use it to publish a route entry pointing to an ECS.
 * default = alicloud.cen.Instance("default", name="my-cen")
 * default_project = alicloud.log.Project("default",
 *     name="sls-for-flowlog",
 *     description="create by terraform")
 * default_store = alicloud.log.Store("default",
 *     project=default_project.name,
 *     name="sls-for-flowlog",
 *     retention_period=3650,
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * default_flow_log = alicloud.cen.FlowLog("default",
 *     flow_log_name="my-flowlog",
 *     cen_id=default.id,
 *     project_name=default_project.name,
 *     log_store_name=default_store.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a cen flowlog resource and use it to publish a route entry pointing to an ECS.
 *     var @default = new AliCloud.Cen.Instance("default", new()
 *     {
 *         Name = "my-cen",
 *     });
 *     var defaultProject = new AliCloud.Log.Project("default", new()
 *     {
 *         Name = "sls-for-flowlog",
 *         Description = "create by terraform",
 *     });
 *     var defaultStore = new AliCloud.Log.Store("default", new()
 *     {
 *         Project = defaultProject.Name,
 *         Name = "sls-for-flowlog",
 *         RetentionPeriod = 3650,
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var defaultFlowLog = new AliCloud.Cen.FlowLog("default", new()
 *     {
 *         FlowLogName = "my-flowlog",
 *         CenId = @default.Id,
 *         ProjectName = defaultProject.Name,
 *         LogStoreName = defaultStore.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a cen flowlog resource and use it to publish a route entry pointing to an ECS.
 * 		_, err := cen.NewInstance(ctx, "default", &cen.InstanceArgs{
 * 			Name: pulumi.String("my-cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultProject, err := log.NewProject(ctx, "default", &log.ProjectArgs{
 * 			Name:        pulumi.String("sls-for-flowlog"),
 * 			Description: pulumi.String("create by terraform"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultStore, err := log.NewStore(ctx, "default", &log.StoreArgs{
 * 			Project:            defaultProject.Name,
 * 			Name:               pulumi.String("sls-for-flowlog"),
 * 			RetentionPeriod:    pulumi.Int(3650),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewFlowLog(ctx, "default", &cen.FlowLogArgs{
 * 			FlowLogName:  pulumi.String("my-flowlog"),
 * 			CenId:        _default.ID(),
 * 			ProjectName:  defaultProject.Name,
 * 			LogStoreName: defaultStore.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.cen.FlowLog;
 * import com.pulumi.alicloud.cen.FlowLogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a cen flowlog resource and use it to publish a route entry pointing to an ECS.
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .name("my-cen")
 *             .build());
 *         var defaultProject = new Project("defaultProject", ProjectArgs.builder()
 *             .name("sls-for-flowlog")
 *             .description("create by terraform")
 *             .build());
 *         var defaultStore = new Store("defaultStore", StoreArgs.builder()
 *             .project(defaultProject.name())
 *             .name("sls-for-flowlog")
 *             .retentionPeriod(3650)
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         var defaultFlowLog = new FlowLog("defaultFlowLog", FlowLogArgs.builder()
 *             .flowLogName("my-flowlog")
 *             .cenId(default_.id())
 *             .projectName(defaultProject.name())
 *             .logStoreName(defaultStore.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a cen flowlog resource and use it to publish a route entry pointing to an ECS.
 *   default:
 *     type: alicloud:cen:Instance
 *     properties:
 *       name: my-cen
 *   defaultProject:
 *     type: alicloud:log:Project
 *     name: default
 *     properties:
 *       name: sls-for-flowlog
 *       description: create by terraform
 *   defaultStore:
 *     type: alicloud:log:Store
 *     name: default
 *     properties:
 *       project: ${defaultProject.name}
 *       name: sls-for-flowlog
 *       retentionPeriod: 3650
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   defaultFlowLog:
 *     type: alicloud:cen:FlowLog
 *     name: default
 *     properties:
 *       flowLogName: my-flowlog
 *       cenId: ${default.id}
 *       projectName: ${defaultProject.name}
 *       logStoreName: ${defaultStore.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN flowlog can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/flowLog:FlowLog default flowlog-tig1xxxxxx
 * ```
 * @property cenId The ID of the CEN Instance.
 * @property description The description of flowlog.
 * @property flowLogName The name of flowlog.
 * @property logStoreName The name of the log store which is in the  `project_name` SLS project.
 * @property projectName The name of the SLS project.
 * @property status The status of flowlog. Valid values: ["Active", "Inactive"]. Default to "Active".
 */
public data class FlowLogArgs(
    public val cenId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val flowLogName: Output<String>? = null,
    public val logStoreName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.FlowLogArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.FlowLogArgs =
        com.pulumi.alicloud.cen.FlowLogArgs.builder()
            .cenId(cenId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .flowLogName(flowLogName?.applyValue({ args0 -> args0 }))
            .logStoreName(logStoreName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowLogArgs].
 */
@PulumiTagMarker
public class FlowLogArgsBuilder internal constructor() {
    private var cenId: Output<String>? = null

    private var description: Output<String>? = null

    private var flowLogName: Output<String>? = null

    private var logStoreName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The ID of the CEN Instance.
     */
    @JvmName("mcwmucvlledephye")
    public suspend fun cenId(`value`: Output<String>) {
        this.cenId = value
    }

    /**
     * @param value The description of flowlog.
     */
    @JvmName("ksyxnsfkbtgrhbwu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of flowlog.
     */
    @JvmName("mcsxkfoxqiumsqvm")
    public suspend fun flowLogName(`value`: Output<String>) {
        this.flowLogName = value
    }

    /**
     * @param value The name of the log store which is in the  `project_name` SLS project.
     */
    @JvmName("haqkoyojqtlfjjdb")
    public suspend fun logStoreName(`value`: Output<String>) {
        this.logStoreName = value
    }

    /**
     * @param value The name of the SLS project.
     */
    @JvmName("asgitstcucpffeqy")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The status of flowlog. Valid values: ["Active", "Inactive"]. Default to "Active".
     */
    @JvmName("eqyogwxckparokuh")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The ID of the CEN Instance.
     */
    @JvmName("gepiqlwrtmxlgfmn")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenId = mapped
    }

    /**
     * @param value The description of flowlog.
     */
    @JvmName("bbvpieocgouoqsus")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of flowlog.
     */
    @JvmName("rvgloanxguwrivya")
    public suspend fun flowLogName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowLogName = mapped
    }

    /**
     * @param value The name of the log store which is in the  `project_name` SLS project.
     */
    @JvmName("biyuvawovxbnyejk")
    public suspend fun logStoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStoreName = mapped
    }

    /**
     * @param value The name of the SLS project.
     */
    @JvmName("gwyvubqvhwfhpgfg")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The status of flowlog. Valid values: ["Active", "Inactive"]. Default to "Active".
     */
    @JvmName("ndnejdqnthyvkuox")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): FlowLogArgs = FlowLogArgs(
        cenId = cenId,
        description = description,
        flowLogName = flowLogName,
        logStoreName = logStoreName,
        projectName = projectName,
        status = status,
    )
}
