@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InstanceAttachment].
 */
@PulumiTagMarker
public class InstanceAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceAttachmentArgs = InstanceAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceAttachmentArgsBuilder.() -> Unit) {
        val builder = InstanceAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InstanceAttachment {
        val builtJavaResource = com.pulumi.alicloud.cen.InstanceAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InstanceAttachment(builtJavaResource)
    }
}

/**
 * Provides a CEN child instance attachment resource that associate the network(VPC, CCN, VBR) with the CEN instance.
 * > **NOTE:** Available since v1.42.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const example = new alicloud.vpc.Network("example", {
 *     vpcName: "tf_example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const exampleInstance = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleInstanceAttachment = new alicloud.cen.InstanceAttachment("example", {
 *     instanceId: exampleInstance.id,
 *     childInstanceId: example.id,
 *     childInstanceType: "VPC",
 *     childInstanceRegionId: _default.then(_default => _default.regions?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_regions(current=True)
 * example = alicloud.vpc.Network("example",
 *     vpc_name="tf_example",
 *     cidr_block="172.17.3.0/24")
 * example_instance = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_instance_attachment = alicloud.cen.InstanceAttachment("example",
 *     instance_id=example_instance.id,
 *     child_instance_id=example.id,
 *     child_instance_type="VPC",
 *     child_instance_region_id=default.regions[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = "tf_example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var exampleInstance = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleInstanceAttachment = new AliCloud.Cen.InstanceAttachment("example", new()
 *     {
 *         InstanceId = exampleInstance.Id,
 *         ChildInstanceId = example.Id,
 *         ChildInstanceType = "VPC",
 *         ChildInstanceRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("tf_example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstance, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewInstanceAttachment(ctx, "example", &cen.InstanceAttachmentArgs{
 * 			InstanceId:            exampleInstance.ID(),
 * 			ChildInstanceId:       example.ID(),
 * 			ChildInstanceType:     pulumi.String("VPC"),
 * 			ChildInstanceRegionId: pulumi.String(_default.Regions[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.InstanceAttachment;
 * import com.pulumi.alicloud.cen.InstanceAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName("tf_example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleInstanceAttachment = new InstanceAttachment("exampleInstanceAttachment", InstanceAttachmentArgs.builder()
 *             .instanceId(exampleInstance.id())
 *             .childInstanceId(example.id())
 *             .childInstanceType("VPC")
 *             .childInstanceRegionId(default_.regions()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: tf_example
 *       cidrBlock: 172.17.3.0/24
 *   exampleInstance:
 *     type: alicloud:cen:Instance
 *     name: example
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleInstanceAttachment:
 *     type: alicloud:cen:InstanceAttachment
 *     name: example
 *     properties:
 *       instanceId: ${exampleInstance.id}
 *       childInstanceId: ${example.id}
 *       childInstanceType: VPC
 *       childInstanceRegionId: ${default.regions[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/instanceAttachment:InstanceAttachment example cen-m7i7pjmkon********:vpc-2ze2w07mcy9nz********:VPC:cn-beijing
 * ```
 */
public class InstanceAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.InstanceAttachment,
) : KotlinCustomResource(javaResource, InstanceAttachmentMapper) {
    /**
     * The account ID to which the CEN instance belongs.
     * ->**NOTE:** Ensure that the child instance is not used in Express Connect.
     */
    public val cenOwnerId: Output<Int>?
        get() = javaResource.cenOwnerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the child instance to attach.
     */
    public val childInstanceId: Output<String>
        get() = javaResource.childInstanceId().applyValue({ args0 -> args0 })

    /**
     * The uid of the child instance. Only used when attach a child instance of other account.
     */
    public val childInstanceOwnerId: Output<Int>
        get() = javaResource.childInstanceOwnerId().applyValue({ args0 -> args0 })

    /**
     * The region ID of the child instance to attach.
     */
    public val childInstanceRegionId: Output<String>
        get() = javaResource.childInstanceRegionId().applyValue({ args0 -> args0 })

    /**
     * The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
     */
    public val childInstanceType: Output<String>
        get() = javaResource.childInstanceType().applyValue({ args0 -> args0 })

    /**
     * The ID of the CEN.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The associating status of the network.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object InstanceAttachmentMapper : ResourceMapper<InstanceAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.InstanceAttachment::class == javaResource::class

    override fun map(javaResource: Resource): InstanceAttachment = InstanceAttachment(
        javaResource as
            com.pulumi.alicloud.cen.InstanceAttachment,
    )
}

/**
 * @see [InstanceAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceAttachment].
 */
public suspend fun instanceAttachment(
    name: String,
    block: suspend InstanceAttachmentResourceBuilder.() -> Unit,
): InstanceAttachment {
    val builder = InstanceAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceAttachment(name: String): InstanceAttachment {
    val builder = InstanceAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
