@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.InstanceAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CEN child instance attachment resource that associate the network(VPC, CCN, VBR) with the CEN instance.
 * > **NOTE:** Available since v1.42.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const example = new alicloud.vpc.Network("example", {
 *     vpcName: "tf_example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const exampleInstance = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleInstanceAttachment = new alicloud.cen.InstanceAttachment("example", {
 *     instanceId: exampleInstance.id,
 *     childInstanceId: example.id,
 *     childInstanceType: "VPC",
 *     childInstanceRegionId: _default.then(_default => _default.regions?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_regions(current=True)
 * example = alicloud.vpc.Network("example",
 *     vpc_name="tf_example",
 *     cidr_block="172.17.3.0/24")
 * example_instance = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_instance_attachment = alicloud.cen.InstanceAttachment("example",
 *     instance_id=example_instance.id,
 *     child_instance_id=example.id,
 *     child_instance_type="VPC",
 *     child_instance_region_id=default.regions[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = "tf_example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var exampleInstance = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleInstanceAttachment = new AliCloud.Cen.InstanceAttachment("example", new()
 *     {
 *         InstanceId = exampleInstance.Id,
 *         ChildInstanceId = example.Id,
 *         ChildInstanceType = "VPC",
 *         ChildInstanceRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("tf_example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstance, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewInstanceAttachment(ctx, "example", &cen.InstanceAttachmentArgs{
 * 			InstanceId:            exampleInstance.ID(),
 * 			ChildInstanceId:       example.ID(),
 * 			ChildInstanceType:     pulumi.String("VPC"),
 * 			ChildInstanceRegionId: pulumi.String(_default.Regions[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.InstanceAttachment;
 * import com.pulumi.alicloud.cen.InstanceAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName("tf_example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleInstanceAttachment = new InstanceAttachment("exampleInstanceAttachment", InstanceAttachmentArgs.builder()
 *             .instanceId(exampleInstance.id())
 *             .childInstanceId(example.id())
 *             .childInstanceType("VPC")
 *             .childInstanceRegionId(default_.regions()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: tf_example
 *       cidrBlock: 172.17.3.0/24
 *   exampleInstance:
 *     type: alicloud:cen:Instance
 *     name: example
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleInstanceAttachment:
 *     type: alicloud:cen:InstanceAttachment
 *     name: example
 *     properties:
 *       instanceId: ${exampleInstance.id}
 *       childInstanceId: ${example.id}
 *       childInstanceType: VPC
 *       childInstanceRegionId: ${default.regions[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/instanceAttachment:InstanceAttachment example cen-m7i7pjmkon********:vpc-2ze2w07mcy9nz********:VPC:cn-beijing
 * ```
 * @property cenOwnerId The account ID to which the CEN instance belongs.
 * ->**NOTE:** Ensure that the child instance is not used in Express Connect.
 * @property childInstanceId The ID of the child instance to attach.
 * @property childInstanceOwnerId The uid of the child instance. Only used when attach a child instance of other account.
 * @property childInstanceRegionId The region ID of the child instance to attach.
 * @property childInstanceType The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
 * @property instanceId The ID of the CEN.
 */
public data class InstanceAttachmentArgs(
    public val cenOwnerId: Output<Int>? = null,
    public val childInstanceId: Output<String>? = null,
    public val childInstanceOwnerId: Output<Int>? = null,
    public val childInstanceRegionId: Output<String>? = null,
    public val childInstanceType: Output<String>? = null,
    public val instanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.InstanceAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.InstanceAttachmentArgs =
        com.pulumi.alicloud.cen.InstanceAttachmentArgs.builder()
            .cenOwnerId(cenOwnerId?.applyValue({ args0 -> args0 }))
            .childInstanceId(childInstanceId?.applyValue({ args0 -> args0 }))
            .childInstanceOwnerId(childInstanceOwnerId?.applyValue({ args0 -> args0 }))
            .childInstanceRegionId(childInstanceRegionId?.applyValue({ args0 -> args0 }))
            .childInstanceType(childInstanceType?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceAttachmentArgs].
 */
@PulumiTagMarker
public class InstanceAttachmentArgsBuilder internal constructor() {
    private var cenOwnerId: Output<Int>? = null

    private var childInstanceId: Output<String>? = null

    private var childInstanceOwnerId: Output<Int>? = null

    private var childInstanceRegionId: Output<String>? = null

    private var childInstanceType: Output<String>? = null

    private var instanceId: Output<String>? = null

    /**
     * @param value The account ID to which the CEN instance belongs.
     * ->**NOTE:** Ensure that the child instance is not used in Express Connect.
     */
    @JvmName("enxsfunptoavrpuw")
    public suspend fun cenOwnerId(`value`: Output<Int>) {
        this.cenOwnerId = value
    }

    /**
     * @param value The ID of the child instance to attach.
     */
    @JvmName("kpqrjmdntjslkpbo")
    public suspend fun childInstanceId(`value`: Output<String>) {
        this.childInstanceId = value
    }

    /**
     * @param value The uid of the child instance. Only used when attach a child instance of other account.
     */
    @JvmName("smtrytuwauqrqqfd")
    public suspend fun childInstanceOwnerId(`value`: Output<Int>) {
        this.childInstanceOwnerId = value
    }

    /**
     * @param value The region ID of the child instance to attach.
     */
    @JvmName("cbatxotloyimdhfg")
    public suspend fun childInstanceRegionId(`value`: Output<String>) {
        this.childInstanceRegionId = value
    }

    /**
     * @param value The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
     */
    @JvmName("hjtlpfprggcbvtrr")
    public suspend fun childInstanceType(`value`: Output<String>) {
        this.childInstanceType = value
    }

    /**
     * @param value The ID of the CEN.
     */
    @JvmName("alaejekvurxyuigx")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The account ID to which the CEN instance belongs.
     * ->**NOTE:** Ensure that the child instance is not used in Express Connect.
     */
    @JvmName("gafbsqoyoqvafsss")
    public suspend fun cenOwnerId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenOwnerId = mapped
    }

    /**
     * @param value The ID of the child instance to attach.
     */
    @JvmName("ddepbwhslruvrltm")
    public suspend fun childInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.childInstanceId = mapped
    }

    /**
     * @param value The uid of the child instance. Only used when attach a child instance of other account.
     */
    @JvmName("pwmsjnrwyuledovp")
    public suspend fun childInstanceOwnerId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.childInstanceOwnerId = mapped
    }

    /**
     * @param value The region ID of the child instance to attach.
     */
    @JvmName("lrasygejusjyehjt")
    public suspend fun childInstanceRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.childInstanceRegionId = mapped
    }

    /**
     * @param value The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
     */
    @JvmName("xxnlpwuqpseedbpr")
    public suspend fun childInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.childInstanceType = mapped
    }

    /**
     * @param value The ID of the CEN.
     */
    @JvmName("ekfmcroesodfgauo")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    internal fun build(): InstanceAttachmentArgs = InstanceAttachmentArgs(
        cenOwnerId = cenOwnerId,
        childInstanceId = childInstanceId,
        childInstanceOwnerId = childInstanceOwnerId,
        childInstanceRegionId = childInstanceRegionId,
        childInstanceType = childInstanceType,
        instanceId = instanceId,
    )
}
