@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.InterRegionTrafficQosPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Enterprise Network (CEN) Inter Region Traffic Qos Policy resource.
 * For information about Cloud Enterprise Network (CEN) Inter Region Traffic Qos Policy and how to use it, see [What is Inter Region Traffic Qos Policy](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createceninterregiontrafficqospolicy).
 * > **NOTE:** Available since v1.195.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.cen.Instance("default", {cenInstanceName: "tf-example"});
 * const defaultBandwidthPackage = new alicloud.cen.BandwidthPackage("default", {
 *     bandwidth: 5,
 *     geographicRegionAId: "China",
 *     geographicRegionBId: "China",
 * });
 * const defaultBandwidthPackageAttachment = new alicloud.cen.BandwidthPackageAttachment("default", {
 *     instanceId: _default.id,
 *     bandwidthPackageId: defaultBandwidthPackage.id,
 * });
 * const hz = new alicloud.cen.TransitRouter("hz", {cenId: defaultBandwidthPackageAttachment.instanceId});
 * const bj = new alicloud.cen.TransitRouter("bj", {cenId: hz.cenId});
 * const defaultTransitRouterPeerAttachment = new alicloud.cen.TransitRouterPeerAttachment("default", {
 *     cenId: _default.id,
 *     transitRouterId: hz.transitRouterId,
 *     peerTransitRouterRegionId: "cn-beijing",
 *     peerTransitRouterId: bj.transitRouterId,
 *     cenBandwidthPackageId: defaultBandwidthPackageAttachment.bandwidthPackageId,
 *     bandwidth: 5,
 * });
 * const defaultInterRegionTrafficQosPolicy = new alicloud.cen.InterRegionTrafficQosPolicy("default", {
 *     transitRouterId: hz.transitRouterId,
 *     transitRouterAttachmentId: defaultTransitRouterPeerAttachment.transitRouterAttachmentId,
 *     interRegionTrafficQosPolicyName: "tf-example-name",
 *     interRegionTrafficQosPolicyDescription: "tf-example-description",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.cen.Instance("default", cen_instance_name="tf-example")
 * default_bandwidth_package = alicloud.cen.BandwidthPackage("default",
 *     bandwidth=5,
 *     geographic_region_a_id="China",
 *     geographic_region_b_id="China")
 * default_bandwidth_package_attachment = alicloud.cen.BandwidthPackageAttachment("default",
 *     instance_id=default.id,
 *     bandwidth_package_id=default_bandwidth_package.id)
 * hz = alicloud.cen.TransitRouter("hz", cen_id=default_bandwidth_package_attachment.instance_id)
 * bj = alicloud.cen.TransitRouter("bj", cen_id=hz.cen_id)
 * default_transit_router_peer_attachment = alicloud.cen.TransitRouterPeerAttachment("default",
 *     cen_id=default.id,
 *     transit_router_id=hz.transit_router_id,
 *     peer_transit_router_region_id="cn-beijing",
 *     peer_transit_router_id=bj.transit_router_id,
 *     cen_bandwidth_package_id=default_bandwidth_package_attachment.bandwidth_package_id,
 *     bandwidth=5)
 * default_inter_region_traffic_qos_policy = alicloud.cen.InterRegionTrafficQosPolicy("default",
 *     transit_router_id=hz.transit_router_id,
 *     transit_router_attachment_id=default_transit_router_peer_attachment.transit_router_attachment_id,
 *     inter_region_traffic_qos_policy_name="tf-example-name",
 *     inter_region_traffic_qos_policy_description="tf-example-description")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Cen.Instance("default", new()
 *     {
 *         CenInstanceName = "tf-example",
 *     });
 *     var defaultBandwidthPackage = new AliCloud.Cen.BandwidthPackage("default", new()
 *     {
 *         Bandwidth = 5,
 *         GeographicRegionAId = "China",
 *         GeographicRegionBId = "China",
 *     });
 *     var defaultBandwidthPackageAttachment = new AliCloud.Cen.BandwidthPackageAttachment("default", new()
 *     {
 *         InstanceId = @default.Id,
 *         BandwidthPackageId = defaultBandwidthPackage.Id,
 *     });
 *     var hz = new AliCloud.Cen.TransitRouter("hz", new()
 *     {
 *         CenId = defaultBandwidthPackageAttachment.InstanceId,
 *     });
 *     var bj = new AliCloud.Cen.TransitRouter("bj", new()
 *     {
 *         CenId = hz.CenId,
 *     });
 *     var defaultTransitRouterPeerAttachment = new AliCloud.Cen.TransitRouterPeerAttachment("default", new()
 *     {
 *         CenId = @default.Id,
 *         TransitRouterId = hz.TransitRouterId,
 *         PeerTransitRouterRegionId = "cn-beijing",
 *         PeerTransitRouterId = bj.TransitRouterId,
 *         CenBandwidthPackageId = defaultBandwidthPackageAttachment.BandwidthPackageId,
 *         Bandwidth = 5,
 *     });
 *     var defaultInterRegionTrafficQosPolicy = new AliCloud.Cen.InterRegionTrafficQosPolicy("default", new()
 *     {
 *         TransitRouterId = hz.TransitRouterId,
 *         TransitRouterAttachmentId = defaultTransitRouterPeerAttachment.TransitRouterAttachmentId,
 *         InterRegionTrafficQosPolicyName = "tf-example-name",
 *         InterRegionTrafficQosPolicyDescription = "tf-example-description",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cen.NewInstance(ctx, "default", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBandwidthPackage, err := cen.NewBandwidthPackage(ctx, "default", &cen.BandwidthPackageArgs{
 * 			Bandwidth:           pulumi.Int(5),
 * 			GeographicRegionAId: pulumi.String("China"),
 * 			GeographicRegionBId: pulumi.String("China"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBandwidthPackageAttachment, err := cen.NewBandwidthPackageAttachment(ctx, "default", &cen.BandwidthPackageAttachmentArgs{
 * 			InstanceId:         _default.ID(),
 * 			BandwidthPackageId: defaultBandwidthPackage.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		hz, err := cen.NewTransitRouter(ctx, "hz", &cen.TransitRouterArgs{
 * 			CenId: defaultBandwidthPackageAttachment.InstanceId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		bj, err := cen.NewTransitRouter(ctx, "bj", &cen.TransitRouterArgs{
 * 			CenId: hz.CenId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTransitRouterPeerAttachment, err := cen.NewTransitRouterPeerAttachment(ctx, "default", &cen.TransitRouterPeerAttachmentArgs{
 * 			CenId:                     _default.ID(),
 * 			TransitRouterId:           hz.TransitRouterId,
 * 			PeerTransitRouterRegionId: pulumi.String("cn-beijing"),
 * 			PeerTransitRouterId:       bj.TransitRouterId,
 * 			CenBandwidthPackageId:     defaultBandwidthPackageAttachment.BandwidthPackageId,
 * 			Bandwidth:                 pulumi.Int(5),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewInterRegionTrafficQosPolicy(ctx, "default", &cen.InterRegionTrafficQosPolicyArgs{
 * 			TransitRouterId:                        hz.TransitRouterId,
 * 			TransitRouterAttachmentId:              defaultTransitRouterPeerAttachment.TransitRouterAttachmentId,
 * 			InterRegionTrafficQosPolicyName:        pulumi.String("tf-example-name"),
 * 			InterRegionTrafficQosPolicyDescription: pulumi.String("tf-example-description"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.BandwidthPackage;
 * import com.pulumi.alicloud.cen.BandwidthPackageArgs;
 * import com.pulumi.alicloud.cen.BandwidthPackageAttachment;
 * import com.pulumi.alicloud.cen.BandwidthPackageAttachmentArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.TransitRouterPeerAttachment;
 * import com.pulumi.alicloud.cen.TransitRouterPeerAttachmentArgs;
 * import com.pulumi.alicloud.cen.InterRegionTrafficQosPolicy;
 * import com.pulumi.alicloud.cen.InterRegionTrafficQosPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .cenInstanceName("tf-example")
 *             .build());
 *         var defaultBandwidthPackage = new BandwidthPackage("defaultBandwidthPackage", BandwidthPackageArgs.builder()
 *             .bandwidth(5)
 *             .geographicRegionAId("China")
 *             .geographicRegionBId("China")
 *             .build());
 *         var defaultBandwidthPackageAttachment = new BandwidthPackageAttachment("defaultBandwidthPackageAttachment", BandwidthPackageAttachmentArgs.builder()
 *             .instanceId(default_.id())
 *             .bandwidthPackageId(defaultBandwidthPackage.id())
 *             .build());
 *         var hz = new TransitRouter("hz", TransitRouterArgs.builder()
 *             .cenId(defaultBandwidthPackageAttachment.instanceId())
 *             .build());
 *         var bj = new TransitRouter("bj", TransitRouterArgs.builder()
 *             .cenId(hz.cenId())
 *             .build());
 *         var defaultTransitRouterPeerAttachment = new TransitRouterPeerAttachment("defaultTransitRouterPeerAttachment", TransitRouterPeerAttachmentArgs.builder()
 *             .cenId(default_.id())
 *             .transitRouterId(hz.transitRouterId())
 *             .peerTransitRouterRegionId("cn-beijing")
 *             .peerTransitRouterId(bj.transitRouterId())
 *             .cenBandwidthPackageId(defaultBandwidthPackageAttachment.bandwidthPackageId())
 *             .bandwidth(5)
 *             .build());
 *         var defaultInterRegionTrafficQosPolicy = new InterRegionTrafficQosPolicy("defaultInterRegionTrafficQosPolicy", InterRegionTrafficQosPolicyArgs.builder()
 *             .transitRouterId(hz.transitRouterId())
 *             .transitRouterAttachmentId(defaultTransitRouterPeerAttachment.transitRouterAttachmentId())
 *             .interRegionTrafficQosPolicyName("tf-example-name")
 *             .interRegionTrafficQosPolicyDescription("tf-example-description")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: tf-example
 *   defaultBandwidthPackage:
 *     type: alicloud:cen:BandwidthPackage
 *     name: default
 *     properties:
 *       bandwidth: 5
 *       geographicRegionAId: China
 *       geographicRegionBId: China
 *   defaultBandwidthPackageAttachment:
 *     type: alicloud:cen:BandwidthPackageAttachment
 *     name: default
 *     properties:
 *       instanceId: ${default.id}
 *       bandwidthPackageId: ${defaultBandwidthPackage.id}
 *   hz:
 *     type: alicloud:cen:TransitRouter
 *     properties:
 *       cenId: ${defaultBandwidthPackageAttachment.instanceId}
 *   bj:
 *     type: alicloud:cen:TransitRouter
 *     properties:
 *       cenId: ${hz.cenId}
 *   defaultTransitRouterPeerAttachment:
 *     type: alicloud:cen:TransitRouterPeerAttachment
 *     name: default
 *     properties:
 *       cenId: ${default.id}
 *       transitRouterId: ${hz.transitRouterId}
 *       peerTransitRouterRegionId: cn-beijing
 *       peerTransitRouterId: ${bj.transitRouterId}
 *       cenBandwidthPackageId: ${defaultBandwidthPackageAttachment.bandwidthPackageId}
 *       bandwidth: 5
 *   defaultInterRegionTrafficQosPolicy:
 *     type: alicloud:cen:InterRegionTrafficQosPolicy
 *     name: default
 *     properties:
 *       transitRouterId: ${hz.transitRouterId}
 *       transitRouterAttachmentId: ${defaultTransitRouterPeerAttachment.transitRouterAttachmentId}
 *       interRegionTrafficQosPolicyName: tf-example-name
 *       interRegionTrafficQosPolicyDescription: tf-example-description
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Enterprise Network (CEN) Inter Region Traffic Qos Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/interRegionTrafficQosPolicy:InterRegionTrafficQosPolicy example <id>
 * ```
 * @property interRegionTrafficQosPolicyDescription The description of the QoS policy. The description must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The description must start with a letter.
 * @property interRegionTrafficQosPolicyName The name of the QoS policy. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). It must start with a letter.
 * @property transitRouterAttachmentId The ID of the inter-region connection.
 * @property transitRouterId The ID of the transit router.
 */
public data class InterRegionTrafficQosPolicyArgs(
    public val interRegionTrafficQosPolicyDescription: Output<String>? = null,
    public val interRegionTrafficQosPolicyName: Output<String>? = null,
    public val transitRouterAttachmentId: Output<String>? = null,
    public val transitRouterId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.InterRegionTrafficQosPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.InterRegionTrafficQosPolicyArgs =
        com.pulumi.alicloud.cen.InterRegionTrafficQosPolicyArgs.builder()
            .interRegionTrafficQosPolicyDescription(
                interRegionTrafficQosPolicyDescription?.applyValue({ args0 ->
                    args0
                }),
            )
            .interRegionTrafficQosPolicyName(interRegionTrafficQosPolicyName?.applyValue({ args0 -> args0 }))
            .transitRouterAttachmentId(transitRouterAttachmentId?.applyValue({ args0 -> args0 }))
            .transitRouterId(transitRouterId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InterRegionTrafficQosPolicyArgs].
 */
@PulumiTagMarker
public class InterRegionTrafficQosPolicyArgsBuilder internal constructor() {
    private var interRegionTrafficQosPolicyDescription: Output<String>? = null

    private var interRegionTrafficQosPolicyName: Output<String>? = null

    private var transitRouterAttachmentId: Output<String>? = null

    private var transitRouterId: Output<String>? = null

    /**
     * @param value The description of the QoS policy. The description must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The description must start with a letter.
     */
    @JvmName("xojmhodulspovsab")
    public suspend fun interRegionTrafficQosPolicyDescription(`value`: Output<String>) {
        this.interRegionTrafficQosPolicyDescription = value
    }

    /**
     * @param value The name of the QoS policy. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). It must start with a letter.
     */
    @JvmName("cfuykspepksxfxwy")
    public suspend fun interRegionTrafficQosPolicyName(`value`: Output<String>) {
        this.interRegionTrafficQosPolicyName = value
    }

    /**
     * @param value The ID of the inter-region connection.
     */
    @JvmName("gglntcxayejgrtus")
    public suspend fun transitRouterAttachmentId(`value`: Output<String>) {
        this.transitRouterAttachmentId = value
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("cxmnntqdgrfrgkth")
    public suspend fun transitRouterId(`value`: Output<String>) {
        this.transitRouterId = value
    }

    /**
     * @param value The description of the QoS policy. The description must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The description must start with a letter.
     */
    @JvmName("qwdjplpeeaypormi")
    public suspend fun interRegionTrafficQosPolicyDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interRegionTrafficQosPolicyDescription = mapped
    }

    /**
     * @param value The name of the QoS policy. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). It must start with a letter.
     */
    @JvmName("cgqncdgtpgeticen")
    public suspend fun interRegionTrafficQosPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interRegionTrafficQosPolicyName = mapped
    }

    /**
     * @param value The ID of the inter-region connection.
     */
    @JvmName("pivvtoopasnkcvyf")
    public suspend fun transitRouterAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterAttachmentId = mapped
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("pxhmdnjcrqsbekar")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterId = mapped
    }

    internal fun build(): InterRegionTrafficQosPolicyArgs = InterRegionTrafficQosPolicyArgs(
        interRegionTrafficQosPolicyDescription = interRegionTrafficQosPolicyDescription,
        interRegionTrafficQosPolicyName = interRegionTrafficQosPolicyName,
        transitRouterAttachmentId = transitRouterAttachmentId,
        transitRouterId = transitRouterId,
    )
}
