@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PrivateZone].
 */
@PulumiTagMarker
public class PrivateZoneResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateZoneArgs = PrivateZoneArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateZoneArgsBuilder.() -> Unit) {
        val builder = PrivateZoneArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateZone {
        val builtJavaResource = com.pulumi.alicloud.cen.PrivateZone(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PrivateZone(builtJavaResource)
    }
}

/**
 * This topic describes how to configure PrivateZone access.
 * PrivateZone is a VPC-based resolution and management service for private domain names.
 * After you set a PrivateZone access, the Cloud Connect Network (CCN) and Virtual Border Router (VBR) attached to a CEN instance can access the PrivateZone service through CEN.
 * For information about CEN Private Zone and how to use it, see [Manage CEN Private Zone](https://www.alibabacloud.com/help/en/cloud-enterprise-network/latest/api-cbn-2017-09-12-routeprivatezoneincentovpc).
 * > **NOTE:** Available since v1.83.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const example = new alicloud.vpc.Network("example", {
 *     vpcName: "tf_example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const exampleInstance = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleInstanceAttachment = new alicloud.cen.InstanceAttachment("example", {
 *     instanceId: exampleInstance.id,
 *     childInstanceId: example.id,
 *     childInstanceType: "VPC",
 *     childInstanceRegionId: _default.then(_default => _default.regions?.[0]?.id),
 * });
 * const defaultPrivateZone = new alicloud.cen.PrivateZone("default", {
 *     accessRegionId: _default.then(_default => _default.regions?.[0]?.id),
 *     cenId: exampleInstanceAttachment.instanceId,
 *     hostRegionId: _default.then(_default => _default.regions?.[0]?.id),
 *     hostVpcId: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_regions(current=True)
 * example = alicloud.vpc.Network("example",
 *     vpc_name="tf_example",
 *     cidr_block="172.17.3.0/24")
 * example_instance = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_instance_attachment = alicloud.cen.InstanceAttachment("example",
 *     instance_id=example_instance.id,
 *     child_instance_id=example.id,
 *     child_instance_type="VPC",
 *     child_instance_region_id=default.regions[0].id)
 * default_private_zone = alicloud.cen.PrivateZone("default",
 *     access_region_id=default.regions[0].id,
 *     cen_id=example_instance_attachment.instance_id,
 *     host_region_id=default.regions[0].id,
 *     host_vpc_id=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = "tf_example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var exampleInstance = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleInstanceAttachment = new AliCloud.Cen.InstanceAttachment("example", new()
 *     {
 *         InstanceId = exampleInstance.Id,
 *         ChildInstanceId = example.Id,
 *         ChildInstanceType = "VPC",
 *         ChildInstanceRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *     });
 *     var defaultPrivateZone = new AliCloud.Cen.PrivateZone("default", new()
 *     {
 *         AccessRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         CenId = exampleInstanceAttachment.InstanceId,
 *         HostRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         HostVpcId = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("tf_example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstance, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstanceAttachment, err := cen.NewInstanceAttachment(ctx, "example", &cen.InstanceAttachmentArgs{
 * 			InstanceId:            exampleInstance.ID(),
 * 			ChildInstanceId:       example.ID(),
 * 			ChildInstanceType:     pulumi.String("VPC"),
 * 			ChildInstanceRegionId: pulumi.String(_default.Regions[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewPrivateZone(ctx, "default", &cen.PrivateZoneArgs{
 * 			AccessRegionId: pulumi.String(_default.Regions[0].Id),
 * 			CenId:          exampleInstanceAttachment.InstanceId,
 * 			HostRegionId:   pulumi.String(_default.Regions[0].Id),
 * 			HostVpcId:      example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.InstanceAttachment;
 * import com.pulumi.alicloud.cen.InstanceAttachmentArgs;
 * import com.pulumi.alicloud.cen.PrivateZone;
 * import com.pulumi.alicloud.cen.PrivateZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName("tf_example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleInstanceAttachment = new InstanceAttachment("exampleInstanceAttachment", InstanceAttachmentArgs.builder()
 *             .instanceId(exampleInstance.id())
 *             .childInstanceId(example.id())
 *             .childInstanceType("VPC")
 *             .childInstanceRegionId(default_.regions()[0].id())
 *             .build());
 *         var defaultPrivateZone = new PrivateZone("defaultPrivateZone", PrivateZoneArgs.builder()
 *             .accessRegionId(default_.regions()[0].id())
 *             .cenId(exampleInstanceAttachment.instanceId())
 *             .hostRegionId(default_.regions()[0].id())
 *             .hostVpcId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: tf_example
 *       cidrBlock: 172.17.3.0/24
 *   exampleInstance:
 *     type: alicloud:cen:Instance
 *     name: example
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleInstanceAttachment:
 *     type: alicloud:cen:InstanceAttachment
 *     name: example
 *     properties:
 *       instanceId: ${exampleInstance.id}
 *       childInstanceId: ${example.id}
 *       childInstanceType: VPC
 *       childInstanceRegionId: ${default.regions[0].id}
 *   defaultPrivateZone:
 *     type: alicloud:cen:PrivateZone
 *     name: default
 *     properties:
 *       accessRegionId: ${default.regions[0].id}
 *       cenId: ${exampleInstanceAttachment.instanceId}
 *       hostRegionId: ${default.regions[0].id}
 *       hostVpcId: ${example.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN Private Zone can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/privateZone:PrivateZone example cen-abc123456:cn-hangzhou
 * ```
 */
public class PrivateZone internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.PrivateZone,
) : KotlinCustomResource(javaResource, PrivateZoneMapper) {
    /**
     * The access region. The access region is the region of the cloud resource that accesses the PrivateZone service through CEN.
     */
    public val accessRegionId: Output<String>
        get() = javaResource.accessRegionId().applyValue({ args0 -> args0 })

    /**
     * The ID of the CEN instance.
     */
    public val cenId: Output<String>
        get() = javaResource.cenId().applyValue({ args0 -> args0 })

    /**
     * The service region. The service region is the target region of the PrivateZone service to be accessed through CEN.
     */
    public val hostRegionId: Output<String>
        get() = javaResource.hostRegionId().applyValue({ args0 -> args0 })

    /**
     * The VPC that belongs to the service region.
     * ->**NOTE:** The "alicloud.cen.PrivateZone" resource depends on the related "alicloud.cen.InstanceAttachment" resource.
     */
    public val hostVpcId: Output<String>
        get() = javaResource.hostVpcId().applyValue({ args0 -> args0 })

    /**
     * The status of the PrivateZone service. Valid values: ["Creating", "Active", "Deleting"].
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object PrivateZoneMapper : ResourceMapper<PrivateZone> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.PrivateZone::class == javaResource::class

    override fun map(javaResource: Resource): PrivateZone = PrivateZone(
        javaResource as
            com.pulumi.alicloud.cen.PrivateZone,
    )
}

/**
 * @see [PrivateZone].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateZone].
 */
public suspend fun privateZone(name: String, block: suspend PrivateZoneResourceBuilder.() -> Unit): PrivateZone {
    val builder = PrivateZoneResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateZone].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateZone(name: String): PrivateZone {
    val builder = PrivateZoneResourceBuilder()
    builder.name(name)
    return builder.build()
}
