@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.PrivateZoneArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This topic describes how to configure PrivateZone access.
 * PrivateZone is a VPC-based resolution and management service for private domain names.
 * After you set a PrivateZone access, the Cloud Connect Network (CCN) and Virtual Border Router (VBR) attached to a CEN instance can access the PrivateZone service through CEN.
 * For information about CEN Private Zone and how to use it, see [Manage CEN Private Zone](https://www.alibabacloud.com/help/en/cloud-enterprise-network/latest/api-cbn-2017-09-12-routeprivatezoneincentovpc).
 * > **NOTE:** Available since v1.83.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const example = new alicloud.vpc.Network("example", {
 *     vpcName: "tf_example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const exampleInstance = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleInstanceAttachment = new alicloud.cen.InstanceAttachment("example", {
 *     instanceId: exampleInstance.id,
 *     childInstanceId: example.id,
 *     childInstanceType: "VPC",
 *     childInstanceRegionId: _default.then(_default => _default.regions?.[0]?.id),
 * });
 * const defaultPrivateZone = new alicloud.cen.PrivateZone("default", {
 *     accessRegionId: _default.then(_default => _default.regions?.[0]?.id),
 *     cenId: exampleInstanceAttachment.instanceId,
 *     hostRegionId: _default.then(_default => _default.regions?.[0]?.id),
 *     hostVpcId: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_regions(current=True)
 * example = alicloud.vpc.Network("example",
 *     vpc_name="tf_example",
 *     cidr_block="172.17.3.0/24")
 * example_instance = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_instance_attachment = alicloud.cen.InstanceAttachment("example",
 *     instance_id=example_instance.id,
 *     child_instance_id=example.id,
 *     child_instance_type="VPC",
 *     child_instance_region_id=default.regions[0].id)
 * default_private_zone = alicloud.cen.PrivateZone("default",
 *     access_region_id=default.regions[0].id,
 *     cen_id=example_instance_attachment.instance_id,
 *     host_region_id=default.regions[0].id,
 *     host_vpc_id=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = "tf_example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var exampleInstance = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleInstanceAttachment = new AliCloud.Cen.InstanceAttachment("example", new()
 *     {
 *         InstanceId = exampleInstance.Id,
 *         ChildInstanceId = example.Id,
 *         ChildInstanceType = "VPC",
 *         ChildInstanceRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *     });
 *     var defaultPrivateZone = new AliCloud.Cen.PrivateZone("default", new()
 *     {
 *         AccessRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         CenId = exampleInstanceAttachment.InstanceId,
 *         HostRegionId = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *         HostVpcId = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("tf_example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstance, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstanceAttachment, err := cen.NewInstanceAttachment(ctx, "example", &cen.InstanceAttachmentArgs{
 * 			InstanceId:            exampleInstance.ID(),
 * 			ChildInstanceId:       example.ID(),
 * 			ChildInstanceType:     pulumi.String("VPC"),
 * 			ChildInstanceRegionId: pulumi.String(_default.Regions[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewPrivateZone(ctx, "default", &cen.PrivateZoneArgs{
 * 			AccessRegionId: pulumi.String(_default.Regions[0].Id),
 * 			CenId:          exampleInstanceAttachment.InstanceId,
 * 			HostRegionId:   pulumi.String(_default.Regions[0].Id),
 * 			HostVpcId:      example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.InstanceAttachment;
 * import com.pulumi.alicloud.cen.InstanceAttachmentArgs;
 * import com.pulumi.alicloud.cen.PrivateZone;
 * import com.pulumi.alicloud.cen.PrivateZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName("tf_example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleInstanceAttachment = new InstanceAttachment("exampleInstanceAttachment", InstanceAttachmentArgs.builder()
 *             .instanceId(exampleInstance.id())
 *             .childInstanceId(example.id())
 *             .childInstanceType("VPC")
 *             .childInstanceRegionId(default_.regions()[0].id())
 *             .build());
 *         var defaultPrivateZone = new PrivateZone("defaultPrivateZone", PrivateZoneArgs.builder()
 *             .accessRegionId(default_.regions()[0].id())
 *             .cenId(exampleInstanceAttachment.instanceId())
 *             .hostRegionId(default_.regions()[0].id())
 *             .hostVpcId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: tf_example
 *       cidrBlock: 172.17.3.0/24
 *   exampleInstance:
 *     type: alicloud:cen:Instance
 *     name: example
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleInstanceAttachment:
 *     type: alicloud:cen:InstanceAttachment
 *     name: example
 *     properties:
 *       instanceId: ${exampleInstance.id}
 *       childInstanceId: ${example.id}
 *       childInstanceType: VPC
 *       childInstanceRegionId: ${default.regions[0].id}
 *   defaultPrivateZone:
 *     type: alicloud:cen:PrivateZone
 *     name: default
 *     properties:
 *       accessRegionId: ${default.regions[0].id}
 *       cenId: ${exampleInstanceAttachment.instanceId}
 *       hostRegionId: ${default.regions[0].id}
 *       hostVpcId: ${example.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN Private Zone can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/privateZone:PrivateZone example cen-abc123456:cn-hangzhou
 * ```
 * @property accessRegionId The access region. The access region is the region of the cloud resource that accesses the PrivateZone service through CEN.
 * @property cenId The ID of the CEN instance.
 * @property hostRegionId The service region. The service region is the target region of the PrivateZone service to be accessed through CEN.
 * @property hostVpcId The VPC that belongs to the service region.
 * ->**NOTE:** The "alicloud.cen.PrivateZone" resource depends on the related "alicloud.cen.InstanceAttachment" resource.
 */
public data class PrivateZoneArgs(
    public val accessRegionId: Output<String>? = null,
    public val cenId: Output<String>? = null,
    public val hostRegionId: Output<String>? = null,
    public val hostVpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.PrivateZoneArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.PrivateZoneArgs =
        com.pulumi.alicloud.cen.PrivateZoneArgs.builder()
            .accessRegionId(accessRegionId?.applyValue({ args0 -> args0 }))
            .cenId(cenId?.applyValue({ args0 -> args0 }))
            .hostRegionId(hostRegionId?.applyValue({ args0 -> args0 }))
            .hostVpcId(hostVpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateZoneArgs].
 */
@PulumiTagMarker
public class PrivateZoneArgsBuilder internal constructor() {
    private var accessRegionId: Output<String>? = null

    private var cenId: Output<String>? = null

    private var hostRegionId: Output<String>? = null

    private var hostVpcId: Output<String>? = null

    /**
     * @param value The access region. The access region is the region of the cloud resource that accesses the PrivateZone service through CEN.
     */
    @JvmName("tdptmkgwljkhgxmm")
    public suspend fun accessRegionId(`value`: Output<String>) {
        this.accessRegionId = value
    }

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("cxwiwqpulwednxmv")
    public suspend fun cenId(`value`: Output<String>) {
        this.cenId = value
    }

    /**
     * @param value The service region. The service region is the target region of the PrivateZone service to be accessed through CEN.
     */
    @JvmName("csvlsoxdfdgvexcc")
    public suspend fun hostRegionId(`value`: Output<String>) {
        this.hostRegionId = value
    }

    /**
     * @param value The VPC that belongs to the service region.
     * ->**NOTE:** The "alicloud.cen.PrivateZone" resource depends on the related "alicloud.cen.InstanceAttachment" resource.
     */
    @JvmName("vbbkojuvvksqywij")
    public suspend fun hostVpcId(`value`: Output<String>) {
        this.hostVpcId = value
    }

    /**
     * @param value The access region. The access region is the region of the cloud resource that accesses the PrivateZone service through CEN.
     */
    @JvmName("sbrdjcmfmxtfntif")
    public suspend fun accessRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessRegionId = mapped
    }

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("ighjfeyrnuyacjvg")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenId = mapped
    }

    /**
     * @param value The service region. The service region is the target region of the PrivateZone service to be accessed through CEN.
     */
    @JvmName("vwomcyykpexedeix")
    public suspend fun hostRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostRegionId = mapped
    }

    /**
     * @param value The VPC that belongs to the service region.
     * ->**NOTE:** The "alicloud.cen.PrivateZone" resource depends on the related "alicloud.cen.InstanceAttachment" resource.
     */
    @JvmName("ovqjkuskhqxgdguj")
    public suspend fun hostVpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostVpcId = mapped
    }

    internal fun build(): PrivateZoneArgs = PrivateZoneArgs(
        accessRegionId = accessRegionId,
        cenId = cenId,
        hostRegionId = hostRegionId,
        hostVpcId = hostVpcId,
    )
}
