@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RouteMap].
 */
@PulumiTagMarker
public class RouteMapResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteMapArgs = RouteMapArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteMapArgsBuilder.() -> Unit) {
        val builder = RouteMapArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RouteMap {
        val builtJavaResource = com.pulumi.alicloud.cen.RouteMap(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RouteMap(builtJavaResource)
    }
}

/**
 * This topic provides an overview of the route map function of Cloud Enterprise Networks (CENs).
 * You can use the route map function to filter routes and modify route attributes.
 * By doing so, you can manage the communication between networks attached to a CEN.
 * For information about CEN Route Map and how to use it, see [Manage CEN Route Map](https://www.alibabacloud.com/help/en/cloud-enterprise-network/latest/api-cbn-2017-09-12-createcenroutemap).
 * > **NOTE:** Available since v1.82.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const sourceRegion = config.get("sourceRegion") || "cn-hangzhou";
 * const destinationRegion = config.get("destinationRegion") || "cn-shanghai";
 * const exampleHz = new alicloud.vpc.Network("example_hz", {
 *     vpcName: "tf_example",
 *     cidrBlock: "192.168.0.0/16",
 * });
 * const exampleSh = new alicloud.vpc.Network("example_sh", {
 *     vpcName: "tf_example",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const example = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleHzInstanceAttachment = new alicloud.cen.InstanceAttachment("example_hz", {
 *     instanceId: example.id,
 *     childInstanceId: exampleHz.id,
 *     childInstanceType: "VPC",
 *     childInstanceRegionId: sourceRegion,
 * });
 * const exampleShInstanceAttachment = new alicloud.cen.InstanceAttachment("example_sh", {
 *     instanceId: example.id,
 *     childInstanceId: exampleSh.id,
 *     childInstanceType: "VPC",
 *     childInstanceRegionId: destinationRegion,
 * });
 * const _default = new alicloud.cen.RouteMap("default", {
 *     cenRegionId: sourceRegion,
 *     cenId: example.id,
 *     description: "tf_example",
 *     priority: 1,
 *     transmitDirection: "RegionIn",
 *     mapResult: "Permit",
 *     nextPriority: 1,
 *     sourceRegionIds: [sourceRegion],
 *     sourceInstanceIds: [exampleHzInstanceAttachment&#46;childInstanceId],
 *     sourceInstanceIdsReverseMatch: false,
 *     destinationInstanceIds: [exampleShInstanceAttachment&#46;childInstanceId],
 *     destinationInstanceIdsReverseMatch: false,
 *     sourceRouteTableIds: [exampleHz&#46;routeTableId],
 *     destinationRouteTableIds: [exampleSh&#46;routeTableId],
 *     sourceChildInstanceTypes: ["VPC"],
 *     destinationChildInstanceTypes: ["VPC"],
 *     destinationCidrBlocks: [exampleSh&#46;cidrBlock],
 *     cidrMatchMode: "Include",
 *     routeTypes: ["System"],
 *     matchAsns: ["65501"],
 *     asPathMatchMode: "Include",
 *     matchCommunitySets: ["65501:1"],
 *     communityMatchMode: "Include",
 *     communityOperateMode: "Additive",
 *     operateCommunitySets: ["65501:1"],
 *     preference: 20,
 *     prependAsPaths: ["65501"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * source_region = config.get("sourceRegion")
 * if source_region is None:
 *     source_region = "cn-hangzhou"
 * destination_region = config.get("destinationRegion")
 * if destination_region is None:
 *     destination_region = "cn-shanghai"
 * example_hz = alicloud.vpc.Network("example_hz",
 *     vpc_name="tf_example",
 *     cidr_block="192.168.0.0/16")
 * example_sh = alicloud.vpc.Network("example_sh",
 *     vpc_name="tf_example",
 *     cidr_block="172.16.0.0/12")
 * example = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_hz_instance_attachment = alicloud.cen.InstanceAttachment("example_hz",
 *     instance_id=example.id,
 *     child_instance_id=example_hz.id,
 *     child_instance_type="VPC",
 *     child_instance_region_id=source_region)
 * example_sh_instance_attachment = alicloud.cen.InstanceAttachment("example_sh",
 *     instance_id=example.id,
 *     child_instance_id=example_sh.id,
 *     child_instance_type="VPC",
 *     child_instance_region_id=destination_region)
 * default = alicloud.cen.RouteMap("default",
 *     cen_region_id=source_region,
 *     cen_id=example.id,
 *     description="tf_example",
 *     priority=1,
 *     transmit_direction="RegionIn",
 *     map_result="Permit",
 *     next_priority=1,
 *     source_region_ids=[source_region],
 *     source_instance_ids=[example_hz_instance_attachment&#46;child_instance_id],
 *     source_instance_ids_reverse_match=False,
 *     destination_instance_ids=[example_sh_instance_attachment&#46;child_instance_id],
 *     destination_instance_ids_reverse_match=False,
 *     source_route_table_ids=[example_hz&#46;route_table_id],
 *     destination_route_table_ids=[example_sh&#46;route_table_id],
 *     source_child_instance_types=["VPC"],
 *     destination_child_instance_types=["VPC"],
 *     destination_cidr_blocks=[example_sh&#46;cidr_block],
 *     cidr_match_mode="Include",
 *     route_types=["System"],
 *     match_asns=["65501"],
 *     as_path_match_mode="Include",
 *     match_community_sets=["65501:1"],
 *     community_match_mode="Include",
 *     community_operate_mode="Additive",
 *     operate_community_sets=["65501:1"],
 *     preference=20,
 *     prepend_as_paths=["65501"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var sourceRegion = config.Get("sourceRegion") ?? "cn-hangzhou";
 *     var destinationRegion = config.Get("destinationRegion") ?? "cn-shanghai";
 *     var exampleHz = new AliCloud.Vpc.Network("example_hz", new()
 *     {
 *         VpcName = "tf_example",
 *         CidrBlock = "192.168.0.0/16",
 *     });
 *     var exampleSh = new AliCloud.Vpc.Network("example_sh", new()
 *     {
 *         VpcName = "tf_example",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var example = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleHzInstanceAttachment = new AliCloud.Cen.InstanceAttachment("example_hz", new()
 *     {
 *         InstanceId = example.Id,
 *         ChildInstanceId = exampleHz.Id,
 *         ChildInstanceType = "VPC",
 *         ChildInstanceRegionId = sourceRegion,
 *     });
 *     var exampleShInstanceAttachment = new AliCloud.Cen.InstanceAttachment("example_sh", new()
 *     {
 *         InstanceId = example.Id,
 *         ChildInstanceId = exampleSh.Id,
 *         ChildInstanceType = "VPC",
 *         ChildInstanceRegionId = destinationRegion,
 *     });
 *     var @default = new AliCloud.Cen.RouteMap("default", new()
 *     {
 *         CenRegionId = sourceRegion,
 *         CenId = example.Id,
 *         Description = "tf_example",
 *         Priority = 1,
 *         TransmitDirection = "RegionIn",
 *         MapResult = "Permit",
 *         NextPriority = 1,
 *         SourceRegionIds = new[]
 *         {
 *             sourceRegion,
 *         },
 *         SourceInstanceIds = new[]
 *         {
 *             exampleHzInstanceAttachment.ChildInstanceId,
 *         },
 *         SourceInstanceIdsReverseMatch = false,
 *         DestinationInstanceIds = new[]
 *         {
 *             exampleShInstanceAttachment.ChildInstanceId,
 *         },
 *         DestinationInstanceIdsReverseMatch = false,
 *         SourceRouteTableIds = new[]
 *         {
 *             exampleHz.RouteTableId,
 *         },
 *         DestinationRouteTableIds = new[]
 *         {
 *             exampleSh.RouteTableId,
 *         },
 *         SourceChildInstanceTypes = new[]
 *         {
 *             "VPC",
 *         },
 *         DestinationChildInstanceTypes = new[]
 *         {
 *             "VPC",
 *         },
 *         DestinationCidrBlocks = new[]
 *         {
 *             exampleSh.CidrBlock,
 *         },
 *         CidrMatchMode = "Include",
 *         RouteTypes = new[]
 *         {
 *             "System",
 *         },
 *         MatchAsns = new[]
 *         {
 *             "65501",
 *         },
 *         AsPathMatchMode = "Include",
 *         MatchCommunitySets = new[]
 *         {
 *             "65501:1",
 *         },
 *         CommunityMatchMode = "Include",
 *         CommunityOperateMode = "Additive",
 *         OperateCommunitySets = new[]
 *         {
 *             "65501:1",
 *         },
 *         Preference = 20,
 *         PrependAsPaths = new[]
 *         {
 *             "65501",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		sourceRegion := "cn-hangzhou"
 * 		if param := cfg.Get("sourceRegion"); param != "" {
 * 			sourceRegion = param
 * 		}
 * 		destinationRegion := "cn-shanghai"
 * 		if param := cfg.Get("destinationRegion"); param != "" {
 * 			destinationRegion = param
 * 		}
 * 		exampleHz, err := vpc.NewNetwork(ctx, "example_hz", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("tf_example"),
 * 			CidrBlock: pulumi.String("192.168.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSh, err := vpc.NewNetwork(ctx, "example_sh", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("tf_example"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleHzInstanceAttachment, err := cen.NewInstanceAttachment(ctx, "example_hz", &cen.InstanceAttachmentArgs{
 * 			InstanceId:            example.ID(),
 * 			ChildInstanceId:       exampleHz.ID(),
 * 			ChildInstanceType:     pulumi.String("VPC"),
 * 			ChildInstanceRegionId: pulumi.String(sourceRegion),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleShInstanceAttachment, err := cen.NewInstanceAttachment(ctx, "example_sh", &cen.InstanceAttachmentArgs{
 * 			InstanceId:            example.ID(),
 * 			ChildInstanceId:       exampleSh.ID(),
 * 			ChildInstanceType:     pulumi.String("VPC"),
 * 			ChildInstanceRegionId: pulumi.String(destinationRegion),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewRouteMap(ctx, "default", &cen.RouteMapArgs{
 * 			CenRegionId:       pulumi.String(sourceRegion),
 * 			CenId:             example.ID(),
 * 			Description:       pulumi.String("tf_example"),
 * 			Priority:          pulumi.Int(1),
 * 			TransmitDirection: pulumi.String("RegionIn"),
 * 			MapResult:         pulumi.String("Permit"),
 * 			NextPriority:      pulumi.Int(1),
 * 			SourceRegionIds: pulumi.StringArray{
 * 				pulumi.String(sourceRegion),
 * 			},
 * 			SourceInstanceIds: pulumi.StringArray{
 * 				exampleHzInstanceAttachment.ChildInstanceId,
 * 			},
 * 			SourceInstanceIdsReverseMatch: pulumi.Bool(false),
 * 			DestinationInstanceIds: pulumi.StringArray{
 * 				exampleShInstanceAttachment.ChildInstanceId,
 * 			},
 * 			DestinationInstanceIdsReverseMatch: pulumi.Bool(false),
 * 			SourceRouteTableIds: pulumi.StringArray{
 * 				exampleHz.RouteTableId,
 * 			},
 * 			DestinationRouteTableIds: pulumi.StringArray{
 * 				exampleSh.RouteTableId,
 * 			},
 * 			SourceChildInstanceTypes: pulumi.StringArray{
 * 				pulumi.String("VPC"),
 * 			},
 * 			DestinationChildInstanceTypes: pulumi.StringArray{
 * 				pulumi.String("VPC"),
 * 			},
 * 			DestinationCidrBlocks: pulumi.StringArray{
 * 				exampleSh.CidrBlock,
 * 			},
 * 			CidrMatchMode: pulumi.String("Include"),
 * 			RouteTypes: pulumi.StringArray{
 * 				pulumi.String("System"),
 * 			},
 * 			MatchAsns: pulumi.StringArray{
 * 				pulumi.String("65501"),
 * 			},
 * 			AsPathMatchMode: pulumi.String("Include"),
 * 			MatchCommunitySets: pulumi.StringArray{
 * 				pulumi.String("65501:1"),
 * 			},
 * 			CommunityMatchMode:   pulumi.String("Include"),
 * 			CommunityOperateMode: pulumi.String("Additive"),
 * 			OperateCommunitySets: pulumi.StringArray{
 * 				pulumi.String("65501:1"),
 * 			},
 * 			Preference: pulumi.Int(20),
 * 			PrependAsPaths: pulumi.StringArray{
 * 				pulumi.String("65501"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.InstanceAttachment;
 * import com.pulumi.alicloud.cen.InstanceAttachmentArgs;
 * import com.pulumi.alicloud.cen.RouteMap;
 * import com.pulumi.alicloud.cen.RouteMapArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var sourceRegion = config.get("sourceRegion").orElse("cn-hangzhou");
 *         final var destinationRegion = config.get("destinationRegion").orElse("cn-shanghai");
 *         var exampleHz = new Network("exampleHz", NetworkArgs.builder()
 *             .vpcName("tf_example")
 *             .cidrBlock("192.168.0.0/16")
 *             .build());
 *         var exampleSh = new Network("exampleSh", NetworkArgs.builder()
 *             .vpcName("tf_example")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleHzInstanceAttachment = new InstanceAttachment("exampleHzInstanceAttachment", InstanceAttachmentArgs.builder()
 *             .instanceId(example.id())
 *             .childInstanceId(exampleHz.id())
 *             .childInstanceType("VPC")
 *             .childInstanceRegionId(sourceRegion)
 *             .build());
 *         var exampleShInstanceAttachment = new InstanceAttachment("exampleShInstanceAttachment", InstanceAttachmentArgs.builder()
 *             .instanceId(example.id())
 *             .childInstanceId(exampleSh.id())
 *             .childInstanceType("VPC")
 *             .childInstanceRegionId(destinationRegion)
 *             .build());
 *         var default_ = new RouteMap("default", RouteMapArgs.builder()
 *             .cenRegionId(sourceRegion)
 *             .cenId(example.id())
 *             .description("tf_example")
 *             .priority("1")
 *             .transmitDirection("RegionIn")
 *             .mapResult("Permit")
 *             .nextPriority("1")
 *             .sourceRegionIds(sourceRegion)
 *             .sourceInstanceIds(exampleHzInstanceAttachment.childInstanceId())
 *             .sourceInstanceIdsReverseMatch("false")
 *             .destinationInstanceIds(exampleShInstanceAttachment.childInstanceId())
 *             .destinationInstanceIdsReverseMatch("false")
 *             .sourceRouteTableIds(exampleHz.routeTableId())
 *             .destinationRouteTableIds(exampleSh.routeTableId())
 *             .sourceChildInstanceTypes("VPC")
 *             .destinationChildInstanceTypes("VPC")
 *             .destinationCidrBlocks(exampleSh.cidrBlock())
 *             .cidrMatchMode("Include")
 *             .routeTypes("System")
 *             .matchAsns("65501")
 *             .asPathMatchMode("Include")
 *             .matchCommunitySets("65501:1")
 *             .communityMatchMode("Include")
 *             .communityOperateMode("Additive")
 *             .operateCommunitySets("65501:1")
 *             .preference("20")
 *             .prependAsPaths("65501")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   sourceRegion:
 *     type: string
 *     default: cn-hangzhou
 *   destinationRegion:
 *     type: string
 *     default: cn-shanghai
 * resources:
 *   exampleHz:
 *     type: alicloud:vpc:Network
 *     name: example_hz
 *     properties:
 *       vpcName: tf_example
 *       cidrBlock: 192.168.0.0/16
 *   exampleSh:
 *     type: alicloud:vpc:Network
 *     name: example_sh
 *     properties:
 *       vpcName: tf_example
 *       cidrBlock: 172.16.0.0/12
 *   example:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleHzInstanceAttachment:
 *     type: alicloud:cen:InstanceAttachment
 *     name: example_hz
 *     properties:
 *       instanceId: ${example.id}
 *       childInstanceId: ${exampleHz.id}
 *       childInstanceType: VPC
 *       childInstanceRegionId: ${sourceRegion}
 *   exampleShInstanceAttachment:
 *     type: alicloud:cen:InstanceAttachment
 *     name: example_sh
 *     properties:
 *       instanceId: ${example.id}
 *       childInstanceId: ${exampleSh.id}
 *       childInstanceType: VPC
 *       childInstanceRegionId: ${destinationRegion}
 *   default:
 *     type: alicloud:cen:RouteMap
 *     properties:
 *       cenRegionId: ${sourceRegion}
 *       cenId: ${example.id}
 *       description: tf_example
 *       priority: '1'
 *       transmitDirection: RegionIn
 *       mapResult: Permit
 *       nextPriority: '1'
 *       sourceRegionIds:
 *         - ${sourceRegion}
 *       sourceInstanceIds:
 *         - ${exampleHzInstanceAttachment.childInstanceId}
 *       sourceInstanceIdsReverseMatch: 'false'
 *       destinationInstanceIds:
 *         - ${exampleShInstanceAttachment.childInstanceId}
 *       destinationInstanceIdsReverseMatch: 'false'
 *       sourceRouteTableIds:
 *         - ${exampleHz.routeTableId}
 *       destinationRouteTableIds:
 *         - ${exampleSh.routeTableId}
 *       sourceChildInstanceTypes:
 *         - VPC
 *       destinationChildInstanceTypes:
 *         - VPC
 *       destinationCidrBlocks:
 *         - ${exampleSh.cidrBlock}
 *       cidrMatchMode: Include
 *       routeTypes:
 *         - System
 *       matchAsns:
 *         - '65501'
 *       asPathMatchMode: Include
 *       matchCommunitySets:
 *         - 65501:1
 *       communityMatchMode: Include
 *       communityOperateMode: Additive
 *       operateCommunitySets:
 *         - 65501:1
 *       preference: '20'
 *       prependAsPaths:
 *         - '65501'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN RouteMap can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/routeMap:RouteMap default <cen_id>:<route_map_id>.
 * ```
 */
public class RouteMap internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.RouteMap,
) : KotlinCustomResource(javaResource, RouteMapMapper) {
    /**
     * A match statement. It indicates the mode in which the AS path attribute is matched. Valid values: ["Include", "Complete"].
     */
    public val asPathMatchMode: Output<String>?
        get() = javaResource.asPathMatchMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the CEN instance.
     */
    public val cenId: Output<String>
        get() = javaResource.cenId().applyValue({ args0 -> args0 })

    /**
     * The ID of the region to which the CEN instance belongs.
     */
    public val cenRegionId: Output<String>
        get() = javaResource.cenRegionId().applyValue({ args0 -> args0 })

    /**
     * A match statement. It indicates the mode in which the prefix attribute is matched. Valid values: ["Include", "Complete"].
     */
    public val cidrMatchMode: Output<String>?
        get() = javaResource.cidrMatchMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A match statement. It indicates the mode in which the community attribute is matched. Valid values: ["Include", "Complete"].
     */
    public val communityMatchMode: Output<String>?
        get() = javaResource.communityMatchMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An action statement. It indicates the mode in which the community attribute is operated. Valid values: ["Additive", "Replace"].
     */
    public val communityOperateMode: Output<String>?
        get() = javaResource.communityOperateMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the route map.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A match statement that indicates the list of destination instance types. Valid values: ["VPC", "VBR", "CCN", "VPN"].
     */
    public val destinationChildInstanceTypes: Output<List<String>>?
        get() = javaResource.destinationChildInstanceTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A match statement that indicates the prefix list. The prefix is in the CIDR format. You can enter a maximum of 32 CIDR blocks.
     */
    public val destinationCidrBlocks: Output<List<String>>?
        get() = javaResource.destinationCidrBlocks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A match statement that indicates the list of IDs of the destination instances.
     */
    public val destinationInstanceIds: Output<List<String>>?
        get() = javaResource.destinationInstanceIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Indicates whether to enable the reverse match method for the DestinationInstanceIds match condition. Valid values: ["false", "true"]. Default to "false".
     */
    public val destinationInstanceIdsReverseMatch: Output<Boolean>?
        get() = javaResource.destinationInstanceIdsReverseMatch().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * A match statement that indicates the list of IDs of the destination route tables. You can enter a maximum of 32 route table IDs.
     */
    public val destinationRouteTableIds: Output<List<String>>?
        get() = javaResource.destinationRouteTableIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The action that is performed to a route if the route matches all the match conditions. Valid values: ["Permit", "Deny"].
     */
    public val mapResult: Output<String>
        get() = javaResource.mapResult().applyValue({ args0 -> args0 })

    /**
     * A match statement that indicates the AS path list. The AS path is a well-known mandatory attribute, which describes the numbers of the ASs that a BGP route passes through during transmission.
     */
    public val matchAsns: Output<List<String>>?
        get() = javaResource.matchAsns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * A match statement that indicates the community set. The format of each community is nn:nn, which ranges from 1 to 65535. You can enter a maximum of 32 communities. Communities must comply with RFC 1997. Large communities (RFC 8092) are not supported.
     */
    public val matchCommunitySets: Output<List<String>>?
        get() = javaResource.matchCommunitySets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The priority of the next route map that is associated with the current route map. Value range: 1 to 100.
     */
    public val nextPriority: Output<Int>?
        get() = javaResource.nextPriority().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An action statement that operates the community attribute. The format of each community is nn:nn, which ranges from 1 to 65535. You can enter a maximum of 32 communities. Communities must comply with RFC 1997. Large communities (RFC 8092) are not supported.
     */
    public val operateCommunitySets: Output<List<String>>?
        get() = javaResource.operateCommunitySets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * An action statement that modifies the priority of the route. Value range: 1 to 100. The default priority of a route is 50. A lower value indicates a higher preference.
     */
    public val preference: Output<Int>?
        get() = javaResource.preference().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An action statement that indicates an AS path is prepended when the regional gateway receives or advertises a route.
     */
    public val prependAsPaths: Output<List<String>>?
        get() = javaResource.prependAsPaths().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The priority of the route map. Value range: 1 to 100. A lower value indicates a higher priority.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * ID of the RouteMap. It is available in 1.161.0+.
     */
    public val routeMapId: Output<String>
        get() = javaResource.routeMapId().applyValue({ args0 -> args0 })

    /**
     * A match statement that indicates the list of route types. Valid values: ["System", "Custom", "BGP"].
     */
    public val routeTypes: Output<List<String>>?
        get() = javaResource.routeTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * A match statement that indicates the list of source instance types. Valid values: ["VPC", "VBR", "CCN"].
     */
    public val sourceChildInstanceTypes: Output<List<String>>?
        get() = javaResource.sourceChildInstanceTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A match statement that indicates the list of IDs of the source instances.
     */
    public val sourceInstanceIds: Output<List<String>>?
        get() = javaResource.sourceInstanceIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Indicates whether to enable the reverse match method for the SourceInstanceIds match condition. Valid values: ["false", "true"]. Default to "false".
     */
    public val sourceInstanceIdsReverseMatch: Output<Boolean>?
        get() = javaResource.sourceInstanceIdsReverseMatch().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A match statement that indicates the list of IDs of the source regions. You can enter a maximum of 32 region IDs.
     */
    public val sourceRegionIds: Output<List<String>>?
        get() = javaResource.sourceRegionIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A match statement that indicates the list of IDs of the source route tables. You can enter a maximum of 32 route table IDs.
     */
    public val sourceRouteTableIds: Output<List<String>>?
        get() = javaResource.sourceRouteTableIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * (Computed) The status of route map. Valid values: ["Creating", "Active", "Deleting"].
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The routing table ID of the forwarding router. If you do not enter the routing table ID, the routing policy is automatically associated with the default routing table of the forwarding router.
     */
    public val transitRouterRouteTableId: Output<String>
        get() = javaResource.transitRouterRouteTableId().applyValue({ args0 -> args0 })

    /**
     * The direction in which the route map is applied. Valid values: ["RegionIn", "RegionOut"].
     */
    public val transmitDirection: Output<String>
        get() = javaResource.transmitDirection().applyValue({ args0 -> args0 })
}

public object RouteMapMapper : ResourceMapper<RouteMap> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.RouteMap::class == javaResource::class

    override fun map(javaResource: Resource): RouteMap = RouteMap(
        javaResource as
            com.pulumi.alicloud.cen.RouteMap,
    )
}

/**
 * @see [RouteMap].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouteMap].
 */
public suspend fun routeMap(name: String, block: suspend RouteMapResourceBuilder.() -> Unit): RouteMap {
    val builder = RouteMapResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouteMap].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routeMap(name: String): RouteMap {
    val builder = RouteMapResourceBuilder()
    builder.name(name)
    return builder.build()
}
