@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TrafficMarkingPolicy].
 */
@PulumiTagMarker
public class TrafficMarkingPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrafficMarkingPolicyArgs = TrafficMarkingPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrafficMarkingPolicyArgsBuilder.() -> Unit) {
        val builder = TrafficMarkingPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TrafficMarkingPolicy {
        val builtJavaResource = com.pulumi.alicloud.cen.TrafficMarkingPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrafficMarkingPolicy(builtJavaResource)
    }
}

/**
 * Provides a Cloud Enterprise Network (CEN) Traffic Marking Policy resource.
 * For information about Cloud Enterprise Network (CEN) Traffic Marking Policy and how to use it, see [What is Traffic Marking Policy](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtrafficmarkingpolicy).
 * > **NOTE:** Available since v1.173.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleTransitRouter = new alicloud.cen.TransitRouter("example", {
 *     transitRouterName: "tf_example",
 *     cenId: example.id,
 * });
 * const exampleTrafficMarkingPolicy = new alicloud.cen.TrafficMarkingPolicy("example", {
 *     markingDscp: 1,
 *     priority: 1,
 *     trafficMarkingPolicyName: "tf_example",
 *     transitRouterId: exampleTransitRouter.transitRouterId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_transit_router = alicloud.cen.TransitRouter("example",
 *     transit_router_name="tf_example",
 *     cen_id=example.id)
 * example_traffic_marking_policy = alicloud.cen.TrafficMarkingPolicy("example",
 *     marking_dscp=1,
 *     priority=1,
 *     traffic_marking_policy_name="tf_example",
 *     transit_router_id=example_transit_router.transit_router_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleTransitRouter = new AliCloud.Cen.TransitRouter("example", new()
 *     {
 *         TransitRouterName = "tf_example",
 *         CenId = example.Id,
 *     });
 *     var exampleTrafficMarkingPolicy = new AliCloud.Cen.TrafficMarkingPolicy("example", new()
 *     {
 *         MarkingDscp = 1,
 *         Priority = 1,
 *         TrafficMarkingPolicyName = "tf_example",
 *         TransitRouterId = exampleTransitRouter.TransitRouterId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouter, err := cen.NewTransitRouter(ctx, "example", &cen.TransitRouterArgs{
 * 			TransitRouterName: pulumi.String("tf_example"),
 * 			CenId:             example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTrafficMarkingPolicy(ctx, "example", &cen.TrafficMarkingPolicyArgs{
 * 			MarkingDscp:              pulumi.Int(1),
 * 			Priority:                 pulumi.Int(1),
 * 			TrafficMarkingPolicyName: pulumi.String("tf_example"),
 * 			TransitRouterId:          exampleTransitRouter.TransitRouterId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.TrafficMarkingPolicy;
 * import com.pulumi.alicloud.cen.TrafficMarkingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleTransitRouter = new TransitRouter("exampleTransitRouter", TransitRouterArgs.builder()
 *             .transitRouterName("tf_example")
 *             .cenId(example.id())
 *             .build());
 *         var exampleTrafficMarkingPolicy = new TrafficMarkingPolicy("exampleTrafficMarkingPolicy", TrafficMarkingPolicyArgs.builder()
 *             .markingDscp(1)
 *             .priority(1)
 *             .trafficMarkingPolicyName("tf_example")
 *             .transitRouterId(exampleTransitRouter.transitRouterId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: example
 *     properties:
 *       transitRouterName: tf_example
 *       cenId: ${example.id}
 *   exampleTrafficMarkingPolicy:
 *     type: alicloud:cen:TrafficMarkingPolicy
 *     name: example
 *     properties:
 *       markingDscp: 1
 *       priority: 1
 *       trafficMarkingPolicyName: tf_example
 *       transitRouterId: ${exampleTransitRouter.transitRouterId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Enterprise Network (CEN) Traffic Marking Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/trafficMarkingPolicy:TrafficMarkingPolicy example <transit_router_id>:<traffic_marking_policy_id>
 * ```
 */
public class TrafficMarkingPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.TrafficMarkingPolicy,
) : KotlinCustomResource(javaResource, TrafficMarkingPolicyMapper) {
    /**
     * The description of the Traffic Marking Policy. The description must be 2 to 128 characters in length, and must start with a letter. It can contain digits, underscores (_), and hyphens (-).
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The dry run.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The DSCP(Differentiated Services Code Point) of the Traffic Marking Policy. Value range: 0~63.
     */
    public val markingDscp: Output<Int>
        get() = javaResource.markingDscp().applyValue({ args0 -> args0 })

    /**
     * The Priority of the Traffic Marking Policy. Value range: 1~100.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of the Traffic Marking Policy.
     */
    public val trafficMarkingPolicyId: Output<String>
        get() = javaResource.trafficMarkingPolicyId().applyValue({ args0 -> args0 })

    /**
     * The name of the Traffic Marking Policy. The name must be 2 to 128 characters in length, and must start with a letter. It can contain digits, underscores (_), and hyphens (-).
     */
    public val trafficMarkingPolicyName: Output<String>?
        get() = javaResource.trafficMarkingPolicyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the transit router.
     */
    public val transitRouterId: Output<String>
        get() = javaResource.transitRouterId().applyValue({ args0 -> args0 })
}

public object TrafficMarkingPolicyMapper : ResourceMapper<TrafficMarkingPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.TrafficMarkingPolicy::class == javaResource::class

    override fun map(javaResource: Resource): TrafficMarkingPolicy = TrafficMarkingPolicy(
        javaResource
            as com.pulumi.alicloud.cen.TrafficMarkingPolicy,
    )
}

/**
 * @see [TrafficMarkingPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrafficMarkingPolicy].
 */
public suspend fun trafficMarkingPolicy(
    name: String,
    block: suspend TrafficMarkingPolicyResourceBuilder.() -> Unit,
): TrafficMarkingPolicy {
    val builder = TrafficMarkingPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrafficMarkingPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trafficMarkingPolicy(name: String): TrafficMarkingPolicy {
    val builder = TrafficMarkingPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
