@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.TrafficMarkingPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Enterprise Network (CEN) Traffic Marking Policy resource.
 * For information about Cloud Enterprise Network (CEN) Traffic Marking Policy and how to use it, see [What is Traffic Marking Policy](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtrafficmarkingpolicy).
 * > **NOTE:** Available since v1.173.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleTransitRouter = new alicloud.cen.TransitRouter("example", {
 *     transitRouterName: "tf_example",
 *     cenId: example.id,
 * });
 * const exampleTrafficMarkingPolicy = new alicloud.cen.TrafficMarkingPolicy("example", {
 *     markingDscp: 1,
 *     priority: 1,
 *     trafficMarkingPolicyName: "tf_example",
 *     transitRouterId: exampleTransitRouter.transitRouterId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_transit_router = alicloud.cen.TransitRouter("example",
 *     transit_router_name="tf_example",
 *     cen_id=example.id)
 * example_traffic_marking_policy = alicloud.cen.TrafficMarkingPolicy("example",
 *     marking_dscp=1,
 *     priority=1,
 *     traffic_marking_policy_name="tf_example",
 *     transit_router_id=example_transit_router.transit_router_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleTransitRouter = new AliCloud.Cen.TransitRouter("example", new()
 *     {
 *         TransitRouterName = "tf_example",
 *         CenId = example.Id,
 *     });
 *     var exampleTrafficMarkingPolicy = new AliCloud.Cen.TrafficMarkingPolicy("example", new()
 *     {
 *         MarkingDscp = 1,
 *         Priority = 1,
 *         TrafficMarkingPolicyName = "tf_example",
 *         TransitRouterId = exampleTransitRouter.TransitRouterId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouter, err := cen.NewTransitRouter(ctx, "example", &cen.TransitRouterArgs{
 * 			TransitRouterName: pulumi.String("tf_example"),
 * 			CenId:             example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTrafficMarkingPolicy(ctx, "example", &cen.TrafficMarkingPolicyArgs{
 * 			MarkingDscp:              pulumi.Int(1),
 * 			Priority:                 pulumi.Int(1),
 * 			TrafficMarkingPolicyName: pulumi.String("tf_example"),
 * 			TransitRouterId:          exampleTransitRouter.TransitRouterId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.TrafficMarkingPolicy;
 * import com.pulumi.alicloud.cen.TrafficMarkingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleTransitRouter = new TransitRouter("exampleTransitRouter", TransitRouterArgs.builder()
 *             .transitRouterName("tf_example")
 *             .cenId(example.id())
 *             .build());
 *         var exampleTrafficMarkingPolicy = new TrafficMarkingPolicy("exampleTrafficMarkingPolicy", TrafficMarkingPolicyArgs.builder()
 *             .markingDscp(1)
 *             .priority(1)
 *             .trafficMarkingPolicyName("tf_example")
 *             .transitRouterId(exampleTransitRouter.transitRouterId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: example
 *     properties:
 *       transitRouterName: tf_example
 *       cenId: ${example.id}
 *   exampleTrafficMarkingPolicy:
 *     type: alicloud:cen:TrafficMarkingPolicy
 *     name: example
 *     properties:
 *       markingDscp: 1
 *       priority: 1
 *       trafficMarkingPolicyName: tf_example
 *       transitRouterId: ${exampleTransitRouter.transitRouterId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Enterprise Network (CEN) Traffic Marking Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/trafficMarkingPolicy:TrafficMarkingPolicy example <transit_router_id>:<traffic_marking_policy_id>
 * ```
 * @property description The description of the Traffic Marking Policy. The description must be 2 to 128 characters in length, and must start with a letter. It can contain digits, underscores (_), and hyphens (-).
 * @property dryRun The dry run.
 * @property markingDscp The DSCP(Differentiated Services Code Point) of the Traffic Marking Policy. Value range: 0~63.
 * @property priority The Priority of the Traffic Marking Policy. Value range: 1~100.
 * @property trafficMarkingPolicyName The name of the Traffic Marking Policy. The name must be 2 to 128 characters in length, and must start with a letter. It can contain digits, underscores (_), and hyphens (-).
 * @property transitRouterId The ID of the transit router.
 */
public data class TrafficMarkingPolicyArgs(
    public val description: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val markingDscp: Output<Int>? = null,
    public val priority: Output<Int>? = null,
    public val trafficMarkingPolicyName: Output<String>? = null,
    public val transitRouterId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.TrafficMarkingPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.TrafficMarkingPolicyArgs =
        com.pulumi.alicloud.cen.TrafficMarkingPolicyArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .markingDscp(markingDscp?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .trafficMarkingPolicyName(trafficMarkingPolicyName?.applyValue({ args0 -> args0 }))
            .transitRouterId(transitRouterId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficMarkingPolicyArgs].
 */
@PulumiTagMarker
public class TrafficMarkingPolicyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var markingDscp: Output<Int>? = null

    private var priority: Output<Int>? = null

    private var trafficMarkingPolicyName: Output<String>? = null

    private var transitRouterId: Output<String>? = null

    /**
     * @param value The description of the Traffic Marking Policy. The description must be 2 to 128 characters in length, and must start with a letter. It can contain digits, underscores (_), and hyphens (-).
     */
    @JvmName("djiuxhbnesopupqt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The dry run.
     */
    @JvmName("wuscaeuxpkoigatp")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The DSCP(Differentiated Services Code Point) of the Traffic Marking Policy. Value range: 0~63.
     */
    @JvmName("bbymnmmswkepeicq")
    public suspend fun markingDscp(`value`: Output<Int>) {
        this.markingDscp = value
    }

    /**
     * @param value The Priority of the Traffic Marking Policy. Value range: 1~100.
     */
    @JvmName("ptiiqajbxrwoohbr")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The name of the Traffic Marking Policy. The name must be 2 to 128 characters in length, and must start with a letter. It can contain digits, underscores (_), and hyphens (-).
     */
    @JvmName("sjppbjjoaqtcyhdb")
    public suspend fun trafficMarkingPolicyName(`value`: Output<String>) {
        this.trafficMarkingPolicyName = value
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("jgstikxoobfhujvj")
    public suspend fun transitRouterId(`value`: Output<String>) {
        this.transitRouterId = value
    }

    /**
     * @param value The description of the Traffic Marking Policy. The description must be 2 to 128 characters in length, and must start with a letter. It can contain digits, underscores (_), and hyphens (-).
     */
    @JvmName("abyqnkhskuhypngm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The dry run.
     */
    @JvmName("qjscmgrwslekwvre")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The DSCP(Differentiated Services Code Point) of the Traffic Marking Policy. Value range: 0~63.
     */
    @JvmName("bscgqwdtjfkcwoqj")
    public suspend fun markingDscp(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.markingDscp = mapped
    }

    /**
     * @param value The Priority of the Traffic Marking Policy. Value range: 1~100.
     */
    @JvmName("joocdhnserbcejth")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The name of the Traffic Marking Policy. The name must be 2 to 128 characters in length, and must start with a letter. It can contain digits, underscores (_), and hyphens (-).
     */
    @JvmName("crsdhbrbrmmrsack")
    public suspend fun trafficMarkingPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficMarkingPolicyName = mapped
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("wijwpvxqusqgiulh")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterId = mapped
    }

    internal fun build(): TrafficMarkingPolicyArgs = TrafficMarkingPolicyArgs(
        description = description,
        dryRun = dryRun,
        markingDscp = markingDscp,
        priority = priority,
        trafficMarkingPolicyName = trafficMarkingPolicyName,
        transitRouterId = transitRouterId,
    )
}
