@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.TransitRouteTableAggregationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Enterprise Network (CEN) Transit Route Table Aggregation resource.
 * For information about Cloud Enterprise Network (CEN) Transit Route Table Aggregation and how to use it, see [What is Transit Route Table Aggregation](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutetableaggregation).
 * > **NOTE:** Available since v1.202.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleTransitRouter = new alicloud.cen.TransitRouter("example", {
 *     transitRouterName: "tf_example",
 *     cenId: example.id,
 * });
 * const exampleTransitRouterRouteTable = new alicloud.cen.TransitRouterRouteTable("example", {transitRouterId: exampleTransitRouter.transitRouterId});
 * const exampleTransitRouteTableAggregation = new alicloud.cen.TransitRouteTableAggregation("example", {
 *     transitRouteTableId: exampleTransitRouterRouteTable.transitRouterRouteTableId,
 *     transitRouteTableAggregationCidr: "10.0.0.0/8",
 *     transitRouteTableAggregationScope: "VPC",
 *     transitRouteTableAggregationName: "tf_example",
 *     transitRouteTableAggregationDescription: "tf_example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_transit_router = alicloud.cen.TransitRouter("example",
 *     transit_router_name="tf_example",
 *     cen_id=example.id)
 * example_transit_router_route_table = alicloud.cen.TransitRouterRouteTable("example", transit_router_id=example_transit_router.transit_router_id)
 * example_transit_route_table_aggregation = alicloud.cen.TransitRouteTableAggregation("example",
 *     transit_route_table_id=example_transit_router_route_table.transit_router_route_table_id,
 *     transit_route_table_aggregation_cidr="10.0.0.0/8",
 *     transit_route_table_aggregation_scope="VPC",
 *     transit_route_table_aggregation_name="tf_example",
 *     transit_route_table_aggregation_description="tf_example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleTransitRouter = new AliCloud.Cen.TransitRouter("example", new()
 *     {
 *         TransitRouterName = "tf_example",
 *         CenId = example.Id,
 *     });
 *     var exampleTransitRouterRouteTable = new AliCloud.Cen.TransitRouterRouteTable("example", new()
 *     {
 *         TransitRouterId = exampleTransitRouter.TransitRouterId,
 *     });
 *     var exampleTransitRouteTableAggregation = new AliCloud.Cen.TransitRouteTableAggregation("example", new()
 *     {
 *         TransitRouteTableId = exampleTransitRouterRouteTable.TransitRouterRouteTableId,
 *         TransitRouteTableAggregationCidr = "10.0.0.0/8",
 *         TransitRouteTableAggregationScope = "VPC",
 *         TransitRouteTableAggregationName = "tf_example",
 *         TransitRouteTableAggregationDescription = "tf_example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouter, err := cen.NewTransitRouter(ctx, "example", &cen.TransitRouterArgs{
 * 			TransitRouterName: pulumi.String("tf_example"),
 * 			CenId:             example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouterRouteTable, err := cen.NewTransitRouterRouteTable(ctx, "example", &cen.TransitRouterRouteTableArgs{
 * 			TransitRouterId: exampleTransitRouter.TransitRouterId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouteTableAggregation(ctx, "example", &cen.TransitRouteTableAggregationArgs{
 * 			TransitRouteTableId:                     exampleTransitRouterRouteTable.TransitRouterRouteTableId,
 * 			TransitRouteTableAggregationCidr:        pulumi.String("10.0.0.0/8"),
 * 			TransitRouteTableAggregationScope:       pulumi.String("VPC"),
 * 			TransitRouteTableAggregationName:        pulumi.String("tf_example"),
 * 			TransitRouteTableAggregationDescription: pulumi.String("tf_example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.TransitRouterRouteTable;
 * import com.pulumi.alicloud.cen.TransitRouterRouteTableArgs;
 * import com.pulumi.alicloud.cen.TransitRouteTableAggregation;
 * import com.pulumi.alicloud.cen.TransitRouteTableAggregationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleTransitRouter = new TransitRouter("exampleTransitRouter", TransitRouterArgs.builder()
 *             .transitRouterName("tf_example")
 *             .cenId(example.id())
 *             .build());
 *         var exampleTransitRouterRouteTable = new TransitRouterRouteTable("exampleTransitRouterRouteTable", TransitRouterRouteTableArgs.builder()
 *             .transitRouterId(exampleTransitRouter.transitRouterId())
 *             .build());
 *         var exampleTransitRouteTableAggregation = new TransitRouteTableAggregation("exampleTransitRouteTableAggregation", TransitRouteTableAggregationArgs.builder()
 *             .transitRouteTableId(exampleTransitRouterRouteTable.transitRouterRouteTableId())
 *             .transitRouteTableAggregationCidr("10.0.0.0/8")
 *             .transitRouteTableAggregationScope("VPC")
 *             .transitRouteTableAggregationName("tf_example")
 *             .transitRouteTableAggregationDescription("tf_example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: example
 *     properties:
 *       transitRouterName: tf_example
 *       cenId: ${example.id}
 *   exampleTransitRouterRouteTable:
 *     type: alicloud:cen:TransitRouterRouteTable
 *     name: example
 *     properties:
 *       transitRouterId: ${exampleTransitRouter.transitRouterId}
 *   exampleTransitRouteTableAggregation:
 *     type: alicloud:cen:TransitRouteTableAggregation
 *     name: example
 *     properties:
 *       transitRouteTableId: ${exampleTransitRouterRouteTable.transitRouterRouteTableId}
 *       transitRouteTableAggregationCidr: 10.0.0.0/8
 *       transitRouteTableAggregationScope: VPC
 *       transitRouteTableAggregationName: tf_example
 *       transitRouteTableAggregationDescription: tf_example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Enterprise Network (CEN) Transit Route Table Aggregation can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouteTableAggregation:TransitRouteTableAggregation example <transit_route_table_id>:<transit_route_table_aggregation_cidr>
 * ```
 * @property transitRouteTableAggregationCidr The destination CIDR block of the aggregate route. CIDR blocks that start with `0` or `100.64`. Multicast CIDR blocks, including `224.0.0.1` to `239.255.255.254`.
 * @property transitRouteTableAggregationDescription The description of the aggregate route.
 * @property transitRouteTableAggregationName The name of the aggregate route.
 * @property transitRouteTableAggregationScope The scope of networks that you want to advertise the aggregate route. Valid Value: `VPC`.
 * @property transitRouteTableId The ID of the route table of the Enterprise Edition transit router.
 */
public data class TransitRouteTableAggregationArgs(
    public val transitRouteTableAggregationCidr: Output<String>? = null,
    public val transitRouteTableAggregationDescription: Output<String>? = null,
    public val transitRouteTableAggregationName: Output<String>? = null,
    public val transitRouteTableAggregationScope: Output<String>? = null,
    public val transitRouteTableId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.TransitRouteTableAggregationArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.TransitRouteTableAggregationArgs =
        com.pulumi.alicloud.cen.TransitRouteTableAggregationArgs.builder()
            .transitRouteTableAggregationCidr(transitRouteTableAggregationCidr?.applyValue({ args0 -> args0 }))
            .transitRouteTableAggregationDescription(
                transitRouteTableAggregationDescription?.applyValue({ args0 ->
                    args0
                }),
            )
            .transitRouteTableAggregationName(transitRouteTableAggregationName?.applyValue({ args0 -> args0 }))
            .transitRouteTableAggregationScope(
                transitRouteTableAggregationScope?.applyValue({ args0 ->
                    args0
                }),
            )
            .transitRouteTableId(transitRouteTableId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitRouteTableAggregationArgs].
 */
@PulumiTagMarker
public class TransitRouteTableAggregationArgsBuilder internal constructor() {
    private var transitRouteTableAggregationCidr: Output<String>? = null

    private var transitRouteTableAggregationDescription: Output<String>? = null

    private var transitRouteTableAggregationName: Output<String>? = null

    private var transitRouteTableAggregationScope: Output<String>? = null

    private var transitRouteTableId: Output<String>? = null

    /**
     * @param value The destination CIDR block of the aggregate route. CIDR blocks that start with `0` or `100.64`. Multicast CIDR blocks, including `224.0.0.1` to `239.255.255.254`.
     */
    @JvmName("dktxbhcisfxovekl")
    public suspend fun transitRouteTableAggregationCidr(`value`: Output<String>) {
        this.transitRouteTableAggregationCidr = value
    }

    /**
     * @param value The description of the aggregate route.
     */
    @JvmName("hbkyfctttcrxosvm")
    public suspend fun transitRouteTableAggregationDescription(`value`: Output<String>) {
        this.transitRouteTableAggregationDescription = value
    }

    /**
     * @param value The name of the aggregate route.
     */
    @JvmName("jnrgjnljcipwrfbm")
    public suspend fun transitRouteTableAggregationName(`value`: Output<String>) {
        this.transitRouteTableAggregationName = value
    }

    /**
     * @param value The scope of networks that you want to advertise the aggregate route. Valid Value: `VPC`.
     */
    @JvmName("jsukebxesagbgwam")
    public suspend fun transitRouteTableAggregationScope(`value`: Output<String>) {
        this.transitRouteTableAggregationScope = value
    }

    /**
     * @param value The ID of the route table of the Enterprise Edition transit router.
     */
    @JvmName("bwwkupjtsyixmbjq")
    public suspend fun transitRouteTableId(`value`: Output<String>) {
        this.transitRouteTableId = value
    }

    /**
     * @param value The destination CIDR block of the aggregate route. CIDR blocks that start with `0` or `100.64`. Multicast CIDR blocks, including `224.0.0.1` to `239.255.255.254`.
     */
    @JvmName("ywqvkvvckwbofrpb")
    public suspend fun transitRouteTableAggregationCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouteTableAggregationCidr = mapped
    }

    /**
     * @param value The description of the aggregate route.
     */
    @JvmName("cmqdffublgeecylt")
    public suspend fun transitRouteTableAggregationDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouteTableAggregationDescription = mapped
    }

    /**
     * @param value The name of the aggregate route.
     */
    @JvmName("lovnvfojrqwnbxcy")
    public suspend fun transitRouteTableAggregationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouteTableAggregationName = mapped
    }

    /**
     * @param value The scope of networks that you want to advertise the aggregate route. Valid Value: `VPC`.
     */
    @JvmName("hjauunihtxusjmak")
    public suspend fun transitRouteTableAggregationScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouteTableAggregationScope = mapped
    }

    /**
     * @param value The ID of the route table of the Enterprise Edition transit router.
     */
    @JvmName("hncasbcxaprkweyn")
    public suspend fun transitRouteTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouteTableId = mapped
    }

    internal fun build(): TransitRouteTableAggregationArgs = TransitRouteTableAggregationArgs(
        transitRouteTableAggregationCidr = transitRouteTableAggregationCidr,
        transitRouteTableAggregationDescription = transitRouteTableAggregationDescription,
        transitRouteTableAggregationName = transitRouteTableAggregationName,
        transitRouteTableAggregationScope = transitRouteTableAggregationScope,
        transitRouteTableId = transitRouteTableId,
    )
}
