@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TransitRouterCidr].
 */
@PulumiTagMarker
public class TransitRouterCidrResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitRouterCidrArgs = TransitRouterCidrArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransitRouterCidrArgsBuilder.() -> Unit) {
        val builder = TransitRouterCidrArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TransitRouterCidr {
        val builtJavaResource = com.pulumi.alicloud.cen.TransitRouterCidr(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TransitRouterCidr(builtJavaResource)
    }
}

/**
 * Provides a Cloud Enterprise Network (CEN) Transit Router Cidr resource.
 * For information about Cloud Enterprise Network (CEN) Transit Router Cidr and how to use it, see [What is Transit Router Cidr](https://www.alibabacloud.com/help/en/cloud-enterprise-network/latest/createtransitroutercidr).
 * > **NOTE:** Available since v1.193.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleTransitRouter = new alicloud.cen.TransitRouter("example", {
 *     transitRouterName: "tf_example",
 *     cenId: example.id,
 * });
 * const exampleTransitRouterCidr = new alicloud.cen.TransitRouterCidr("example", {
 *     transitRouterId: exampleTransitRouter.transitRouterId,
 *     cidr: "192.168.0.0/16",
 *     transitRouterCidrName: "tf_example",
 *     description: "tf_example",
 *     publishCidrRoute: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_transit_router = alicloud.cen.TransitRouter("example",
 *     transit_router_name="tf_example",
 *     cen_id=example.id)
 * example_transit_router_cidr = alicloud.cen.TransitRouterCidr("example",
 *     transit_router_id=example_transit_router.transit_router_id,
 *     cidr="192.168.0.0/16",
 *     transit_router_cidr_name="tf_example",
 *     description="tf_example",
 *     publish_cidr_route=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleTransitRouter = new AliCloud.Cen.TransitRouter("example", new()
 *     {
 *         TransitRouterName = "tf_example",
 *         CenId = example.Id,
 *     });
 *     var exampleTransitRouterCidr = new AliCloud.Cen.TransitRouterCidr("example", new()
 *     {
 *         TransitRouterId = exampleTransitRouter.TransitRouterId,
 *         Cidr = "192.168.0.0/16",
 *         TransitRouterCidrName = "tf_example",
 *         Description = "tf_example",
 *         PublishCidrRoute = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouter, err := cen.NewTransitRouter(ctx, "example", &cen.TransitRouterArgs{
 * 			TransitRouterName: pulumi.String("tf_example"),
 * 			CenId:             example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouterCidr(ctx, "example", &cen.TransitRouterCidrArgs{
 * 			TransitRouterId:       exampleTransitRouter.TransitRouterId,
 * 			Cidr:                  pulumi.String("192.168.0.0/16"),
 * 			TransitRouterCidrName: pulumi.String("tf_example"),
 * 			Description:           pulumi.String("tf_example"),
 * 			PublishCidrRoute:      pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.TransitRouterCidr;
 * import com.pulumi.alicloud.cen.TransitRouterCidrArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleTransitRouter = new TransitRouter("exampleTransitRouter", TransitRouterArgs.builder()
 *             .transitRouterName("tf_example")
 *             .cenId(example.id())
 *             .build());
 *         var exampleTransitRouterCidr = new TransitRouterCidr("exampleTransitRouterCidr", TransitRouterCidrArgs.builder()
 *             .transitRouterId(exampleTransitRouter.transitRouterId())
 *             .cidr("192.168.0.0/16")
 *             .transitRouterCidrName("tf_example")
 *             .description("tf_example")
 *             .publishCidrRoute(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: example
 *     properties:
 *       transitRouterName: tf_example
 *       cenId: ${example.id}
 *   exampleTransitRouterCidr:
 *     type: alicloud:cen:TransitRouterCidr
 *     name: example
 *     properties:
 *       transitRouterId: ${exampleTransitRouter.transitRouterId}
 *       cidr: 192.168.0.0/16
 *       transitRouterCidrName: tf_example
 *       description: tf_example
 *       publishCidrRoute: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Enterprise Network (CEN) Transit Router Cidr can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterCidr:TransitRouterCidr default <transit_router_id>:<transit_router_cidr_id>.
 * ```
 */
public class TransitRouterCidr internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.TransitRouterCidr,
) : KotlinCustomResource(javaResource, TransitRouterCidrMapper) {
    /**
     * The cidr of the transit router.
     */
    public val cidr: Output<String>
        get() = javaResource.cidr().applyValue({ args0 -> args0 })

    /**
     * The description of the transit router. The description must be `2` to `256` characters in length, and it must start with English letters, but cannot start with `http://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to allow automatically adding Transit Router Cidr in Transit Router Route Table. Valid values: `true` and `false`. Default value: `true`.
     */
    public val publishCidrRoute: Output<Boolean>
        get() = javaResource.publishCidrRoute().applyValue({ args0 -> args0 })

    /**
     * The ID of the transit router cidr.
     */
    public val transitRouterCidrId: Output<String>
        get() = javaResource.transitRouterCidrId().applyValue({ args0 -> args0 })

    /**
     * The name of the transit router. The name must be `2` to `128` characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
     */
    public val transitRouterCidrName: Output<String>?
        get() = javaResource.transitRouterCidrName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the transit router.
     */
    public val transitRouterId: Output<String>
        get() = javaResource.transitRouterId().applyValue({ args0 -> args0 })
}

public object TransitRouterCidrMapper : ResourceMapper<TransitRouterCidr> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.TransitRouterCidr::class == javaResource::class

    override fun map(javaResource: Resource): TransitRouterCidr = TransitRouterCidr(
        javaResource as
            com.pulumi.alicloud.cen.TransitRouterCidr,
    )
}

/**
 * @see [TransitRouterCidr].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitRouterCidr].
 */
public suspend fun transitRouterCidr(
    name: String,
    block: suspend TransitRouterCidrResourceBuilder.() -> Unit,
): TransitRouterCidr {
    val builder = TransitRouterCidrResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitRouterCidr].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitRouterCidr(name: String): TransitRouterCidr {
    val builder = TransitRouterCidrResourceBuilder()
    builder.name(name)
    return builder.build()
}
