@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.TransitRouterCidrArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Enterprise Network (CEN) Transit Router Cidr resource.
 * For information about Cloud Enterprise Network (CEN) Transit Router Cidr and how to use it, see [What is Transit Router Cidr](https://www.alibabacloud.com/help/en/cloud-enterprise-network/latest/createtransitroutercidr).
 * > **NOTE:** Available since v1.193.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleTransitRouter = new alicloud.cen.TransitRouter("example", {
 *     transitRouterName: "tf_example",
 *     cenId: example.id,
 * });
 * const exampleTransitRouterCidr = new alicloud.cen.TransitRouterCidr("example", {
 *     transitRouterId: exampleTransitRouter.transitRouterId,
 *     cidr: "192.168.0.0/16",
 *     transitRouterCidrName: "tf_example",
 *     description: "tf_example",
 *     publishCidrRoute: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_transit_router = alicloud.cen.TransitRouter("example",
 *     transit_router_name="tf_example",
 *     cen_id=example.id)
 * example_transit_router_cidr = alicloud.cen.TransitRouterCidr("example",
 *     transit_router_id=example_transit_router.transit_router_id,
 *     cidr="192.168.0.0/16",
 *     transit_router_cidr_name="tf_example",
 *     description="tf_example",
 *     publish_cidr_route=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleTransitRouter = new AliCloud.Cen.TransitRouter("example", new()
 *     {
 *         TransitRouterName = "tf_example",
 *         CenId = example.Id,
 *     });
 *     var exampleTransitRouterCidr = new AliCloud.Cen.TransitRouterCidr("example", new()
 *     {
 *         TransitRouterId = exampleTransitRouter.TransitRouterId,
 *         Cidr = "192.168.0.0/16",
 *         TransitRouterCidrName = "tf_example",
 *         Description = "tf_example",
 *         PublishCidrRoute = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouter, err := cen.NewTransitRouter(ctx, "example", &cen.TransitRouterArgs{
 * 			TransitRouterName: pulumi.String("tf_example"),
 * 			CenId:             example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouterCidr(ctx, "example", &cen.TransitRouterCidrArgs{
 * 			TransitRouterId:       exampleTransitRouter.TransitRouterId,
 * 			Cidr:                  pulumi.String("192.168.0.0/16"),
 * 			TransitRouterCidrName: pulumi.String("tf_example"),
 * 			Description:           pulumi.String("tf_example"),
 * 			PublishCidrRoute:      pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.TransitRouterCidr;
 * import com.pulumi.alicloud.cen.TransitRouterCidrArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleTransitRouter = new TransitRouter("exampleTransitRouter", TransitRouterArgs.builder()
 *             .transitRouterName("tf_example")
 *             .cenId(example.id())
 *             .build());
 *         var exampleTransitRouterCidr = new TransitRouterCidr("exampleTransitRouterCidr", TransitRouterCidrArgs.builder()
 *             .transitRouterId(exampleTransitRouter.transitRouterId())
 *             .cidr("192.168.0.0/16")
 *             .transitRouterCidrName("tf_example")
 *             .description("tf_example")
 *             .publishCidrRoute(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: example
 *     properties:
 *       transitRouterName: tf_example
 *       cenId: ${example.id}
 *   exampleTransitRouterCidr:
 *     type: alicloud:cen:TransitRouterCidr
 *     name: example
 *     properties:
 *       transitRouterId: ${exampleTransitRouter.transitRouterId}
 *       cidr: 192.168.0.0/16
 *       transitRouterCidrName: tf_example
 *       description: tf_example
 *       publishCidrRoute: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Enterprise Network (CEN) Transit Router Cidr can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterCidr:TransitRouterCidr default <transit_router_id>:<transit_router_cidr_id>.
 * ```
 * @property cidr The cidr of the transit router.
 * @property description The description of the transit router. The description must be `2` to `256` characters in length, and it must start with English letters, but cannot start with `http://` or `https://`.
 * @property publishCidrRoute Whether to allow automatically adding Transit Router Cidr in Transit Router Route Table. Valid values: `true` and `false`. Default value: `true`.
 * @property transitRouterCidrName The name of the transit router. The name must be `2` to `128` characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
 * @property transitRouterId The ID of the transit router.
 */
public data class TransitRouterCidrArgs(
    public val cidr: Output<String>? = null,
    public val description: Output<String>? = null,
    public val publishCidrRoute: Output<Boolean>? = null,
    public val transitRouterCidrName: Output<String>? = null,
    public val transitRouterId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.TransitRouterCidrArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.TransitRouterCidrArgs =
        com.pulumi.alicloud.cen.TransitRouterCidrArgs.builder()
            .cidr(cidr?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .publishCidrRoute(publishCidrRoute?.applyValue({ args0 -> args0 }))
            .transitRouterCidrName(transitRouterCidrName?.applyValue({ args0 -> args0 }))
            .transitRouterId(transitRouterId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitRouterCidrArgs].
 */
@PulumiTagMarker
public class TransitRouterCidrArgsBuilder internal constructor() {
    private var cidr: Output<String>? = null

    private var description: Output<String>? = null

    private var publishCidrRoute: Output<Boolean>? = null

    private var transitRouterCidrName: Output<String>? = null

    private var transitRouterId: Output<String>? = null

    /**
     * @param value The cidr of the transit router.
     */
    @JvmName("pqbajchqqthytaiw")
    public suspend fun cidr(`value`: Output<String>) {
        this.cidr = value
    }

    /**
     * @param value The description of the transit router. The description must be `2` to `256` characters in length, and it must start with English letters, but cannot start with `http://` or `https://`.
     */
    @JvmName("hqejvigtswcrrsbu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether to allow automatically adding Transit Router Cidr in Transit Router Route Table. Valid values: `true` and `false`. Default value: `true`.
     */
    @JvmName("jfnrctlatlpvehwp")
    public suspend fun publishCidrRoute(`value`: Output<Boolean>) {
        this.publishCidrRoute = value
    }

    /**
     * @param value The name of the transit router. The name must be `2` to `128` characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
     */
    @JvmName("kyqtbybbupssebes")
    public suspend fun transitRouterCidrName(`value`: Output<String>) {
        this.transitRouterCidrName = value
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("reumvoodlsgaoldl")
    public suspend fun transitRouterId(`value`: Output<String>) {
        this.transitRouterId = value
    }

    /**
     * @param value The cidr of the transit router.
     */
    @JvmName("tvdmeqswkbsxxlxi")
    public suspend fun cidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidr = mapped
    }

    /**
     * @param value The description of the transit router. The description must be `2` to `256` characters in length, and it must start with English letters, but cannot start with `http://` or `https://`.
     */
    @JvmName("qtvpucfvkkxuqfef")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether to allow automatically adding Transit Router Cidr in Transit Router Route Table. Valid values: `true` and `false`. Default value: `true`.
     */
    @JvmName("sqxckuijbbkqgvdo")
    public suspend fun publishCidrRoute(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publishCidrRoute = mapped
    }

    /**
     * @param value The name of the transit router. The name must be `2` to `128` characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
     */
    @JvmName("kuwdwpralqtrmxqh")
    public suspend fun transitRouterCidrName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterCidrName = mapped
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("ecmwwoyjcywsnpau")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterId = mapped
    }

    internal fun build(): TransitRouterCidrArgs = TransitRouterCidrArgs(
        cidr = cidr,
        description = description,
        publishCidrRoute = publishCidrRoute,
        transitRouterCidrName = transitRouterCidrName,
        transitRouterId = transitRouterId,
    )
}
