@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TransitRouterGrantAttachment].
 */
@PulumiTagMarker
public class TransitRouterGrantAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitRouterGrantAttachmentArgs = TransitRouterGrantAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransitRouterGrantAttachmentArgsBuilder.() -> Unit) {
        val builder = TransitRouterGrantAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TransitRouterGrantAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.cen.TransitRouterGrantAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TransitRouterGrantAttachment(builtJavaResource)
    }
}

/**
 * Provides a Cloud Enterprise Network (CEN) Transit Router Grant Attachment resource.
 * For information about Cloud Enterprise Network (CEN) Transit Router Grant Attachment and how to use it, see [What is Transit Router Grant Attachment](https://www.alibabacloud.com/help/en/cloud-enterprise-network/latest/grantinstancetotransitrouter).
 * > **NOTE:** Available since v1.187.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getAccount({});
 * const example = new alicloud.vpc.Network("example", {
 *     vpcName: "tf_example",
 *     cidrBlock: "172.17.3.0/24",
 * });
 * const exampleInstance = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleTransitRouterGrantAttachment = new alicloud.cen.TransitRouterGrantAttachment("example", {
 *     cenId: exampleInstance.id,
 *     cenOwnerId: _default.then(_default => _default.id),
 *     instanceId: example.id,
 *     instanceType: "VPC",
 *     orderType: "PayByCenOwner",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_account()
 * example = alicloud.vpc.Network("example",
 *     vpc_name="tf_example",
 *     cidr_block="172.17.3.0/24")
 * example_instance = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_transit_router_grant_attachment = alicloud.cen.TransitRouterGrantAttachment("example",
 *     cen_id=example_instance.id,
 *     cen_owner_id=default.id,
 *     instance_id=example.id,
 *     instance_type="VPC",
 *     order_type="PayByCenOwner")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetAccount.Invoke();
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = "tf_example",
 *         CidrBlock = "172.17.3.0/24",
 *     });
 *     var exampleInstance = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleTransitRouterGrantAttachment = new AliCloud.Cen.TransitRouterGrantAttachment("example", new()
 *     {
 *         CenId = exampleInstance.Id,
 *         CenOwnerId = @default.Apply(@default => @default.Apply(getAccountResult => getAccountResult.Id)),
 *         InstanceId = example.Id,
 *         InstanceType = "VPC",
 *         OrderType = "PayByCenOwner",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("tf_example"),
 * 			CidrBlock: pulumi.String("172.17.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstance, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouterGrantAttachment(ctx, "example", &cen.TransitRouterGrantAttachmentArgs{
 * 			CenId:        exampleInstance.ID(),
 * 			CenOwnerId:   pulumi.String(_default.Id),
 * 			InstanceId:   example.ID(),
 * 			InstanceType: pulumi.String("VPC"),
 * 			OrderType:    pulumi.String("PayByCenOwner"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouterGrantAttachment;
 * import com.pulumi.alicloud.cen.TransitRouterGrantAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getAccount();
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName("tf_example")
 *             .cidrBlock("172.17.3.0/24")
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleTransitRouterGrantAttachment = new TransitRouterGrantAttachment("exampleTransitRouterGrantAttachment", TransitRouterGrantAttachmentArgs.builder()
 *             .cenId(exampleInstance.id())
 *             .cenOwnerId(default_.id())
 *             .instanceId(example.id())
 *             .instanceType("VPC")
 *             .orderType("PayByCenOwner")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: tf_example
 *       cidrBlock: 172.17.3.0/24
 *   exampleInstance:
 *     type: alicloud:cen:Instance
 *     name: example
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleTransitRouterGrantAttachment:
 *     type: alicloud:cen:TransitRouterGrantAttachment
 *     name: example
 *     properties:
 *       cenId: ${exampleInstance.id}
 *       cenOwnerId: ${default.id}
 *       instanceId: ${example.id}
 *       instanceType: VPC
 *       orderType: PayByCenOwner
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Enterprise Network (CEN) Transit Router Grant Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterGrantAttachment:TransitRouterGrantAttachment example <instance_type>:<instance_id>:<cen_owner_id>:<cen_id>
 * ```
 */
public class TransitRouterGrantAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.TransitRouterGrantAttachment,
) : KotlinCustomResource(javaResource, TransitRouterGrantAttachmentMapper) {
    /**
     * The ID of the Cloud Enterprise Network (CEN) instance to which the transit router belongs.
     */
    public val cenId: Output<String>
        get() = javaResource.cenId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Alibaba Cloud account to which the CEN instance belongs.
     */
    public val cenOwnerId: Output<String>
        get() = javaResource.cenOwnerId().applyValue({ args0 -> args0 })

    /**
     * The ID of the network instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The type of the network instance. Valid values: `VPC`, `ExpressConnect`, `VPN`.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * The entity that pays the fees of the network instance. Valid values: `PayByResourceOwner`, `PayByCenOwner`.
     */
    public val orderType: Output<String>
        get() = javaResource.orderType().applyValue({ args0 -> args0 })
}

public object TransitRouterGrantAttachmentMapper : ResourceMapper<TransitRouterGrantAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.TransitRouterGrantAttachment::class == javaResource::class

    override fun map(javaResource: Resource): TransitRouterGrantAttachment =
        TransitRouterGrantAttachment(
            javaResource as
                com.pulumi.alicloud.cen.TransitRouterGrantAttachment,
        )
}

/**
 * @see [TransitRouterGrantAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitRouterGrantAttachment].
 */
public suspend fun transitRouterGrantAttachment(
    name: String,
    block: suspend TransitRouterGrantAttachmentResourceBuilder.() -> Unit,
): TransitRouterGrantAttachment {
    val builder = TransitRouterGrantAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitRouterGrantAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitRouterGrantAttachment(name: String): TransitRouterGrantAttachment {
    val builder = TransitRouterGrantAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
