@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TransitRouterMulticastDomain].
 */
@PulumiTagMarker
public class TransitRouterMulticastDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitRouterMulticastDomainArgs = TransitRouterMulticastDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransitRouterMulticastDomainArgsBuilder.() -> Unit) {
        val builder = TransitRouterMulticastDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TransitRouterMulticastDomain {
        val builtJavaResource =
            com.pulumi.alicloud.cen.TransitRouterMulticastDomain(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TransitRouterMulticastDomain(builtJavaResource)
    }
}

/**
 * Provides a Cloud Enterprise Network (CEN) Transit Router Multicast Domain resource.
 * For information about Cloud Enterprise Network (CEN) Transit Router Multicast Domain and how to use it, see [What is Transit Router Multicast Domain](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutermulticastdomain).
 * > **NOTE:** Available since v1.195.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleTransitRouter = new alicloud.cen.TransitRouter("example", {
 *     transitRouterName: "tf_example",
 *     cenId: example.id,
 *     supportMulticast: true,
 * });
 * const exampleTransitRouterMulticastDomain = new alicloud.cen.TransitRouterMulticastDomain("example", {
 *     transitRouterId: exampleTransitRouter.transitRouterId,
 *     transitRouterMulticastDomainName: "tf_example",
 *     transitRouterMulticastDomainDescription: "tf_example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_transit_router = alicloud.cen.TransitRouter("example",
 *     transit_router_name="tf_example",
 *     cen_id=example.id,
 *     support_multicast=True)
 * example_transit_router_multicast_domain = alicloud.cen.TransitRouterMulticastDomain("example",
 *     transit_router_id=example_transit_router.transit_router_id,
 *     transit_router_multicast_domain_name="tf_example",
 *     transit_router_multicast_domain_description="tf_example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleTransitRouter = new AliCloud.Cen.TransitRouter("example", new()
 *     {
 *         TransitRouterName = "tf_example",
 *         CenId = example.Id,
 *         SupportMulticast = true,
 *     });
 *     var exampleTransitRouterMulticastDomain = new AliCloud.Cen.TransitRouterMulticastDomain("example", new()
 *     {
 *         TransitRouterId = exampleTransitRouter.TransitRouterId,
 *         TransitRouterMulticastDomainName = "tf_example",
 *         TransitRouterMulticastDomainDescription = "tf_example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouter, err := cen.NewTransitRouter(ctx, "example", &cen.TransitRouterArgs{
 * 			TransitRouterName: pulumi.String("tf_example"),
 * 			CenId:             example.ID(),
 * 			SupportMulticast:  pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouterMulticastDomain(ctx, "example", &cen.TransitRouterMulticastDomainArgs{
 * 			TransitRouterId:                         exampleTransitRouter.TransitRouterId,
 * 			TransitRouterMulticastDomainName:        pulumi.String("tf_example"),
 * 			TransitRouterMulticastDomainDescription: pulumi.String("tf_example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.TransitRouterMulticastDomain;
 * import com.pulumi.alicloud.cen.TransitRouterMulticastDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleTransitRouter = new TransitRouter("exampleTransitRouter", TransitRouterArgs.builder()
 *             .transitRouterName("tf_example")
 *             .cenId(example.id())
 *             .supportMulticast(true)
 *             .build());
 *         var exampleTransitRouterMulticastDomain = new TransitRouterMulticastDomain("exampleTransitRouterMulticastDomain", TransitRouterMulticastDomainArgs.builder()
 *             .transitRouterId(exampleTransitRouter.transitRouterId())
 *             .transitRouterMulticastDomainName("tf_example")
 *             .transitRouterMulticastDomainDescription("tf_example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: example
 *     properties:
 *       transitRouterName: tf_example
 *       cenId: ${example.id}
 *       supportMulticast: true
 *   exampleTransitRouterMulticastDomain:
 *     type: alicloud:cen:TransitRouterMulticastDomain
 *     name: example
 *     properties:
 *       transitRouterId: ${exampleTransitRouter.transitRouterId}
 *       transitRouterMulticastDomainName: tf_example
 *       transitRouterMulticastDomainDescription: tf_example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Enterprise Network (CEN) Transit Router Multicast Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterMulticastDomain:TransitRouterMulticastDomain example <id>
 * ```
 */
public class TransitRouterMulticastDomain internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.TransitRouterMulticastDomain,
) : KotlinCustomResource(javaResource, TransitRouterMulticastDomainMapper) {
    /**
     * The status of the Transit Router Multicast Domain.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the transit router.
     */
    public val transitRouterId: Output<String>
        get() = javaResource.transitRouterId().applyValue({ args0 -> args0 })

    /**
     * The description of the multicast domain. The description must be 0 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (_), and hyphens (-).
     */
    public val transitRouterMulticastDomainDescription: Output<String>?
        get() = javaResource.transitRouterMulticastDomainDescription().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The name of the multicast domain. The name must be 0 to 128 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (_), and hyphens (-).
     */
    public val transitRouterMulticastDomainName: Output<String>?
        get() = javaResource.transitRouterMulticastDomainName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object TransitRouterMulticastDomainMapper : ResourceMapper<TransitRouterMulticastDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.TransitRouterMulticastDomain::class == javaResource::class

    override fun map(javaResource: Resource): TransitRouterMulticastDomain =
        TransitRouterMulticastDomain(
            javaResource as
                com.pulumi.alicloud.cen.TransitRouterMulticastDomain,
        )
}

/**
 * @see [TransitRouterMulticastDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitRouterMulticastDomain].
 */
public suspend fun transitRouterMulticastDomain(
    name: String,
    block: suspend TransitRouterMulticastDomainResourceBuilder.() -> Unit,
): TransitRouterMulticastDomain {
    val builder = TransitRouterMulticastDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitRouterMulticastDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitRouterMulticastDomain(name: String): TransitRouterMulticastDomain {
    val builder = TransitRouterMulticastDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
