@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.TransitRouterMulticastDomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Enterprise Network (CEN) Transit Router Multicast Domain resource.
 * For information about Cloud Enterprise Network (CEN) Transit Router Multicast Domain and how to use it, see [What is Transit Router Multicast Domain](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutermulticastdomain).
 * > **NOTE:** Available since v1.195.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleTransitRouter = new alicloud.cen.TransitRouter("example", {
 *     transitRouterName: "tf_example",
 *     cenId: example.id,
 *     supportMulticast: true,
 * });
 * const exampleTransitRouterMulticastDomain = new alicloud.cen.TransitRouterMulticastDomain("example", {
 *     transitRouterId: exampleTransitRouter.transitRouterId,
 *     transitRouterMulticastDomainName: "tf_example",
 *     transitRouterMulticastDomainDescription: "tf_example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_transit_router = alicloud.cen.TransitRouter("example",
 *     transit_router_name="tf_example",
 *     cen_id=example.id,
 *     support_multicast=True)
 * example_transit_router_multicast_domain = alicloud.cen.TransitRouterMulticastDomain("example",
 *     transit_router_id=example_transit_router.transit_router_id,
 *     transit_router_multicast_domain_name="tf_example",
 *     transit_router_multicast_domain_description="tf_example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleTransitRouter = new AliCloud.Cen.TransitRouter("example", new()
 *     {
 *         TransitRouterName = "tf_example",
 *         CenId = example.Id,
 *         SupportMulticast = true,
 *     });
 *     var exampleTransitRouterMulticastDomain = new AliCloud.Cen.TransitRouterMulticastDomain("example", new()
 *     {
 *         TransitRouterId = exampleTransitRouter.TransitRouterId,
 *         TransitRouterMulticastDomainName = "tf_example",
 *         TransitRouterMulticastDomainDescription = "tf_example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouter, err := cen.NewTransitRouter(ctx, "example", &cen.TransitRouterArgs{
 * 			TransitRouterName: pulumi.String("tf_example"),
 * 			CenId:             example.ID(),
 * 			SupportMulticast:  pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouterMulticastDomain(ctx, "example", &cen.TransitRouterMulticastDomainArgs{
 * 			TransitRouterId:                         exampleTransitRouter.TransitRouterId,
 * 			TransitRouterMulticastDomainName:        pulumi.String("tf_example"),
 * 			TransitRouterMulticastDomainDescription: pulumi.String("tf_example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.TransitRouterMulticastDomain;
 * import com.pulumi.alicloud.cen.TransitRouterMulticastDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleTransitRouter = new TransitRouter("exampleTransitRouter", TransitRouterArgs.builder()
 *             .transitRouterName("tf_example")
 *             .cenId(example.id())
 *             .supportMulticast(true)
 *             .build());
 *         var exampleTransitRouterMulticastDomain = new TransitRouterMulticastDomain("exampleTransitRouterMulticastDomain", TransitRouterMulticastDomainArgs.builder()
 *             .transitRouterId(exampleTransitRouter.transitRouterId())
 *             .transitRouterMulticastDomainName("tf_example")
 *             .transitRouterMulticastDomainDescription("tf_example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: example
 *     properties:
 *       transitRouterName: tf_example
 *       cenId: ${example.id}
 *       supportMulticast: true
 *   exampleTransitRouterMulticastDomain:
 *     type: alicloud:cen:TransitRouterMulticastDomain
 *     name: example
 *     properties:
 *       transitRouterId: ${exampleTransitRouter.transitRouterId}
 *       transitRouterMulticastDomainName: tf_example
 *       transitRouterMulticastDomainDescription: tf_example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Enterprise Network (CEN) Transit Router Multicast Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterMulticastDomain:TransitRouterMulticastDomain example <id>
 * ```
 * @property tags A mapping of tags to assign to the resource.
 * @property transitRouterId The ID of the transit router.
 * @property transitRouterMulticastDomainDescription The description of the multicast domain. The description must be 0 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (_), and hyphens (-).
 * @property transitRouterMulticastDomainName The name of the multicast domain. The name must be 0 to 128 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (_), and hyphens (-).
 */
public data class TransitRouterMulticastDomainArgs(
    public val tags: Output<Map<String, String>>? = null,
    public val transitRouterId: Output<String>? = null,
    public val transitRouterMulticastDomainDescription: Output<String>? = null,
    public val transitRouterMulticastDomainName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.TransitRouterMulticastDomainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.TransitRouterMulticastDomainArgs =
        com.pulumi.alicloud.cen.TransitRouterMulticastDomainArgs.builder()
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitRouterId(transitRouterId?.applyValue({ args0 -> args0 }))
            .transitRouterMulticastDomainDescription(
                transitRouterMulticastDomainDescription?.applyValue({ args0 ->
                    args0
                }),
            )
            .transitRouterMulticastDomainName(
                transitRouterMulticastDomainName?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [TransitRouterMulticastDomainArgs].
 */
@PulumiTagMarker
public class TransitRouterMulticastDomainArgsBuilder internal constructor() {
    private var tags: Output<Map<String, String>>? = null

    private var transitRouterId: Output<String>? = null

    private var transitRouterMulticastDomainDescription: Output<String>? = null

    private var transitRouterMulticastDomainName: Output<String>? = null

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("rxdwxsaeyndieaaa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("agastgwhvnvkavml")
    public suspend fun transitRouterId(`value`: Output<String>) {
        this.transitRouterId = value
    }

    /**
     * @param value The description of the multicast domain. The description must be 0 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (_), and hyphens (-).
     */
    @JvmName("mbmmppoevsccplgp")
    public suspend fun transitRouterMulticastDomainDescription(`value`: Output<String>) {
        this.transitRouterMulticastDomainDescription = value
    }

    /**
     * @param value The name of the multicast domain. The name must be 0 to 128 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (_), and hyphens (-).
     */
    @JvmName("tqxlbahalobuenwb")
    public suspend fun transitRouterMulticastDomainName(`value`: Output<String>) {
        this.transitRouterMulticastDomainName = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("jqybwmajbvwlevcf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("eosuawgmqbceyiai")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("soueayixtjpvoaye")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterId = mapped
    }

    /**
     * @param value The description of the multicast domain. The description must be 0 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (_), and hyphens (-).
     */
    @JvmName("xffecjxjrtyvkoyr")
    public suspend fun transitRouterMulticastDomainDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterMulticastDomainDescription = mapped
    }

    /**
     * @param value The name of the multicast domain. The name must be 0 to 128 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (_), and hyphens (-).
     */
    @JvmName("baubcpmpoxmejwdw")
    public suspend fun transitRouterMulticastDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterMulticastDomainName = mapped
    }

    internal fun build(): TransitRouterMulticastDomainArgs = TransitRouterMulticastDomainArgs(
        tags = tags,
        transitRouterId = transitRouterId,
        transitRouterMulticastDomainDescription = transitRouterMulticastDomainDescription,
        transitRouterMulticastDomainName = transitRouterMulticastDomainName,
    )
}
