@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TransitRouterMulticastDomainMember].
 */
@PulumiTagMarker
public class TransitRouterMulticastDomainMemberResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitRouterMulticastDomainMemberArgs = TransitRouterMulticastDomainMemberArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransitRouterMulticastDomainMemberArgsBuilder.() -> Unit) {
        val builder = TransitRouterMulticastDomainMemberArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TransitRouterMulticastDomainMember {
        val builtJavaResource =
            com.pulumi.alicloud.cen.TransitRouterMulticastDomainMember(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TransitRouterMulticastDomainMember(builtJavaResource)
    }
}

/**
 * Provides a Cen Transit Router Multicast Domain Member resource.
 * For information about Cen Transit Router Multicast Domain Member and how to use it, see [What is Transit Router Multicast Domain Member](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-registertransitroutermulticastgroupmembers).
 * > **NOTE:** Available since v1.195.0.
 * ## Import
 * Cen Transit Router Multicast Domain Member can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterMulticastDomainMember:TransitRouterMulticastDomainMember example <transit_router_multicast_domain_id>:<group_ip_address>:<network_interface_id>
 * ```
 */
public class TransitRouterMulticastDomainMember internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.TransitRouterMulticastDomainMember,
) : KotlinCustomResource(javaResource, TransitRouterMulticastDomainMemberMapper) {
    /**
     * Specifies whether only to precheck the request.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The IP address of the multicast group to which the multicast member belongs. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you in the current multicast domain.
     */
    public val groupIpAddress: Output<String>
        get() = javaResource.groupIpAddress().applyValue({ args0 -> args0 })

    /**
     * The ID of the ENI.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The status of the Transit Router Multicast Domain Member.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of the multicast domain to which the multicast member belongs.
     */
    public val transitRouterMulticastDomainId: Output<String>
        get() = javaResource.transitRouterMulticastDomainId().applyValue({ args0 -> args0 })

    /**
     * The VPC to which the ENI of the multicast member belongs. This field is mandatory for VPCs owned by another accounts.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object TransitRouterMulticastDomainMemberMapper :
    ResourceMapper<TransitRouterMulticastDomainMember> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.TransitRouterMulticastDomainMember::class == javaResource::class

    override fun map(javaResource: Resource): TransitRouterMulticastDomainMember =
        TransitRouterMulticastDomainMember(
            javaResource as
                com.pulumi.alicloud.cen.TransitRouterMulticastDomainMember,
        )
}

/**
 * @see [TransitRouterMulticastDomainMember].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitRouterMulticastDomainMember].
 */
public suspend fun transitRouterMulticastDomainMember(
    name: String,
    block: suspend TransitRouterMulticastDomainMemberResourceBuilder.() -> Unit,
): TransitRouterMulticastDomainMember {
    val builder = TransitRouterMulticastDomainMemberResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitRouterMulticastDomainMember].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitRouterMulticastDomainMember(name: String): TransitRouterMulticastDomainMember {
    val builder = TransitRouterMulticastDomainMemberResourceBuilder()
    builder.name(name)
    return builder.build()
}
