@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.TransitRouterMulticastDomainMemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cen Transit Router Multicast Domain Member resource.
 * For information about Cen Transit Router Multicast Domain Member and how to use it, see [What is Transit Router Multicast Domain Member](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-registertransitroutermulticastgroupmembers).
 * > **NOTE:** Available since v1.195.0.
 * ## Import
 * Cen Transit Router Multicast Domain Member can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterMulticastDomainMember:TransitRouterMulticastDomainMember example <transit_router_multicast_domain_id>:<group_ip_address>:<network_interface_id>
 * ```
 * @property dryRun Specifies whether only to precheck the request.
 * @property groupIpAddress The IP address of the multicast group to which the multicast member belongs. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you in the current multicast domain.
 * @property networkInterfaceId The ID of the ENI.
 * @property transitRouterMulticastDomainId The ID of the multicast domain to which the multicast member belongs.
 * @property vpcId The VPC to which the ENI of the multicast member belongs. This field is mandatory for VPCs owned by another accounts.
 */
public data class TransitRouterMulticastDomainMemberArgs(
    public val dryRun: Output<Boolean>? = null,
    public val groupIpAddress: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val transitRouterMulticastDomainId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.TransitRouterMulticastDomainMemberArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.TransitRouterMulticastDomainMemberArgs =
        com.pulumi.alicloud.cen.TransitRouterMulticastDomainMemberArgs.builder()
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .groupIpAddress(groupIpAddress?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .transitRouterMulticastDomainId(transitRouterMulticastDomainId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitRouterMulticastDomainMemberArgs].
 */
@PulumiTagMarker
public class TransitRouterMulticastDomainMemberArgsBuilder internal constructor() {
    private var dryRun: Output<Boolean>? = null

    private var groupIpAddress: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var transitRouterMulticastDomainId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Specifies whether only to precheck the request.
     */
    @JvmName("cdgdvmafqnwngurg")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The IP address of the multicast group to which the multicast member belongs. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you in the current multicast domain.
     */
    @JvmName("kvcmshwwqbywpfgx")
    public suspend fun groupIpAddress(`value`: Output<String>) {
        this.groupIpAddress = value
    }

    /**
     * @param value The ID of the ENI.
     */
    @JvmName("wdkngeximduiglmo")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The ID of the multicast domain to which the multicast member belongs.
     */
    @JvmName("xxcbtvfnrhiffupu")
    public suspend fun transitRouterMulticastDomainId(`value`: Output<String>) {
        this.transitRouterMulticastDomainId = value
    }

    /**
     * @param value The VPC to which the ENI of the multicast member belongs. This field is mandatory for VPCs owned by another accounts.
     */
    @JvmName("wiwbuwnxlgjlaxps")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Specifies whether only to precheck the request.
     */
    @JvmName("vccqkjdoodyypjva")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The IP address of the multicast group to which the multicast member belongs. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you in the current multicast domain.
     */
    @JvmName("ysujbdmwqgnhaglu")
    public suspend fun groupIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIpAddress = mapped
    }

    /**
     * @param value The ID of the ENI.
     */
    @JvmName("fqanlrqexlbusifl")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The ID of the multicast domain to which the multicast member belongs.
     */
    @JvmName("irptkuqxslkwnodn")
    public suspend fun transitRouterMulticastDomainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterMulticastDomainId = mapped
    }

    /**
     * @param value The VPC to which the ENI of the multicast member belongs. This field is mandatory for VPCs owned by another accounts.
     */
    @JvmName("rqpdnektyfaoaaep")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): TransitRouterMulticastDomainMemberArgs =
        TransitRouterMulticastDomainMemberArgs(
            dryRun = dryRun,
            groupIpAddress = groupIpAddress,
            networkInterfaceId = networkInterfaceId,
            transitRouterMulticastDomainId = transitRouterMulticastDomainId,
            vpcId = vpcId,
        )
}
