@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TransitRouterMulticastDomainSource].
 */
@PulumiTagMarker
public class TransitRouterMulticastDomainSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitRouterMulticastDomainSourceArgs = TransitRouterMulticastDomainSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransitRouterMulticastDomainSourceArgsBuilder.() -> Unit) {
        val builder = TransitRouterMulticastDomainSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TransitRouterMulticastDomainSource {
        val builtJavaResource =
            com.pulumi.alicloud.cen.TransitRouterMulticastDomainSource(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TransitRouterMulticastDomainSource(builtJavaResource)
    }
}

/**
 * Provides a Cen Transit Router Multicast Domain Source resource.
 * For information about Cen Transit Router Multicast Domain Source and how to use it, see [What is Transit Router Multicast Domain Source](https://www.alibabacloud.com/help/en/cloud-enterprise-network/latest/api-cbn-2017-09-12-registertransitroutermulticastgroupsources).
 * > **NOTE:** Available since v1.195.0.
 * ## Import
 * Cen Transit Router Multicast Domain Source can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterMulticastDomainSource:TransitRouterMulticastDomainSource example <transit_router_multicast_domain_id>:<group_ip_address>:<network_interface_id>
 * ```
 */
public class TransitRouterMulticastDomainSource internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.TransitRouterMulticastDomainSource,
) : KotlinCustomResource(javaResource, TransitRouterMulticastDomainSourceMapper) {
    /**
     * The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
     */
    public val groupIpAddress: Output<String>
        get() = javaResource.groupIpAddress().applyValue({ args0 -> args0 })

    /**
     * ENI ID of the multicast source.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of the multicast domain to which the multicast source belongs.
     */
    public val transitRouterMulticastDomainId: Output<String>
        get() = javaResource.transitRouterMulticastDomainId().applyValue({ args0 -> args0 })

    /**
     * The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object TransitRouterMulticastDomainSourceMapper :
    ResourceMapper<TransitRouterMulticastDomainSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.TransitRouterMulticastDomainSource::class == javaResource::class

    override fun map(javaResource: Resource): TransitRouterMulticastDomainSource =
        TransitRouterMulticastDomainSource(
            javaResource as
                com.pulumi.alicloud.cen.TransitRouterMulticastDomainSource,
        )
}

/**
 * @see [TransitRouterMulticastDomainSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitRouterMulticastDomainSource].
 */
public suspend fun transitRouterMulticastDomainSource(
    name: String,
    block: suspend TransitRouterMulticastDomainSourceResourceBuilder.() -> Unit,
): TransitRouterMulticastDomainSource {
    val builder = TransitRouterMulticastDomainSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitRouterMulticastDomainSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitRouterMulticastDomainSource(name: String): TransitRouterMulticastDomainSource {
    val builder = TransitRouterMulticastDomainSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
