@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.TransitRouterMulticastDomainSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cen Transit Router Multicast Domain Source resource.
 * For information about Cen Transit Router Multicast Domain Source and how to use it, see [What is Transit Router Multicast Domain Source](https://www.alibabacloud.com/help/en/cloud-enterprise-network/latest/api-cbn-2017-09-12-registertransitroutermulticastgroupsources).
 * > **NOTE:** Available since v1.195.0.
 * ## Import
 * Cen Transit Router Multicast Domain Source can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterMulticastDomainSource:TransitRouterMulticastDomainSource example <transit_router_multicast_domain_id>:<group_ip_address>:<network_interface_id>
 * ```
 * @property groupIpAddress The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
 * @property networkInterfaceId ENI ID of the multicast source.
 * @property transitRouterMulticastDomainId The ID of the multicast domain to which the multicast source belongs.
 * @property vpcId The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
 */
public data class TransitRouterMulticastDomainSourceArgs(
    public val groupIpAddress: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val transitRouterMulticastDomainId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.TransitRouterMulticastDomainSourceArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.TransitRouterMulticastDomainSourceArgs =
        com.pulumi.alicloud.cen.TransitRouterMulticastDomainSourceArgs.builder()
            .groupIpAddress(groupIpAddress?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .transitRouterMulticastDomainId(transitRouterMulticastDomainId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitRouterMulticastDomainSourceArgs].
 */
@PulumiTagMarker
public class TransitRouterMulticastDomainSourceArgsBuilder internal constructor() {
    private var groupIpAddress: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var transitRouterMulticastDomainId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
     */
    @JvmName("kglflpahbwewwxxm")
    public suspend fun groupIpAddress(`value`: Output<String>) {
        this.groupIpAddress = value
    }

    /**
     * @param value ENI ID of the multicast source.
     */
    @JvmName("uubaqfdtrpjsqojh")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The ID of the multicast domain to which the multicast source belongs.
     */
    @JvmName("ncwodjlwwjajsqia")
    public suspend fun transitRouterMulticastDomainId(`value`: Output<String>) {
        this.transitRouterMulticastDomainId = value
    }

    /**
     * @param value The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
     */
    @JvmName("lcsjjxbamfcwpmfc")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
     */
    @JvmName("tfuqvwwshgykskmr")
    public suspend fun groupIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIpAddress = mapped
    }

    /**
     * @param value ENI ID of the multicast source.
     */
    @JvmName("nnbnaacjkhxdjhrp")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The ID of the multicast domain to which the multicast source belongs.
     */
    @JvmName("kehdmnucwpfvwoac")
    public suspend fun transitRouterMulticastDomainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterMulticastDomainId = mapped
    }

    /**
     * @param value The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
     */
    @JvmName("crudhobuvhdnrhld")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): TransitRouterMulticastDomainSourceArgs =
        TransitRouterMulticastDomainSourceArgs(
            groupIpAddress = groupIpAddress,
            networkInterfaceId = networkInterfaceId,
            transitRouterMulticastDomainId = transitRouterMulticastDomainId,
            vpcId = vpcId,
        )
}
