@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TransitRouterPeerAttachment].
 */
@PulumiTagMarker
public class TransitRouterPeerAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitRouterPeerAttachmentArgs = TransitRouterPeerAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransitRouterPeerAttachmentArgsBuilder.() -> Unit) {
        val builder = TransitRouterPeerAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TransitRouterPeerAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.cen.TransitRouterPeerAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TransitRouterPeerAttachment(builtJavaResource)
    }
}

/**
 * Provides a CEN transit router peer attachment resource that associate the transit router with the CEN instance. [What is CEN transit router peer attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitrouterpeerattachment)
 * > **NOTE:** Available since v1.128.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const region = config.get("region") || "cn-hangzhou";
 * const peerRegion = config.get("peerRegion") || "cn-beijing";
 * const example = new alicloud.cen.Instance("example", {
 *     cenInstanceName: name,
 *     protectionLevel: "REDUCED",
 * });
 * const exampleBandwidthPackage = new alicloud.cen.BandwidthPackage("example", {
 *     bandwidth: 5,
 *     cenBandwidthPackageName: "tf_example",
 *     geographicRegionAId: "China",
 *     geographicRegionBId: "China",
 * });
 * const exampleBandwidthPackageAttachment = new alicloud.cen.BandwidthPackageAttachment("example", {
 *     instanceId: example.id,
 *     bandwidthPackageId: exampleBandwidthPackage.id,
 * });
 * const exampleTransitRouter = new alicloud.cen.TransitRouter("example", {cenId: exampleBandwidthPackageAttachment.instanceId});
 * const peer = new alicloud.cen.TransitRouter("peer", {cenId: exampleTransitRouter.cenId});
 * const exampleTransitRouterPeerAttachment = new alicloud.cen.TransitRouterPeerAttachment("example", {
 *     cenId: example.id,
 *     transitRouterId: exampleTransitRouter.transitRouterId,
 *     peerTransitRouterRegionId: peerRegion,
 *     peerTransitRouterId: peer.transitRouterId,
 *     cenBandwidthPackageId: exampleBandwidthPackageAttachment.bandwidthPackageId,
 *     bandwidth: 5,
 *     transitRouterAttachmentDescription: name,
 *     transitRouterAttachmentName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * peer_region = config.get("peerRegion")
 * if peer_region is None:
 *     peer_region = "cn-beijing"
 * example = alicloud.cen.Instance("example",
 *     cen_instance_name=name,
 *     protection_level="REDUCED")
 * example_bandwidth_package = alicloud.cen.BandwidthPackage("example",
 *     bandwidth=5,
 *     cen_bandwidth_package_name="tf_example",
 *     geographic_region_a_id="China",
 *     geographic_region_b_id="China")
 * example_bandwidth_package_attachment = alicloud.cen.BandwidthPackageAttachment("example",
 *     instance_id=example.id,
 *     bandwidth_package_id=example_bandwidth_package.id)
 * example_transit_router = alicloud.cen.TransitRouter("example", cen_id=example_bandwidth_package_attachment.instance_id)
 * peer = alicloud.cen.TransitRouter("peer", cen_id=example_transit_router.cen_id)
 * example_transit_router_peer_attachment = alicloud.cen.TransitRouterPeerAttachment("example",
 *     cen_id=example.id,
 *     transit_router_id=example_transit_router.transit_router_id,
 *     peer_transit_router_region_id=peer_region,
 *     peer_transit_router_id=peer.transit_router_id,
 *     cen_bandwidth_package_id=example_bandwidth_package_attachment.bandwidth_package_id,
 *     bandwidth=5,
 *     transit_router_attachment_description=name,
 *     transit_router_attachment_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var peerRegion = config.Get("peerRegion") ?? "cn-beijing";
 *     var example = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = name,
 *         ProtectionLevel = "REDUCED",
 *     });
 *     var exampleBandwidthPackage = new AliCloud.Cen.BandwidthPackage("example", new()
 *     {
 *         Bandwidth = 5,
 *         CenBandwidthPackageName = "tf_example",
 *         GeographicRegionAId = "China",
 *         GeographicRegionBId = "China",
 *     });
 *     var exampleBandwidthPackageAttachment = new AliCloud.Cen.BandwidthPackageAttachment("example", new()
 *     {
 *         InstanceId = example.Id,
 *         BandwidthPackageId = exampleBandwidthPackage.Id,
 *     });
 *     var exampleTransitRouter = new AliCloud.Cen.TransitRouter("example", new()
 *     {
 *         CenId = exampleBandwidthPackageAttachment.InstanceId,
 *     });
 *     var peer = new AliCloud.Cen.TransitRouter("peer", new()
 *     {
 *         CenId = exampleTransitRouter.CenId,
 *     });
 *     var exampleTransitRouterPeerAttachment = new AliCloud.Cen.TransitRouterPeerAttachment("example", new()
 *     {
 *         CenId = example.Id,
 *         TransitRouterId = exampleTransitRouter.TransitRouterId,
 *         PeerTransitRouterRegionId = peerRegion,
 *         PeerTransitRouterId = peer.TransitRouterId,
 *         CenBandwidthPackageId = exampleBandwidthPackageAttachment.BandwidthPackageId,
 *         Bandwidth = 5,
 *         TransitRouterAttachmentDescription = name,
 *         TransitRouterAttachmentName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		peerRegion := "cn-beijing"
 * 		if param := cfg.Get("peerRegion"); param != "" {
 * 			peerRegion = param
 * 		}
 * 		example, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String(name),
 * 			ProtectionLevel: pulumi.String("REDUCED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleBandwidthPackage, err := cen.NewBandwidthPackage(ctx, "example", &cen.BandwidthPackageArgs{
 * 			Bandwidth:               pulumi.Int(5),
 * 			CenBandwidthPackageName: pulumi.String("tf_example"),
 * 			GeographicRegionAId:     pulumi.String("China"),
 * 			GeographicRegionBId:     pulumi.String("China"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleBandwidthPackageAttachment, err := cen.NewBandwidthPackageAttachment(ctx, "example", &cen.BandwidthPackageAttachmentArgs{
 * 			InstanceId:         example.ID(),
 * 			BandwidthPackageId: exampleBandwidthPackage.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouter, err := cen.NewTransitRouter(ctx, "example", &cen.TransitRouterArgs{
 * 			CenId: exampleBandwidthPackageAttachment.InstanceId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		peer, err := cen.NewTransitRouter(ctx, "peer", &cen.TransitRouterArgs{
 * 			CenId: exampleTransitRouter.CenId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouterPeerAttachment(ctx, "example", &cen.TransitRouterPeerAttachmentArgs{
 * 			CenId:                              example.ID(),
 * 			TransitRouterId:                    exampleTransitRouter.TransitRouterId,
 * 			PeerTransitRouterRegionId:          pulumi.String(peerRegion),
 * 			PeerTransitRouterId:                peer.TransitRouterId,
 * 			CenBandwidthPackageId:              exampleBandwidthPackageAttachment.BandwidthPackageId,
 * 			Bandwidth:                          pulumi.Int(5),
 * 			TransitRouterAttachmentDescription: pulumi.String(name),
 * 			TransitRouterAttachmentName:        pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.BandwidthPackage;
 * import com.pulumi.alicloud.cen.BandwidthPackageArgs;
 * import com.pulumi.alicloud.cen.BandwidthPackageAttachment;
 * import com.pulumi.alicloud.cen.BandwidthPackageAttachmentArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.TransitRouterPeerAttachment;
 * import com.pulumi.alicloud.cen.TransitRouterPeerAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         final var peerRegion = config.get("peerRegion").orElse("cn-beijing");
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .cenInstanceName(name)
 *             .protectionLevel("REDUCED")
 *             .build());
 *         var exampleBandwidthPackage = new BandwidthPackage("exampleBandwidthPackage", BandwidthPackageArgs.builder()
 *             .bandwidth(5)
 *             .cenBandwidthPackageName("tf_example")
 *             .geographicRegionAId("China")
 *             .geographicRegionBId("China")
 *             .build());
 *         var exampleBandwidthPackageAttachment = new BandwidthPackageAttachment("exampleBandwidthPackageAttachment", BandwidthPackageAttachmentArgs.builder()
 *             .instanceId(example.id())
 *             .bandwidthPackageId(exampleBandwidthPackage.id())
 *             .build());
 *         var exampleTransitRouter = new TransitRouter("exampleTransitRouter", TransitRouterArgs.builder()
 *             .cenId(exampleBandwidthPackageAttachment.instanceId())
 *             .build());
 *         var peer = new TransitRouter("peer", TransitRouterArgs.builder()
 *             .cenId(exampleTransitRouter.cenId())
 *             .build());
 *         var exampleTransitRouterPeerAttachment = new TransitRouterPeerAttachment("exampleTransitRouterPeerAttachment", TransitRouterPeerAttachmentArgs.builder()
 *             .cenId(example.id())
 *             .transitRouterId(exampleTransitRouter.transitRouterId())
 *             .peerTransitRouterRegionId(peerRegion)
 *             .peerTransitRouterId(peer.transitRouterId())
 *             .cenBandwidthPackageId(exampleBandwidthPackageAttachment.bandwidthPackageId())
 *             .bandwidth(5)
 *             .transitRouterAttachmentDescription(name)
 *             .transitRouterAttachmentName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 *   region:
 *     type: string
 *     default: cn-hangzhou
 *   peerRegion:
 *     type: string
 *     default: cn-beijing
 * resources:
 *   example:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: ${name}
 *       protectionLevel: REDUCED
 *   exampleBandwidthPackage:
 *     type: alicloud:cen:BandwidthPackage
 *     name: example
 *     properties:
 *       bandwidth: 5
 *       cenBandwidthPackageName: tf_example
 *       geographicRegionAId: China
 *       geographicRegionBId: China
 *   exampleBandwidthPackageAttachment:
 *     type: alicloud:cen:BandwidthPackageAttachment
 *     name: example
 *     properties:
 *       instanceId: ${example.id}
 *       bandwidthPackageId: ${exampleBandwidthPackage.id}
 *   exampleTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: example
 *     properties:
 *       cenId: ${exampleBandwidthPackageAttachment.instanceId}
 *   peer:
 *     type: alicloud:cen:TransitRouter
 *     properties:
 *       cenId: ${exampleTransitRouter.cenId}
 *   exampleTransitRouterPeerAttachment:
 *     type: alicloud:cen:TransitRouterPeerAttachment
 *     name: example
 *     properties:
 *       cenId: ${example.id}
 *       transitRouterId: ${exampleTransitRouter.transitRouterId}
 *       peerTransitRouterRegionId: ${peerRegion}
 *       peerTransitRouterId: ${peer.transitRouterId}
 *       cenBandwidthPackageId: ${exampleBandwidthPackageAttachment.bandwidthPackageId}
 *       bandwidth: 5
 *       transitRouterAttachmentDescription: ${name}
 *       transitRouterAttachmentName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN Transit Router Peer Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterPeerAttachment:TransitRouterPeerAttachment example <id>
 * ```
 */
public class TransitRouterPeerAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.TransitRouterPeerAttachment,
) : KotlinCustomResource(javaResource, TransitRouterPeerAttachmentMapper) {
    /**
     * Auto publish route enabled. The system default value is `false`.
     */
    public val autoPublishRouteEnabled: Output<Boolean>?
        get() = javaResource.autoPublishRouteEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The bandwidth of the bandwidth package.
     */
    public val bandwidth: Output<Int>?
        get() = javaResource.bandwidth().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The method that is used to allocate bandwidth to the cross-region connection. Valid values: `BandwidthPackage` and `DataTransfer`.
     * * `DataTransfer` - uses pay-by-data-transfer bandwidth.
     * * `BandwidthPackage` - allocates bandwidth from a bandwidth plan.
     */
    public val bandwidthType: Output<String>
        get() = javaResource.bandwidthType().applyValue({ args0 -> args0 })

    /**
     * The ID of the bandwidth package. If you do not enter the ID of the package, it means you are using the test. The system default test is 1bps, demonstrating that you test network connectivity
     */
    public val cenBandwidthPackageId: Output<String>?
        get() = javaResource.cenBandwidthPackageId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the CEN.
     */
    public val cenId: Output<String>
        get() = javaResource.cenId().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * DefaultLinkType. Valid values: `Platinum` and `Gold`.
     */
    public val defaultLinkType: Output<String>
        get() = javaResource.defaultLinkType().applyValue({ args0 -> args0 })

    /**
     * Whether to perform pre-check for this request, including permission, instance status verification, etc.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the peer transit router.
     */
    public val peerTransitRouterId: Output<String>
        get() = javaResource.peerTransitRouterId().applyValue({ args0 -> args0 })

    /**
     * The region ID of peer transit router.
     */
    public val peerTransitRouterRegionId: Output<String>
        get() = javaResource.peerTransitRouterRegionId().applyValue({ args0 -> args0 })

    /**
     * The resource type to attachment. Only support `VR` and default value is `VR`.
     */
    public val resourceType: Output<String>?
        get() = javaResource.resourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to association route table. System default is `false`.
     */
    public val routeTableAssociationEnabled: Output<Boolean>?
        get() = javaResource.routeTableAssociationEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to propagation route table. System default is `false`.
     */
    public val routeTablePropagationEnabled: Output<Boolean>?
        get() = javaResource.routeTablePropagationEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The description of transit router attachment. The description is 2~256 characters long and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
     */
    public val transitRouterAttachmentDescription: Output<String>?
        get() = javaResource.transitRouterAttachmentDescription().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The ID of transit router attachment id.
     */
    public val transitRouterAttachmentId: Output<String>
        get() = javaResource.transitRouterAttachmentId().applyValue({ args0 -> args0 })

    /**
     * The name of transit router attachment. The name is 2~128 characters in length, starts with uppercase and lowercase letters or Chinese, and can contain numbers, underscores (_) and dashes (-)
     */
    public val transitRouterAttachmentName: Output<String>?
        get() = javaResource.transitRouterAttachmentName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the transit router to attach.
     */
    public val transitRouterId: Output<String>?
        get() = javaResource.transitRouterId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object TransitRouterPeerAttachmentMapper : ResourceMapper<TransitRouterPeerAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.TransitRouterPeerAttachment::class == javaResource::class

    override fun map(javaResource: Resource): TransitRouterPeerAttachment =
        TransitRouterPeerAttachment(
            javaResource as
                com.pulumi.alicloud.cen.TransitRouterPeerAttachment,
        )
}

/**
 * @see [TransitRouterPeerAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitRouterPeerAttachment].
 */
public suspend fun transitRouterPeerAttachment(
    name: String,
    block: suspend TransitRouterPeerAttachmentResourceBuilder.() -> Unit,
): TransitRouterPeerAttachment {
    val builder = TransitRouterPeerAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitRouterPeerAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitRouterPeerAttachment(name: String): TransitRouterPeerAttachment {
    val builder = TransitRouterPeerAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
