@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.TransitRouterPeerAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CEN transit router peer attachment resource that associate the transit router with the CEN instance. [What is CEN transit router peer attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitrouterpeerattachment)
 * > **NOTE:** Available since v1.128.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const region = config.get("region") || "cn-hangzhou";
 * const peerRegion = config.get("peerRegion") || "cn-beijing";
 * const example = new alicloud.cen.Instance("example", {
 *     cenInstanceName: name,
 *     protectionLevel: "REDUCED",
 * });
 * const exampleBandwidthPackage = new alicloud.cen.BandwidthPackage("example", {
 *     bandwidth: 5,
 *     cenBandwidthPackageName: "tf_example",
 *     geographicRegionAId: "China",
 *     geographicRegionBId: "China",
 * });
 * const exampleBandwidthPackageAttachment = new alicloud.cen.BandwidthPackageAttachment("example", {
 *     instanceId: example.id,
 *     bandwidthPackageId: exampleBandwidthPackage.id,
 * });
 * const exampleTransitRouter = new alicloud.cen.TransitRouter("example", {cenId: exampleBandwidthPackageAttachment.instanceId});
 * const peer = new alicloud.cen.TransitRouter("peer", {cenId: exampleTransitRouter.cenId});
 * const exampleTransitRouterPeerAttachment = new alicloud.cen.TransitRouterPeerAttachment("example", {
 *     cenId: example.id,
 *     transitRouterId: exampleTransitRouter.transitRouterId,
 *     peerTransitRouterRegionId: peerRegion,
 *     peerTransitRouterId: peer.transitRouterId,
 *     cenBandwidthPackageId: exampleBandwidthPackageAttachment.bandwidthPackageId,
 *     bandwidth: 5,
 *     transitRouterAttachmentDescription: name,
 *     transitRouterAttachmentName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * peer_region = config.get("peerRegion")
 * if peer_region is None:
 *     peer_region = "cn-beijing"
 * example = alicloud.cen.Instance("example",
 *     cen_instance_name=name,
 *     protection_level="REDUCED")
 * example_bandwidth_package = alicloud.cen.BandwidthPackage("example",
 *     bandwidth=5,
 *     cen_bandwidth_package_name="tf_example",
 *     geographic_region_a_id="China",
 *     geographic_region_b_id="China")
 * example_bandwidth_package_attachment = alicloud.cen.BandwidthPackageAttachment("example",
 *     instance_id=example.id,
 *     bandwidth_package_id=example_bandwidth_package.id)
 * example_transit_router = alicloud.cen.TransitRouter("example", cen_id=example_bandwidth_package_attachment.instance_id)
 * peer = alicloud.cen.TransitRouter("peer", cen_id=example_transit_router.cen_id)
 * example_transit_router_peer_attachment = alicloud.cen.TransitRouterPeerAttachment("example",
 *     cen_id=example.id,
 *     transit_router_id=example_transit_router.transit_router_id,
 *     peer_transit_router_region_id=peer_region,
 *     peer_transit_router_id=peer.transit_router_id,
 *     cen_bandwidth_package_id=example_bandwidth_package_attachment.bandwidth_package_id,
 *     bandwidth=5,
 *     transit_router_attachment_description=name,
 *     transit_router_attachment_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var peerRegion = config.Get("peerRegion") ?? "cn-beijing";
 *     var example = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = name,
 *         ProtectionLevel = "REDUCED",
 *     });
 *     var exampleBandwidthPackage = new AliCloud.Cen.BandwidthPackage("example", new()
 *     {
 *         Bandwidth = 5,
 *         CenBandwidthPackageName = "tf_example",
 *         GeographicRegionAId = "China",
 *         GeographicRegionBId = "China",
 *     });
 *     var exampleBandwidthPackageAttachment = new AliCloud.Cen.BandwidthPackageAttachment("example", new()
 *     {
 *         InstanceId = example.Id,
 *         BandwidthPackageId = exampleBandwidthPackage.Id,
 *     });
 *     var exampleTransitRouter = new AliCloud.Cen.TransitRouter("example", new()
 *     {
 *         CenId = exampleBandwidthPackageAttachment.InstanceId,
 *     });
 *     var peer = new AliCloud.Cen.TransitRouter("peer", new()
 *     {
 *         CenId = exampleTransitRouter.CenId,
 *     });
 *     var exampleTransitRouterPeerAttachment = new AliCloud.Cen.TransitRouterPeerAttachment("example", new()
 *     {
 *         CenId = example.Id,
 *         TransitRouterId = exampleTransitRouter.TransitRouterId,
 *         PeerTransitRouterRegionId = peerRegion,
 *         PeerTransitRouterId = peer.TransitRouterId,
 *         CenBandwidthPackageId = exampleBandwidthPackageAttachment.BandwidthPackageId,
 *         Bandwidth = 5,
 *         TransitRouterAttachmentDescription = name,
 *         TransitRouterAttachmentName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		peerRegion := "cn-beijing"
 * 		if param := cfg.Get("peerRegion"); param != "" {
 * 			peerRegion = param
 * 		}
 * 		example, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String(name),
 * 			ProtectionLevel: pulumi.String("REDUCED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleBandwidthPackage, err := cen.NewBandwidthPackage(ctx, "example", &cen.BandwidthPackageArgs{
 * 			Bandwidth:               pulumi.Int(5),
 * 			CenBandwidthPackageName: pulumi.String("tf_example"),
 * 			GeographicRegionAId:     pulumi.String("China"),
 * 			GeographicRegionBId:     pulumi.String("China"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleBandwidthPackageAttachment, err := cen.NewBandwidthPackageAttachment(ctx, "example", &cen.BandwidthPackageAttachmentArgs{
 * 			InstanceId:         example.ID(),
 * 			BandwidthPackageId: exampleBandwidthPackage.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouter, err := cen.NewTransitRouter(ctx, "example", &cen.TransitRouterArgs{
 * 			CenId: exampleBandwidthPackageAttachment.InstanceId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		peer, err := cen.NewTransitRouter(ctx, "peer", &cen.TransitRouterArgs{
 * 			CenId: exampleTransitRouter.CenId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouterPeerAttachment(ctx, "example", &cen.TransitRouterPeerAttachmentArgs{
 * 			CenId:                              example.ID(),
 * 			TransitRouterId:                    exampleTransitRouter.TransitRouterId,
 * 			PeerTransitRouterRegionId:          pulumi.String(peerRegion),
 * 			PeerTransitRouterId:                peer.TransitRouterId,
 * 			CenBandwidthPackageId:              exampleBandwidthPackageAttachment.BandwidthPackageId,
 * 			Bandwidth:                          pulumi.Int(5),
 * 			TransitRouterAttachmentDescription: pulumi.String(name),
 * 			TransitRouterAttachmentName:        pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.BandwidthPackage;
 * import com.pulumi.alicloud.cen.BandwidthPackageArgs;
 * import com.pulumi.alicloud.cen.BandwidthPackageAttachment;
 * import com.pulumi.alicloud.cen.BandwidthPackageAttachmentArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.TransitRouterPeerAttachment;
 * import com.pulumi.alicloud.cen.TransitRouterPeerAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         final var peerRegion = config.get("peerRegion").orElse("cn-beijing");
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .cenInstanceName(name)
 *             .protectionLevel("REDUCED")
 *             .build());
 *         var exampleBandwidthPackage = new BandwidthPackage("exampleBandwidthPackage", BandwidthPackageArgs.builder()
 *             .bandwidth(5)
 *             .cenBandwidthPackageName("tf_example")
 *             .geographicRegionAId("China")
 *             .geographicRegionBId("China")
 *             .build());
 *         var exampleBandwidthPackageAttachment = new BandwidthPackageAttachment("exampleBandwidthPackageAttachment", BandwidthPackageAttachmentArgs.builder()
 *             .instanceId(example.id())
 *             .bandwidthPackageId(exampleBandwidthPackage.id())
 *             .build());
 *         var exampleTransitRouter = new TransitRouter("exampleTransitRouter", TransitRouterArgs.builder()
 *             .cenId(exampleBandwidthPackageAttachment.instanceId())
 *             .build());
 *         var peer = new TransitRouter("peer", TransitRouterArgs.builder()
 *             .cenId(exampleTransitRouter.cenId())
 *             .build());
 *         var exampleTransitRouterPeerAttachment = new TransitRouterPeerAttachment("exampleTransitRouterPeerAttachment", TransitRouterPeerAttachmentArgs.builder()
 *             .cenId(example.id())
 *             .transitRouterId(exampleTransitRouter.transitRouterId())
 *             .peerTransitRouterRegionId(peerRegion)
 *             .peerTransitRouterId(peer.transitRouterId())
 *             .cenBandwidthPackageId(exampleBandwidthPackageAttachment.bandwidthPackageId())
 *             .bandwidth(5)
 *             .transitRouterAttachmentDescription(name)
 *             .transitRouterAttachmentName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 *   region:
 *     type: string
 *     default: cn-hangzhou
 *   peerRegion:
 *     type: string
 *     default: cn-beijing
 * resources:
 *   example:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: ${name}
 *       protectionLevel: REDUCED
 *   exampleBandwidthPackage:
 *     type: alicloud:cen:BandwidthPackage
 *     name: example
 *     properties:
 *       bandwidth: 5
 *       cenBandwidthPackageName: tf_example
 *       geographicRegionAId: China
 *       geographicRegionBId: China
 *   exampleBandwidthPackageAttachment:
 *     type: alicloud:cen:BandwidthPackageAttachment
 *     name: example
 *     properties:
 *       instanceId: ${example.id}
 *       bandwidthPackageId: ${exampleBandwidthPackage.id}
 *   exampleTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: example
 *     properties:
 *       cenId: ${exampleBandwidthPackageAttachment.instanceId}
 *   peer:
 *     type: alicloud:cen:TransitRouter
 *     properties:
 *       cenId: ${exampleTransitRouter.cenId}
 *   exampleTransitRouterPeerAttachment:
 *     type: alicloud:cen:TransitRouterPeerAttachment
 *     name: example
 *     properties:
 *       cenId: ${example.id}
 *       transitRouterId: ${exampleTransitRouter.transitRouterId}
 *       peerTransitRouterRegionId: ${peerRegion}
 *       peerTransitRouterId: ${peer.transitRouterId}
 *       cenBandwidthPackageId: ${exampleBandwidthPackageAttachment.bandwidthPackageId}
 *       bandwidth: 5
 *       transitRouterAttachmentDescription: ${name}
 *       transitRouterAttachmentName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN Transit Router Peer Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterPeerAttachment:TransitRouterPeerAttachment example <id>
 * ```
 * @property autoPublishRouteEnabled Auto publish route enabled. The system default value is `false`.
 * @property bandwidth The bandwidth of the bandwidth package.
 * @property bandwidthType The method that is used to allocate bandwidth to the cross-region connection. Valid values: `BandwidthPackage` and `DataTransfer`.
 * * `DataTransfer` - uses pay-by-data-transfer bandwidth.
 * * `BandwidthPackage` - allocates bandwidth from a bandwidth plan.
 * @property cenBandwidthPackageId The ID of the bandwidth package. If you do not enter the ID of the package, it means you are using the test. The system default test is 1bps, demonstrating that you test network connectivity
 * @property cenId The ID of the CEN.
 * @property defaultLinkType DefaultLinkType. Valid values: `Platinum` and `Gold`.
 * @property dryRun Whether to perform pre-check for this request, including permission, instance status verification, etc.
 * @property peerTransitRouterId The ID of the peer transit router.
 * @property peerTransitRouterRegionId The region ID of peer transit router.
 * @property resourceType The resource type to attachment. Only support `VR` and default value is `VR`.
 * @property routeTableAssociationEnabled Whether to association route table. System default is `false`.
 * @property routeTablePropagationEnabled Whether to propagation route table. System default is `false`.
 * @property transitRouterAttachmentDescription The description of transit router attachment. The description is 2~256 characters long and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
 * @property transitRouterAttachmentName The name of transit router attachment. The name is 2~128 characters in length, starts with uppercase and lowercase letters or Chinese, and can contain numbers, underscores (_) and dashes (-)
 * @property transitRouterId The ID of the transit router to attach.
 */
public data class TransitRouterPeerAttachmentArgs(
    public val autoPublishRouteEnabled: Output<Boolean>? = null,
    public val bandwidth: Output<Int>? = null,
    public val bandwidthType: Output<String>? = null,
    public val cenBandwidthPackageId: Output<String>? = null,
    public val cenId: Output<String>? = null,
    public val defaultLinkType: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val peerTransitRouterId: Output<String>? = null,
    public val peerTransitRouterRegionId: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val routeTableAssociationEnabled: Output<Boolean>? = null,
    public val routeTablePropagationEnabled: Output<Boolean>? = null,
    public val transitRouterAttachmentDescription: Output<String>? = null,
    public val transitRouterAttachmentName: Output<String>? = null,
    public val transitRouterId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.TransitRouterPeerAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.TransitRouterPeerAttachmentArgs =
        com.pulumi.alicloud.cen.TransitRouterPeerAttachmentArgs.builder()
            .autoPublishRouteEnabled(autoPublishRouteEnabled?.applyValue({ args0 -> args0 }))
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .bandwidthType(bandwidthType?.applyValue({ args0 -> args0 }))
            .cenBandwidthPackageId(cenBandwidthPackageId?.applyValue({ args0 -> args0 }))
            .cenId(cenId?.applyValue({ args0 -> args0 }))
            .defaultLinkType(defaultLinkType?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .peerTransitRouterId(peerTransitRouterId?.applyValue({ args0 -> args0 }))
            .peerTransitRouterRegionId(peerTransitRouterRegionId?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .routeTableAssociationEnabled(routeTableAssociationEnabled?.applyValue({ args0 -> args0 }))
            .routeTablePropagationEnabled(routeTablePropagationEnabled?.applyValue({ args0 -> args0 }))
            .transitRouterAttachmentDescription(
                transitRouterAttachmentDescription?.applyValue({ args0 ->
                    args0
                }),
            )
            .transitRouterAttachmentName(transitRouterAttachmentName?.applyValue({ args0 -> args0 }))
            .transitRouterId(transitRouterId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitRouterPeerAttachmentArgs].
 */
@PulumiTagMarker
public class TransitRouterPeerAttachmentArgsBuilder internal constructor() {
    private var autoPublishRouteEnabled: Output<Boolean>? = null

    private var bandwidth: Output<Int>? = null

    private var bandwidthType: Output<String>? = null

    private var cenBandwidthPackageId: Output<String>? = null

    private var cenId: Output<String>? = null

    private var defaultLinkType: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var peerTransitRouterId: Output<String>? = null

    private var peerTransitRouterRegionId: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var routeTableAssociationEnabled: Output<Boolean>? = null

    private var routeTablePropagationEnabled: Output<Boolean>? = null

    private var transitRouterAttachmentDescription: Output<String>? = null

    private var transitRouterAttachmentName: Output<String>? = null

    private var transitRouterId: Output<String>? = null

    /**
     * @param value Auto publish route enabled. The system default value is `false`.
     */
    @JvmName("igpgwlmdgddhdshd")
    public suspend fun autoPublishRouteEnabled(`value`: Output<Boolean>) {
        this.autoPublishRouteEnabled = value
    }

    /**
     * @param value The bandwidth of the bandwidth package.
     */
    @JvmName("ahjqocylxbopafsi")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value The method that is used to allocate bandwidth to the cross-region connection. Valid values: `BandwidthPackage` and `DataTransfer`.
     * * `DataTransfer` - uses pay-by-data-transfer bandwidth.
     * * `BandwidthPackage` - allocates bandwidth from a bandwidth plan.
     */
    @JvmName("xmayvqajdbdvqqvr")
    public suspend fun bandwidthType(`value`: Output<String>) {
        this.bandwidthType = value
    }

    /**
     * @param value The ID of the bandwidth package. If you do not enter the ID of the package, it means you are using the test. The system default test is 1bps, demonstrating that you test network connectivity
     */
    @JvmName("urgrlepkgagjkise")
    public suspend fun cenBandwidthPackageId(`value`: Output<String>) {
        this.cenBandwidthPackageId = value
    }

    /**
     * @param value The ID of the CEN.
     */
    @JvmName("ywstvqbghmgbkpio")
    public suspend fun cenId(`value`: Output<String>) {
        this.cenId = value
    }

    /**
     * @param value DefaultLinkType. Valid values: `Platinum` and `Gold`.
     */
    @JvmName("bcwgxcknbvbiwawc")
    public suspend fun defaultLinkType(`value`: Output<String>) {
        this.defaultLinkType = value
    }

    /**
     * @param value Whether to perform pre-check for this request, including permission, instance status verification, etc.
     */
    @JvmName("wyroeqhqtsotyoai")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The ID of the peer transit router.
     */
    @JvmName("jisplhjfiygjvnmg")
    public suspend fun peerTransitRouterId(`value`: Output<String>) {
        this.peerTransitRouterId = value
    }

    /**
     * @param value The region ID of peer transit router.
     */
    @JvmName("iuucplvmjeirfrdx")
    public suspend fun peerTransitRouterRegionId(`value`: Output<String>) {
        this.peerTransitRouterRegionId = value
    }

    /**
     * @param value The resource type to attachment. Only support `VR` and default value is `VR`.
     */
    @JvmName("hdbwpqdqunpiudrm")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Whether to association route table. System default is `false`.
     */
    @JvmName("tfogjmfntjhgchxl")
    public suspend fun routeTableAssociationEnabled(`value`: Output<Boolean>) {
        this.routeTableAssociationEnabled = value
    }

    /**
     * @param value Whether to propagation route table. System default is `false`.
     */
    @JvmName("ocmhvgvjkpnkibpq")
    public suspend fun routeTablePropagationEnabled(`value`: Output<Boolean>) {
        this.routeTablePropagationEnabled = value
    }

    /**
     * @param value The description of transit router attachment. The description is 2~256 characters long and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
     */
    @JvmName("ujgbmikqlajokeuc")
    public suspend fun transitRouterAttachmentDescription(`value`: Output<String>) {
        this.transitRouterAttachmentDescription = value
    }

    /**
     * @param value The name of transit router attachment. The name is 2~128 characters in length, starts with uppercase and lowercase letters or Chinese, and can contain numbers, underscores (_) and dashes (-)
     */
    @JvmName("onbbjheggeqqtlkg")
    public suspend fun transitRouterAttachmentName(`value`: Output<String>) {
        this.transitRouterAttachmentName = value
    }

    /**
     * @param value The ID of the transit router to attach.
     */
    @JvmName("kmqdwqisnjuuokee")
    public suspend fun transitRouterId(`value`: Output<String>) {
        this.transitRouterId = value
    }

    /**
     * @param value Auto publish route enabled. The system default value is `false`.
     */
    @JvmName("fhurfgubhluyqgwu")
    public suspend fun autoPublishRouteEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPublishRouteEnabled = mapped
    }

    /**
     * @param value The bandwidth of the bandwidth package.
     */
    @JvmName("fhbksmvyyctlkhwt")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The method that is used to allocate bandwidth to the cross-region connection. Valid values: `BandwidthPackage` and `DataTransfer`.
     * * `DataTransfer` - uses pay-by-data-transfer bandwidth.
     * * `BandwidthPackage` - allocates bandwidth from a bandwidth plan.
     */
    @JvmName("cuegllhhacqiduea")
    public suspend fun bandwidthType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthType = mapped
    }

    /**
     * @param value The ID of the bandwidth package. If you do not enter the ID of the package, it means you are using the test. The system default test is 1bps, demonstrating that you test network connectivity
     */
    @JvmName("irwkjrcemlvyfvpo")
    public suspend fun cenBandwidthPackageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenBandwidthPackageId = mapped
    }

    /**
     * @param value The ID of the CEN.
     */
    @JvmName("dcnfbbqnrxywsuje")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenId = mapped
    }

    /**
     * @param value DefaultLinkType. Valid values: `Platinum` and `Gold`.
     */
    @JvmName("tcebqnrgtxpliuyi")
    public suspend fun defaultLinkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultLinkType = mapped
    }

    /**
     * @param value Whether to perform pre-check for this request, including permission, instance status verification, etc.
     */
    @JvmName("nitiyjkqsoygjlck")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The ID of the peer transit router.
     */
    @JvmName("jsqtmanwkkruvamd")
    public suspend fun peerTransitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerTransitRouterId = mapped
    }

    /**
     * @param value The region ID of peer transit router.
     */
    @JvmName("jnfxcegwffrjynro")
    public suspend fun peerTransitRouterRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerTransitRouterRegionId = mapped
    }

    /**
     * @param value The resource type to attachment. Only support `VR` and default value is `VR`.
     */
    @JvmName("lrgcmwlggwloqgso")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Whether to association route table. System default is `false`.
     */
    @JvmName("tkqepcmxyucvcefy")
    public suspend fun routeTableAssociationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableAssociationEnabled = mapped
    }

    /**
     * @param value Whether to propagation route table. System default is `false`.
     */
    @JvmName("toqvmknhdawojulu")
    public suspend fun routeTablePropagationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTablePropagationEnabled = mapped
    }

    /**
     * @param value The description of transit router attachment. The description is 2~256 characters long and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
     */
    @JvmName("pckiiixhxdkkdnvx")
    public suspend fun transitRouterAttachmentDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterAttachmentDescription = mapped
    }

    /**
     * @param value The name of transit router attachment. The name is 2~128 characters in length, starts with uppercase and lowercase letters or Chinese, and can contain numbers, underscores (_) and dashes (-)
     */
    @JvmName("toicyfyyiktxxxqj")
    public suspend fun transitRouterAttachmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterAttachmentName = mapped
    }

    /**
     * @param value The ID of the transit router to attach.
     */
    @JvmName("brqhpdqhcyfolaps")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterId = mapped
    }

    internal fun build(): TransitRouterPeerAttachmentArgs = TransitRouterPeerAttachmentArgs(
        autoPublishRouteEnabled = autoPublishRouteEnabled,
        bandwidth = bandwidth,
        bandwidthType = bandwidthType,
        cenBandwidthPackageId = cenBandwidthPackageId,
        cenId = cenId,
        defaultLinkType = defaultLinkType,
        dryRun = dryRun,
        peerTransitRouterId = peerTransitRouterId,
        peerTransitRouterRegionId = peerTransitRouterRegionId,
        resourceType = resourceType,
        routeTableAssociationEnabled = routeTableAssociationEnabled,
        routeTablePropagationEnabled = routeTablePropagationEnabled,
        transitRouterAttachmentDescription = transitRouterAttachmentDescription,
        transitRouterAttachmentName = transitRouterAttachmentName,
        transitRouterId = transitRouterId,
    )
}
