@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TransitRouterRouteTable].
 */
@PulumiTagMarker
public class TransitRouterRouteTableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitRouterRouteTableArgs = TransitRouterRouteTableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransitRouterRouteTableArgsBuilder.() -> Unit) {
        val builder = TransitRouterRouteTableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TransitRouterRouteTable {
        val builtJavaResource = com.pulumi.alicloud.cen.TransitRouterRouteTable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TransitRouterRouteTable(builtJavaResource)
    }
}

/**
 * Provides a CEN transit router route table resource.[What is Cen Transit Router Route Table](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitrouterroutetable)
 * > **NOTE:** Available since v1.126.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleTransitRouter = new alicloud.cen.TransitRouter("example", {
 *     transitRouterName: "tf_example",
 *     cenId: example.id,
 * });
 * const exampleTransitRouterRouteTable = new alicloud.cen.TransitRouterRouteTable("example", {transitRouterId: exampleTransitRouter.transitRouterId});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_transit_router = alicloud.cen.TransitRouter("example",
 *     transit_router_name="tf_example",
 *     cen_id=example.id)
 * example_transit_router_route_table = alicloud.cen.TransitRouterRouteTable("example", transit_router_id=example_transit_router.transit_router_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleTransitRouter = new AliCloud.Cen.TransitRouter("example", new()
 *     {
 *         TransitRouterName = "tf_example",
 *         CenId = example.Id,
 *     });
 *     var exampleTransitRouterRouteTable = new AliCloud.Cen.TransitRouterRouteTable("example", new()
 *     {
 *         TransitRouterId = exampleTransitRouter.TransitRouterId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouter, err := cen.NewTransitRouter(ctx, "example", &cen.TransitRouterArgs{
 * 			TransitRouterName: pulumi.String("tf_example"),
 * 			CenId:             example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouterRouteTable(ctx, "example", &cen.TransitRouterRouteTableArgs{
 * 			TransitRouterId: exampleTransitRouter.TransitRouterId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.TransitRouterRouteTable;
 * import com.pulumi.alicloud.cen.TransitRouterRouteTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleTransitRouter = new TransitRouter("exampleTransitRouter", TransitRouterArgs.builder()
 *             .transitRouterName("tf_example")
 *             .cenId(example.id())
 *             .build());
 *         var exampleTransitRouterRouteTable = new TransitRouterRouteTable("exampleTransitRouterRouteTable", TransitRouterRouteTableArgs.builder()
 *             .transitRouterId(exampleTransitRouter.transitRouterId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: example
 *     properties:
 *       transitRouterName: tf_example
 *       cenId: ${example.id}
 *   exampleTransitRouterRouteTable:
 *     type: alicloud:cen:TransitRouterRouteTable
 *     name: example
 *     properties:
 *       transitRouterId: ${exampleTransitRouter.transitRouterId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN transit router route table  can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterRouteTable:TransitRouterRouteTable default tr-*********:vtb-********
 * ```
 */
public class TransitRouterRouteTable internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.TransitRouterRouteTable,
) : KotlinCustomResource(javaResource, TransitRouterRouteTableMapper) {
    /**
     * The dry run.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The associating status of the Transit Router.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the transit router.
     */
    public val transitRouterId: Output<String>
        get() = javaResource.transitRouterId().applyValue({ args0 -> args0 })

    /**
     * The description of the transit router route table.
     */
    public val transitRouterRouteTableDescription: Output<String>
        get() = javaResource.transitRouterRouteTableDescription().applyValue({ args0 -> args0 })

    /**
     * The id of the transit router route table.
     */
    public val transitRouterRouteTableId: Output<String>
        get() = javaResource.transitRouterRouteTableId().applyValue({ args0 -> args0 })

    /**
     * The name of the transit router route table.
     */
    public val transitRouterRouteTableName: Output<String>?
        get() = javaResource.transitRouterRouteTableName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the transit router route table. Valid values: `Custom`, `System`.
     */
    public val transitRouterRouteTableType: Output<String>
        get() = javaResource.transitRouterRouteTableType().applyValue({ args0 -> args0 })
}

public object TransitRouterRouteTableMapper : ResourceMapper<TransitRouterRouteTable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.TransitRouterRouteTable::class == javaResource::class

    override fun map(javaResource: Resource): TransitRouterRouteTable =
        TransitRouterRouteTable(javaResource as com.pulumi.alicloud.cen.TransitRouterRouteTable)
}

/**
 * @see [TransitRouterRouteTable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitRouterRouteTable].
 */
public suspend fun transitRouterRouteTable(
    name: String,
    block: suspend TransitRouterRouteTableResourceBuilder.() -> Unit,
): TransitRouterRouteTable {
    val builder = TransitRouterRouteTableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitRouterRouteTable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitRouterRouteTable(name: String): TransitRouterRouteTable {
    val builder = TransitRouterRouteTableResourceBuilder()
    builder.name(name)
    return builder.build()
}
