@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.TransitRouterRouteTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CEN transit router route table resource.[What is Cen Transit Router Route Table](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitrouterroutetable)
 * > **NOTE:** Available since v1.126.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.cen.Instance("example", {
 *     cenInstanceName: "tf_example",
 *     description: "an example for cen",
 * });
 * const exampleTransitRouter = new alicloud.cen.TransitRouter("example", {
 *     transitRouterName: "tf_example",
 *     cenId: example.id,
 * });
 * const exampleTransitRouterRouteTable = new alicloud.cen.TransitRouterRouteTable("example", {transitRouterId: exampleTransitRouter.transitRouterId});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.cen.Instance("example",
 *     cen_instance_name="tf_example",
 *     description="an example for cen")
 * example_transit_router = alicloud.cen.TransitRouter("example",
 *     transit_router_name="tf_example",
 *     cen_id=example.id)
 * example_transit_router_route_table = alicloud.cen.TransitRouterRouteTable("example", transit_router_id=example_transit_router.transit_router_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = "tf_example",
 *         Description = "an example for cen",
 *     });
 *     var exampleTransitRouter = new AliCloud.Cen.TransitRouter("example", new()
 *     {
 *         TransitRouterName = "tf_example",
 *         CenId = example.Id,
 *     });
 *     var exampleTransitRouterRouteTable = new AliCloud.Cen.TransitRouterRouteTable("example", new()
 *     {
 *         TransitRouterId = exampleTransitRouter.TransitRouterId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String("tf_example"),
 * 			Description:     pulumi.String("an example for cen"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouter, err := cen.NewTransitRouter(ctx, "example", &cen.TransitRouterArgs{
 * 			TransitRouterName: pulumi.String("tf_example"),
 * 			CenId:             example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouterRouteTable(ctx, "example", &cen.TransitRouterRouteTableArgs{
 * 			TransitRouterId: exampleTransitRouter.TransitRouterId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.TransitRouterRouteTable;
 * import com.pulumi.alicloud.cen.TransitRouterRouteTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .cenInstanceName("tf_example")
 *             .description("an example for cen")
 *             .build());
 *         var exampleTransitRouter = new TransitRouter("exampleTransitRouter", TransitRouterArgs.builder()
 *             .transitRouterName("tf_example")
 *             .cenId(example.id())
 *             .build());
 *         var exampleTransitRouterRouteTable = new TransitRouterRouteTable("exampleTransitRouterRouteTable", TransitRouterRouteTableArgs.builder()
 *             .transitRouterId(exampleTransitRouter.transitRouterId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: tf_example
 *       description: an example for cen
 *   exampleTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: example
 *     properties:
 *       transitRouterName: tf_example
 *       cenId: ${example.id}
 *   exampleTransitRouterRouteTable:
 *     type: alicloud:cen:TransitRouterRouteTable
 *     name: example
 *     properties:
 *       transitRouterId: ${exampleTransitRouter.transitRouterId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN transit router route table  can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterRouteTable:TransitRouterRouteTable default tr-*********:vtb-********
 * ```
 * @property dryRun The dry run.
 * @property tags A mapping of tags to assign to the resource.
 * @property transitRouterId The ID of the transit router.
 * @property transitRouterRouteTableDescription The description of the transit router route table.
 * @property transitRouterRouteTableName The name of the transit router route table.
 */
public data class TransitRouterRouteTableArgs(
    public val dryRun: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitRouterId: Output<String>? = null,
    public val transitRouterRouteTableDescription: Output<String>? = null,
    public val transitRouterRouteTableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.TransitRouterRouteTableArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.TransitRouterRouteTableArgs =
        com.pulumi.alicloud.cen.TransitRouterRouteTableArgs.builder()
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitRouterId(transitRouterId?.applyValue({ args0 -> args0 }))
            .transitRouterRouteTableDescription(
                transitRouterRouteTableDescription?.applyValue({ args0 ->
                    args0
                }),
            )
            .transitRouterRouteTableName(transitRouterRouteTableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitRouterRouteTableArgs].
 */
@PulumiTagMarker
public class TransitRouterRouteTableArgsBuilder internal constructor() {
    private var dryRun: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitRouterId: Output<String>? = null

    private var transitRouterRouteTableDescription: Output<String>? = null

    private var transitRouterRouteTableName: Output<String>? = null

    /**
     * @param value The dry run.
     */
    @JvmName("dghqakixvyolxarb")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("jglklmmyaljbudxn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("ppushsglmbqvyqms")
    public suspend fun transitRouterId(`value`: Output<String>) {
        this.transitRouterId = value
    }

    /**
     * @param value The description of the transit router route table.
     */
    @JvmName("thfkptdoohbqtuus")
    public suspend fun transitRouterRouteTableDescription(`value`: Output<String>) {
        this.transitRouterRouteTableDescription = value
    }

    /**
     * @param value The name of the transit router route table.
     */
    @JvmName("rstbfyieehcpyrqp")
    public suspend fun transitRouterRouteTableName(`value`: Output<String>) {
        this.transitRouterRouteTableName = value
    }

    /**
     * @param value The dry run.
     */
    @JvmName("splqsarwosbiqvhj")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("oijiybwysianmgwt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("srpinximermllnbg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("gtbmgsdgwaksmxun")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterId = mapped
    }

    /**
     * @param value The description of the transit router route table.
     */
    @JvmName("mnxmmkrfrmbhdmir")
    public suspend fun transitRouterRouteTableDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterRouteTableDescription = mapped
    }

    /**
     * @param value The name of the transit router route table.
     */
    @JvmName("rnvpdpgxbssxdewy")
    public suspend fun transitRouterRouteTableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterRouteTableName = mapped
    }

    internal fun build(): TransitRouterRouteTableArgs = TransitRouterRouteTableArgs(
        dryRun = dryRun,
        tags = tags,
        transitRouterId = transitRouterId,
        transitRouterRouteTableDescription = transitRouterRouteTableDescription,
        transitRouterRouteTableName = transitRouterRouteTableName,
    )
}
