@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TransitRouterVbrAttachment].
 */
@PulumiTagMarker
public class TransitRouterVbrAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitRouterVbrAttachmentArgs = TransitRouterVbrAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransitRouterVbrAttachmentArgsBuilder.() -> Unit) {
        val builder = TransitRouterVbrAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TransitRouterVbrAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.cen.TransitRouterVbrAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TransitRouterVbrAttachment(builtJavaResource)
    }
}

/**
 * Provides a CEN transit router VBR attachment resource that associate the VBR with the CEN instance.[What is Cen Transit Router VBR Attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutervbrattachment)
 * > **NOTE:** Available since v1.126.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.cen.Instance("default", {
 *     cenInstanceName: name,
 *     protectionLevel: "REDUCED",
 * });
 * const defaultTransitRouter = new alicloud.cen.TransitRouter("default", {cenId: _default.id});
 * const nameRegex = alicloud.expressconnect.getPhysicalConnections({
 *     nameRegex: "^preserved-NODELETING",
 * });
 * const defaultVirtualBorderRouter = new alicloud.expressconnect.VirtualBorderRouter("default", {
 *     localGatewayIp: "10.0.0.1",
 *     peerGatewayIp: "10.0.0.2",
 *     peeringSubnetMask: "255.255.255.252",
 *     physicalConnectionId: nameRegex.then(nameRegex => nameRegex.connections?.[0]?.id),
 *     virtualBorderRouterName: name,
 *     vlanId: 2420,
 *     minRxInterval: 1000,
 *     minTxInterval: 1000,
 *     detectMultiplier: 10,
 * });
 * const defaultTransitRouterVbrAttachment = new alicloud.cen.TransitRouterVbrAttachment("default", {
 *     transitRouterId: defaultTransitRouter.transitRouterId,
 *     transitRouterAttachmentName: "example",
 *     transitRouterAttachmentDescription: "example",
 *     vbrId: defaultVirtualBorderRouter.id,
 *     cenId: _default.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.cen.Instance("default",
 *     cen_instance_name=name,
 *     protection_level="REDUCED")
 * default_transit_router = alicloud.cen.TransitRouter("default", cen_id=default.id)
 * name_regex = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
 * default_virtual_border_router = alicloud.expressconnect.VirtualBorderRouter("default",
 *     local_gateway_ip="10.0.0.1",
 *     peer_gateway_ip="10.0.0.2",
 *     peering_subnet_mask="255.255.255.252",
 *     physical_connection_id=name_regex.connections[0].id,
 *     virtual_border_router_name=name,
 *     vlan_id=2420,
 *     min_rx_interval=1000,
 *     min_tx_interval=1000,
 *     detect_multiplier=10)
 * default_transit_router_vbr_attachment = alicloud.cen.TransitRouterVbrAttachment("default",
 *     transit_router_id=default_transit_router.transit_router_id,
 *     transit_router_attachment_name="example",
 *     transit_router_attachment_description="example",
 *     vbr_id=default_virtual_border_router.id,
 *     cen_id=default.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Cen.Instance("default", new()
 *     {
 *         CenInstanceName = name,
 *         ProtectionLevel = "REDUCED",
 *     });
 *     var defaultTransitRouter = new AliCloud.Cen.TransitRouter("default", new()
 *     {
 *         CenId = @default.Id,
 *     });
 *     var nameRegex = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
 *     {
 *         NameRegex = "^preserved-NODELETING",
 *     });
 *     var defaultVirtualBorderRouter = new AliCloud.ExpressConnect.VirtualBorderRouter("default", new()
 *     {
 *         LocalGatewayIp = "10.0.0.1",
 *         PeerGatewayIp = "10.0.0.2",
 *         PeeringSubnetMask = "255.255.255.252",
 *         PhysicalConnectionId = nameRegex.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Connections[0]?.Id),
 *         VirtualBorderRouterName = name,
 *         VlanId = 2420,
 *         MinRxInterval = 1000,
 *         MinTxInterval = 1000,
 *         DetectMultiplier = 10,
 *     });
 *     var defaultTransitRouterVbrAttachment = new AliCloud.Cen.TransitRouterVbrAttachment("default", new()
 *     {
 *         TransitRouterId = defaultTransitRouter.TransitRouterId,
 *         TransitRouterAttachmentName = "example",
 *         TransitRouterAttachmentDescription = "example",
 *         VbrId = defaultVirtualBorderRouter.Id,
 *         CenId = @default.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cen.NewInstance(ctx, "default", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String(name),
 * 			ProtectionLevel: pulumi.String("REDUCED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTransitRouter, err := cen.NewTransitRouter(ctx, "default", &cen.TransitRouterArgs{
 * 			CenId: _default.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		nameRegex, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
 * 			NameRegex: pulumi.StringRef("^preserved-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVirtualBorderRouter, err := expressconnect.NewVirtualBorderRouter(ctx, "default", &expressconnect.VirtualBorderRouterArgs{
 * 			LocalGatewayIp:          pulumi.String("10.0.0.1"),
 * 			PeerGatewayIp:           pulumi.String("10.0.0.2"),
 * 			PeeringSubnetMask:       pulumi.String("255.255.255.252"),
 * 			PhysicalConnectionId:    pulumi.String(nameRegex.Connections[0].Id),
 * 			VirtualBorderRouterName: pulumi.String(name),
 * 			VlanId:                  pulumi.Int(2420),
 * 			MinRxInterval:           pulumi.Int(1000),
 * 			MinTxInterval:           pulumi.Int(1000),
 * 			DetectMultiplier:        pulumi.Int(10),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouterVbrAttachment(ctx, "default", &cen.TransitRouterVbrAttachmentArgs{
 * 			TransitRouterId:                    defaultTransitRouter.TransitRouterId,
 * 			TransitRouterAttachmentName:        pulumi.String("example"),
 * 			TransitRouterAttachmentDescription: pulumi.String("example"),
 * 			VbrId:                              defaultVirtualBorderRouter.ID(),
 * 			CenId:                              _default.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
 * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
 * import com.pulumi.alicloud.expressconnect.VirtualBorderRouter;
 * import com.pulumi.alicloud.expressconnect.VirtualBorderRouterArgs;
 * import com.pulumi.alicloud.cen.TransitRouterVbrAttachment;
 * import com.pulumi.alicloud.cen.TransitRouterVbrAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .cenInstanceName(name)
 *             .protectionLevel("REDUCED")
 *             .build());
 *         var defaultTransitRouter = new TransitRouter("defaultTransitRouter", TransitRouterArgs.builder()
 *             .cenId(default_.id())
 *             .build());
 *         final var nameRegex = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
 *             .nameRegex("^preserved-NODELETING")
 *             .build());
 *         var defaultVirtualBorderRouter = new VirtualBorderRouter("defaultVirtualBorderRouter", VirtualBorderRouterArgs.builder()
 *             .localGatewayIp("10.0.0.1")
 *             .peerGatewayIp("10.0.0.2")
 *             .peeringSubnetMask("255.255.255.252")
 *             .physicalConnectionId(nameRegex.applyValue(getPhysicalConnectionsResult -> getPhysicalConnectionsResult.connections()[0].id()))
 *             .virtualBorderRouterName(name)
 *             .vlanId(2420)
 *             .minRxInterval(1000)
 *             .minTxInterval(1000)
 *             .detectMultiplier(10)
 *             .build());
 *         var defaultTransitRouterVbrAttachment = new TransitRouterVbrAttachment("defaultTransitRouterVbrAttachment", TransitRouterVbrAttachmentArgs.builder()
 *             .transitRouterId(defaultTransitRouter.transitRouterId())
 *             .transitRouterAttachmentName("example")
 *             .transitRouterAttachmentDescription("example")
 *             .vbrId(defaultVirtualBorderRouter.id())
 *             .cenId(default_.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: ${name}
 *       protectionLevel: REDUCED
 *   defaultTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: default
 *     properties:
 *       cenId: ${default.id}
 *   defaultVirtualBorderRouter:
 *     type: alicloud:expressconnect:VirtualBorderRouter
 *     name: default
 *     properties:
 *       localGatewayIp: 10.0.0.1
 *       peerGatewayIp: 10.0.0.2
 *       peeringSubnetMask: 255.255.255.252
 *       physicalConnectionId: ${nameRegex.connections[0].id}
 *       virtualBorderRouterName: ${name}
 *       vlanId: 2420
 *       minRxInterval: 1000
 *       minTxInterval: 1000
 *       detectMultiplier: 10
 *   defaultTransitRouterVbrAttachment:
 *     type: alicloud:cen:TransitRouterVbrAttachment
 *     name: default
 *     properties:
 *       transitRouterId: ${defaultTransitRouter.transitRouterId}
 *       transitRouterAttachmentName: example
 *       transitRouterAttachmentDescription: example
 *       vbrId: ${defaultVirtualBorderRouter.id}
 *       cenId: ${default.id}
 * variables:
 *   nameRegex:
 *     fn::invoke:
 *       Function: alicloud:expressconnect:getPhysicalConnections
 *       Arguments:
 *         nameRegex: ^preserved-NODELETING
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN transit router VBR attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterVbrAttachment:TransitRouterVbrAttachment example tr-********:tr-attach-********
 * ```
 */
public class TransitRouterVbrAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.TransitRouterVbrAttachment,
) : KotlinCustomResource(javaResource, TransitRouterVbrAttachmentMapper) {
    /**
     * Auto publish route enabled.Default value is `false`.
     */
    public val autoPublishRouteEnabled: Output<Boolean>
        get() = javaResource.autoPublishRouteEnabled().applyValue({ args0 -> args0 })

    /**
     * The ID of the CEN.
     */
    public val cenId: Output<String>
        get() = javaResource.cenId().applyValue({ args0 -> args0 })

    /**
     * The dry run.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource type of the transit router vbr attachment.  Valid values: `VPC`, `CCN`, `VBR`, `TR`.
     * ->**NOTE:** Ensure that the vbr is not used in Express Connect.
     */
    public val resourceType: Output<String>?
        get() = javaResource.resourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enabled route table association. The system default value is `true`.
     */
    public val routeTableAssociationEnabled: Output<Boolean>?
        get() = javaResource.routeTableAssociationEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enabled route table propagation. The system default value is `true`.
     */
    public val routeTablePropagationEnabled: Output<Boolean>?
        get() = javaResource.routeTablePropagationEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The associating status of the network.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The description of the transit router vbr attachment.
     */
    public val transitRouterAttachmentDescription: Output<String>?
        get() = javaResource.transitRouterAttachmentDescription().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The id of the transit router vbr attachment.
     */
    public val transitRouterAttachmentId: Output<String>
        get() = javaResource.transitRouterAttachmentId().applyValue({ args0 -> args0 })

    /**
     * The name of the transit router vbr attachment.
     */
    public val transitRouterAttachmentName: Output<String>?
        get() = javaResource.transitRouterAttachmentName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the transit router.
     */
    public val transitRouterId: Output<String>?
        get() = javaResource.transitRouterId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the VBR.
     */
    public val vbrId: Output<String>
        get() = javaResource.vbrId().applyValue({ args0 -> args0 })

    /**
     * The owner id of the transit router vbr attachment.
     */
    public val vbrOwnerId: Output<String>
        get() = javaResource.vbrOwnerId().applyValue({ args0 -> args0 })
}

public object TransitRouterVbrAttachmentMapper : ResourceMapper<TransitRouterVbrAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.TransitRouterVbrAttachment::class == javaResource::class

    override fun map(javaResource: Resource): TransitRouterVbrAttachment =
        TransitRouterVbrAttachment(javaResource as com.pulumi.alicloud.cen.TransitRouterVbrAttachment)
}

/**
 * @see [TransitRouterVbrAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitRouterVbrAttachment].
 */
public suspend fun transitRouterVbrAttachment(
    name: String,
    block: suspend TransitRouterVbrAttachmentResourceBuilder.() -> Unit,
): TransitRouterVbrAttachment {
    val builder = TransitRouterVbrAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitRouterVbrAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitRouterVbrAttachment(name: String): TransitRouterVbrAttachment {
    val builder = TransitRouterVbrAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
