@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.TransitRouterVbrAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CEN transit router VBR attachment resource that associate the VBR with the CEN instance.[What is Cen Transit Router VBR Attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutervbrattachment)
 * > **NOTE:** Available since v1.126.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.cen.Instance("default", {
 *     cenInstanceName: name,
 *     protectionLevel: "REDUCED",
 * });
 * const defaultTransitRouter = new alicloud.cen.TransitRouter("default", {cenId: _default.id});
 * const nameRegex = alicloud.expressconnect.getPhysicalConnections({
 *     nameRegex: "^preserved-NODELETING",
 * });
 * const defaultVirtualBorderRouter = new alicloud.expressconnect.VirtualBorderRouter("default", {
 *     localGatewayIp: "10.0.0.1",
 *     peerGatewayIp: "10.0.0.2",
 *     peeringSubnetMask: "255.255.255.252",
 *     physicalConnectionId: nameRegex.then(nameRegex => nameRegex.connections?.[0]?.id),
 *     virtualBorderRouterName: name,
 *     vlanId: 2420,
 *     minRxInterval: 1000,
 *     minTxInterval: 1000,
 *     detectMultiplier: 10,
 * });
 * const defaultTransitRouterVbrAttachment = new alicloud.cen.TransitRouterVbrAttachment("default", {
 *     transitRouterId: defaultTransitRouter.transitRouterId,
 *     transitRouterAttachmentName: "example",
 *     transitRouterAttachmentDescription: "example",
 *     vbrId: defaultVirtualBorderRouter.id,
 *     cenId: _default.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.cen.Instance("default",
 *     cen_instance_name=name,
 *     protection_level="REDUCED")
 * default_transit_router = alicloud.cen.TransitRouter("default", cen_id=default.id)
 * name_regex = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
 * default_virtual_border_router = alicloud.expressconnect.VirtualBorderRouter("default",
 *     local_gateway_ip="10.0.0.1",
 *     peer_gateway_ip="10.0.0.2",
 *     peering_subnet_mask="255.255.255.252",
 *     physical_connection_id=name_regex.connections[0].id,
 *     virtual_border_router_name=name,
 *     vlan_id=2420,
 *     min_rx_interval=1000,
 *     min_tx_interval=1000,
 *     detect_multiplier=10)
 * default_transit_router_vbr_attachment = alicloud.cen.TransitRouterVbrAttachment("default",
 *     transit_router_id=default_transit_router.transit_router_id,
 *     transit_router_attachment_name="example",
 *     transit_router_attachment_description="example",
 *     vbr_id=default_virtual_border_router.id,
 *     cen_id=default.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Cen.Instance("default", new()
 *     {
 *         CenInstanceName = name,
 *         ProtectionLevel = "REDUCED",
 *     });
 *     var defaultTransitRouter = new AliCloud.Cen.TransitRouter("default", new()
 *     {
 *         CenId = @default.Id,
 *     });
 *     var nameRegex = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
 *     {
 *         NameRegex = "^preserved-NODELETING",
 *     });
 *     var defaultVirtualBorderRouter = new AliCloud.ExpressConnect.VirtualBorderRouter("default", new()
 *     {
 *         LocalGatewayIp = "10.0.0.1",
 *         PeerGatewayIp = "10.0.0.2",
 *         PeeringSubnetMask = "255.255.255.252",
 *         PhysicalConnectionId = nameRegex.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Connections[0]?.Id),
 *         VirtualBorderRouterName = name,
 *         VlanId = 2420,
 *         MinRxInterval = 1000,
 *         MinTxInterval = 1000,
 *         DetectMultiplier = 10,
 *     });
 *     var defaultTransitRouterVbrAttachment = new AliCloud.Cen.TransitRouterVbrAttachment("default", new()
 *     {
 *         TransitRouterId = defaultTransitRouter.TransitRouterId,
 *         TransitRouterAttachmentName = "example",
 *         TransitRouterAttachmentDescription = "example",
 *         VbrId = defaultVirtualBorderRouter.Id,
 *         CenId = @default.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := cen.NewInstance(ctx, "default", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String(name),
 * 			ProtectionLevel: pulumi.String("REDUCED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTransitRouter, err := cen.NewTransitRouter(ctx, "default", &cen.TransitRouterArgs{
 * 			CenId: _default.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		nameRegex, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
 * 			NameRegex: pulumi.StringRef("^preserved-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVirtualBorderRouter, err := expressconnect.NewVirtualBorderRouter(ctx, "default", &expressconnect.VirtualBorderRouterArgs{
 * 			LocalGatewayIp:          pulumi.String("10.0.0.1"),
 * 			PeerGatewayIp:           pulumi.String("10.0.0.2"),
 * 			PeeringSubnetMask:       pulumi.String("255.255.255.252"),
 * 			PhysicalConnectionId:    pulumi.String(nameRegex.Connections[0].Id),
 * 			VirtualBorderRouterName: pulumi.String(name),
 * 			VlanId:                  pulumi.Int(2420),
 * 			MinRxInterval:           pulumi.Int(1000),
 * 			MinTxInterval:           pulumi.Int(1000),
 * 			DetectMultiplier:        pulumi.Int(10),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouterVbrAttachment(ctx, "default", &cen.TransitRouterVbrAttachmentArgs{
 * 			TransitRouterId:                    defaultTransitRouter.TransitRouterId,
 * 			TransitRouterAttachmentName:        pulumi.String("example"),
 * 			TransitRouterAttachmentDescription: pulumi.String("example"),
 * 			VbrId:                              defaultVirtualBorderRouter.ID(),
 * 			CenId:                              _default.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
 * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
 * import com.pulumi.alicloud.expressconnect.VirtualBorderRouter;
 * import com.pulumi.alicloud.expressconnect.VirtualBorderRouterArgs;
 * import com.pulumi.alicloud.cen.TransitRouterVbrAttachment;
 * import com.pulumi.alicloud.cen.TransitRouterVbrAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .cenInstanceName(name)
 *             .protectionLevel("REDUCED")
 *             .build());
 *         var defaultTransitRouter = new TransitRouter("defaultTransitRouter", TransitRouterArgs.builder()
 *             .cenId(default_.id())
 *             .build());
 *         final var nameRegex = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
 *             .nameRegex("^preserved-NODELETING")
 *             .build());
 *         var defaultVirtualBorderRouter = new VirtualBorderRouter("defaultVirtualBorderRouter", VirtualBorderRouterArgs.builder()
 *             .localGatewayIp("10.0.0.1")
 *             .peerGatewayIp("10.0.0.2")
 *             .peeringSubnetMask("255.255.255.252")
 *             .physicalConnectionId(nameRegex.applyValue(getPhysicalConnectionsResult -> getPhysicalConnectionsResult.connections()[0].id()))
 *             .virtualBorderRouterName(name)
 *             .vlanId(2420)
 *             .minRxInterval(1000)
 *             .minTxInterval(1000)
 *             .detectMultiplier(10)
 *             .build());
 *         var defaultTransitRouterVbrAttachment = new TransitRouterVbrAttachment("defaultTransitRouterVbrAttachment", TransitRouterVbrAttachmentArgs.builder()
 *             .transitRouterId(defaultTransitRouter.transitRouterId())
 *             .transitRouterAttachmentName("example")
 *             .transitRouterAttachmentDescription("example")
 *             .vbrId(defaultVirtualBorderRouter.id())
 *             .cenId(default_.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: ${name}
 *       protectionLevel: REDUCED
 *   defaultTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: default
 *     properties:
 *       cenId: ${default.id}
 *   defaultVirtualBorderRouter:
 *     type: alicloud:expressconnect:VirtualBorderRouter
 *     name: default
 *     properties:
 *       localGatewayIp: 10.0.0.1
 *       peerGatewayIp: 10.0.0.2
 *       peeringSubnetMask: 255.255.255.252
 *       physicalConnectionId: ${nameRegex.connections[0].id}
 *       virtualBorderRouterName: ${name}
 *       vlanId: 2420
 *       minRxInterval: 1000
 *       minTxInterval: 1000
 *       detectMultiplier: 10
 *   defaultTransitRouterVbrAttachment:
 *     type: alicloud:cen:TransitRouterVbrAttachment
 *     name: default
 *     properties:
 *       transitRouterId: ${defaultTransitRouter.transitRouterId}
 *       transitRouterAttachmentName: example
 *       transitRouterAttachmentDescription: example
 *       vbrId: ${defaultVirtualBorderRouter.id}
 *       cenId: ${default.id}
 * variables:
 *   nameRegex:
 *     fn::invoke:
 *       Function: alicloud:expressconnect:getPhysicalConnections
 *       Arguments:
 *         nameRegex: ^preserved-NODELETING
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN transit router VBR attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterVbrAttachment:TransitRouterVbrAttachment example tr-********:tr-attach-********
 * ```
 * @property autoPublishRouteEnabled Auto publish route enabled.Default value is `false`.
 * @property cenId The ID of the CEN.
 * @property dryRun The dry run.
 * @property resourceType The resource type of the transit router vbr attachment.  Valid values: `VPC`, `CCN`, `VBR`, `TR`.
 * ->**NOTE:** Ensure that the vbr is not used in Express Connect.
 * @property routeTableAssociationEnabled Whether to enabled route table association. The system default value is `true`.
 * @property routeTablePropagationEnabled Whether to enabled route table propagation. The system default value is `true`.
 * @property tags A mapping of tags to assign to the resource.
 * @property transitRouterAttachmentDescription The description of the transit router vbr attachment.
 * @property transitRouterAttachmentName The name of the transit router vbr attachment.
 * @property transitRouterId The ID of the transit router.
 * @property vbrId The ID of the VBR.
 * @property vbrOwnerId The owner id of the transit router vbr attachment.
 */
public data class TransitRouterVbrAttachmentArgs(
    public val autoPublishRouteEnabled: Output<Boolean>? = null,
    public val cenId: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val resourceType: Output<String>? = null,
    public val routeTableAssociationEnabled: Output<Boolean>? = null,
    public val routeTablePropagationEnabled: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitRouterAttachmentDescription: Output<String>? = null,
    public val transitRouterAttachmentName: Output<String>? = null,
    public val transitRouterId: Output<String>? = null,
    public val vbrId: Output<String>? = null,
    public val vbrOwnerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.TransitRouterVbrAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.TransitRouterVbrAttachmentArgs =
        com.pulumi.alicloud.cen.TransitRouterVbrAttachmentArgs.builder()
            .autoPublishRouteEnabled(autoPublishRouteEnabled?.applyValue({ args0 -> args0 }))
            .cenId(cenId?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .routeTableAssociationEnabled(routeTableAssociationEnabled?.applyValue({ args0 -> args0 }))
            .routeTablePropagationEnabled(routeTablePropagationEnabled?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitRouterAttachmentDescription(
                transitRouterAttachmentDescription?.applyValue({ args0 ->
                    args0
                }),
            )
            .transitRouterAttachmentName(transitRouterAttachmentName?.applyValue({ args0 -> args0 }))
            .transitRouterId(transitRouterId?.applyValue({ args0 -> args0 }))
            .vbrId(vbrId?.applyValue({ args0 -> args0 }))
            .vbrOwnerId(vbrOwnerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitRouterVbrAttachmentArgs].
 */
@PulumiTagMarker
public class TransitRouterVbrAttachmentArgsBuilder internal constructor() {
    private var autoPublishRouteEnabled: Output<Boolean>? = null

    private var cenId: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var resourceType: Output<String>? = null

    private var routeTableAssociationEnabled: Output<Boolean>? = null

    private var routeTablePropagationEnabled: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitRouterAttachmentDescription: Output<String>? = null

    private var transitRouterAttachmentName: Output<String>? = null

    private var transitRouterId: Output<String>? = null

    private var vbrId: Output<String>? = null

    private var vbrOwnerId: Output<String>? = null

    /**
     * @param value Auto publish route enabled.Default value is `false`.
     */
    @JvmName("krpsjntocuhjpgqb")
    public suspend fun autoPublishRouteEnabled(`value`: Output<Boolean>) {
        this.autoPublishRouteEnabled = value
    }

    /**
     * @param value The ID of the CEN.
     */
    @JvmName("ytothlphhxflqxhb")
    public suspend fun cenId(`value`: Output<String>) {
        this.cenId = value
    }

    /**
     * @param value The dry run.
     */
    @JvmName("eeajaftwlyshbvll")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The resource type of the transit router vbr attachment.  Valid values: `VPC`, `CCN`, `VBR`, `TR`.
     * ->**NOTE:** Ensure that the vbr is not used in Express Connect.
     */
    @JvmName("innhpodntpgysnax")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Whether to enabled route table association. The system default value is `true`.
     */
    @JvmName("olkcedwegyqfltac")
    public suspend fun routeTableAssociationEnabled(`value`: Output<Boolean>) {
        this.routeTableAssociationEnabled = value
    }

    /**
     * @param value Whether to enabled route table propagation. The system default value is `true`.
     */
    @JvmName("cvhijsybrrujjjty")
    public suspend fun routeTablePropagationEnabled(`value`: Output<Boolean>) {
        this.routeTablePropagationEnabled = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("kgqgwuwqeaichffi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the transit router vbr attachment.
     */
    @JvmName("vkletvekrumvrqbm")
    public suspend fun transitRouterAttachmentDescription(`value`: Output<String>) {
        this.transitRouterAttachmentDescription = value
    }

    /**
     * @param value The name of the transit router vbr attachment.
     */
    @JvmName("wpmxvqfinlvroydy")
    public suspend fun transitRouterAttachmentName(`value`: Output<String>) {
        this.transitRouterAttachmentName = value
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("nllhqiekluhphbua")
    public suspend fun transitRouterId(`value`: Output<String>) {
        this.transitRouterId = value
    }

    /**
     * @param value The ID of the VBR.
     */
    @JvmName("sdjxokxynvacpodi")
    public suspend fun vbrId(`value`: Output<String>) {
        this.vbrId = value
    }

    /**
     * @param value The owner id of the transit router vbr attachment.
     */
    @JvmName("mtrphrwwivrausdm")
    public suspend fun vbrOwnerId(`value`: Output<String>) {
        this.vbrOwnerId = value
    }

    /**
     * @param value Auto publish route enabled.Default value is `false`.
     */
    @JvmName("nsbuwlrdtgjdtntn")
    public suspend fun autoPublishRouteEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPublishRouteEnabled = mapped
    }

    /**
     * @param value The ID of the CEN.
     */
    @JvmName("ajtfqtlokgmmsjxw")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenId = mapped
    }

    /**
     * @param value The dry run.
     */
    @JvmName("kwpgrvagpsruwamt")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The resource type of the transit router vbr attachment.  Valid values: `VPC`, `CCN`, `VBR`, `TR`.
     * ->**NOTE:** Ensure that the vbr is not used in Express Connect.
     */
    @JvmName("llqxtmvsjuqvcyqw")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Whether to enabled route table association. The system default value is `true`.
     */
    @JvmName("ktptlmdbxnsgydie")
    public suspend fun routeTableAssociationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableAssociationEnabled = mapped
    }

    /**
     * @param value Whether to enabled route table propagation. The system default value is `true`.
     */
    @JvmName("bhkqraitxdudvjyc")
    public suspend fun routeTablePropagationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTablePropagationEnabled = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ysixrhaqremrxecs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("oqudoyjmqjspaoww")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The description of the transit router vbr attachment.
     */
    @JvmName("pycstsiashlawjay")
    public suspend fun transitRouterAttachmentDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterAttachmentDescription = mapped
    }

    /**
     * @param value The name of the transit router vbr attachment.
     */
    @JvmName("vridyymdytiurwda")
    public suspend fun transitRouterAttachmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterAttachmentName = mapped
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("fampcmaqoeesqqpv")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterId = mapped
    }

    /**
     * @param value The ID of the VBR.
     */
    @JvmName("dagoedxjnbdrubbs")
    public suspend fun vbrId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vbrId = mapped
    }

    /**
     * @param value The owner id of the transit router vbr attachment.
     */
    @JvmName("juncsxvjcxhcuhlt")
    public suspend fun vbrOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vbrOwnerId = mapped
    }

    internal fun build(): TransitRouterVbrAttachmentArgs = TransitRouterVbrAttachmentArgs(
        autoPublishRouteEnabled = autoPublishRouteEnabled,
        cenId = cenId,
        dryRun = dryRun,
        resourceType = resourceType,
        routeTableAssociationEnabled = routeTableAssociationEnabled,
        routeTablePropagationEnabled = routeTablePropagationEnabled,
        tags = tags,
        transitRouterAttachmentDescription = transitRouterAttachmentDescription,
        transitRouterAttachmentName = transitRouterAttachmentName,
        transitRouterId = transitRouterId,
        vbrId = vbrId,
        vbrOwnerId = vbrOwnerId,
    )
}
